/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Serializer {
    public static byte[] serialize(Object toSerialize) throws IOException {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream ooStream = new ObjectOutputStream(arrayOutputStream);){
            ooStream.writeObject(toSerialize);
            byte[] byArray = arrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static Object deserialize(InputStream inputStream) throws IOException, ClassNotFoundException {
        try (ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);){
            Object object = objectInputStream.readObject();
            return object;
        }
    }

    public static Object deserialize(byte[] byteArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream arrayInputStream = new ByteArrayInputStream(byteArray);
        return Serializer.deserialize(arrayInputStream);
    }

    public static Object deserialize(String fileName) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = Serializer.class.getClassLoader();
        InputStream fileStream = classLoader.getResourceAsStream(fileName);
        return Serializer.deserialize(fileStream);
    }
}

