/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;

public class LeaveGroupResponse
extends AbstractResponse {
    private static final Schema LEAVE_GROUP_RESPONSE_V0 = new Schema(CommonFields.ERROR_CODE);
    private static final Schema LEAVE_GROUP_RESPONSE_V1;
    private static final Schema LEAVE_GROUP_RESPONSE_V2;
    private final Errors error;
    private final int throttleTimeMs;

    public static Schema[] schemaVersions() {
        return new Schema[]{LEAVE_GROUP_RESPONSE_V0, LEAVE_GROUP_RESPONSE_V1, LEAVE_GROUP_RESPONSE_V2};
    }

    public LeaveGroupResponse(Errors error) {
        this(0, error);
    }

    public LeaveGroupResponse(int throttleTimeMs, Errors error) {
        this.throttleTimeMs = throttleTimeMs;
        this.error = error;
    }

    public LeaveGroupResponse(Struct struct) {
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
        this.error = Errors.forCode(struct.get(CommonFields.ERROR_CODE));
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Errors error() {
        return this.error;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error);
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.LEAVE_GROUP.responseSchema(version));
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        struct.set(CommonFields.ERROR_CODE, this.error.code());
        return struct;
    }

    public static LeaveGroupResponse parse(ByteBuffer buffer, short versionId) {
        return new LeaveGroupResponse(ApiKeys.LEAVE_GROUP.parseResponse(versionId, buffer));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 2;
    }

    static {
        LEAVE_GROUP_RESPONSE_V2 = LEAVE_GROUP_RESPONSE_V1 = new Schema(CommonFields.THROTTLE_TIME_MS, CommonFields.ERROR_CODE);
    }
}

