/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RenewDelegationTokenResponse;

public class RenewDelegationTokenRequest
extends AbstractRequest {
    private static final String HMAC_KEY_NAME = "hmac";
    private static final String RENEW_TIME_PERIOD_KEY_NAME = "renew_time_period";
    private final ByteBuffer hmac;
    private final long renewTimePeriod;
    public static final Schema TOKEN_RENEW_REQUEST_V0;
    public static final Schema TOKEN_RENEW_REQUEST_V1;

    private RenewDelegationTokenRequest(short version, ByteBuffer hmac, long renewTimePeriod) {
        super(version);
        this.hmac = hmac;
        this.renewTimePeriod = renewTimePeriod;
    }

    public RenewDelegationTokenRequest(Struct struct, short versionId) {
        super(versionId);
        this.hmac = struct.getBytes(HMAC_KEY_NAME);
        this.renewTimePeriod = struct.getLong(RENEW_TIME_PERIOD_KEY_NAME);
    }

    public static RenewDelegationTokenRequest parse(ByteBuffer buffer, short version) {
        return new RenewDelegationTokenRequest(ApiKeys.RENEW_DELEGATION_TOKEN.parseRequest(version, buffer), version);
    }

    public static Schema[] schemaVersions() {
        return new Schema[]{TOKEN_RENEW_REQUEST_V0, TOKEN_RENEW_REQUEST_V1};
    }

    @Override
    protected Struct toStruct() {
        short version = this.version();
        Struct struct = new Struct(ApiKeys.RENEW_DELEGATION_TOKEN.requestSchema(version));
        struct.set(HMAC_KEY_NAME, (Object)this.hmac);
        struct.set(RENEW_TIME_PERIOD_KEY_NAME, (Object)this.renewTimePeriod);
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new RenewDelegationTokenResponse(throttleTimeMs, Errors.forException(e));
    }

    public ByteBuffer hmac() {
        return this.hmac;
    }

    public long renewTimePeriod() {
        return this.renewTimePeriod;
    }

    static {
        TOKEN_RENEW_REQUEST_V1 = TOKEN_RENEW_REQUEST_V0 = new Schema(new Field(HMAC_KEY_NAME, Type.BYTES, "HMAC of the delegation token to be renewed."), new Field(RENEW_TIME_PERIOD_KEY_NAME, Type.INT64, "Renew time period in milli seconds."));
    }

    public static class Builder
    extends AbstractRequest.Builder<RenewDelegationTokenRequest> {
        private final ByteBuffer hmac;
        private final long renewTimePeriod;

        public Builder(byte[] hmac, long renewTimePeriod) {
            super(ApiKeys.RENEW_DELEGATION_TOKEN);
            this.hmac = ByteBuffer.wrap(hmac);
            this.renewTimePeriod = renewTimePeriod;
        }

        @Override
        public RenewDelegationTokenRequest build(short version) {
            return new RenewDelegationTokenRequest(version, this.hmac, this.renewTimePeriod);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type: RenewDelegationTokenRequest").append(", hmac=").append(this.hmac).append(", renewTimePeriod=").append(this.renewTimePeriod).append(")");
            return bld.toString();
        }
    }
}

