/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.streams.errors.TaskAssignmentException;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.state.HostInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignmentInfo {
    private static final Logger log = LoggerFactory.getLogger(AssignmentInfo.class);
    private static final int CURRENT_VERSION = 2;
    public final int version;
    public final List<TaskId> activeTasks;
    public final Map<TaskId, Set<TopicPartition>> standbyTasks;
    public final Map<HostInfo, Set<TopicPartition>> partitionsByHost;

    public AssignmentInfo(List<TaskId> activeTasks, Map<TaskId, Set<TopicPartition>> standbyTasks, Map<HostInfo, Set<TopicPartition>> hostState) {
        this(2, activeTasks, standbyTasks, hostState);
    }

    public AssignmentInfo(int version, List<TaskId> activeTasks, Map<TaskId, Set<TopicPartition>> standbyTasks, Map<HostInfo, Set<TopicPartition>> hostState) {
        this.version = version;
        this.activeTasks = activeTasks;
        this.standbyTasks = standbyTasks;
        this.partitionsByHost = hostState;
    }

    public ByteBuffer encode() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        try {
            out.writeInt(this.version);
            out.writeInt(this.activeTasks.size());
            for (TaskId taskId : this.activeTasks) {
                taskId.writeTo(out);
            }
            out.writeInt(this.standbyTasks.size());
            for (Map.Entry entry : this.standbyTasks.entrySet()) {
                TaskId id = (TaskId)entry.getKey();
                id.writeTo(out);
                Set partitions = (Set)entry.getValue();
                this.writeTopicPartitions(out, partitions);
            }
            out.writeInt(this.partitionsByHost.size());
            for (Map.Entry entry : this.partitionsByHost.entrySet()) {
                HostInfo hostInfo = (HostInfo)entry.getKey();
                out.writeUTF(hostInfo.host());
                out.writeInt(hostInfo.port());
                this.writeTopicPartitions(out, (Set)entry.getValue());
            }
            out.flush();
            out.close();
            return ByteBuffer.wrap(baos.toByteArray());
        }
        catch (IOException ex) {
            throw new TaskAssignmentException("Failed to encode AssignmentInfo", ex);
        }
    }

    private void writeTopicPartitions(DataOutputStream out, Set<TopicPartition> partitions) throws IOException {
        out.writeInt(partitions.size());
        for (TopicPartition partition : partitions) {
            out.writeUTF(partition.topic());
            out.writeInt(partition.partition());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AssignmentInfo decode(ByteBuffer data) {
        data.rewind();
        try (DataInputStream in = new DataInputStream((InputStream)new ByteBufferInputStream(data));){
            int version = in.readInt();
            if (version < 0 || version > 2) {
                TaskAssignmentException ex = new TaskAssignmentException("Unknown assignment data version: " + version);
                log.error(ex.getMessage(), (Throwable)((Object)ex));
                throw ex;
            }
            int count = in.readInt();
            ArrayList<TaskId> activeTasks = new ArrayList<TaskId>(count);
            for (int i = 0; i < count; ++i) {
                activeTasks.add(TaskId.readFrom(in));
            }
            count = in.readInt();
            HashMap<TaskId, Set<TopicPartition>> standbyTasks = new HashMap<TaskId, Set<TopicPartition>>(count);
            for (int i = 0; i < count; ++i) {
                TaskId id = TaskId.readFrom(in);
                standbyTasks.put(id, AssignmentInfo.readTopicPartitions(in));
            }
            HashMap<HostInfo, Set<TopicPartition>> hostStateToTopicPartitions = new HashMap<HostInfo, Set<TopicPartition>>();
            if (version == 2) {
                int numEntries = in.readInt();
                for (int i = 0; i < numEntries; ++i) {
                    HostInfo hostInfo = new HostInfo(in.readUTF(), in.readInt());
                    hostStateToTopicPartitions.put(hostInfo, AssignmentInfo.readTopicPartitions(in));
                }
            }
            AssignmentInfo assignmentInfo = new AssignmentInfo(version, activeTasks, standbyTasks, hostStateToTopicPartitions);
            return assignmentInfo;
        }
        catch (IOException ex) {
            throw new TaskAssignmentException("Failed to decode AssignmentInfo", ex);
        }
    }

    private static Set<TopicPartition> readTopicPartitions(DataInputStream in) throws IOException {
        int numPartitions = in.readInt();
        HashSet<TopicPartition> partitions = new HashSet<TopicPartition>(numPartitions);
        for (int j = 0; j < numPartitions; ++j) {
            partitions.add(new TopicPartition(in.readUTF(), in.readInt()));
        }
        return partitions;
    }

    public int hashCode() {
        return this.version ^ this.activeTasks.hashCode() ^ this.standbyTasks.hashCode() ^ this.partitionsByHost.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AssignmentInfo) {
            AssignmentInfo other = (AssignmentInfo)o;
            return this.version == other.version && this.activeTasks.equals(other.activeTasks) && this.standbyTasks.equals(other.standbyTasks) && this.partitionsByHost.equals(other.partitionsByHost);
        }
        return false;
    }

    public String toString() {
        return "[version=" + this.version + ", active tasks=" + this.activeTasks.size() + ", standby tasks=" + this.standbyTasks.size() + "]";
    }
}

