/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001=3A!\u0001\u0002\u0001\u000f\t\u0011\u0002K]8ek\u000e,'+Z9vKN$H+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI!\"D\u0001\u0003\u0013\tY!AA\bCCN,'+Z9vKN$H+Z:u\u0011\u0015i\u0001\u0001\"\u0001\u000f\u0003\u0019a\u0014N\\5u}Q\tq\u0002\u0005\u0002\n\u0001!)\u0011\u0003\u0001C\u0001%\u0005AB/Z:u'&l\u0007\u000f\\3Qe>$WoY3SKF,Xm\u001d;\u0015\u0003M\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011A!\u00168ji\"\u0012\u0001C\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\tQA[;oSRT\u0011aH\u0001\u0004_J<\u0017BA\u0011\u001d\u0005\u0011!Vm\u001d;\t\u000b\r\u0002A\u0011\u0001\n\u0002/Q,7\u000f\u001e)s_\u0012,8-\u001a+p\u001d>t'+\u001a9mS\u000e\f\u0007F\u0001\u0012\u001b\u0011\u00151\u0003\u0001\"\u0003(\u0003\u0015\u001a'/Z1uKR{\u0007/[2B]\u00124\u0015N\u001c3QCJ$\u0018\u000e^5p]^KG\u000f\u001b'fC\u0012,'\u000f\u0006\u0002)]A!A#K\u0016,\u0013\tQSC\u0001\u0004UkBdWM\r\t\u0003)1J!!L\u000b\u0003\u0007%sG\u000fC\u00030K\u0001\u0007\u0001'A\u0003u_BL7\r\u0005\u00022i9\u0011ACM\u0005\u0003gU\ta\u0001\u0015:fI\u00164\u0017BA\u001b7\u0005\u0019\u0019FO]5oO*\u00111'\u0006\u0005\u0006q\u0001!\tAE\u0001\u001di\u0016\u001cHoQ8seV\u0004H\u000f\u0014>5!J|G-^2f%\u0016\fX/Z:uQ\t9$\u0004C\u0003<\u0001\u0011%A(\u0001\ntK:$\u0007K]8ek\u000e,'+Z9vKN$HcA\u001fI\u0015B\u0011aHR\u0007\u0002\u007f)\u0011\u0001)Q\u0001\te\u0016\fX/Z:ug*\u0011!iQ\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015!%BA#\u001f\u0003\u0019\t\u0007/Y2iK&\u0011qi\u0010\u0002\u0010!J|G-^2f%\u0016\u001c\bo\u001c8tK\")\u0011J\u000fa\u0001W\u0005AA.Z1eKJLE\rC\u0003Lu\u0001\u0007A*A\u0004sKF,Xm\u001d;\u0011\u0005yj\u0015B\u0001(@\u00059\u0001&o\u001c3vG\u0016\u0014V-];fgR\u0004")
public class ProduceRequestTest
extends BaseRequestTest {
    @Test
    public void testSimpleProduceRequest() {
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int partition = tuple2._1$mcI$sp();
            int leader2 = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(partition, leader2);
            int partition2 = sp3._1$mcI$sp();
            int leader3 = sp3._2$mcI$sp();
            this.sendAndCheck$1(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())}), 0L, partition2, leader3);
            this.sendAndCheck$1(MemoryRecords.withRecords((CompressionType)CompressionType.GZIP, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key1".getBytes(), "value1".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key2".getBytes(), "value2".getBytes())}), 1L, partition2, leader3);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testProduceToNonReplica() {
        String topic = "topic";
        int partition = 0;
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int leader2 = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.servers().find((Function1)new Serializable(this, leader2){
            public static final long serialVersionUID = 0L;
            private final int leader$2;

            public final boolean apply(KafkaServer x$3) {
                return x$3.config().brokerId() != this.leader$2;
            }
            {
                this.leader$2 = leader$2;
            }
        });
        Assert.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaServer)nonReplicaOpt.get()).config().brokerId();
        MemoryRecords records2 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("key".getBytes(), "value".getBytes())});
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records2)}));
        ProduceRequest produceRequest = (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)3000, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava())).build();
        ProduceResponse produceResponse = this.sendProduceRequest(nonReplicaId, produceRequest);
        Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)((ProduceResponse.PartitionResponse)((Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)produceResponse.responses()).asScala()).head())._2()).error);
    }

    private Tuple2<Object, Object> createTopicAndFindPartitionWithLeader(String topic) {
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 3, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        return (Tuple2)partitionToLeader.collectFirst((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    int partition = A1._1$mcI$sp();
                    int leader2 = A1._2$mcI$sp();
                    if (leader2 != -1) {
                        object = new Tuple2.mcII.sp(partition, leader2);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                int leader2;
                Tuple2<Object, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (leader2 = tuple2._2$mcI$sp()) != -1;
                return bl;
            }
        }).getOrElse((Function0)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProduceRequestTest $outer;
            private final String topic$1;

            public final Nothing$ apply() {
                return this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No leader elected for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1})), new Position("ProduceRequestTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        });
    }

    @Test
    public void testCorruptLz4ProduceRequest() {
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int partition = tuple2._1$mcI$sp();
            int leader2 = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(partition, leader2);
            int partition2 = sp3._1$mcI$sp();
            int leader3 = sp3._2$mcI$sp();
            int timestamp = 1000000;
            MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.LZ4, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord((long)timestamp, "key".getBytes(), "value".getBytes())});
            int lz4ChecksumOffset = 6;
            memoryRecords.buffer().array()[61 + lz4ChecksumOffset] = 0;
            TopicPartition topicPartition = new TopicPartition("topic", partition2);
            scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)memoryRecords)}));
            ProduceResponse produceResponse = this.sendProduceRequest(leader3, (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)3000, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava())).build());
            Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
            Tuple2 tuple22 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
            if (tuple22 != null) {
                Tuple2 tuple23;
                TopicPartition tp = (TopicPartition)tuple22._1();
                ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)tp, (Object)partitionResponse);
                TopicPartition tp2 = (TopicPartition)tuple24._1();
                ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple24._2();
                Assert.assertEquals((Object)topicPartition, (Object)tp2);
                Assert.assertEquals((Object)Errors.CORRUPT_MESSAGE, (Object)partitionResponse2.error);
                Assert.assertEquals((long)-1L, (long)partitionResponse2.baseOffset);
                Assert.assertEquals((long)-1L, (long)partitionResponse2.logAppendTime);
                return;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError(tuple2);
    }

    private ProduceResponse sendProduceRequest(int leaderId, ProduceRequest request) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.PRODUCE, this.brokerSocketServer(leaderId), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return ProduceResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private final ProduceResponse.PartitionResponse sendAndCheck$1(MemoryRecords memoryRecords, long expectedOffset, int partition$1, int leader$1) {
        TopicPartition topicPartition = new TopicPartition("topic", partition$1);
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)memoryRecords)}));
        ProduceResponse produceResponse = this.sendProduceRequest(leader$1, (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)3000, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava())).build());
        Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
        Tuple2 tuple2 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition tp = (TopicPartition)tuple2._1();
            ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)tp, (Object)partitionResponse);
            TopicPartition tp2 = (TopicPartition)tuple23._1();
            ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple23._2();
            Assert.assertEquals((Object)topicPartition, (Object)tp2);
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionResponse2.error);
            Assert.assertEquals((long)expectedOffset, (long)partitionResponse2.baseOffset);
            Assert.assertEquals((long)-1L, (long)partitionResponse2.logAppendTime);
            return partitionResponse2;
        }
        throw new MatchError((Object)tuple2);
    }
}

