/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.checkpoints.LeaderEpochCheckpointFile;
import kafka.server.checkpoints.LeaderEpochCheckpointFile$;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u0001%\u0011\u0001\u0004T3bI\u0016\u0014X\t]8dQ\u001aKG.Z\"bG\",G+Z:u\u0015\t\u0019A!A\u0003fa>\u001c\u0007N\u0003\u0002\u0006\r\u000511/\u001a:wKJT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006#\u0001!\tAE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\tAqA\u0006\u0001C\u0002\u0013\u0005q#\u0001\u0002uaV\t\u0001\u0004\u0005\u0002\u001aC5\t!D\u0003\u0002\u001c9\u000511m\\7n_:T!aB\u000f\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0005\u0003Ei\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004%\u0001\u0001\u0006I\u0001G\u0001\u0004iB\u0004\u0003b\u0002\u0014\u0001\u0001\u0004%IaJ\u0001\rY><WI\u001c3PM\u001a\u001cX\r^\u000b\u0002QA\u00111\"K\u0005\u0003U1\u0011A\u0001T8oO\"9A\u0006\u0001a\u0001\n\u0013i\u0013\u0001\u00057pO\u0016sGm\u00144gg\u0016$x\fJ3r)\tq\u0013\u0007\u0005\u0002\f_%\u0011\u0001\u0007\u0004\u0002\u0005+:LG\u000fC\u00043W\u0005\u0005\t\u0019\u0001\u0015\u0002\u0007a$\u0013\u0007\u0003\u00045\u0001\u0001\u0006K\u0001K\u0001\u000eY><WI\u001c3PM\u001a\u001cX\r\u001e\u0011\t\u000fY\u0002!\u0019!C\u0005o\u0005Q1\r[3dWB|\u0017N\u001c;\u0016\u0003a\u0002\"!\u000f\u001f\u000e\u0003iR!a\u000f\u0003\u0002\u0017\rDWmY6q_&tGo]\u0005\u0003{i\u0012Q\u0003T3bI\u0016\u0014X\t]8dQ\u000eCWmY6q_&tG\u000f\u0003\u0004@\u0001\u0001\u0006I\u0001O\u0001\fG\",7m\u001b9pS:$\b\u0005C\u0004B\u0001\t\u0007I\u0011\u0002\"\u0002\u000b\r\f7\r[3\u0016\u0003\r\u0003\"\u0001\u0006#\n\u0005\u0015\u0013!\u0001\u0006'fC\u0012,'/\u00129pG\"4\u0015\u000e\\3DC\u000eDW\r\u0003\u0004H\u0001\u0001\u0006IaQ\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\t\u000b%\u0003A\u0011\u0001&\u0002KMDw.\u001e7e\u0003\u0012$W\t]8dQ\u0006sG-T3tg\u0006<Wm\u00144gg\u0016$Hk\\\"bG\",G#\u0001\u0018)\u0005!c\u0005CA'Q\u001b\u0005q%BA( \u0003\u0015QWO\\5u\u0013\t\tfJ\u0001\u0003UKN$\b\"B*\u0001\t\u0003Q\u0015AL:i_VdGMU3ukJtGj\\4F]\u0012|eMZ:fi&3G*\u0019;fgR,\u0005o\\2i%\u0016\fX/Z:uK\u0012D#A\u0015'\t\u000bY\u0003A\u0011\u0001&\u0002iMDw.\u001e7e%\u0016$XO\u001d8V]\u0012,g-\u001b8fI>3gm]3u\u0013\u001a,f\u000eZ3gS:,G-\u00129pG\"\u0014V-];fgR,G\r\u000b\u0002V\u0019\")\u0011\f\u0001C\u0001\u0015\u0006\u00115\u000f[8vY\u0012tu\u000e^(wKJ<(/\u001b;f\u0019><WI\u001c3PM\u001a\u001cX\r\u001e$pe\u0006cU-\u00193fe\u0016\u0003xn\u00195P]\u000e,\u0017\n\u001e%bg\n+WM\\!tg&<g.\u001a3)\u0005ac\u0005\"\u0002/\u0001\t\u0003Q\u0015\u0001M:i_VdG-\u00128g_J\u001cW-T8o_R|g.[2bY2L\u0018J\\2sK\u0006\u001c\u0018N\\4Ti\u0006\u0014Ho\u00144gg\u0016$8\u000f\u000b\u0002\\\u0019\")q\f\u0001C\u0001\u0015\u0006a4\u000f[8vY\u0012tu\u000e^(wKJ<(/\u001b;f\u001f\u001a47/\u001a;G_J\fE*Z1eKJ,\u0005o\\2i\u001f:\u001cW-\u0013;ICN\u0014U-\u001a8BgNLwM\\3eQ\tqF\nC\u0003c\u0001\u0011\u0005!*\u0001\u0015tQ>,H\u000e\u001a*fiV\u0014h.\u00168tkB\u0004xN\u001d;fI&3gj\\#q_\u000eD'+Z2pe\u0012,G\r\u000b\u0002b\u0019\")Q\r\u0001C\u0001\u0015\u0006\u00115\u000f[8vY\u0012\u0014V\r^;s]Vs7/\u001e9q_J$X\rZ%g\u001d>,\u0005o\\2i%\u0016\u001cwN\u001d3fI\u0006sG-\u00168eK\u001aLg.\u001a3Fa>\u001c\u0007NU3rk\u0016\u001cH/\u001a3)\u0005\u0011d\u0005\"\u00025\u0001\t\u0003Q\u0015\u0001O:i_VdGMU3ukJtg)\u001b:ti\u0016\u0003xn\u00195JMJ+\u0017/^3ti\u0016$W\t]8dQ2+7o\u001d+iC:4\u0015N]:u\u000bB|7\r\u001b\u0015\u0003O2CQa\u001b\u0001\u0005\u0002)\u000bQg\u001d5pk2$GK];oG\u0006$X-\u00134NCR\u001c\u0007.\u001b8h\u000bB|7\r\u001b\"vi\u0016\u000b'\u000f\\5feN#\u0018M\u001d;j]\u001e|eMZ:fi\"\u0012!\u000e\u0014\u0005\u0006]\u0002!\tAS\u0001Ig\"|W\u000f\u001c3HKR4\u0015N]:u\u001f\u001a47/\u001a;PMN+(m]3rk\u0016tG/\u00129pG\"<\u0006.\u001a8PM\u001a\u001cX\r\u001e*fcV,7\u000f^3e\r>\u0014\bK]3wS>,8/\u00129pG\"D#!\u001c'\t\u000bE\u0004A\u0011\u0001&\u0002\u000bNDw.\u001e7e%\u0016$XO\u001d8OKb$\u0018I^1jY\u0006\u0014G.Z#q_\u000eD\u0017J\u001a+iKJ,\u0017j\u001d(p\u000bb\f7\r^#q_\u000eDgi\u001c:UQ\u0016|e.\u001a*fcV,7\u000f^3eQ\t\u0001H\nC\u0003u\u0001\u0011\u0005!*\u0001\u001atQ>,H\u000e\u001a(piV\u0003H-\u0019;f\u000bB|7\r[!oIN#\u0018M\u001d;PM\u001a\u001cX\r^%g\u0013R$\u0015\u000e\u001a(pi\u000eC\u0017M\\4fQ\t\u0019H\nC\u0003x\u0001\u0011\u0005!*A#tQ>,H\u000e\u001a*fiV\u0014h.\u00138wC2LGm\u00144gg\u0016$\u0018JZ#q_\u000eD\u0017j\u001d*fcV,7\u000f^3e/\"L7\r[%t\u001d>$8)\u001e:sK:$H.\u001f+sC\u000e\\W\r\u001a\u0015\u0003m2CQA\u001f\u0001\u0005\u0002)\u000b\u0011f\u001d5pk2$7+\u001e9q_J$X\t]8dQN$\u0006.\u0019;E_:{Go\u0015;beR4%o\\7[KJ|\u0007FA=M\u0011\u0015i\b\u0001\"\u0001K\u0003\r\u001a\bn\\;mIB+'o]5ti\u0016\u0003xn\u00195t\u0005\u0016$x/Z3o\u0013:\u001cH/\u00198dKND#\u0001 '\t\r\u0005\u0005\u0001\u0001\"\u0001K\u0003)\u001a\bn\\;mI\u0016sgm\u001c:dK6{gn\u001c;p]&\u001c\u0017\r\u001c7z\u0013:\u001c'/Z1tS:<W\t]8dQND#a '\t\r\u0005\u001d\u0001\u0001\"\u0001K\u0003%\u001a\bn\\;mI\u0016sgm\u001c:dK>3gm]3ug&s7M]3bg\u0016luN\\8u_:L7-\u00197ms\"\u001a\u0011Q\u0001'\t\r\u00055\u0001\u0001\"\u0001K\u0003Q\u001a\bn\\;mI&s7M]3bg\u0016\fe\u000e\u001a+sC\u000e\\W\t]8dQN\f5\u000fT3bI\u0016\u00148o\u00115b]\u001e,W*\u00198z)&lWm\u001d\u0015\u0004\u0003\u0017a\u0005BBA\n\u0001\u0011\u0005!*\u0001\u001etQ>,H\u000eZ%oGJ,\u0017m]3B]\u0012$&/Y2l\u000bB|7\r[:Bg\u001a{G\u000e\\8xKJ\u0014VmY3jm\u0016\u001cX*\u00198z\u001b\u0016\u001c8/Y4fg\"\u001a\u0011\u0011\u0003'\t\r\u0005e\u0001\u0001\"\u0001K\u0003e\u001a\bn\\;mI\u0012\u0013x\u000e]#oiJLWm](o\u000bB|7\r\u001b\"pk:$\u0017M]=XQ\u0016t'+Z7pm&tw\rT1uKN$XI\u001c;sS\u0016\u001c\bfAA\f\u0019\"1\u0011q\u0004\u0001\u0005\u0002)\u000b1g\u001d5pk2$\u0007K]3tKJ4XMU3tKR|eMZ:fi>s7\t\\3be\u0016\u000b'\u000f\\5fgRLem\u00148f\u000bbL7\u000f^:)\u0007\u0005uA\n\u0003\u0004\u0002&\u0001!\tAS\u0001:g\"|W\u000f\u001c3Va\u0012\fG/Z*bm\u0016$wJ\u001a4tKR<\u0006.\u001a8PM\u001a\u001cX\r\u001e+p\u00072,\u0017M\u001d+p\u0013N\u0014U\r^<fK:,\u0005o\\2ig\"\u001a\u00111\u0005'\t\r\u0005-\u0002\u0001\"\u0001K\u0003\u0015\u001a\bn\\;mI:{Go\u00117fCJ\fe.\u001f;iS:<\u0017JZ(gMN,G\u000fV8FCJd\u0017\u0010K\u0002\u0002*1Ca!!\r\u0001\t\u0003Q\u0015aK:i_VdGMT8u\u00072,\u0017M]!osRD\u0017N\\4JM>3gm]3u)>4\u0015N]:u\u001f\u001a47/\u001a;)\u0007\u0005=B\n\u0003\u0004\u00028\u0001!\tAS\u0001*g\"|W\u000f\u001c3SKR\f\u0017N\u001c'bi\u0016\u001cH/\u00129pG\"|en\u00117fCJ\fE\u000e\\#be2LWm\u001d;)\u0007\u0005UB\n\u0003\u0004\u0002>\u0001!\tAS\u00018g\"|W\u000f\u001c3Va\u0012\fG/Z(gMN,GOQ3uo\u0016,g.\u00129pG\"\u0014u.\u001e8eCJLWm](o\u00072,\u0017M]#be2LWm\u001d;)\u0007\u0005mB\n\u0003\u0004\u0002D\u0001!\tAS\u00019g\"|W\u000f\u001c3Va\u0012\fG/Z(gMN,GOQ3uo\u0016,g.\u00129pG\"\u0014u.\u001e8eCJLWm](o\u00072,\u0017M]#be2LWm\u001d;3Q\r\t\t\u0005\u0014\u0005\u0007\u0003\u0013\u0002A\u0011\u0001&\u0002wMDw.\u001e7e%\u0016$\u0018-\u001b8MCR,7\u000f^#q_\u000eDwJ\\\"mK\u0006\u0014\u0018\t\u001c7FCJd\u0017.Z:u\u0003:$W\u000b\u001d3bi\u0016LEo](gMN,G\u000fK\u0002\u0002H1Ca!a\u0014\u0001\t\u0003Q\u0015aN:i_VdG\r\u0012:pa\u0016sGO]5fg\n+Go^3f]\u0016\u0003xn\u00195C_VtG-\u0019:z/\",gNU3n_ZLgn\u001a(fo\u0016\u001cH\u000fK\u0002\u0002N1Ca!!\u0016\u0001\t\u0003Q\u0015!F:i_VdGm\u00117fCJ\fE\u000e\\#oiJLWm\u001d\u0015\u0004\u0003'b\u0005BBA.\u0001\u0011\u0005!*A\u0018tQ>,H\u000e\u001a(piJ+7/\u001a;Fa>\u001c\u0007\u000eS5ti>\u0014\u0018\u0010S3bI&3WK\u001c3fM&tW\r\u001a)bgN,G\rK\u0002\u0002Z1Ca!!\u0019\u0001\t\u0003Q\u0015aL:i_VdGMT8u%\u0016\u001cX\r^#q_\u000eD\u0007*[:u_JLH+Y5m\u0013\u001a,f\u000eZ3gS:,G\rU1tg\u0016$\u0007fAA0\u0019\"1\u0011q\r\u0001\u0005\u0002)\u000b!e\u001d5pk2$g)\u001a;dQ2\u000bG/Z:u\u000bB|7\r[(g\u000b6\u0004H/_\"bG\",\u0007fAA3\u0019\"1\u0011Q\u000e\u0001\u0005\u0002)\u000b\u0001e\u001d5pk2$g)\u001a;dQ\u0016sGm\u00144gg\u0016$xJZ#naRL8)Y2iK\"\u001a\u00111\u000e'\t\r\u0005M\u0004\u0001\"\u0001K\u0003}\u0019\bn\\;mI\u000ecW-\u0019:FCJd\u0017.Z:u\u001f:,U\u000e\u001d;z\u0007\u0006\u001c\u0007.\u001a\u0015\u0004\u0003cb\u0005BBA=\u0001\u0011\u0005!*A\u000ftQ>,H\u000eZ\"mK\u0006\u0014H*\u0019;fgR|e.R7qif\u001c\u0015m\u00195fQ\r\t9\b\u0014")
public class LeaderEpochFileCacheTest {
    private final TopicPartition tp = new TopicPartition("TestTopic", 5);
    private long kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset = 0L;
    private final LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(this){
        private Seq<EpochEntry> epochs;

        private Seq<EpochEntry> epochs() {
            return this.epochs;
        }

        private void epochs_$eq(Seq<EpochEntry> x$1) {
            this.epochs = x$1;
        }

        public void write(Seq<EpochEntry> epochs) {
            this.epochs_$eq(epochs);
        }

        public Seq<EpochEntry> read() {
            return this.epochs();
        }
        {
            this.epochs = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
    };
    private final LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
        public static final long serialVersionUID = 0L;
        private final /* synthetic */ LeaderEpochFileCacheTest $outer;

        public final long apply() {
            return this.apply$mcJ$sp();
        }

        public long apply$mcJ$sp() {
            return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset();
        }
        {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }, this.checkpoint());

    public TopicPartition tp() {
        return this.tp;
    }

    public long kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset() {
        return this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset;
    }

    private void kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(long x$1) {
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset = x$1;
    }

    private LeaderEpochCheckpoint checkpoint() {
        return this.checkpoint;
    }

    private LeaderEpochFileCache cache() {
        return this.cache;
    }

    @Test
    public void shouldAddEpochAndMessageOffsetToCache() {
        this.cache().assign(2, 10L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(11L);
        Assert.assertEquals((long)2L, (long)this.cache().latestEpoch());
        Assert.assertEquals((Object)new EpochEntry(2, 10L), (Object)this.cache().epochEntries().apply(0));
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(2, this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset()), (Object)this.cache().endOffsetFor(2));
    }

    @Test
    public void shouldReturnLogEndOffsetIfLatestEpochRequested() {
        this.cache().assign(2, 11L);
        this.cache().assign(2, 12L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(14L);
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(2, this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset()), (Object)this.cache().endOffsetFor(2));
    }

    @Test
    public void shouldReturnUndefinedOffsetIfUndefinedEpochRequested() {
        Tuple2.mcIJ.sp expectedEpochEndOffset = new Tuple2.mcIJ.sp(-1, -1L);
        this.cache().assign(2, 11L);
        this.cache().assign(3, 12L);
        Tuple2 epochAndOffsetFor = this.cache().endOffsetFor(-1);
        Assert.assertEquals((String)"Expected undefined epoch and offset if undefined epoch requested. Cache not empty.", (Object)expectedEpochEndOffset, (Object)epochAndOffsetFor);
    }

    @Test
    public void shouldNotOverwriteLogEndOffsetForALeaderEpochOnceItHasBeenAssigned() {
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(9L);
        this.cache().assign(2, this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset());
        this.cache().assign(2, 10L);
        Assert.assertEquals((long)this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset(), (long)((EpochEntry)this.cache().epochEntries().apply(0)).startOffset());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 9L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingStartOffsets() {
        this.cache().assign(2, 9L);
        this.cache().assign(3, 9L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotOverwriteOffsetForALeaderEpochOnceItHasBeenAssigned() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 10L);
        Assert.assertEquals((long)6L, (long)((EpochEntry)this.cache().epochEntries().apply(0)).startOffset());
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecorded() {
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(0));
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecordedAndUndefinedEpochRequested() {
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(73L);
        Tuple2 offsetFor = this.cache().endOffsetFor(-1);
        Assert.assertEquals((String)"Expected undefined epoch and offset if undefined epoch requested. Empty cache.", (Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)offsetFor);
    }

    @Test
    public void shouldReturnFirstEpochIfRequestedEpochLessThanFirstEpoch() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        Tuple2 epochAndOffset = this.cache().endOffsetFor(4);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(4, 11), (Object)epochAndOffset);
    }

    @Test
    public void shouldTruncateIfMatchingEpochButEarlierStartingOffset() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        this.cache().assign(7, 12L);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(5, 12), (Object)this.cache().endOffsetFor(5));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(5, 12), (Object)this.cache().endOffsetFor(6));
    }

    @Test
    public void shouldGetFirstOffsetOfSubsequentEpochWhenOffsetRequestedForPreviousEpoch() {
        this.cache().assign(1, 11L);
        this.cache().assign(1, 12L);
        this.cache().assign(2, 13L);
        this.cache().assign(2, 14L);
        this.cache().assign(3, 15L);
        this.cache().assign(3, 16L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(17L);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(2, 15), (Object)this.cache().endOffsetFor(2));
    }

    @Test
    public void shouldReturnNextAvailableEpochIfThereIsNoExactEpochForTheOneRequested() {
        this.cache().assign(0, 10L);
        this.cache().assign(2, 13L);
        this.cache().assign(4, 17L);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(0, 13), (Object)this.cache().endOffsetFor(1));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(2, 17), (Object)this.cache().endOffsetFor(2));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(2, 17), (Object)this.cache().endOffsetFor(3));
    }

    @Test
    public void shouldNotUpdateEpochAndStartOffsetIfItDidNotChange() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        Assert.assertEquals((long)1L, (long)this.cache().epochEntries().size());
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)this.cache().epochEntries().toList().apply(0));
    }

    @Test
    public void shouldReturnInvalidOffsetIfEpochIsRequestedWhichIsNotCurrentlyTracked() {
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(100L);
        this.cache().assign(2, 100L);
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(3));
    }

    @Test
    public void shouldSupportEpochsThatDoNotStartFromZero() {
        this.cache().assign(2, 6L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(7L);
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(2, this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset()), (Object)this.cache().endOffsetFor(2));
        Assert.assertEquals((long)1L, (long)this.cache().epochEntries().size());
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)this.cache().epochEntries().apply(0));
    }

    @Test
    public void shouldPersistEpochsBetweenInstances() {
        String checkpointPath = TestUtils$.MODULE$.tempFile().getAbsolutePath();
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(new File(checkpointPath), LeaderEpochCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (LeaderEpochCheckpoint)checkpoint);
        cache.assign(2, 6L);
        LeaderEpochCheckpointFile checkpoint2 = new LeaderEpochCheckpointFile(new File(checkpointPath), LeaderEpochCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        LeaderEpochFileCache cache2 = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (LeaderEpochCheckpoint)checkpoint2);
        Assert.assertEquals((long)1L, (long)cache2.epochEntries().size());
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache2.epochEntries().toList().apply(0));
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingEpochs() {
        this.cache().assign(1, 5L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(6L);
        this.cache().assign(2, 6L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(7L);
        this.cache().assign(1, 7L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(8L);
        Assert.assertEquals((long)1L, (long)this.cache().latestEpoch());
        Assert.assertEquals((Object)new Tuple2.mcII.sp(1, 8), (Object)this.cache().endOffsetFor(1));
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(2));
        Assert.assertEquals((Object)new EpochEntry(1, 7L), (Object)this.cache().epochEntries().apply(0));
    }

    @Test
    public void shouldEnforceOffsetsIncreaseMonotonically() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 5L);
        Assert.assertEquals((Object)new EpochEntry(3, 5L), (Object)this.cache().epochEntries().toList().apply(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsLeadersChangeManyTimes() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 0L);
        Assert.assertEquals((long)1L, (long)this.cache().latestEpoch());
        Assert.assertEquals((Object)new Tuple2.mcII.sp(1, 0), (Object)this.cache().endOffsetFor(1));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0));
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(5L);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(1, 5), (Object)this.cache().endOffsetFor(1));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0));
        this.cache().assign(2, 5L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(10L);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(2, 10), (Object)this.cache().endOffsetFor(2));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(1, 5), (Object)this.cache().endOffsetFor(1));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsFollowerReceivesManyMessages() {
        this.cache().assign(0, 0L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(1L);
        this.cache().assign(0, 1L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(2L);
        this.cache().assign(0, 2L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(3L);
        Assert.assertEquals((long)0L, (long)this.cache().latestEpoch());
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(0, this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset()), (Object)this.cache().endOffsetFor(0));
        this.cache().assign(1, 3L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(4L);
        this.cache().assign(1, 4L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(5L);
        this.cache().assign(1, 5L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(6L);
        Assert.assertEquals((long)1L, (long)this.cache().latestEpoch());
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(1, this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset()), (Object)this.cache().endOffsetFor(1));
        this.cache().assign(2, 6L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(7L);
        this.cache().assign(2, 7L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(8L);
        this.cache().assign(2, 8L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(9L);
        Assert.assertEquals((long)2L, (long)this.cache().latestEpoch());
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(2, this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset()), (Object)this.cache().endOffsetFor(2));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(0, 3), (Object)this.cache().endOffsetFor(0));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(1, 6), (Object)this.cache().endOffsetFor(1));
    }

    @Test
    public void shouldDropEntriesOnEpochBoundaryWhenRemovingLatestEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(8L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldPreserveResetOffsetOnClearEarliestIfOneExists() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(8L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateSavedOffsetWhenOffsetToClearToIsBetweenEpochs() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToEarly() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(1L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToFirstOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(6L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(11L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest2() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 7L);
        this.cache().assign(2, 10L);
        this.cache().truncateFromStart(5L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 5L), new EpochEntry(1, 7L), new EpochEntry(2, 10L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliestAndUpdateItsOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(15L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 15L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldDropEntriesBetweenEpochBoundaryWhenRemovingNewest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(9L);
        Assert.assertEquals((long)3L, (long)this.cache().latestEpoch());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldClearAllEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().clearAndFlush();
        Assert.assertEquals((long)0L, (long)this.cache().epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryHeadIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(-1L);
        Assert.assertEquals((long)3L, (long)this.cache().epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryTailIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(-1L);
        Assert.assertEquals((long)3L, (long)this.cache().epochEntries().size());
    }

    @Test
    public void shouldFetchLatestEpochOfEmptyCache() {
        Assert.assertEquals((long)-1L, (long)this.cache().latestEpoch());
    }

    @Test
    public void shouldFetchEndOffsetOfEmptyCache() {
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(7));
    }

    @Test
    public void shouldClearEarliestOnEmptyCache() {
        this.cache().truncateFromStart(7L);
    }

    @Test
    public void shouldClearLatestOnEmptyCache() {
        this.cache().truncateFromEnd(7L);
    }
}

