/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.cluster.Broker;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.AdminManager$;
import kafka.server.AdminManager$$anonfun$10$;
import kafka.server.ConfigType$;
import kafka.server.CreatePartitionsMetadata;
import kafka.server.DelayedCreatePartitions;
import kafka.server.DelayedDeleteTopics;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DeleteTopicMetadata;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.MetadataCache;
import kafka.server.TopicKey;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging$class;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.ReassignmentInProgressException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t=g\u0001B\u0001\u0003\u0001\u001d\u0011A\"\u00113nS:l\u0015M\\1hKJT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0005\u0001!qA\u0003\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oOB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\b[\u0016$(/[2t\u0013\tIbCA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkBD\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u0007G>tg-[4\u0016\u0003u\u0001\"AH\u0010\u000e\u0003\tI!\u0001\t\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\tE\u0001\u0011\t\u0011)A\u0005;\u000591m\u001c8gS\u001e\u0004\u0003\u0002C\f\u0001\u0005\u000b\u0007I\u0011\u0001\u0013\u0016\u0003\u0015\u0002\"AJ\u0018\u000e\u0003\u001dR!a\u0006\u0015\u000b\u0005%R\u0013AB2p[6|gN\u0003\u0002\u0006W)\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0013\t\u0001tEA\u0004NKR\u0014\u0018nY:\t\u0011I\u0002!\u0011!Q\u0001\n\u0015\n\u0001\"\\3ue&\u001c7\u000f\t\u0005\ti\u0001\u0011)\u0019!C\u0001k\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012A\u000e\t\u0003=]J!\u0001\u000f\u0002\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0011!Q\u0004A!A!\u0002\u00131\u0014AD7fi\u0006$\u0017\r^1DC\u000eDW\r\t\u0005\ty\u0001\u0011)\u0019!C\u0001{\u0005A!p[\"mS\u0016tG/F\u0001?!\ty$)D\u0001A\u0015\t\tE!\u0001\u0002{W&\u00111\t\u0011\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\t\u0011\u0015\u0003!\u0011!Q\u0001\ny\n\u0011B_6DY&,g\u000e\u001e\u0011\t\u000b\u001d\u0003A\u0011\u0001%\u0002\rqJg.\u001b;?)\u0015I%j\u0013'N!\tq\u0002\u0001C\u0003\u001c\r\u0002\u0007Q\u0004C\u0003\u0018\r\u0002\u0007Q\u0005C\u00035\r\u0002\u0007a\u0007C\u0003=\r\u0002\u0007a\bC\u0004P\u0001\t\u0007I\u0011\u0002)\u0002\u001dQ|\u0007/[2QkJ<\u0017\r^8ssV\t\u0011\u000bE\u0002\u001f%RK!a\u0015\u0002\u00033\u0011+G.Y=fI>\u0003XM]1uS>t\u0007+\u001e:hCR|'/\u001f\t\u0003=UK!A\u0016\u0002\u0003!\u0011+G.Y=fI>\u0003XM]1uS>t\u0007B\u0002-\u0001A\u0003%\u0011+A\bu_BL7\rU;sO\u0006$xN]=!\u0011\u001dQ\u0006A1A\u0005\nm\u000bQ\"\u00193nS:T6n\u00117jK:$X#\u0001/\u0011\u0005}j\u0016B\u00010A\u00055\tE-\\5o5.\u001cE.[3oi\"1\u0001\r\u0001Q\u0001\nq\u000ba\"\u00193nS:T6n\u00117jK:$\b\u0005C\u0004c\u0001\t\u0007I\u0011B2\u0002#\r\u0014X-\u0019;f)>\u0004\u0018n\u0019)pY&\u001c\u00170F\u0001e!\rIQmZ\u0005\u0003M*\u0011aa\u00149uS>t\u0007C\u00015m\u001b\u0005I'B\u00016l\u0003\u0019\u0001x\u000e\\5ds*\u00111AK\u0005\u0003[&\u0014\u0011c\u0011:fCR,Gk\u001c9jGB{G.[2z\u0011\u0019y\u0007\u0001)A\u0005I\u0006\u00112M]3bi\u0016$v\u000e]5d!>d\u0017nY=!\u0011\u001d\t\bA1A\u0005\nI\f\u0011#\u00197uKJ\u001cuN\u001c4jOB{G.[2z+\u0005\u0019\bcA\u0005fiB\u0011\u0001.^\u0005\u0003m&\u0014\u0011#\u00117uKJ\u001cuN\u001c4jOB{G.[2z\u0011\u0019A\b\u0001)A\u0005g\u0006\u0011\u0012\r\u001c;fe\u000e{gNZ5h!>d\u0017nY=!\u0011\u0015Q\b\u0001\"\u0001|\u0003eA\u0017m\u001d#fY\u0006LX\r\u001a+pa&\u001cw\n]3sCRLwN\\:\u0016\u0003q\u0004\"!C?\n\u0005yT!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0003\u0005\"(/_\"p[BdW\r^3EK2\f\u00170\u001a3U_BL7m\u00149fe\u0006$\u0018n\u001c8t)\u0011\t)!a\u0003\u0011\u0007%\t9!C\u0002\u0002\n)\u0011A!\u00168ji\"9\u0011QB@A\u0002\u0005=\u0011!\u0002;pa&\u001c\u0007\u0003BA\t\u0003/q1!CA\n\u0013\r\t)BC\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00111\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005U!\u0002C\u0004\u0002 \u0001!\t!!\t\u0002\u0019\r\u0014X-\u0019;f)>\u0004\u0018nY:\u0015\u0015\u0005\u0015\u00111EA\u0017\u0003c\ti\u0007\u0003\u0005\u0002&\u0005u\u0001\u0019AA\u0014\u0003\u001d!\u0018.\\3pkR\u00042!CA\u0015\u0013\r\tYC\u0003\u0002\u0004\u0013:$\bbBA\u0018\u0003;\u0001\r\u0001`\u0001\rm\u0006d\u0017\u000eZ1uK>sG.\u001f\u0005\t\u0003g\ti\u00021\u0001\u00026\u0005Q1M]3bi\u0016LeNZ8\u0011\u0011\u0005]\u0012QHA\b\u0003\u0003j!!!\u000f\u000b\u0007\u0005m\"\"\u0001\u0006d_2dWm\u0019;j_:LA!a\u0010\u0002:\t\u0019Q*\u00199\u0011\t\u0005\r\u0013q\r\b\u0005\u0003\u000b\n\tG\u0004\u0003\u0002H\u0005uc\u0002BA%\u00037rA!a\u0013\u0002Z9!\u0011QJA,\u001d\u0011\ty%!\u0016\u000e\u0005\u0005E#bAA*\r\u00051AH]8pizJ\u0011AL\u0005\u0003Y5J!!B\u0016\n\u0005%R\u0013bAA0Q\u0005A!/Z9vKN$8/\u0003\u0003\u0002d\u0005\u0015\u0014aE\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$(bAA0Q%!\u0011\u0011NA6\u00051!v\u000e]5d\t\u0016$\u0018-\u001b7t\u0015\u0011\t\u0019'!\u001a\t\u0011\u0005=\u0014Q\u0004a\u0001\u0003c\n\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\u000f%\t\u0019(a\u001e\u0002\u0006%\u0019\u0011Q\u000f\u0006\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003CA\u001c\u0003{\ty!!\u001f\u0011\t\u0005m\u0014QP\u0007\u0003\u0003KJA!a \u0002f\tA\u0011\t]5FeJ|'\u000fC\u0004\u0002\u0004\u0002!\t!!\"\u0002\u0019\u0011,G.\u001a;f)>\u0004\u0018nY:\u0015\u0011\u0005\u0015\u0011qQAE\u0003'C\u0001\"!\n\u0002\u0002\u0002\u0007\u0011q\u0005\u0005\t\u0003\u0017\u000b\t\t1\u0001\u0002\u000e\u00061Ao\u001c9jGN\u0004b!a\u000e\u0002\u0010\u0006=\u0011\u0002BAI\u0003s\u00111aU3u\u0011!\ty'!!A\u0002\u0005U\u0005cB\u0005\u0002t\u0005]\u0015Q\u0001\t\t\u0003o\ti$a\u0004\u0002\u001aB!\u00111TAQ\u001b\t\tiJC\u0002\u0002 \"\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003G\u000biJ\u0001\u0004FeJ|'o\u001d\u0005\b\u0003O\u0003A\u0011AAU\u0003A\u0019'/Z1uKB\u000b'\u000f^5uS>t7\u000f\u0006\u0007\u0002\u0006\u0005-\u0016QVAb\u0003\u000b\f)\u000e\u0003\u0005\u0002&\u0005\u0015\u0006\u0019AA\u0014\u0011!\ty+!*A\u0002\u0005E\u0016!\u00048foB\u000b'\u000f^5uS>t7\u000f\u0005\u0005\u00028\u0005u\u0012qBAZ!\u0011\t),a0\u000e\u0005\u0005]&\u0002BA]\u0003w\u000bQ!\u00193nS:T1!!0+\u0003\u001d\u0019G.[3oiNLA!!1\u00028\nia*Z<QCJ$\u0018\u000e^5p]NDq!a\f\u0002&\u0002\u0007A\u0010\u0003\u0005\u0002H\u0006\u0015\u0006\u0019AAe\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f!\u0011\tY-!5\u000e\u0005\u00055'bAAhQ\u00059a.\u001a;x_J\\\u0017\u0002BAj\u0003\u001b\u0014A\u0002T5ti\u0016tWM\u001d(b[\u0016D\u0001\"a6\u0002&\u0002\u0007\u0011\u0011O\u0001\tG\u0006dGNY1dW\"9\u00111\u001c\u0001\u0005\u0002\u0005u\u0017a\u00043fg\u000e\u0014\u0018NY3D_:4\u0017nZ:\u0015\r\u0005}\u0017\u0011 B\u0001!!\t9$!\u0010\u0002b\u0006-\b\u0003BAr\u0003Ol!!!:\u000b\u0005mA\u0013\u0002BAu\u0003K\u0014abQ8oM&<'+Z:pkJ\u001cW\r\u0005\u0003\u0002n\u0006Mh\u0002BA>\u0003_LA!!=\u0002f\u00059B)Z:de&\u0014WmQ8oM&<7OU3ta>t7/Z\u0005\u0005\u0003k\f9P\u0001\u0004D_:4\u0017n\u001a\u0006\u0005\u0003c\f)\u0007\u0003\u0005\u0002|\u0006e\u0007\u0019AA\u007f\u0003U\u0011Xm]8ve\u000e,Gk\\\"p]\u001aLwMT1nKN\u0004\u0002\"a\u000e\u0002>\u0005\u0005\u0018q \t\u0005\u0013\u0015\fi\tC\u0004\u0003\u0004\u0005e\u0007\u0019\u0001?\u0002\u001f%t7\r\\;eKNKhn\u001c8z[NDqAa\u0002\u0001\t\u0003\u0011I!\u0001\u0007bYR,'oQ8oM&<7\u000f\u0006\u0004\u0003\f\t5!q\u0004\t\t\u0003o\ti$!9\u0002z!A!q\u0002B\u0003\u0001\u0004\u0011\t\"A\u0004d_:4\u0017nZ:\u0011\u0011\u0005]\u0012QHAq\u0005'\u0001BA!\u0006\u0003\u001c9!\u00111\u0010B\f\u0013\u0011\u0011I\"!\u001a\u0002'\u0005cG/\u001a:D_:4\u0017nZ:SKF,Xm\u001d;\n\t\u0005U(Q\u0004\u0006\u0005\u00053\t)\u0007C\u0004\u00020\t\u0015\u0001\u0019\u0001?\t\u000f\t\r\u0002\u0001\"\u0001\u0003&\u0005A1\u000f[;uI><h\u000e\u0006\u0002\u0002\u0006!9!\u0011\u0006\u0001\u0005\n\t-\u0012A\u0006:fg>,(oY3OC6,Gk\u001c\"s_.,'/\u00133\u0015\t\u0005\u001d\"Q\u0006\u0005\t\u0005_\u00119\u00031\u0001\u0002\u0010\u0005a!/Z:pkJ\u001cWMT1nK\"9!1\u0007\u0001\u0005\n\tU\u0012A\u00042s_.,'oU=o_:LXn\u001d\u000b\u0005\u0005o\u0011I\u0005\u0005\u0004\u0003:\t\r\u0013q\u0002\b\u0005\u0005w\u0011yD\u0004\u0003\u0002P\tu\u0012\"A\u0006\n\u0007\t\u0005#\"A\u0004qC\u000e\\\u0017mZ3\n\t\t\u0015#q\t\u0002\u0005\u0019&\u001cHOC\u0002\u0003B)A\u0001Ba\u0013\u00032\u0001\u0007\u0011qB\u0001\u0005]\u0006lW\rC\u0004\u0003P\u0001!IA!\u0015\u0002\u0015\r|gNZ5h)f\u0004X\r\u0006\u0004\u0003T\t\u0005$1\r\t\u0005\u0005+\u0012YF\u0004\u0003\u0002d\n]\u0013\u0002\u0002B-\u0003K\f\u0011bQ8oM&<G)\u001a4\n\t\tu#q\f\u0002\u0005)f\u0004XM\u0003\u0003\u0003Z\u0005\u0015\b\u0002\u0003B&\u0005\u001b\u0002\r!a\u0004\t\u0011\t\u0015$Q\na\u0001\u0005o\t\u0001b]=o_:LXn\u001d\u0005\b\u0005S\u0002A\u0011\u0002B6\u00039\u0019wN\u001c4jONKhn\u001c8z[N$\u0002B!\u001c\u0003v\t]$\u0011\u0010\t\u0007\u0005s\u0011\u0019Ea\u001c\u0011\t\u00055(\u0011O\u0005\u0005\u0005g\n9PA\u0007D_:4\u0017nZ*z]>t\u00170\u001c\u0005\t\u0005\u0017\u00129\u00071\u0001\u0002\u0010!A!Q\rB4\u0001\u0004\u00119\u0004C\u0004\u0003|\t\u001d\u0004\u0019\u0001?\u0002\u0017%\u001c8+\u001a8tSRLg/\u001a\u0005\b\u0005\u007f\u0002A\u0011\u0002BA\u0003Y\u0019'/Z1uKR{\u0007/[2D_:4\u0017nZ#oiJLH\u0003\u0003BB\u0005/\u00139Ka/\u0015\r\t\u0015%1\u0012BG!\u0011\tiOa\"\n\t\t%\u0015q\u001f\u0002\f\u0007>tg-[4F]R\u0014\u0018\u0010\u0003\u0005\u0003L\tu\u0004\u0019AA\b\u0011!\u0011yI! A\u0002\tE\u0015!\u0002<bYV,\u0007cA\u0005\u0003\u0014&\u0019!Q\u0013\u0006\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0003\u001a\nu\u0004\u0019\u0001BN\u0003%awnZ\"p]\u001aLw\r\u0005\u0003\u0003\u001e\n\rVB\u0001BP\u0015\r\u0011\t\u000bB\u0001\u0004Y><\u0017\u0002\u0002BS\u0005?\u0013\u0011\u0002T8h\u0007>tg-[4\t\u0011\t%&Q\u0010a\u0001\u0005W\u000b!\u0002^8qS\u000e\u0004&o\u001c9t!\u0011\u0011iKa.\u000e\u0005\t=&\u0002\u0002BY\u0005g\u000bA!\u001e;jY*\u0011!QW\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003:\n=&A\u0003)s_B,'\u000f^5fg\"9!1\u0001B?\u0001\u0004a\bb\u0002B`\u0001\u0011%!\u0011Y\u0001\u0018GJ,\u0017\r^3Ce>\\WM]\"p]\u001aLw-\u00128uef$bAa1\u0003J\n5GC\u0002BC\u0005\u000b\u00149\r\u0003\u0005\u0003L\tu\u0006\u0019AA\b\u0011!\u0011yI!0A\u0002\tE\u0005b\u0002Bf\u0005{\u0003\r\u0001`\u0001\u0010a\u0016\u0014(I]8lKJ\u001cuN\u001c4jO\"9!1\u0001B_\u0001\u0004a\b")
public class AdminManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MetadataCache metadataCache;
    private final KafkaZkClient zkClient;
    private final DelayedOperationPurgatory<DelayedOperation> topicPurgatory;
    private final AdminZkClient kafka$server$AdminManager$$adminZkClient;
    private final Option<CreateTopicPolicy> kafka$server$AdminManager$$createTopicPolicy;
    private final Option<AlterConfigPolicy> kafka$server$AdminManager$$alterConfigPolicy;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.metricName(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.explicitMetricName(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    private Logger logger$lzycompute() {
        AdminManager adminManager = this;
        synchronized (adminManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private DelayedOperationPurgatory<DelayedOperation> topicPurgatory() {
        return this.topicPurgatory;
    }

    public AdminZkClient kafka$server$AdminManager$$adminZkClient() {
        return this.kafka$server$AdminManager$$adminZkClient;
    }

    public Option<CreateTopicPolicy> kafka$server$AdminManager$$createTopicPolicy() {
        return this.kafka$server$AdminManager$$createTopicPolicy;
    }

    public Option<AlterConfigPolicy> kafka$server$AdminManager$$alterConfigPolicy() {
        return this.kafka$server$AdminManager$$alterConfigPolicy;
    }

    public boolean hasDelayedTopicOperations() {
        return this.topicPurgatory().delayed() != 0;
    }

    public void tryCompleteDelayedTopicOperations(String topic) {
        TopicKey key = new TopicKey(topic);
        int completed = this.topicPurgatory().checkAndComplete(key);
        this.debug((Function0<String>)new Serializable(this, key, completed){
            public static final long serialVersionUID = 0L;
            private final TopicKey key$1;
            private final int completed$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request key ", " unblocked ", " topic requests."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$1.keyLabel(), BoxesRunTime.boxToInteger((int)this.completed$1)}));
            }
            {
                this.key$1 = key$1;
                this.completed$1 = completed$1;
            }
        });
    }

    public void createTopics(int timeout, boolean validateOnly, Map<String, CreateTopicsRequest.TopicDetails> createInfo, Function1<Map<String, ApiError>, BoxedUnit> responseCallback) {
        Seq brokers = (Seq)this.metadataCache().getAliveBrokers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Broker b) {
                return new BrokerMetadata(b.id(), b.rack());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Iterable metadata = (Iterable)createInfo.map((Function1)new Serializable(this, validateOnly, brokers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            private final boolean validateOnly$1;
            private final Seq brokers$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final CreatePartitionsMetadata apply(Tuple2<String, CreateTopicsRequest.TopicDetails> x0$1) {
                CreatePartitionsMetadata createPartitionsMetadata;
                Tuple2<String, CreateTopicsRequest.TopicDetails> tuple2 = x0$1;
                if (tuple2 == null) throw new MatchError(tuple2);
                String topic = (String)tuple2._1();
                CreateTopicsRequest.TopicDetails arguments = (CreateTopicsRequest.TopicDetails)tuple2._2();
                try {
                    Properties configs = new Properties();
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.configs).asScala()).foreach((Function1)new Serializable(this, configs){
                        public static final long serialVersionUID = 0L;
                        private final Properties configs$1;

                        public final Object apply(Tuple2<String, String> x0$2) {
                            Tuple2<String, String> tuple2 = x0$2;
                            if (tuple2 != null) {
                                String key = (String)tuple2._1();
                                String value2 = (String)tuple2._2();
                                Object object = this.configs$1.setProperty(key, value2);
                                return object;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.configs$1 = configs$1;
                        }
                    });
                    LogConfig$.MODULE$.validate(configs);
                    if (!(arguments.numPartitions == -1 && arguments.replicationFactor == -1 || arguments.replicasAssignments.isEmpty())) {
                        throw new InvalidRequestException("Both numPartitions or replicationFactor and replicasAssignments were set. Both cannot be used at the same time.");
                    }
                    Map assignments = arguments.replicasAssignments.isEmpty() ? AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)this.brokers$1, arguments.numPartitions, arguments.replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5()) : (Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.replicasAssignments).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Buffer<Object>> apply(Tuple2<Integer, java.util.List<Integer>> x0$3) {
                            Tuple2<Integer, java.util.List<Integer>> tuple2 = x0$3;
                            if (tuple2 != null) {
                                Integer partitionId = (Integer)tuple2._1();
                                java.util.List replicas = (java.util.List)tuple2._2();
                                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(Integer x$1) {
                                        return x$1;
                                    }
                                }, Buffer$.MODULE$.canBuildFrom()));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    this.$outer.trace((Function0<String>)new Serializable(this, topic, assignments){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;
                        private final Map assignments$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Assignments for topic ", " are ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.assignments$1}));
                        }
                        {
                            this.topic$1 = topic$1;
                            this.assignments$1 = assignments$1;
                        }
                    });
                    Option<CreateTopicPolicy> option = this.$outer.kafka$server$AdminManager$$createTopicPolicy();
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some = (Some)option;
                        CreateTopicPolicy policy = (CreateTopicPolicy)some.x();
                        this.$outer.kafka$server$AdminManager$$adminZkClient().validateCreateOrUpdateTopic(topic, (Map<Object, Seq<Object>>)assignments, configs, false);
                        Integer numPartitions = arguments.numPartitions == -1 ? null : Predef$.MODULE$.int2Integer(arguments.numPartitions);
                        Short replicationFactor = arguments.replicationFactor == -1 ? null : Predef$.MODULE$.short2Short(arguments.replicationFactor);
                        java.util.Map replicaAssignments = arguments.replicasAssignments.isEmpty() ? null : arguments.replicasAssignments;
                        policy.validate(new CreateTopicPolicy.RequestMetadata(topic, numPartitions, replicationFactor, replicaAssignments, arguments.configs));
                        if (this.validateOnly$1) {
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.$outer.kafka$server$AdminManager$$adminZkClient().createOrUpdateTopicPartitionAssignmentPathInZK(topic, (Map<Object, Seq<Object>>)assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else {
                        BoxedUnit boxedUnit;
                        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                        if (this.validateOnly$1) {
                            this.$outer.kafka$server$AdminManager$$adminZkClient().validateCreateOrUpdateTopic(topic, (Map<Object, Seq<Object>>)assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.$outer.kafka$server$AdminManager$$adminZkClient().createOrUpdateTopicPartitionAssignmentPathInZK(topic, (Map<Object, Seq<Object>>)assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit;
                    }
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)assignments, ApiError.NONE);
                    return createPartitionsMetadata;
                }
                catch (Throwable throwable) {
                    this.$outer.error((Function0<String>)new Serializable(this, topic, arguments){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;
                        private final CreateTopicsRequest.TopicDetails arguments$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing create topic request for topic ", " with arguments ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.arguments$1}));
                        }
                        {
                            this.topic$1 = topic$1;
                            this.arguments$1 = arguments$1;
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable e$2;

                        public final Throwable apply() {
                            return this.e$2;
                        }
                        {
                            this.e$2 = e$2;
                        }
                    });
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), ApiError.fromThrowable((Throwable)throwable));
                    return createPartitionsMetadata;
                }
                catch (ApiException apiException) {
                    this.$outer.info((Function0<String>)new Serializable(this, topic, arguments){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;
                        private final CreateTopicsRequest.TopicDetails arguments$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing create topic request for topic ", " with arguments ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.arguments$1}));
                        }
                        {
                            this.topic$1 = topic$1;
                            this.arguments$1 = arguments$1;
                        }
                    }, (Function0<Throwable>)new Serializable(this, apiException){
                        public static final long serialVersionUID = 0L;
                        private final ApiException e$1;

                        public final ApiException apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), ApiError.fromThrowable((Throwable)apiException));
                }
                return createPartitionsMetadata;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.validateOnly$1 = validateOnly$1;
                this.brokers$1 = brokers$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        if (timeout > 0 && !validateOnly && metadata.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CreatePartitionsMetadata x$2) {
                return x$2.error().is(Errors.NONE);
            }
        })) {
            DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, (Seq<CreatePartitionsMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedCreateKeys = ((TraversableOnce)createInfo.keys().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TopicKey apply(String x$3) {
                    return new TopicKey(x$3);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
        } else {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1)new Serializable(this, validateOnly){
                public static final long serialVersionUID = 0L;
                private final boolean validateOnly$1;

                public final Tuple2<String, ApiError> apply(CreatePartitionsMetadata createTopicMetadata) {
                    return createTopicMetadata.error().isSuccess() && !this.validateOnly$1 ? new Tuple2((Object)createTopicMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null)) : new Tuple2((Object)createTopicMetadata.topic(), (Object)createTopicMetadata.error());
                }
                {
                    this.validateOnly$1 = validateOnly$1;
                }
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
        }
    }

    public void deleteTopics(int timeout, Set<String> topics, Function1<Map<String, Errors>, BoxedUnit> responseCallback) {
        Set metadata = (Set)topics.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;

            public final DeleteTopicMetadata apply(String topic) {
                DeleteTopicMetadata deleteTopicMetadata;
                try {
                    this.$outer.kafka$server$AdminManager$$adminZkClient().deleteTopic(topic);
                    deleteTopicMetadata = new DeleteTopicMetadata(topic, Errors.NONE);
                }
                catch (Throwable throwable) {
                    this.$outer.error((Function0<String>)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing delete topic request for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2}));
                        }
                        {
                            this.topic$2 = topic$2;
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable e$3;

                        public final Throwable apply() {
                            return this.e$3;
                        }
                        {
                            this.e$3 = e$3;
                        }
                    });
                    deleteTopicMetadata = new DeleteTopicMetadata(topic, Errors.forException((Throwable)throwable));
                }
                catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
                    deleteTopicMetadata = new DeleteTopicMetadata(topic, Errors.NONE);
                }
                return deleteTopicMetadata;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        if (timeout > 0 && metadata.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(DeleteTopicMetadata x$4) {
                Errors errors = x$4.error();
                Errors errors2 = Errors.NONE;
                return !(errors != null ? !errors.equals(errors2) : errors2 != null);
            }
        })) {
            DelayedDeleteTopics delayedDelete = new DelayedDeleteTopics(timeout, (Seq<DeleteTopicMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedDeleteKeys = ((SetLike)topics.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TopicKey apply(String x$5) {
                    return new TopicKey(x$5);
                }
            }, Set$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedDelete, (Seq<Object>)delayedDeleteKeys);
        } else {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Errors> apply(DeleteTopicMetadata deleteTopicMetadata) {
                    Errors errors = deleteTopicMetadata.error();
                    Errors errors2 = Errors.NONE;
                    return !(errors != null ? !errors.equals(errors2) : errors2 != null) ? new Tuple2((Object)deleteTopicMetadata.topic(), (Object)Errors.REQUEST_TIMED_OUT) : new Tuple2((Object)deleteTopicMetadata.topic(), (Object)deleteTopicMetadata.error());
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
        }
    }

    public void createPartitions(int timeout, Map<String, NewPartitions> newPartitions, boolean validateOnly, ListenerName listenerName, Function1<Map<String, ApiError>, BoxedUnit> callback) {
        boolean reassignPartitionsInProgress = this.zkClient().reassignPartitionsInProgress();
        Seq<BrokerMetadata> allBrokers = this.kafka$server$AdminManager$$adminZkClient().getBrokerMetadatas(this.kafka$server$AdminManager$$adminZkClient().getBrokerMetadatas$default$1(), this.kafka$server$AdminManager$$adminZkClient().getBrokerMetadatas$default$2());
        Seq allBrokerIds = (Seq)allBrokers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$6) {
                return x$6.id();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Iterable metadata = (Iterable)newPartitions.map((Function1)new Serializable(this, validateOnly, reassignPartitionsInProgress, allBrokers, allBrokerIds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            private final boolean validateOnly$2;
            private final boolean reassignPartitionsInProgress$1;
            private final Seq allBrokers$1;
            public final Seq allBrokerIds$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final CreatePartitionsMetadata apply(Tuple2<String, NewPartitions> x0$4) {
                CreatePartitionsMetadata createPartitionsMetadata;
                Tuple2<String, NewPartitions> tuple2 = x0$4;
                if (tuple2 == null) throw new MatchError(tuple2);
                String topic = (String)tuple2._1();
                NewPartitions newPartition = (NewPartitions)tuple2._2();
                try {
                    if (this.reassignPartitionsInProgress$1) {
                        throw new ReassignmentInProgressException("A partition reassignment is in progress.");
                    }
                    scala.collection.immutable.Map existingAssignment = (scala.collection.immutable.Map)this.$outer.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)scala.collection.immutable.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicPartition, Seq<Object>> x0$5) {
                            Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$5;
                            if (tuple2 != null) {
                                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                                Seq replicas = (Seq)tuple2._2();
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (Object)replicas);
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                    if (existingAssignment.isEmpty()) {
                        throw new UnknownTopicOrPartitionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The topic '", "' does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                    }
                    int oldNumPartitions = existingAssignment.size();
                    int newNumPartitions = newPartition.totalCount();
                    int numPartitionsIncrement = newNumPartitions - oldNumPartitions;
                    if (numPartitionsIncrement < 0) {
                        throw new InvalidPartitionsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic currently has ", " partitions, which is higher than the requested ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)oldNumPartitions), BoxesRunTime.boxToInteger((int)newNumPartitions)})));
                    }
                    if (numPartitionsIncrement == 0) {
                        throw new InvalidPartitionsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic already has ", " partitions."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)oldNumPartitions)})));
                    }
                    Option reassignment = Option$.MODULE$.apply((Object)newPartition.assignments()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Buffer<Buffer<Object>> apply(java.util.List<java.util.List<Integer>> x$7) {
                            return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$7).asScala()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Buffer<Object> apply(java.util.List<Integer> x$8) {
                                    return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$8).asScala()).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(Integer x$9) {
                                            return Predef$.MODULE$.Integer2int(x$9);
                                        }
                                    }, Buffer$.MODULE$.canBuildFrom());
                                }
                            }, Buffer$.MODULE$.canBuildFrom());
                        }
                    }).map((Function1)new Serializable(this, existingAssignment, numPartitionsIncrement){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$10 $outer;
                        public final scala.collection.immutable.Map existingAssignment$1;
                        private final int numPartitionsIncrement$1;

                        public final scala.collection.immutable.Map<Object, Buffer<Object>> apply(Buffer<Buffer<Object>> assignments) {
                            scala.collection.immutable.Set unknownBrokers = (scala.collection.immutable.Set)((TraversableOnce)assignments.flatten((Function1)Predef$.MODULE$.$conforms())).toSet().$minus$minus((GenTraversableOnce)this.$outer.allBrokerIds$1);
                            if (unknownBrokers.nonEmpty()) {
                                throw new InvalidReplicaAssignmentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown broker(s) in replica assignment: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unknownBrokers.mkString(", ")})));
                            }
                            if (assignments.size() != this.numPartitionsIncrement$1) {
                                throw new InvalidReplicaAssignmentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Increasing the number of partitions by ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numPartitionsIncrement$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but ", " assignments provided."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)assignments.size())}))).toString());
                            }
                            return ((TraversableOnce)((TraversableLike)assignments.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$10$$anonfun$13 $outer;

                                public final Tuple2<Object, Buffer<Object>> apply(Tuple2<Buffer<Object>, Object> x0$6) {
                                    Tuple2<Buffer<Object>, Object> tuple2 = x0$6;
                                    if (tuple2 != null) {
                                        Buffer replicas = (Buffer)tuple2._1();
                                        int index = tuple2._2$mcI$sp();
                                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(this.$outer.existingAssignment$1.size() + index))), (Object)replicas);
                                        return tuple22;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.existingAssignment$1 = existingAssignment$1;
                            this.numPartitionsIncrement$1 = numPartitionsIncrement$1;
                        }
                    });
                    Map<Object, Seq<Object>> updatedReplicaAssignment = this.$outer.kafka$server$AdminManager$$adminZkClient().addPartitions(topic, (Map<Object, Seq<Object>>)existingAssignment, (Seq<BrokerMetadata>)this.allBrokers$1, newPartition.totalCount(), (Option<Map<Object, Seq<Object>>>)reassignment, this.validateOnly$2);
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, updatedReplicaAssignment, ApiError.NONE);
                    return createPartitionsMetadata;
                }
                catch (ApiException apiException) {
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)scala.collection.Map$.MODULE$.empty(), ApiError.fromThrowable((Throwable)apiException));
                    return createPartitionsMetadata;
                }
                catch (AdminOperationException adminOperationException) {
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)scala.collection.Map$.MODULE$.empty(), ApiError.fromThrowable((Throwable)adminOperationException));
                }
                return createPartitionsMetadata;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.validateOnly$2 = validateOnly$2;
                this.reassignPartitionsInProgress$1 = reassignPartitionsInProgress$1;
                this.allBrokers$1 = allBrokers$1;
                this.allBrokerIds$1 = allBrokerIds$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        if (timeout > 0 && !validateOnly && metadata.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CreatePartitionsMetadata x$10) {
                return x$10.error().is(Errors.NONE);
            }
        })) {
            DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, (Seq<CreatePartitionsMetadata>)metadata.toSeq(), this, callback);
            Seq delayedCreateKeys = ((SetLike)newPartitions.keySet().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TopicKey apply(String x$11) {
                    return new TopicKey(x$11);
                }
            }, Set$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
        } else {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1)new Serializable(this, validateOnly){
                public static final long serialVersionUID = 0L;
                private final boolean validateOnly$2;

                public final Tuple2<String, ApiError> apply(CreatePartitionsMetadata createPartitionMetadata) {
                    return createPartitionMetadata.error().isSuccess() && !this.validateOnly$2 ? new Tuple2((Object)createPartitionMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null)) : new Tuple2((Object)createPartitionMetadata.topic(), (Object)createPartitionMetadata.error());
                }
                {
                    this.validateOnly$2 = validateOnly$2;
                }
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            callback.apply((Object)results);
        }
    }

    public Map<ConfigResource, DescribeConfigsResponse.Config> describeConfigs(Map<ConfigResource, Option<Set<String>>> resourceToConfigNames, boolean includeSynonyms) {
        return ((TraversableOnce)resourceToConfigNames.map((Function1)new Serializable(this, includeSynonyms){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            public final boolean includeSynonyms$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple2<ConfigResource, DescribeConfigsResponse.Config> apply(Tuple2<ConfigResource, Option<Set<String>>> x0$7) {
                Tuple2 tuple2;
                Tuple2<ConfigResource, Option<Set<String>>> tuple22 = x0$7;
                if (tuple22 == null) throw new MatchError(tuple22);
                ConfigResource resource = (ConfigResource)tuple22._1();
                Option configNames = (Option)tuple22._2();
                try {
                    DescribeConfigsResponse.Config config;
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        DescribeConfigsResponse.Config config2;
                        String topic = resource.name();
                        Topic.validate((String)topic);
                        if (this.$outer.metadataCache().contains(topic)) {
                            Properties topicProps = this.$outer.kafka$server$AdminManager$$adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
                            LogConfig logConfig = LogConfig$.MODULE$.fromProps(KafkaServer$.MODULE$.copyKafkaConfigToLog(this.$outer.config()), topicProps);
                            config2 = this.createResponseConfig$1((Map)this.allConfigs$1(logConfig), (Function2)new Serializable(this, topicProps, logConfig){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$describeConfigs$1 $outer;
                                private final Properties topicProps$1;
                                private final LogConfig logConfig$1;

                                public final DescribeConfigsResponse.ConfigEntry apply(String name, Object value2) {
                                    return this.$outer.kafka$server$AdminManager$$anonfun$$$outer().kafka$server$AdminManager$$createTopicConfigEntry(this.logConfig$1, this.topicProps$1, this.$outer.includeSynonyms$1, name, value2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.topicProps$1 = topicProps$1;
                                    this.logConfig$1 = logConfig$1;
                                }
                            }, configNames);
                        } else {
                            config2 = new DescribeConfigsResponse.Config(new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, null), Collections.<T>emptyList());
                        }
                        config = config2;
                    } else {
                        DescribeConfigsResponse.Config config3;
                        if (!ConfigResource.Type.BROKER.equals(type)) throw new InvalidRequestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported resource type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{type})));
                        if (resource.name() == null || resource.name().isEmpty()) {
                            config3 = this.createResponseConfig$1(this.$outer.config().dynamicConfig().currentDynamicDefaultConfigs(), (Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$describeConfigs$1 $outer;

                                public final DescribeConfigsResponse.ConfigEntry apply(String name, Object value2) {
                                    return this.$outer.kafka$server$AdminManager$$anonfun$$$outer().kafka$server$AdminManager$$createBrokerConfigEntry(false, this.$outer.includeSynonyms$1, name, value2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, configNames);
                        } else {
                            if (this.$outer.kafka$server$AdminManager$$resourceNameToBrokerId(resource.name()) != this.$outer.config().brokerId()) throw new InvalidRequestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected broker id, expected ", " or empty string, but received ", ".name"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.config().brokerId()), resource})));
                            config3 = this.createResponseConfig$1((Map)this.allConfigs$1(this.$outer.config()), (Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$describeConfigs$1 $outer;

                                public final DescribeConfigsResponse.ConfigEntry apply(String name, Object value2) {
                                    return this.$outer.kafka$server$AdminManager$$anonfun$$$outer().kafka$server$AdminManager$$createBrokerConfigEntry(true, this.$outer.includeSynonyms$1, name, value2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, configNames);
                        }
                        config = config3;
                    }
                    DescribeConfigsResponse.Config resourceConfig = config;
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)resourceConfig);
                    return tuple2;
                }
                catch (Throwable throwable) {
                    String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing describe configs request for resource ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource}));
                    if (throwable instanceof ApiException) {
                        this.$outer.info((Function0<String>)new Serializable(this, message){
                            public static final long serialVersionUID = 0L;
                            private final String message$1;

                            public final String apply() {
                                return this.message$1;
                            }
                            {
                                this.message$1 = message$1;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable){
                            public static final long serialVersionUID = 0L;
                            private final Throwable e$4;

                            public final Throwable apply() {
                                return this.e$4;
                            }
                            {
                                this.e$4 = e$4;
                            }
                        });
                    } else {
                        this.$outer.error((Function0<String>)new Serializable(this, message){
                            public static final long serialVersionUID = 0L;
                            private final String message$1;

                            public final String apply() {
                                return this.message$1;
                            }
                            {
                                this.message$1 = message$1;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable){
                            public static final long serialVersionUID = 0L;
                            private final Throwable e$4;

                            public final Throwable apply() {
                                return this.e$4;
                            }
                            {
                                this.e$4 = e$4;
                            }
                        });
                    }
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)new DescribeConfigsResponse.Config(ApiError.fromThrowable((Throwable)throwable), Collections.<T>emptyList()));
                }
                return tuple2;
            }

            public /* synthetic */ AdminManager kafka$server$AdminManager$$anonfun$$$outer() {
                return this.$outer;
            }

            private final scala.collection.mutable.Map allConfigs$1(AbstractConfig config) {
                return ((MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.originals()).asScala()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, Object> x$12) {
                        return x$12._2() != null;
                    }
                })).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.values()).asScala());
            }

            private final DescribeConfigsResponse.Config createResponseConfig$1(Map configs, Function2 createConfigEntry, Option configNames$1) {
                IndexedSeq filteredConfigPairs = ((TraversableOnce)configs.filter((Function1)new Serializable(this, configNames$1){
                    public static final long serialVersionUID = 0L;
                    private final Option configNames$1;

                    public final boolean apply(Tuple2<String, Object> x0$8) {
                        Tuple2<String, Object> tuple2 = x0$8;
                        if (tuple2 != null) {
                            String configName = (String)tuple2._1();
                            boolean bl = this.configNames$1.forall((Function1)new Serializable(this, configName){
                                public static final long serialVersionUID = 0L;
                                private final String configName$1;

                                public final boolean apply(Set<String> x$13) {
                                    return x$13.contains((Object)this.configName$1);
                                }
                                {
                                    this.configName$1 = configName$1;
                                }
                            });
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.configNames$1 = configNames$1;
                    }
                })).toIndexedSeq();
                IndexedSeq configEntries = (IndexedSeq)filteredConfigPairs.map((Function1)new Serializable(this, createConfigEntry){
                    public static final long serialVersionUID = 0L;
                    private final Function2 createConfigEntry$1;

                    public final DescribeConfigsResponse.ConfigEntry apply(Tuple2<String, Object> x0$9) {
                        Tuple2<String, Object> tuple2 = x0$9;
                        if (tuple2 != null) {
                            String name = (String)tuple2._1();
                            Object value2 = tuple2._2();
                            DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)this.createConfigEntry$1.apply((Object)name, value2);
                            return configEntry;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.createConfigEntry$1 = createConfigEntry$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                return new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)configEntries).asJava());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.includeSynonyms$1 = includeSynonyms$1;
            }
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<ConfigResource, ApiError> alterConfigs(Map<ConfigResource, AlterConfigsRequest.Config> configs, boolean validateOnly) {
        return ((TraversableOnce)configs.map((Function1)new Serializable(this, validateOnly){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            private final boolean validateOnly$3;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple2<ConfigResource, ApiError> apply(Tuple2<ConfigResource, AlterConfigsRequest.Config> x0$10) {
                Tuple2 tuple2;
                Tuple2<ConfigResource, AlterConfigsRequest.Config> tuple22 = x0$10;
                if (tuple22 == null) throw new MatchError(tuple22);
                ConfigResource resource = (ConfigResource)tuple22._1();
                AlterConfigsRequest.Config config = (AlterConfigsRequest.Config)tuple22._2();
                try {
                    Tuple2 tuple23;
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        String topic = resource.name();
                        Properties properties = new Properties();
                        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1)new Serializable(this, properties){
                            public static final long serialVersionUID = 0L;
                            private final Properties properties$1;

                            public final Object apply(AlterConfigsRequest.ConfigEntry configEntry) {
                                return this.properties$1.setProperty(configEntry.name(), configEntry.value());
                            }
                            {
                                this.properties$1 = properties$1;
                            }
                        });
                        this.$outer.kafka$server$AdminManager$$adminZkClient().validateTopicConfig(topic, properties);
                        this.validateConfigPolicy$1(ConfigResource.Type.TOPIC, resource, config);
                        if (!this.validateOnly$3) {
                            this.$outer.kafka$server$AdminManager$$adminZkClient().changeTopicConfig(topic, properties);
                        }
                        tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.NONE);
                    } else {
                        None$ none$;
                        if (!ConfigResource.Type.BROKER.equals(type)) throw new InvalidRequestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AlterConfigs is only supported for topics and brokers, but resource type is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{type})));
                        if (resource.name() == null || resource.name().isEmpty()) {
                            none$ = None$.MODULE$;
                        } else {
                            int id = this.$outer.kafka$server$AdminManager$$resourceNameToBrokerId(resource.name());
                            if (id != this.$outer.config().brokerId()) {
                                throw new InvalidRequestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected broker id, expected ", ", but received ", ".name"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.config().brokerId()), resource})));
                            }
                            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)id));
                        }
                        None$ brokerId = none$;
                        Properties configProps = new Properties();
                        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1)new Serializable(this, configProps){
                            public static final long serialVersionUID = 0L;
                            private final Properties configProps$1;

                            public final Object apply(AlterConfigsRequest.ConfigEntry configEntry) {
                                return this.configProps$1.setProperty(configEntry.name(), configEntry.value());
                            }
                            {
                                this.configProps$1 = configProps$1;
                            }
                        });
                        boolean perBrokerConfig = brokerId.nonEmpty();
                        this.$outer.config().dynamicConfig().validate(configProps, perBrokerConfig);
                        this.validateConfigPolicy$1(ConfigResource.Type.BROKER, resource, config);
                        if (!this.validateOnly$3) {
                            this.$outer.kafka$server$AdminManager$$adminZkClient().changeBrokerConfig((Option<Object>)brokerId, this.$outer.config().dynamicConfig().toPersistentProps(configProps, perBrokerConfig));
                        }
                        tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.NONE);
                    }
                    tuple2 = tuple23;
                    return tuple2;
                }
                catch (Throwable throwable22) {
                    Tuple2 tuple24;
                    Throwable throwable3 = throwable22;
                    boolean bl = throwable3 instanceof ConfigException ? true : throwable3 instanceof IllegalArgumentException;
                    if (bl) {
                        String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid config value for resource ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource, throwable3.getMessage()}));
                        this.$outer.info((Function0<String>)new Serializable(this, message){
                            public static final long serialVersionUID = 0L;
                            private final String message$2;

                            public final String apply() {
                                return this.message$2;
                            }
                            {
                                this.message$2 = message$2;
                            }
                        });
                        tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.fromThrowable((Throwable)new InvalidRequestException(message, throwable3)));
                    } else {
                        if (throwable3 == null) throw throwable22;
                        Throwable throwable4 = throwable3;
                        String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing alter configs request for resource ", ", config ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource, config}));
                        if (throwable4 instanceof ApiException) {
                            this.$outer.info((Function0<String>)new Serializable(this, message){
                                public static final long serialVersionUID = 0L;
                                private final String message$3;

                                public final String apply() {
                                    return this.message$3;
                                }
                                {
                                    this.message$3 = message$3;
                                }
                            }, (Function0<Throwable>)new Serializable(this, throwable4){
                                public static final long serialVersionUID = 0L;
                                private final Throwable x10$1;

                                public final Throwable apply() {
                                    return this.x10$1;
                                }
                                {
                                    this.x10$1 = x10$1;
                                }
                            });
                        } else {
                            this.$outer.error((Function0<String>)new Serializable(this, message){
                                public static final long serialVersionUID = 0L;
                                private final String message$3;

                                public final String apply() {
                                    return this.message$3;
                                }
                                {
                                    this.message$3 = message$3;
                                }
                            }, (Function0<Throwable>)new Serializable(this, throwable4){
                                public static final long serialVersionUID = 0L;
                                private final Throwable x10$1;

                                public final Throwable apply() {
                                    return this.x10$1;
                                }
                                {
                                    this.x10$1 = x10$1;
                                }
                            });
                        }
                        tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.fromThrowable((Throwable)throwable4));
                    }
                    tuple2 = tuple24;
                }
                return tuple2;
            }

            private final void validateConfigPolicy$1(ConfigResource.Type resourceType, ConfigResource resource$1, AlterConfigsRequest.Config config$1) {
                Option<AlterConfigPolicy> option;
                block4: {
                    block3: {
                        block2: {
                            option = this.$outer.kafka$server$AdminManager$$alterConfigPolicy();
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            AlterConfigPolicy policy = (AlterConfigPolicy)some.x();
                            scala.collection.immutable.Map configEntriesMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config$1.entries()).asScala()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Tuple2<String, String> apply(AlterConfigsRequest.ConfigEntry entry2) {
                                    return new Tuple2((Object)entry2.name(), (Object)entry2.value());
                                }
                            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                            policy.validate(new AlterConfigPolicy.RequestMetadata(new ConfigResource(resourceType, resource$1.name()), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)configEntriesMap).asJava()));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError(option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.validateOnly$3 = validateOnly$3;
            }
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public void shutdown() {
        this.topicPurgatory().shutdown();
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$AdminManager$$createTopicPolicy().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(CreateTopicPolicy x$14) {
                        x$14.close();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$AdminManager$$alterConfigPolicy().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(AlterConfigPolicy x$15) {
                        x$15.close();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public int kafka$server$AdminManager$$resourceNameToBrokerId(String resourceName) {
        try {
            return new StringOps(Predef$.MODULE$.augmentString(resourceName)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker id must be an integer, but it is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resourceName})));
        }
    }

    public List<String> kafka$server$AdminManager$$brokerSynonyms(String name) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
    }

    private ConfigDef.Type configType(String name, List<String> synonyms) {
        ConfigDef.Type configType2 = this.config().typeOf(name);
        return configType2 == null ? (ConfigDef.Type)synonyms.iterator().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;

            public final ConfigDef.Type apply(String x$1) {
                return this.$outer.config().typeOf(x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ConfigDef.Type x$16) {
                return x$16 != null;
            }
        }).orNull(Predef$.MODULE$.$conforms()) : configType2;
    }

    public List<DescribeConfigsResponse.ConfigSynonym> kafka$server$AdminManager$$configSynonyms(String name, List<String> synonyms, boolean isSensitive) {
        DynamicBrokerConfig dynamicConfig = this.config().dynamicConfig();
        Buffer allSynonyms = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Map<String, String> map = dynamicConfig.currentDynamicBrokerConfigs();
        synonyms.foreach((Function1)new Serializable(this, isSensitive, allSynonyms, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            private final boolean isSensitive$1;
            private final Buffer allSynonyms$1;
            private final Map eta$0$1$1;

            public final void apply(String name) {
                this.$outer.kafka$server$AdminManager$$maybeAddSynonym$1(this.eta$0$1$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, name, this.isSensitive$1, this.allSynonyms$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.isSensitive$1 = isSensitive$1;
                this.allSynonyms$1 = allSynonyms$1;
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
        Map<String, String> map2 = dynamicConfig.currentDynamicDefaultConfigs();
        synonyms.foreach((Function1)new Serializable(this, isSensitive, allSynonyms, map2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            private final boolean isSensitive$1;
            private final Buffer allSynonyms$1;
            private final Map eta$0$2$1;

            public final void apply(String name) {
                this.$outer.kafka$server$AdminManager$$maybeAddSynonym$1(this.eta$0$2$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, name, this.isSensitive$1, this.allSynonyms$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.isSensitive$1 = isSensitive$1;
                this.allSynonyms$1 = allSynonyms$1;
                this.eta$0$2$1 = eta$0$2$1;
            }
        });
        synonyms.foreach((Function1)new Serializable(this, isSensitive, dynamicConfig, allSynonyms){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            private final boolean isSensitive$1;
            private final DynamicBrokerConfig dynamicConfig$1;
            private final Buffer allSynonyms$1;

            public final void apply(String name) {
                this.$outer.kafka$server$AdminManager$$maybeAddSynonym$1((Map)this.dynamicConfig$1.staticBrokerConfigs(), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, name, this.isSensitive$1, this.allSynonyms$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.isSensitive$1 = isSensitive$1;
                this.dynamicConfig$1 = dynamicConfig$1;
                this.allSynonyms$1 = allSynonyms$1;
            }
        });
        synonyms.foreach((Function1)new Serializable(this, isSensitive, dynamicConfig, allSynonyms){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            private final boolean isSensitive$1;
            private final DynamicBrokerConfig dynamicConfig$1;
            private final Buffer allSynonyms$1;

            public final void apply(String name) {
                this.$outer.kafka$server$AdminManager$$maybeAddSynonym$1((Map)this.dynamicConfig$1.staticDefaultConfigs(), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, name, this.isSensitive$1, this.allSynonyms$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.isSensitive$1 = isSensitive$1;
                this.dynamicConfig$1 = dynamicConfig$1;
                this.allSynonyms$1 = allSynonyms$1;
            }
        });
        return ((TraversableOnce)allSynonyms.dropWhile((Function1)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final boolean apply(DescribeConfigsResponse.ConfigSynonym s) {
                String string = s.name();
                String string2 = this.name$1;
                return string != null ? !string.equals(string2) : string2 != null;
            }
            {
                this.name$1 = name$1;
            }
        })).toList();
    }

    public DescribeConfigsResponse.ConfigEntry kafka$server$AdminManager$$createTopicConfigEntry(LogConfig logConfig, Properties topicProps, boolean includeSynonyms, String name, Object value2) {
        List list;
        ConfigDef.Type configEntryType;
        ConfigDef.Type type = configEntryType = logConfig.typeOf(name);
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        boolean isSensitive = !(type != null ? !type.equals(type2) : type2 != null);
        String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value2, (ConfigDef.Type)configEntryType);
        List list2 = (List)LogConfig$.MODULE$.TopicConfigSynonyms().get((Object)name).map((Function1)new Serializable(this, isSensitive){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            private final boolean isSensitive$2;

            public final List<DescribeConfigsResponse.ConfigSynonym> apply(String s) {
                return this.$outer.kafka$server$AdminManager$$configSynonyms(s, this.$outer.kafka$server$AdminManager$$brokerSynonyms(s), this.isSensitive$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.isSensitive$2 = isSensitive$2;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<Nothing$> apply() {
                return List$.MODULE$.empty();
            }
        });
        if (topicProps.containsKey(name)) {
            DescribeConfigsResponse.ConfigSynonym configSynonym = new DescribeConfigsResponse.ConfigSynonym(name, valueAsString, DescribeConfigsResponse.ConfigSource.TOPIC_CONFIG);
            list = (List)list2.$plus$colon((Object)configSynonym, List$.MODULE$.canBuildFrom());
        } else {
            list = list2;
        }
        List allSynonyms = list;
        DescribeConfigsResponse.ConfigSource source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG : ((DescribeConfigsResponse.ConfigSynonym)allSynonyms.head()).source();
        List synonyms = includeSynonyms ? allSynonyms : List$.MODULE$.empty();
        return new DescribeConfigsResponse.ConfigEntry(name, valueAsString, source, isSensitive, false, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava());
    }

    public DescribeConfigsResponse.ConfigEntry kafka$server$AdminManager$$createBrokerConfigEntry(boolean perBrokerConfig, boolean includeSynonyms, String name, Object value2) {
        String string;
        boolean isSensitive;
        ConfigDef.Type configEntryType;
        List<String> allNames = this.kafka$server$AdminManager$$brokerSynonyms(name);
        ConfigDef.Type type = configEntryType = this.configType(name, allNames);
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        boolean bl = !(type == null ? type2 != null : !type.equals(type2)) || configEntryType == null ? true : (isSensitive = false);
        if (isSensitive) {
            string = null;
        } else {
            String string2;
            Object object = value2;
            String string3 = object instanceof String ? (string2 = (String)object) : ConfigDef.convertToString((Object)value2, (ConfigDef.Type)configEntryType);
            string = string3;
        }
        String valueAsString = string;
        List allSynonyms = (List)this.kafka$server$AdminManager$$configSynonyms(name, allNames, isSensitive).filter((Function1)new Serializable(this, perBrokerConfig){
            public static final long serialVersionUID = 0L;
            private final boolean perBrokerConfig$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(DescribeConfigsResponse.ConfigSynonym x$18) {
                if (this.perBrokerConfig$1) return true;
                DescribeConfigsResponse.ConfigSource configSource = x$18.source();
                DescribeConfigsResponse.ConfigSource configSource2 = DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG;
                if (configSource != null) {
                    if (!configSource.equals(configSource2)) return false;
                    return true;
                }
                if (configSource2 == null) return true;
                return false;
            }
            {
                this.perBrokerConfig$1 = perBrokerConfig$1;
            }
        });
        List synonyms = includeSynonyms ? allSynonyms : List$.MODULE$.empty();
        DescribeConfigsResponse.ConfigSource source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG : ((DescribeConfigsResponse.ConfigSynonym)allSynonyms.head()).source();
        boolean readOnly = !allNames.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String elem) {
                return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains((Object)elem);
            }
        });
        return new DescribeConfigsResponse.ConfigEntry(name, valueAsString, source, isSensitive, readOnly, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava());
    }

    public final void kafka$server$AdminManager$$maybeAddSynonym$1(Map map, DescribeConfigsResponse.ConfigSource source, String name, boolean isSensitive$1, Buffer allSynonyms$1) {
        map.get((Object)name).map((Function1)new Serializable(this, isSensitive$1, allSynonyms$1, source, name){
            public static final long serialVersionUID = 0L;
            private final boolean isSensitive$1;
            private final Buffer allSynonyms$1;
            private final DescribeConfigsResponse.ConfigSource source$1;
            private final String name$2;

            public final Buffer<DescribeConfigsResponse.ConfigSynonym> apply(String value2) {
                String configValue = this.isSensitive$1 ? null : value2;
                return this.allSynonyms$1.$plus$eq((Object)new DescribeConfigsResponse.ConfigSynonym(this.name$2, configValue, this.source$1));
            }
            {
                this.isSensitive$1 = isSensitive$1;
                this.allSynonyms$1 = allSynonyms$1;
                this.source$1 = source$1;
                this.name$2 = name$2;
            }
        });
    }

    public AdminManager(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, KafkaZkClient zkClient) {
        this.config = config;
        this.metrics = metrics;
        this.metadataCache = metadataCache;
        this.zkClient = zkClient;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Admin Manager on Broker ").append((Object)BoxesRunTime.boxToInteger((int)config.brokerId())).append((Object)"]: ").toString());
        this.topicPurgatory = DelayedOperationPurgatory$.MODULE$.apply("topic", config.brokerId(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5());
        this.kafka$server$AdminManager$$adminZkClient = new AdminZkClient(zkClient);
        this.kafka$server$AdminManager$$createTopicPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class));
        this.kafka$server$AdminManager$$alterConfigPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class));
    }
}

