/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.logging.log4j.util.Strings;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringsTest {
    @Test
    public void testIsEmpty() {
        Assertions.assertTrue((boolean)Strings.isEmpty(null));
        Assertions.assertTrue((boolean)Strings.isEmpty((CharSequence)""));
        Assertions.assertFalse((boolean)Strings.isEmpty((CharSequence)" "));
        Assertions.assertFalse((boolean)Strings.isEmpty((CharSequence)"a"));
    }

    @Test
    public void testIsBlank() {
        Assertions.assertTrue((boolean)Strings.isBlank(null));
        Assertions.assertTrue((boolean)Strings.isBlank((String)""));
        Assertions.assertTrue((boolean)Strings.isBlank((String)" "));
        Assertions.assertTrue((boolean)Strings.isBlank((String)"\n"));
        Assertions.assertTrue((boolean)Strings.isBlank((String)"\r"));
        Assertions.assertTrue((boolean)Strings.isBlank((String)"\t"));
        Assertions.assertFalse((boolean)Strings.isEmpty((CharSequence)"a"));
    }

    @Test
    public void testEMPTY() {
        Assertions.assertEquals((Object)"", (Object)"");
        Assertions.assertEquals((int)0, (int)"".length());
    }

    @Test
    public void testConcat() {
        Assertions.assertEquals((Object)"ab", (Object)Strings.concat((String)"a", (String)"b"));
        Assertions.assertEquals((Object)"a", (Object)Strings.concat((String)"a", (String)""));
        Assertions.assertEquals((Object)"a", (Object)Strings.concat((String)"a", null));
        Assertions.assertEquals((Object)"b", (Object)Strings.concat((String)"", (String)"b"));
        Assertions.assertEquals((Object)"b", (Object)Strings.concat(null, (String)"b"));
    }

    @Test
    public void testJoin() {
        Assertions.assertNull((Object)Strings.join((Iterable)null, (char)'.'));
        Assertions.assertNull((Object)Strings.join((Iterator)null, (char)'.'));
        Assertions.assertEquals((Object)"", (Object)Strings.join(Collections.emptyList(), (char)'.'));
        Assertions.assertEquals((Object)"a", (Object)Strings.join(Collections.singletonList("a"), (char)'.'));
        Assertions.assertEquals((Object)"a.b", (Object)Strings.join(Arrays.asList("a", "b"), (char)'.'));
        Assertions.assertEquals((Object)"a.b.c", (Object)Strings.join(Arrays.asList("a", "b", "c"), (char)'.'));
        Assertions.assertEquals((Object)"", (Object)Strings.join(Collections.singletonList(null), (char)':'));
        Assertions.assertEquals((Object)":", (Object)Strings.join(Arrays.asList(null, null), (char)':'));
        Assertions.assertEquals((Object)"a:", (Object)Strings.join(Arrays.asList("a", null), (char)':'));
        Assertions.assertEquals((Object)":b", (Object)Strings.join(Arrays.asList(null, "b"), (char)':'));
    }

    @Test
    public void testQuote() {
        Assertions.assertEquals((Object)"'Q'", (Object)Strings.quote((String)"Q"));
    }
}

