/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.logging.log4j.util.SystemPropertiesPropertySource;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceLock;

@Tag(value="concurrency")
@ResourceLock(value="java.lang.System.properties")
public class SystemPropertiesPropertySourceTest {
    private static final int ITERATIONS = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiThreadedAccess() throws InterruptedException, ExecutionException {
        ExecutorService threadPool = Executors.newSingleThreadExecutor();
        try {
            Future<?> future = threadPool.submit(() -> {
                Properties properties = System.getProperties();
                for (int i = 0; i < 10000; ++i) {
                    properties.setProperty("FOO_" + i, "BAR");
                }
            });
            for (int i = 0; i < 10000; ++i) {
                new SystemPropertiesPropertySource().forEach((key, value) -> {});
            }
            future.get();
        }
        finally {
            threadPool.shutdown();
        }
    }
}

