/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.EventLogger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.TestLogger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceLock;

@ResourceLock(value="log4j2.TestLogger")
public class EventLoggerTest {
    TestLogger logger = (TestLogger)LogManager.getLogger((String)"EventLogger");
    List<String> results = this.logger.getEntries();

    @BeforeEach
    public void setup() {
        this.results.clear();
    }

    @Test
    public void structuredData() {
        ThreadContext.put((String)"loginId", (String)"JohnDoe");
        ThreadContext.put((String)"ipAddress", (String)"192.168.0.120");
        ThreadContext.put((String)"locale", (String)Locale.US.getDisplayName(Locale.US));
        StructuredDataMessage msg = new StructuredDataMessage("Transfer@18060", "Transfer Complete", "Audit");
        msg.put("ToAccount", "123456");
        msg.put("FromAccount", "123457");
        msg.put("Amount", "200.00");
        EventLogger.logEvent((StructuredDataMessage)msg);
        ThreadContext.clearMap();
        Assertions.assertThat(this.results).hasSize(1);
        String expected = "EVENT OFF Audit [Transfer@18060 Amount=\"200.00\" FromAccount=\"123457\" ToAccount=\"123456\"] Transfer Complete";
        Assertions.assertThat((String)this.results.get(0)).startsWith((CharSequence)"EVENT OFF Audit [Transfer@18060 Amount=\"200.00\" FromAccount=\"123457\" ToAccount=\"123456\"] Transfer Complete");
    }
}

