/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.junit.UsingAnyThreadContext;
import org.apache.logging.log4j.spi.DefaultThreadContextMap;
import org.apache.logging.log4j.spi.DefaultThreadContextStack;
import org.apache.logging.log4j.spi.MutableThreadContextStack;
import org.apache.logging.log4j.spi.MutableThreadContextStackTest;
import org.apache.logging.log4j.spi.ThreadContextStack;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@UsingAnyThreadContext
public class DefaultThreadContextStackTest {
    @BeforeEach
    public void before() {
        new DefaultThreadContextMap(true).clear();
    }

    @Test
    public void testEqualsVsSameKind() {
        DefaultThreadContextStack stack1 = DefaultThreadContextStackTest.createStack();
        DefaultThreadContextStack stack2 = DefaultThreadContextStackTest.createStack();
        Assertions.assertEquals((Object)stack1, (Object)stack1);
        Assertions.assertEquals((Object)stack2, (Object)stack2);
        Assertions.assertEquals((Object)stack1, (Object)stack2);
        Assertions.assertEquals((Object)stack2, (Object)stack1);
    }

    @Test
    public void testEqualsVsMutable() {
        DefaultThreadContextStack stack1 = DefaultThreadContextStackTest.createStack();
        MutableThreadContextStack stack2 = MutableThreadContextStackTest.createStack();
        Assertions.assertEquals((Object)stack1, (Object)stack1);
        Assertions.assertEquals((Object)stack2, (Object)stack2);
        Assertions.assertEquals((Object)stack1, (Object)stack2);
        Assertions.assertEquals((Object)stack2, (Object)stack1);
    }

    @Test
    public void testHashCodeVsSameKind() {
        DefaultThreadContextStack stack1 = DefaultThreadContextStackTest.createStack();
        DefaultThreadContextStack stack2 = DefaultThreadContextStackTest.createStack();
        Assertions.assertEquals((int)stack1.hashCode(), (int)stack2.hashCode());
    }

    @Test
    public void testImmutableOrNullReturnsNullIfUseStackIsFalse() {
        DefaultThreadContextStack stack = new DefaultThreadContextStack(false);
        stack.clear();
        Assertions.assertNull((Object)stack.getImmutableStackOrNull());
    }

    @Test
    public void testImmutableOrNullReturnsNullIfStackIsEmpty() {
        DefaultThreadContextStack stack = new DefaultThreadContextStack(true);
        stack.clear();
        Assertions.assertTrue((boolean)stack.isEmpty());
        Assertions.assertNull((Object)stack.getImmutableStackOrNull());
    }

    @Test
    public void testImmutableOrNullReturnsCopyOfContents() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        Assertions.assertFalse((boolean)stack.isEmpty());
        ThreadContext.ContextStack actual = stack.getImmutableStackOrNull();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)stack, (Object)actual);
    }

    @Test
    public void testModifyingImmutableOrNullThrowsException() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        int originalSize = stack.size();
        Assertions.assertTrue((originalSize > 0 ? 1 : 0) != 0);
        ThreadContext.ContextStack actual = stack.getImmutableStackOrNull();
        Assertions.assertEquals((int)originalSize, (int)actual.size());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> actual.pop());
    }

    @Test
    public void testDoesNothingIfConstructedWithUseStackIsFalse() {
        DefaultThreadContextStack stack = new DefaultThreadContextStack(false);
        stack.clear();
        Assertions.assertTrue((boolean)stack.isEmpty());
        stack.push("msg");
        Assertions.assertTrue((boolean)stack.isEmpty());
        Assertions.assertEquals((int)0, (int)stack.size());
    }

    @Test
    public void testPushAndAddIncreaseStack() {
        DefaultThreadContextStack stack = new DefaultThreadContextStack(true);
        stack.clear();
        Assertions.assertTrue((boolean)stack.isEmpty());
        stack.push("msg1");
        stack.add("msg2");
        Assertions.assertEquals((int)2, (int)stack.size());
    }

    @Test
    public void testPeekReturnsLastAddedItem() {
        DefaultThreadContextStack stack = new DefaultThreadContextStack(true);
        stack.clear();
        Assertions.assertTrue((boolean)stack.isEmpty());
        stack.push("msg1");
        stack.add("msg2");
        Assertions.assertEquals((int)2, (int)stack.size());
        Assertions.assertEquals((Object)"msg2", (Object)stack.peek());
        stack.push("msg3");
        Assertions.assertEquals((Object)"msg3", (Object)stack.peek());
    }

    @Test
    public void testPopRemovesLastAddedItem() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        Assertions.assertEquals((int)3, (int)stack.getDepth());
        Assertions.assertEquals((Object)"msg3", (Object)stack.pop());
        Assertions.assertEquals((int)2, (int)stack.size());
        Assertions.assertEquals((int)2, (int)stack.getDepth());
        Assertions.assertEquals((Object)"msg2", (Object)stack.pop());
        Assertions.assertEquals((int)1, (int)stack.size());
        Assertions.assertEquals((int)1, (int)stack.getDepth());
        Assertions.assertEquals((Object)"msg1", (Object)stack.pop());
        Assertions.assertEquals((int)0, (int)stack.size());
        Assertions.assertEquals((int)0, (int)stack.getDepth());
    }

    @Test
    public void testAsList() {
        DefaultThreadContextStack stack = new DefaultThreadContextStack(true);
        stack.clear();
        Assertions.assertTrue((boolean)stack.isEmpty());
        stack.push("msg1");
        stack.add("msg2");
        stack.push("msg3");
        Assertions.assertEquals(Arrays.asList("msg1", "msg2", "msg3"), (Object)stack.asList());
    }

    @Test
    public void testTrim() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        stack.trim(1);
        Assertions.assertEquals((int)1, (int)stack.size());
        Assertions.assertEquals((Object)"msg1", (Object)stack.peek());
    }

    @Test
    public void testCopy() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        ThreadContextStack copy = stack.copy();
        Assertions.assertEquals((int)3, (int)copy.size());
        Assertions.assertTrue((boolean)copy.containsAll(Arrays.asList("msg1", "msg2", "msg3")));
        stack.clear();
        Assertions.assertTrue((boolean)stack.isEmpty());
        Assertions.assertEquals((int)3, (int)copy.size());
        Assertions.assertTrue((boolean)copy.containsAll(Arrays.asList("msg1", "msg2", "msg3")));
        copy.add((Object)"other");
        Assertions.assertEquals((int)4, (int)copy.size());
        Assertions.assertTrue((boolean)stack.isEmpty());
        stack.push("newStackMsg");
        Assertions.assertEquals((int)1, (int)stack.size());
        Assertions.assertEquals((int)4, (int)copy.size());
        copy.clear();
        Assertions.assertTrue((boolean)copy.isEmpty());
        Assertions.assertEquals((int)1, (int)stack.size());
    }

    @Test
    public void testClear() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        stack.clear();
        Assertions.assertTrue((boolean)stack.isEmpty());
    }

    static DefaultThreadContextStack createStack() {
        DefaultThreadContextStack stack = new DefaultThreadContextStack(true);
        stack.clear();
        Assertions.assertTrue((boolean)stack.isEmpty());
        stack.push("msg1");
        stack.add("msg2");
        stack.push("msg3");
        Assertions.assertEquals((int)3, (int)stack.size());
        return stack;
    }

    @Test
    public void testContains() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        Assertions.assertTrue((boolean)stack.contains((Object)"msg1"));
        Assertions.assertTrue((boolean)stack.contains((Object)"msg2"));
        Assertions.assertTrue((boolean)stack.contains((Object)"msg3"));
    }

    @Test
    public void testIteratorReturnsInListOrderNotStackOrder() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        Iterator iter = stack.iterator();
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"msg1", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"msg2", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"msg3", iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testToArray() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        Object[] expecteds = new String[]{"msg1", "msg2", "msg3"};
        Assertions.assertArrayEquals((Object[])expecteds, (Object[])stack.toArray());
    }

    @Test
    public void testToArrayTArray() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        Object[] expecteds = new String[]{"msg1", "msg2", "msg3"};
        Object[] result = new String[3];
        Assertions.assertArrayEquals((Object[])expecteds, (Object[])stack.toArray(result));
        Assertions.assertSame((Object)result, (Object)stack.toArray(result));
    }

    @Test
    public void testRemove() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        Assertions.assertTrue((boolean)stack.containsAll(Arrays.asList("msg1", "msg2", "msg3")));
        stack.remove((Object)"msg1");
        Assertions.assertEquals((int)2, (int)stack.size());
        Assertions.assertTrue((boolean)stack.containsAll(Arrays.asList("msg2", "msg3")));
        Assertions.assertEquals((Object)"msg3", (Object)stack.peek());
        stack.remove((Object)"msg3");
        Assertions.assertEquals((int)1, (int)stack.size());
        Assertions.assertTrue((boolean)stack.containsAll(Collections.singletonList("msg2")));
        Assertions.assertEquals((Object)"msg2", (Object)stack.peek());
    }

    @Test
    public void testContainsAll() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        Assertions.assertTrue((boolean)stack.containsAll(Arrays.asList("msg1", "msg2", "msg3")));
    }

    @Test
    public void testAddAll() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        stack.addAll(Arrays.asList("msg4", "msg5"));
        Assertions.assertEquals((int)5, (int)stack.size());
        Assertions.assertTrue((boolean)stack.contains((Object)"msg1"));
        Assertions.assertTrue((boolean)stack.contains((Object)"msg2"));
        Assertions.assertTrue((boolean)stack.contains((Object)"msg3"));
        Assertions.assertTrue((boolean)stack.contains((Object)"msg4"));
        Assertions.assertTrue((boolean)stack.contains((Object)"msg5"));
    }

    @Test
    public void testRemoveAll() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        stack.removeAll(Arrays.asList("msg1", "msg3"));
        Assertions.assertEquals((int)1, (int)stack.size());
        Assertions.assertFalse((boolean)stack.contains((Object)"msg1"));
        Assertions.assertTrue((boolean)stack.contains((Object)"msg2"));
        Assertions.assertFalse((boolean)stack.contains((Object)"msg3"));
    }

    @Test
    public void testRetainAll() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        stack.retainAll(Arrays.asList("msg1", "msg3"));
        Assertions.assertEquals((int)2, (int)stack.size());
        Assertions.assertTrue((boolean)stack.contains((Object)"msg1"));
        Assertions.assertFalse((boolean)stack.contains((Object)"msg2"));
        Assertions.assertTrue((boolean)stack.contains((Object)"msg3"));
    }

    @Test
    public void testToStringShowsListContents() {
        DefaultThreadContextStack stack = new DefaultThreadContextStack(true);
        stack.clear();
        Assertions.assertEquals((Object)"[]", (Object)stack.toString());
        stack.push("msg1");
        stack.add("msg2");
        stack.push("msg3");
        Assertions.assertEquals((Object)"[msg1, msg2, msg3]", (Object)stack.toString());
        stack.retainAll(Arrays.asList("msg1", "msg3"));
        Assertions.assertEquals((Object)"[msg1, msg3]", (Object)stack.toString());
    }
}

