/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.logging.log4j.junit.Mutable;
import org.apache.logging.log4j.junit.SerialUtil;
import org.apache.logging.log4j.message.ObjectMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ObjectMessageTest {
    @Test
    public void testNull() {
        ObjectMessage msg = new ObjectMessage(null);
        String result = msg.getFormattedMessage();
        Assertions.assertEquals((Object)"null", (Object)result);
    }

    @Test
    public void testNotNull() {
        String testMsg = "Test message {}";
        ObjectMessage msg = new ObjectMessage((Object)"Test message {}");
        String result = msg.getFormattedMessage();
        Assertions.assertEquals((Object)"Test message {}", (Object)result);
    }

    @Test
    public void testUnsafeWithMutableParams() {
        Mutable param = new Mutable().set("abc");
        ObjectMessage msg = new ObjectMessage((Object)param);
        param.set("XYZ");
        String actual = msg.getFormattedMessage();
        Assertions.assertEquals((Object)"XYZ", (Object)actual, (String)"Expected most recent param value");
    }

    @Test
    public void testSafeAfterGetFormattedMessageIsCalled() {
        Mutable param = new Mutable().set("abc");
        ObjectMessage msg = new ObjectMessage((Object)param);
        msg.getFormattedMessage();
        param.set("XYZ");
        String actual = msg.getFormattedMessage();
        Assertions.assertEquals((Object)"abc", (Object)actual, (String)"Should use initial param value");
    }

    @Test
    public void testSerializeWithSerializableParam() {
        BigDecimal big = BigDecimal.valueOf(123.456);
        ObjectMessage msg = new ObjectMessage((Object)big);
        ObjectMessage other = (ObjectMessage)SerialUtil.deserialize(SerialUtil.serialize((Serializable)msg));
        Assertions.assertEquals((Object)msg, (Object)other);
    }

    @Test
    public void testDeserializeNonSerializableParamEqualIfToStringSame() {
        class NonSerializable {
            NonSerializable() {
            }

            public boolean equals(Object other) {
                return other instanceof NonSerializable;
            }
        }
        NonSerializable nonSerializable = new NonSerializable();
        Assertions.assertFalse((boolean)(nonSerializable instanceof Serializable));
        ObjectMessage msg = new ObjectMessage((Object)nonSerializable);
        ObjectMessage other = (ObjectMessage)SerialUtil.deserialize(SerialUtil.serialize((Serializable)msg));
        Assertions.assertEquals((Object)msg, (Object)other);
        Assertions.assertEquals((Object)other, (Object)msg);
    }

    @Test
    public void formatTo_usesCachedMessageString() throws Exception {
        StringBuilder charSequence = new StringBuilder("initial value");
        ObjectMessage message = new ObjectMessage((Object)charSequence);
        Assertions.assertEquals((Object)"initial value", (Object)message.getFormattedMessage());
        charSequence.setLength(0);
        charSequence.append("different value");
        StringBuilder result = new StringBuilder();
        message.formatTo(result);
        Assertions.assertEquals((Object)"initial value", (Object)result.toString());
    }
}

