/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.simple;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.junit.LoggerContextFactoryExtension;
import org.apache.logging.log4j.simple.SimpleLoggerContextFactory;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.util.Constants;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.parallel.ResourceLock;

@Tag(value="smoke")
@ResourceLock(value="log4j2.LoggerContextFactory")
public class SimpleLoggerTest {
    @RegisterExtension
    public static final LoggerContextFactoryExtension EXTENSION = new LoggerContextFactoryExtension((LoggerContextFactory)new SimpleLoggerContextFactory());
    private final Logger logger = LogManager.getLogger((String)"TestError");

    @Test
    public void testString() {
        this.logger.error("Logging without args");
    }

    @Test
    public void testMissingMessageArg() {
        this.logger.error("Logging without args {}");
    }

    @Test
    public void testEmptyObjectArray() {
        this.logger.error((Object)Constants.EMPTY_OBJECT_ARRAY);
    }

    @Test
    public void testMessageWithEmptyObjectArray() {
        this.logger.error("Logging with an empty Object[] {} {}", (Object)Constants.EMPTY_BYTE_ARRAY);
    }

    @Test
    public void testMessageWithShortArray() {
        this.logger.error("Logging with a size 1 Object[] {} {}", new Object[]{"only one param"});
    }
}

