/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.StringBuilders;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringBuildersTest {
    @Test
    public void trimToMaxSize() {
        StringBuilder sb = new StringBuilder();
        char[] value = new char[4096];
        sb.append(value);
        Assertions.assertTrue((sb.length() > Constants.MAX_REUSABLE_MESSAGE_SIZE ? 1 : 0) != 0, (String)"needs trimming");
        StringBuilders.trimToMaxSize((StringBuilder)sb, (int)Constants.MAX_REUSABLE_MESSAGE_SIZE);
        Assertions.assertTrue((sb.length() <= Constants.MAX_REUSABLE_MESSAGE_SIZE ? 1 : 0) != 0, (String)"trimmed OK");
    }

    @Test
    public void trimToMaxSizeWithLargeCapacity() {
        StringBuilder sb = new StringBuilder();
        char[] value = new char[4096];
        sb.append(value);
        sb.setLength(0);
        Assertions.assertTrue((sb.capacity() > Constants.MAX_REUSABLE_MESSAGE_SIZE ? 1 : 0) != 0, (String)"needs trimming");
        StringBuilders.trimToMaxSize((StringBuilder)sb, (int)Constants.MAX_REUSABLE_MESSAGE_SIZE);
        Assertions.assertTrue((sb.capacity() <= Constants.MAX_REUSABLE_MESSAGE_SIZE ? 1 : 0) != 0, (String)"trimmed OK");
    }

    @Test
    public void escapeJsonCharactersCorrectly() {
        String jsonValueNotEscaped = "{\"field\n1\":\"value_1\"}";
        String jsonValueEscaped = "{\\\"field\\n1\\\":\\\"value_1\\\"}";
        StringBuilder sb = new StringBuilder();
        sb.append("{\"field\n1\":\"value_1\"}");
        Assertions.assertEquals((Object)"{\"field\n1\":\"value_1\"}", (Object)sb.toString());
        StringBuilders.escapeJson((StringBuilder)sb, (int)0);
        Assertions.assertEquals((Object)"{\\\"field\\n1\\\":\\\"value_1\\\"}", (Object)sb.toString());
        sb = new StringBuilder();
        String jsonValuePartiallyEscaped = "{\"field\n1\":\\\"value_1\\\"}";
        sb.append("{\"field\n1\":\"value_1\"}");
        Assertions.assertEquals((Object)"{\"field\n1\":\"value_1\"}", (Object)sb.toString());
        StringBuilders.escapeJson((StringBuilder)sb, (int)10);
        Assertions.assertEquals((Object)"{\"field\n1\":\\\"value_1\\\"}", (Object)sb.toString());
    }

    @Test
    public void escapeJsonCharactersISOControl() {
        String jsonValueNotEscaped = "{\"field\n1\":\"value\u008f_1\"}";
        String jsonValueEscaped = "{\\\"field\\n1\\\":\\\"value\\u008F_1\\\"}";
        StringBuilder sb = new StringBuilder();
        sb.append("{\"field\n1\":\"value\u008f_1\"}");
        Assertions.assertEquals((Object)"{\"field\n1\":\"value\u008f_1\"}", (Object)sb.toString());
        StringBuilders.escapeJson((StringBuilder)sb, (int)0);
        Assertions.assertEquals((Object)"{\\\"field\\n1\\\":\\\"value\\u008F_1\\\"}", (Object)sb.toString());
    }

    @Test
    public void escapeXMLCharactersCorrectly() {
        String xmlValueNotEscaped = "<\"Salt&Peppa'\">";
        String xmlValueEscaped = "&lt;&quot;Salt&amp;Peppa&apos;&quot;&gt;";
        StringBuilder sb = new StringBuilder();
        sb.append("<\"Salt&Peppa'\">");
        Assertions.assertEquals((Object)"<\"Salt&Peppa'\">", (Object)sb.toString());
        StringBuilders.escapeXml((StringBuilder)sb, (int)0);
        Assertions.assertEquals((Object)"&lt;&quot;Salt&amp;Peppa&apos;&quot;&gt;", (Object)sb.toString());
    }
}

