/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayout;
import org.apache.logging.log4j.layout.template.json.LogEventFixture;
import org.apache.logging.log4j.layout.template.json.TestHelpers;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class GcpLayoutTest {
    private static final JsonTemplateLayout LAYOUT = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setStackTraceEnabled(true).setLocationInfoEnabled(true).setEventTemplateUri("classpath:GcpLayout.json").build();
    private static final int LOG_EVENT_COUNT = 1000;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);

    GcpLayoutTest() {
    }

    @Test
    void test_lite_log_events() {
        LogEventFixture.createLiteLogEvents(1000).forEach(GcpLayoutTest::verifySerialization);
    }

    @Test
    void test_full_log_events() {
        LogEventFixture.createFullLogEvents(1000).forEach(GcpLayoutTest::verifySerialization);
    }

    private static void verifySerialization(LogEvent logEvent) {
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)LAYOUT, logEvent, accessor -> {
            String expectedTimestamp = GcpLayoutTest.formatLogEventInstant(logEvent);
            Assertions.assertThat((String)accessor.getString("timestamp")).isEqualTo(expectedTimestamp);
            Level level = logEvent.getLevel();
            String expectedSeverity = Level.WARN.equals((Object)level) ? "WARNING" : (Level.TRACE.equals((Object)level) ? "TRACE" : (Level.FATAL.equals((Object)level) ? "EMERGENCY" : level.name()));
            Assertions.assertThat((String)accessor.getString("severity")).isEqualTo(expectedSeverity);
            Throwable exception = logEvent.getThrown();
            if (exception != null) {
                String actualMessage = accessor.getString("message");
                ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)actualMessage).contains(new CharSequence[]{logEvent.getMessage().getFormattedMessage()})).contains(new CharSequence[]{exception.getLocalizedMessage()})).contains(new CharSequence[]{"at org.apache.logging.log4j.layout.template.json"})).contains(new CharSequence[]{"at java.lang.reflect.Method"})).contains(new CharSequence[]{"at org.junit.platform.engine"});
            }
            logEvent.getContextData().forEach((key, value) -> {
                String expectedValue = String.valueOf(value);
                String actualValue = accessor.getString(new String[]{"logging.googleapis.com/labels", key});
                Assertions.assertThat((String)actualValue).isEqualTo(expectedValue);
            });
            StackTraceElement source = logEvent.getSource();
            if (source != null) {
                String actualFileName = accessor.getString(new String[]{"logging.googleapis.com/sourceLocation", "file"});
                Assertions.assertThat((String)actualFileName).isEqualTo(source.getFileName());
                int actualLineNumber = accessor.getInteger(new String[]{"logging.googleapis.com/sourceLocation", "line"});
                Assertions.assertThat((int)actualLineNumber).isEqualTo(source.getLineNumber());
                String expectedFunction = source.getClassName() + "." + source.getMethodName();
                String actualFunction = accessor.getString(new String[]{"logging.googleapis.com/sourceLocation", "function"});
                Assertions.assertThat((String)actualFunction).isEqualTo(expectedFunction);
            } else {
                Assertions.assertThat((boolean)accessor.exists(new String[]{"logging.googleapis.com/sourceLocation", "file"})).isFalse();
                Assertions.assertThat((boolean)accessor.exists(new String[]{"logging.googleapis.com/sourceLocation", "line"})).isFalse();
                Assertions.assertThat((String)accessor.getString(new String[]{"logging.googleapis.com/sourceLocation", "function"})).isEmpty();
            }
            Assertions.assertThat((String)accessor.getString("logging.googleapis.com/insertId")).matches((CharSequence)"[-]?[0-9]+");
            if (exception != null) {
                Assertions.assertThat((String)accessor.getString(new String[]{"_exception", "class"})).isEqualTo(exception.getClass().getCanonicalName());
                Assertions.assertThat((String)accessor.getString(new String[]{"_exception", "message"})).isEqualTo(exception.getMessage());
                ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)accessor.getString(new String[]{"_exception", "stackTrace"})).contains(new CharSequence[]{exception.getLocalizedMessage()})).contains(new CharSequence[]{"at org.apache.logging.log4j.layout.template.json"})).contains(new CharSequence[]{"at java.lang.reflect.Method"})).contains(new CharSequence[]{"at org.junit.platform.engine"});
            } else {
                Assertions.assertThat((Object)accessor.getObject(new String[]{"_exception", "class"})).isNull();
                Assertions.assertThat((Object)accessor.getObject(new String[]{"_exception", "message"})).isNull();
                Assertions.assertThat((String)accessor.getString(new String[]{"_exception", "stackTrace"})).isEmpty();
            }
            Assertions.assertThat((String)accessor.getString("_thread")).isEqualTo(logEvent.getThreadName());
            Assertions.assertThat((String)accessor.getString("_logger")).isEqualTo(logEvent.getLoggerName());
        });
    }

    private static String formatLogEventInstant(LogEvent logEvent) {
        Instant instant = logEvent.getInstant();
        ZonedDateTime dateTime = java.time.Instant.ofEpochSecond(instant.getEpochSecond(), instant.getNanoOfSecond()).atZone(ZoneId.of("UTC"));
        return DATE_TIME_FORMATTER.format(dateTime);
    }
}

