/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.time.Duration;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

class JsonTemplateLayoutNullEventDelimiterTest {
    JsonTemplateLayoutNullEventDelimiterTest() {
    }

    @Test
    void test() throws Exception {
        try (TcpServer server = new TcpServer(0);){
            System.setProperty("serverPort", String.valueOf(server.getPort()));
            System.setProperty("log4j.configurationFile", "nullEventDelimitedJsonTemplateLayoutLogging.xml");
            Logger logger = LogManager.getLogger(JsonTemplateLayoutNullEventDelimiterTest.class);
            logger.log(Level.INFO, "foo");
            logger.log(Level.INFO, "bar");
            byte[] expectedBytes = new byte[]{34, 102, 111, 111, 34, 0, 34, 98, 97, 114, 34, 0};
            Awaitility.await().atMost(Duration.ofSeconds(10L)).pollDelay(Duration.ofSeconds(1L)).until(() -> server.getTotalReadByteCount() >= expectedBytes.length);
            byte[] actualBytes = server.getReceivedBytes();
            Assertions.assertThat((byte[])actualBytes).startsWith(expectedBytes);
        }
    }

    private static final class TcpServer
    extends Thread
    implements AutoCloseable {
        private final ServerSocket serverSocket;
        private final ByteArrayOutputStream outputStream;
        private volatile int totalReadByteCount = 0;
        private volatile boolean closed = false;

        private TcpServer(int port) throws IOException {
            this.serverSocket = new ServerSocket(port);
            this.outputStream = new ByteArrayOutputStream();
            this.serverSocket.setReuseAddress(true);
            this.serverSocket.setSoTimeout(5000);
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                Socket socket = this.serverSocket.accept();
                Throwable throwable = null;
                try {
                    try {
                        InputStream inputStream = socket.getInputStream();
                        byte[] buffer = new byte[1024];
                        while (true) {
                            int readByteCount;
                            if ((readByteCount = inputStream.read(buffer)) <= 0) {
                                continue;
                            }
                            TcpServer tcpServer = this;
                            synchronized (tcpServer) {
                                this.totalReadByteCount += readByteCount;
                                this.outputStream.write(buffer, 0, readByteCount);
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (socket == null) throw throwable3;
                    if (throwable == null) {
                        socket.close();
                        throw throwable3;
                    }
                    try {
                        socket.close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                        throw throwable3;
                    }
                }
            }
            catch (EOFException socket) {
                return;
            }
            catch (Exception error) {
                if (this.closed) return;
                throw new RuntimeException(error);
            }
        }

        public int getPort() {
            return this.serverSocket.getLocalPort();
        }

        public synchronized byte[] getReceivedBytes() {
            return this.outputStream.toByteArray();
        }

        public synchronized int getTotalReadByteCount() {
            return this.totalReadByteCount;
        }

        @Override
        public synchronized void close() {
            if (this.closed) {
                throw new IllegalStateException("shutdown has already been invoked");
            }
            this.closed = true;
            this.interrupt();
            try {
                this.join(3000L);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

