/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.SocketAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.lookup.MainMapLookup;
import org.apache.logging.log4j.core.net.AbstractSocketManager;
import org.apache.logging.log4j.core.net.Severity;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.apache.logging.log4j.layout.template.json.JacksonFixture;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayout;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayoutDefaults;
import org.apache.logging.log4j.layout.template.json.LogEventFixture;
import org.apache.logging.log4j.layout.template.json.TestHelpers;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.apache.logging.log4j.message.ReusableMessageFactory;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.message.StringMapMessage;
import org.apache.logging.log4j.test.AvailablePortFinder;
import org.apache.logging.log4j.util.Strings;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class JsonTemplateLayoutTest {
    private static final List<LogEvent> LOG_EVENTS = LogEventFixture.createFullLogEvents(5);
    private static final ObjectMapper OBJECT_MAPPER = JacksonFixture.getObjectMapper();
    private static final String LOGGER_NAME = JsonTemplateLayoutTest.class.getSimpleName();

    JsonTemplateLayoutTest() {
    }

    @Test
    void test_serialized_event() throws IOException {
        String lookupTestKey = "lookup_test_key";
        String lookupTestVal = String.format("lookup_test_value_%d", (int)(1000.0 * Math.random()));
        System.setProperty("lookup_test_key", lookupTestVal);
        for (LogEvent logEvent : LOG_EVENTS) {
            this.checkLogEvent(logEvent, "lookup_test_key", lookupTestVal);
        }
    }

    private void checkLogEvent(LogEvent logEvent, String lookupTestKey, String lookupTestVal) throws IOException {
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplateUri("classpath:testJsonTemplateLayout.json").setStackTraceEnabled(true).setLocationInfoEnabled(true).build();
        String serializedLogEvent = layout.toSerializable(logEvent);
        JsonNode rootNode = (JsonNode)OBJECT_MAPPER.readValue(serializedLogEvent, JsonNode.class);
        JsonTemplateLayoutTest.checkConstants(rootNode);
        JsonTemplateLayoutTest.checkBasicFields(logEvent, rootNode);
        JsonTemplateLayoutTest.checkSource(logEvent, rootNode);
        JsonTemplateLayoutTest.checkException(layout.getCharset(), logEvent, rootNode);
        JsonTemplateLayoutTest.checkLookupTest(lookupTestKey, lookupTestVal, rootNode);
    }

    private static void checkConstants(JsonNode rootNode) {
        Assertions.assertThat((int)JsonTemplateLayoutTest.point(rootNode, "@version").asInt()).isEqualTo(1);
    }

    private static void checkBasicFields(LogEvent logEvent, JsonNode rootNode) {
        Assertions.assertThat((String)JsonTemplateLayoutTest.point(rootNode, "message").asText()).isEqualTo(logEvent.getMessage().getFormattedMessage());
        Assertions.assertThat((String)JsonTemplateLayoutTest.point(rootNode, "level").asText()).isEqualTo(logEvent.getLevel().name());
        Assertions.assertThat((String)JsonTemplateLayoutTest.point(rootNode, "logger_fqcn").asText()).isEqualTo(logEvent.getLoggerFqcn());
        Assertions.assertThat((String)JsonTemplateLayoutTest.point(rootNode, "logger_name").asText()).isEqualTo(logEvent.getLoggerName());
        Assertions.assertThat((long)JsonTemplateLayoutTest.point(rootNode, "thread_id").asLong()).isEqualTo(logEvent.getThreadId());
        Assertions.assertThat((String)JsonTemplateLayoutTest.point(rootNode, "thread_name").asText()).isEqualTo(logEvent.getThreadName());
        Assertions.assertThat((int)JsonTemplateLayoutTest.point(rootNode, "thread_priority").asInt()).isEqualTo(logEvent.getThreadPriority());
        Assertions.assertThat((boolean)JsonTemplateLayoutTest.point(rootNode, "end_of_batch").asBoolean()).isEqualTo(logEvent.isEndOfBatch());
    }

    private static void checkSource(LogEvent logEvent, JsonNode rootNode) {
        Assertions.assertThat((String)JsonTemplateLayoutTest.point(rootNode, "class").asText()).isEqualTo(logEvent.getSource().getClassName());
        Assertions.assertThat((String)JsonTemplateLayoutTest.point(rootNode, "file").asText()).isEqualTo(logEvent.getSource().getFileName());
        Assertions.assertThat((int)JsonTemplateLayoutTest.point(rootNode, "line_number").asInt()).isEqualTo(logEvent.getSource().getLineNumber());
    }

    private static void checkException(Charset charset, LogEvent logEvent, JsonNode rootNode) {
        Throwable thrown = logEvent.getThrown();
        if (thrown != null) {
            Assertions.assertThat((String)JsonTemplateLayoutTest.point(rootNode, "exception_class").asText()).isEqualTo(thrown.getClass().getCanonicalName());
            Assertions.assertThat((String)JsonTemplateLayoutTest.point(rootNode, "exception_message").asText()).isEqualTo(thrown.getMessage());
            String stackTrace = JsonTemplateLayoutTest.serializeStackTrace(charset, thrown);
            Assertions.assertThat((String)JsonTemplateLayoutTest.point(rootNode, "stacktrace").asText()).isEqualTo(stackTrace);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String serializeStackTrace(Charset charset, Throwable exception) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String charsetName = charset.name();
        try (PrintStream printStream = new PrintStream((OutputStream)outputStream, false, charsetName);){
            exception.printStackTrace(printStream);
            String string = outputStream.toString(charsetName);
            return string;
        }
        catch (UnsupportedEncodingException error) {
            throw new RuntimeException("failed converting the stack trace to string", error);
        }
    }

    private static void checkLookupTest(String lookupTestKey, String lookupTestVal, JsonNode rootNode) {
        Assertions.assertThat((String)JsonTemplateLayoutTest.point(rootNode, lookupTestKey).asText()).isEqualTo(lookupTestVal);
    }

    private static JsonNode point(JsonNode node, Object ... fields) {
        String pointer = JsonTemplateLayoutTest.createJsonPointer(fields);
        return node.at(pointer);
    }

    private static String createJsonPointer(Object ... fields) {
        StringBuilder jsonPathBuilder = new StringBuilder();
        for (Object field : fields) {
            jsonPathBuilder.append("/").append(field);
        }
        return jsonPathBuilder.toString();
    }

    @Test
    void test_inline_template() {
        SimpleMessage message = new SimpleMessage("Hello, World");
        String formattedInstant = "2017-09-28T17:13:29.098Z";
        java.time.Instant instantAccessor = java.time.Instant.parse("2017-09-28T17:13:29.098Z");
        long instantEpochSeconds = instantAccessor.getLong(ChronoField.INSTANT_SECONDS);
        int instantEpochSecondsNanos = instantAccessor.get(ChronoField.NANO_OF_SECOND);
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochSecond(instantEpochSeconds, instantEpochSecondsNanos);
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setLevel(Level.INFO).setMessage((Message)message).setInstant((Instant)instant).build();
        String timestampFieldName = "@timestamp";
        String staticFieldName = "staticFieldName";
        String staticFieldValue = "staticFieldValue";
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("@timestamp", TestHelpers.asMap("$resolver", "timestamp", "pattern", TestHelpers.asMap("format", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "timeZone", "UTC")), "staticFieldName", "staticFieldValue"));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            Assertions.assertThat((String)accessor.getString("@timestamp")).isEqualTo("2017-09-28T17:13:29.098Z");
            Assertions.assertThat((String)accessor.getString("staticFieldName")).isEqualTo("staticFieldValue");
        });
    }

    @Test
    void test_log4j_deferred_runtime_resolver_for_MapMessage() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("mapValue3", TestHelpers.asMap("$resolver", "message"), "mapValue1", "${map:key1}", "mapValue2", "${map:key2}", "nestedLookupEmptyValue", "${map:noExist:-${map:noExist2:-${map:noExist3:-}}}", "nestedLookupStaticValue", "${map:noExist:-${map:noExist2:-${map:noExist3:-Static Value}}}"));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        StringMapMessage mapMessage = (StringMapMessage)((StringMapMessage)((StringMapMessage)new StringMapMessage().with("key1", "val1")).with("key2", "val2")).with("key3", Collections.singletonMap("foo", "bar"));
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setLevel(Level.INFO).setMessage((Message)mapMessage).setTimeMillis(System.currentTimeMillis()).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            Assertions.assertThat((String)accessor.getString("mapValue1")).isEqualTo("val1");
            Assertions.assertThat((String)accessor.getString("mapValue2")).isEqualTo("val2");
            Assertions.assertThat((String)accessor.getString("nestedLookupEmptyValue")).isEmpty();
            Assertions.assertThat((String)accessor.getString("nestedLookupStaticValue")).isEqualTo("Static Value");
        });
    }

    @Test
    void test_property_injection() {
        SimpleMessage message = new SimpleMessage("Hello, World");
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setLevel(Level.INFO).setMessage((Message)message).build();
        String propertyName = "propertyName";
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("propertyName", "${propertyName}"));
        String propertyValue = "propertyValue";
        Configuration config = (Configuration)ConfigurationBuilderFactory.newConfigurationBuilder().addProperty("propertyName", "propertyValue").build();
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(config).setEventTemplate(eventTemplate).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> Assertions.assertThat((String)accessor.getString("propertyName")).isEqualTo("propertyValue"));
    }

    @Test
    void test_empty_root_cause() {
        SimpleMessage message = new SimpleMessage("Hello, World!");
        RuntimeException exception = new RuntimeException("failure for test purposes");
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setLevel(Level.ERROR).setMessage((Message)message).setThrown((Throwable)exception).build();
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("ex_class", TestHelpers.asMap("$resolver", "exception", "field", "className"), "ex_message", TestHelpers.asMap("$resolver", "exception", "field", "message"), "ex_stacktrace", TestHelpers.asMap("$resolver", "exception", "field", "stackTrace", "stackTrace", TestHelpers.asMap("stringified", true)), "root_ex_class", TestHelpers.asMap("$resolver", "exceptionRootCause", "field", "className"), "root_ex_message", TestHelpers.asMap("$resolver", "exceptionRootCause", "field", "message"), "root_ex_stacktrace", TestHelpers.asMap("$resolver", "exceptionRootCause", "field", "stackTrace", "stackTrace", TestHelpers.asMap("stringified", true))));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setStackTraceEnabled(true).setEventTemplate(eventTemplate).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            Assertions.assertThat((String)accessor.getString("ex_class")).isEqualTo(exception.getClass().getCanonicalName());
            Assertions.assertThat((String)accessor.getString("ex_message")).isEqualTo(exception.getMessage());
            Assertions.assertThat((String)accessor.getString("ex_stacktrace")).startsWith((CharSequence)(exception.getClass().getCanonicalName() + ": " + exception.getMessage()));
            Assertions.assertThat((String)accessor.getString("root_ex_class")).isEqualTo(accessor.getString("ex_class"));
            Assertions.assertThat((String)accessor.getString("root_ex_message")).isEqualTo(accessor.getString("ex_message"));
            Assertions.assertThat((String)accessor.getString("root_ex_stacktrace")).isEqualTo(accessor.getString("ex_stacktrace"));
        });
    }

    @Test
    void test_root_cause() {
        SimpleMessage message = new SimpleMessage("Hello, World!");
        RuntimeException exceptionCause = new RuntimeException("failure cause for test purposes");
        RuntimeException exception = new RuntimeException("failure for test purposes", exceptionCause);
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setLevel(Level.ERROR).setMessage((Message)message).setThrown((Throwable)exception).build();
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("ex_class", TestHelpers.asMap("$resolver", "exception", "field", "className"), "ex_message", TestHelpers.asMap("$resolver", "exception", "field", "message"), "ex_stacktrace", TestHelpers.asMap("$resolver", "exception", "field", "stackTrace", "stringified", true), "root_ex_class", TestHelpers.asMap("$resolver", "exceptionRootCause", "field", "className"), "root_ex_message", TestHelpers.asMap("$resolver", "exceptionRootCause", "field", "message"), "root_ex_stacktrace", TestHelpers.asMap("$resolver", "exceptionRootCause", "field", "stackTrace", "stackTrace", TestHelpers.asMap("stringified", true))));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setStackTraceEnabled(true).setEventTemplate(eventTemplate).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            Assertions.assertThat((String)accessor.getString("ex_class")).isEqualTo(exception.getClass().getCanonicalName());
            Assertions.assertThat((String)accessor.getString("ex_message")).isEqualTo(exception.getMessage());
            Assertions.assertThat((String)accessor.getString("ex_stacktrace")).startsWith((CharSequence)(exception.getClass().getCanonicalName() + ": " + exception.getMessage()));
            Assertions.assertThat((String)accessor.getString("root_ex_class")).isEqualTo(exceptionCause.getClass().getCanonicalName());
            Assertions.assertThat((String)accessor.getString("root_ex_message")).isEqualTo(exceptionCause.getMessage());
            Assertions.assertThat((String)accessor.getString("root_ex_stacktrace")).startsWith((CharSequence)(exceptionCause.getClass().getCanonicalName() + ": " + exceptionCause.getMessage()));
        });
    }

    @Test
    void test_marker_name() {
        SimpleMessage message = new SimpleMessage("Hello, World!");
        String markerName = "test";
        Marker marker = MarkerManager.getMarker((String)"test");
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setLevel(Level.ERROR).setMessage((Message)message).setMarker(marker).build();
        String messageKey = "message";
        String markerNameKey = "marker";
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("message", TestHelpers.asMap("$resolver", "message"), "marker", TestHelpers.asMap("$resolver", "marker", "field", "name")));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            Assertions.assertThat((String)accessor.getString("message")).isEqualTo(message.getFormattedMessage());
            Assertions.assertThat((String)accessor.getString("marker")).isEqualTo("test");
        });
    }

    @Test
    void test_lineSeparator_suffix() {
        SimpleMessage message = new SimpleMessage("Hello, World!");
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setLevel(Level.INFO).setMessage((Message)message).build();
        this.test_lineSeparator_suffix((LogEvent)logEvent, true);
        this.test_lineSeparator_suffix((LogEvent)logEvent, false);
    }

    private void test_lineSeparator_suffix(LogEvent logEvent, boolean prettyPrintEnabled) {
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplateUri("classpath:LogstashJsonEventLayoutV1.json").build();
        String serializedLogEvent = layout.toSerializable(logEvent);
        String assertionCaption = String.format("testing lineSeperator (prettyPrintEnabled=%s)", prettyPrintEnabled);
        ((AbstractStringAssert)Assertions.assertThat((String)serializedLogEvent).as(assertionCaption, new Object[0])).endsWith((CharSequence)("}" + System.lineSeparator()));
    }

    @Test
    void test_main_key_access() {
        String kwKey = "--name";
        String kwVal = "aNameValue";
        String positionArg = "position2Value";
        String missingKwKey = "--missing";
        String[] mainArgs = new String[]{"--name", "aNameValue", "position2Value"};
        MainMapLookup.setMainArguments((String[])mainArgs);
        SimpleMessage message = new SimpleMessage("Hello, World!");
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setLevel(Level.INFO).setMessage((Message)message).build();
        String template = TestHelpers.writeJson(TestHelpers.asMap("name", TestHelpers.asMap("$resolver", "main", "key", "--name"), "positionArg", TestHelpers.asMap("$resolver", "main", "index", 2), "notFoundArg", TestHelpers.asMap("$resolver", "main", "key", "--missing")));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(template).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            Assertions.assertThat((String)accessor.getString("name")).isEqualTo("aNameValue");
            Assertions.assertThat((String)accessor.getString("positionArg")).isEqualTo("position2Value");
            Assertions.assertThat((boolean)accessor.exists("notFoundArg")).isFalse();
        });
    }

    @Test
    void test_StackTraceElement_template() {
        String classNameFieldName = "className";
        String methodNameFieldName = "methodName";
        String fileNameFieldName = "fileName";
        String lineNumberFieldName = "lineNumber";
        String stackTraceElementTemplate = TestHelpers.writeJson(TestHelpers.asMap("className", TestHelpers.asMap("$resolver", "stackTraceElement", "field", "className"), "methodName", TestHelpers.asMap("$resolver", "stackTraceElement", "field", "methodName"), "fileName", TestHelpers.asMap("$resolver", "stackTraceElement", "field", "fileName"), "lineNumber", TestHelpers.asMap("$resolver", "stackTraceElement", "field", "lineNumber")));
        String stackTraceFieldName = "stackTrace";
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("stackTrace", TestHelpers.asMap("$resolver", "exception", "field", "stackTrace")));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setStackTraceEnabled(true).setStackTraceElementTemplate(stackTraceElementTemplate).setEventTemplate(eventTemplate).build();
        SimpleMessage message = new SimpleMessage("Hello, World!");
        RuntimeException exceptionCause = new RuntimeException("failure cause for test purposes");
        RuntimeException exception = new RuntimeException("failure for test purposes", exceptionCause);
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setLevel(Level.ERROR).setMessage((Message)message).setThrown((Throwable)exception).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            Assertions.assertThat((boolean)accessor.exists("stackTrace")).isTrue();
            List deserializedStackTraceElements = (List)accessor.getObject("stackTrace", List.class);
            StackTraceElement[] stackTraceElements = exception.getStackTrace();
            Assertions.assertThat((int)deserializedStackTraceElements.size()).isEqualTo(stackTraceElements.length);
            for (int stackTraceElementIndex = 0; stackTraceElementIndex < stackTraceElements.length; ++stackTraceElementIndex) {
                StackTraceElement stackTraceElement = stackTraceElements[stackTraceElementIndex];
                Map deserializedStackTraceElement = (Map)deserializedStackTraceElements.get(stackTraceElementIndex);
                Assertions.assertThat((int)deserializedStackTraceElement.size()).isEqualTo(4);
                Assertions.assertThat(deserializedStackTraceElement.get("className")).isEqualTo((Object)stackTraceElement.getClassName());
                Assertions.assertThat(deserializedStackTraceElement.get("methodName")).isEqualTo((Object)stackTraceElement.getMethodName());
                Assertions.assertThat(deserializedStackTraceElement.get("fileName")).isEqualTo((Object)stackTraceElement.getFileName());
                Assertions.assertThat(deserializedStackTraceElement.get("lineNumber")).isEqualTo((Object)stackTraceElement.getLineNumber());
            }
        });
    }

    @Test
    void test_toSerializable_toByteArray_encode_outputs() {
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplateUri("classpath:LogstashJsonEventLayoutV1.json").setStackTraceEnabled(true).build();
        LogEvent logEvent = LogEventFixture.createFullLogEvents(1).get(0);
        String toSerializableOutput = layout.toSerializable(logEvent);
        byte[] toByteArrayOutputBytes = layout.toByteArray(logEvent);
        String toByteArrayOutput = new String(toByteArrayOutputBytes, 0, toByteArrayOutputBytes.length, layout.getCharset());
        final ByteBuffer byteBuffer = ByteBuffer.allocate(524288);
        ByteBufferDestination byteBufferDestination = new ByteBufferDestination(){

            public ByteBuffer getByteBuffer() {
                return byteBuffer;
            }

            public ByteBuffer drain(ByteBuffer ignored) {
                throw new UnsupportedOperationException();
            }

            public void writeBytes(ByteBuffer data) {
                byteBuffer.put(data);
            }

            public void writeBytes(byte[] buffer, int offset, int length) {
                byteBuffer.put(buffer, offset, length);
            }
        };
        layout.encode(logEvent, byteBufferDestination);
        String encodeOutput = new String(byteBuffer.array(), 0, byteBuffer.position(), layout.getCharset());
        Assertions.assertThat((String)toSerializableOutput).isEqualTo(toByteArrayOutput);
        Assertions.assertThat((String)toByteArrayOutput).isEqualTo(encodeOutput);
    }

    @Test
    void test_maxStringLength() {
        int maxStringLength = 30;
        String excessiveMessageString = Strings.repeat((String)"m", (int)30) + 'M';
        SimpleMessage message = new SimpleMessage(excessiveMessageString);
        RuntimeException thrown = new RuntimeException();
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setLevel(Level.INFO).setMessage((Message)message).setThrown((Throwable)thrown).build();
        String messageKey = "message";
        String excessiveKey = Strings.repeat((String)"k", (int)30) + 'K';
        String excessiveValue = Strings.repeat((String)"v", (int)30) + 'V';
        String nullValueKey = "nullValueKey";
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("message", TestHelpers.asMap("$resolver", "message"), excessiveKey, excessiveValue, "nullValueKey", TestHelpers.asMap("$resolver", "exception", "field", "message")));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).setMaxStringLength(30).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            String truncatedStringSuffix = JsonTemplateLayoutDefaults.getTruncatedStringSuffix();
            String truncatedMessageString = excessiveMessageString.substring(0, 30) + truncatedStringSuffix;
            Assertions.assertThat((String)accessor.getString("message")).isEqualTo(truncatedMessageString);
            String truncatedKey = excessiveKey.substring(0, 30) + truncatedStringSuffix;
            String truncatedValue = excessiveValue.substring(0, 30) + truncatedStringSuffix;
            Assertions.assertThat((String)accessor.getString(truncatedKey)).isEqualTo(truncatedValue);
            Assertions.assertThat((String)accessor.getString("nullValueKey")).isNull();
        });
    }

    @Test
    void test_exception_with_nonAscii_utf8_method_name() {
        SimpleMessage message = new SimpleMessage("Hello, World!");
        NonAsciiUtf8MethodNameContainingException exception = NonAsciiUtf8MethodNameContainingException.INSTANCE;
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setLevel(Level.ERROR).setMessage((Message)message).setThrown((Throwable)exception).build();
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("ex_stacktrace", TestHelpers.asMap("$resolver", "exception", "field", "stackTrace", "stringified", true)));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setStackTraceEnabled(true).setEventTemplate(eventTemplate).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)accessor.getString("ex_stacktrace")).contains(new CharSequence[]{"\u0b85\u0b86\u0b87\u0e2c\u0e58"});
        });
    }

    @Test
    void test_event_template_additional_fields() {
        SimpleMessage message = new SimpleMessage("Hello, World!");
        NonAsciiUtf8MethodNameContainingException exception = NonAsciiUtf8MethodNameContainingException.INSTANCE;
        Level level = Level.ERROR;
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setLevel(level).setMessage((Message)message).setThrown((Throwable)exception).build();
        String eventTemplate = "{}";
        JsonTemplateLayout.EventTemplateAdditionalField[] additionalFields = new JsonTemplateLayout.EventTemplateAdditionalField[]{JsonTemplateLayout.EventTemplateAdditionalField.newBuilder().setKey("number").setValue("1").setFormat(JsonTemplateLayout.EventTemplateAdditionalField.Format.JSON).build(), JsonTemplateLayout.EventTemplateAdditionalField.newBuilder().setKey("string").setValue("foo").build(), JsonTemplateLayout.EventTemplateAdditionalField.newBuilder().setKey("level").setValue("{\"$resolver\": \"level\", \"field\": \"name\"}").setFormat(JsonTemplateLayout.EventTemplateAdditionalField.Format.JSON).build()};
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setStackTraceEnabled(true).setEventTemplate("{}").setEventTemplateAdditionalFields(additionalFields).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            Assertions.assertThat((Integer)accessor.getInteger("number")).isEqualTo(1);
            Assertions.assertThat((String)accessor.getString("string")).isEqualTo("foo");
            Assertions.assertThat((String)accessor.getString("level")).isEqualTo(level.name());
        });
    }

    @Test
    void test_timestamp_epoch_resolvers() {
        List<Map> testCases = Arrays.asList(TestHelpers.asMap("epochSecs", new BigDecimal("1581082727.982123456"), "epochSecsRounded", 1581082727, "epochSecsNanos", 982123456, "epochMillis", new BigDecimal("1581082727982.123456"), "epochMillisRounded", 1581082727982L, "epochMillisNanos", 123456, "epochNanos", 1581082727982123456L), TestHelpers.asMap("epochSecs", new BigDecimal("1591177590.005000001"), "epochSecsRounded", 1591177590, "epochSecsNanos", 5000001, "epochMillis", new BigDecimal("1591177590005.000001"), "epochMillisRounded", 1591177590005L, "epochMillisNanos", 1, "epochNanos", 1591177590005000001L));
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("epochSecs", TestHelpers.asMap("$resolver", "timestamp", "epoch", TestHelpers.asMap("unit", "secs")), "epochSecsRounded", TestHelpers.asMap("$resolver", "timestamp", "epoch", TestHelpers.asMap("unit", "secs", "rounded", true)), "epochSecsNanos", TestHelpers.asMap("$resolver", "timestamp", "epoch", TestHelpers.asMap("unit", "secs.nanos")), "epochMillis", TestHelpers.asMap("$resolver", "timestamp", "epoch", TestHelpers.asMap("unit", "millis")), "epochMillisRounded", TestHelpers.asMap("$resolver", "timestamp", "epoch", TestHelpers.asMap("unit", "millis", "rounded", true)), "epochMillisNanos", TestHelpers.asMap("$resolver", "timestamp", "epoch", TestHelpers.asMap("unit", "millis.nanos")), "epochNanos", TestHelpers.asMap("$resolver", "timestamp", "epoch", TestHelpers.asMap("unit", "nanos"))));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        testCases.forEach(testCase -> {
            SimpleMessage message = new SimpleMessage("Hello, World!");
            Level level = Level.ERROR;
            MutableInstant instant = new MutableInstant();
            Object instantSecsObject = testCase.get("epochSecsRounded");
            long instantSecs = instantSecsObject instanceof Long ? (Long)instantSecsObject : (long)((Integer)instantSecsObject).intValue();
            int instantSecsNanos = (Integer)testCase.get("epochSecsNanos");
            instant.initFromEpochSecond(instantSecs, instantSecsNanos);
            Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setLevel(level).setMessage((Message)message).setInstant((Instant)instant).build();
            TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> testCase.forEach((key, expectedValue) -> {
                ObjectAssert cfr_ignored_0 = (ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)accessor.getObject(key)).describedAs("key=%s", new Object[]{key})).isEqualTo(expectedValue);
            }));
        });
    }

    @Test
    void test_timestamp_pattern_resolver() {
        String logEvent1FormattedInstant = "2019-01-02T09:34:11Z";
        LogEvent logEvent1 = JsonTemplateLayoutTest.createLogEventAtInstant("2019-01-02T09:34:11Z");
        String logEvent2FormattedInstant = "2019-01-02T09:34:12Z";
        LogEvent logEvent2 = JsonTemplateLayoutTest.createLogEventAtInstant("2019-01-02T09:34:12Z");
        String logEvent3FormattedInstant = "2019-01-02T09:34:12Z";
        LogEvent logEvent3 = JsonTemplateLayoutTest.createLogEventAtInstant("2019-01-02T09:34:12Z");
        String logEvent4FormattedInstant = "2019-01-02T09:34:13Z";
        LogEvent logEvent4 = JsonTemplateLayoutTest.createLogEventAtInstant("2019-01-02T09:34:13Z");
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("timestamp", TestHelpers.asMap("$resolver", "timestamp", "pattern", TestHelpers.asMap("format", "yyyy-MM-dd'T'HH:mm:ss'Z'", "timeZone", "UTC"))));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, logEvent1, accessor -> Assertions.assertThat((String)accessor.getString("timestamp")).isEqualTo("2019-01-02T09:34:11Z"));
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, logEvent2, accessor -> Assertions.assertThat((String)accessor.getString("timestamp")).isEqualTo("2019-01-02T09:34:12Z"));
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, logEvent3, accessor -> Assertions.assertThat((String)accessor.getString("timestamp")).isEqualTo("2019-01-02T09:34:12Z"));
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, logEvent4, accessor -> Assertions.assertThat((String)accessor.getString("timestamp")).isEqualTo("2019-01-02T09:34:13Z"));
    }

    private static LogEvent createLogEventAtInstant(String formattedInstant) {
        SimpleMessage message = new SimpleMessage("LogEvent at instant " + formattedInstant);
        long instantEpochMillis = java.time.Instant.parse(formattedInstant).toEpochMilli();
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochMilli(instantEpochMillis, 0);
        return Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setMessage((Message)message).setInstant((Instant)instant).build();
    }

    @Test
    void test_level_severity() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("severityKeyword", TestHelpers.asMap("$resolver", "level", "field", "severity", "severity", TestHelpers.asMap("field", "keyword")), "severityCode", TestHelpers.asMap("$resolver", "level", "field", "severity", "severity", TestHelpers.asMap("field", "code"))));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        for (Level level : Level.values()) {
            SimpleMessage message = new SimpleMessage("Hello, World!");
            Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setLevel(level).setMessage((Message)message).build();
            TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
                Severity expectedSeverity = Severity.getSeverity((Level)level);
                String expectedSeverityKeyword = expectedSeverity.name();
                int expectedSeverityCode = expectedSeverity.getCode();
                Assertions.assertThat((String)accessor.getString("severityKeyword")).isEqualTo(expectedSeverityKeyword);
                Assertions.assertThat((Integer)accessor.getInteger("severityCode")).isEqualTo(expectedSeverityCode);
            });
        }
    }

    @Test
    void test_exception_resolvers_against_no_exceptions() {
        SimpleMessage message = new SimpleMessage("Hello, World!");
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setMessage((Message)message).build();
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("exStackTrace", TestHelpers.asMap("$resolver", "exception", "field", "stackTrace"), "exStackTraceString", TestHelpers.asMap("$resolver", "exception", "field", "stackTrace", "stackTrace", TestHelpers.asMap("stringified", true)), "exRootCauseStackTrace", TestHelpers.asMap("$resolver", "exceptionRootCause", "field", "stackTrace"), "exRootCauseStackTraceString", TestHelpers.asMap("$resolver", "exceptionRootCause", "field", "stackTrace", "stackTrace", TestHelpers.asMap("stringified", true)), "requiredFieldTriggeringError", true));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).setStackTraceEnabled(true).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            Assertions.assertThat((Object)accessor.getObject("exStackTrace")).isNull();
            Assertions.assertThat((Object)accessor.getObject("exStackTraceString")).isNull();
            Assertions.assertThat((Object)accessor.getObject("exRootCauseStackTrace")).isNull();
            Assertions.assertThat((Object)accessor.getObject("exRootCauseStackTraceString")).isNull();
            Assertions.assertThat((Boolean)accessor.getBoolean("requiredFieldTriggeringError")).isTrue();
        });
    }

    @Test
    void test_stringified_exception_resolver_with_maxStringLength() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("stackTrace", TestHelpers.asMap("$resolver", "exception", "field", "stackTrace", "stringified", true)));
        int maxStringLength = eventTemplate.length();
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).setMaxStringLength(maxStringLength).setStackTraceEnabled(true).build();
        SimpleMessage message = new SimpleMessage("foo");
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setMessage((Message)message).setThrown((Throwable)NonAsciiUtf8MethodNameContainingException.INSTANCE).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            int expectedLength = maxStringLength + JsonTemplateLayoutDefaults.getTruncatedStringSuffix().length();
            Assertions.assertThat((int)accessor.getString("stackTrace").length()).isEqualTo(expectedLength);
        });
    }

    @Test
    void test_stack_trace_truncation() {
        Exception childError = new Exception("unique child exception message");
        Exception parentError = new Exception("unique parent exception message", childError);
        String truncationSuffix = "~";
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("ex", TestHelpers.asMap("$resolver", "exception", "field", "stackTrace", "stackTrace", TestHelpers.asMap("stringified", true)), "stringMatchedEx", TestHelpers.asMap("$resolver", "exception", "field", "stackTrace", "stackTrace", TestHelpers.asMap("stringified", TestHelpers.asMap("truncation", TestHelpers.asMap("suffix", "~", "pointMatcherStrings", Arrays.asList("this string shouldn't match with anything", parentError.getMessage()))))), "regexMatchedEx", TestHelpers.asMap("$resolver", "exception", "field", "stackTrace", "stackTrace", TestHelpers.asMap("stringified", TestHelpers.asMap("truncation", TestHelpers.asMap("suffix", "~", "pointMatcherRegexes", Arrays.asList("this string shouldn't match with anything", parentError.getMessage().replace("unique", "[xu]n.que")))))), "rootEx", TestHelpers.asMap("$resolver", "exceptionRootCause", "field", "stackTrace", "stackTrace", TestHelpers.asMap("stringified", true)), "stringMatchedRootEx", TestHelpers.asMap("$resolver", "exceptionRootCause", "field", "stackTrace", "stackTrace", TestHelpers.asMap("stringified", TestHelpers.asMap("truncation", TestHelpers.asMap("suffix", "~", "pointMatcherStrings", Arrays.asList("this string shouldn't match with anything", childError.getMessage()))))), "regexMatchedRootEx", TestHelpers.asMap("$resolver", "exceptionRootCause", "field", "stackTrace", "stackTrace", TestHelpers.asMap("stringified", TestHelpers.asMap("truncation", TestHelpers.asMap("suffix", "~", "pointMatcherRegexes", Arrays.asList("this string shouldn't match with anything", childError.getMessage().replace("unique", "[xu]n.que"))))))));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).setStackTraceEnabled(true).build();
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setThrown((Throwable)parentError).build();
        String expectedMatchedExEnd = parentError.getMessage() + "~";
        String expectedMatchedRootExEnd = childError.getMessage() + "~";
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            ((AbstractStringAssert)Assertions.assertThat((String)accessor.getString("ex")).doesNotEndWith((CharSequence)expectedMatchedExEnd)).doesNotEndWith((CharSequence)expectedMatchedRootExEnd);
            Assertions.assertThat((String)accessor.getString("stringMatchedEx")).endsWith((CharSequence)expectedMatchedExEnd);
            Assertions.assertThat((String)accessor.getString("regexMatchedEx")).endsWith((CharSequence)expectedMatchedExEnd);
            ((AbstractStringAssert)Assertions.assertThat((String)accessor.getString("rootEx")).doesNotEndWith((CharSequence)expectedMatchedExEnd)).doesNotEndWith((CharSequence)expectedMatchedRootExEnd);
            Assertions.assertThat((String)accessor.getString("stringMatchedRootEx")).endsWith((CharSequence)expectedMatchedRootExEnd);
            Assertions.assertThat((String)accessor.getString("regexMatchedRootEx")).endsWith((CharSequence)expectedMatchedRootExEnd);
        });
    }

    @Test
    void test_inline_stack_trace_element_template() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("stackTrace", TestHelpers.asMap("$resolver", "exception", "field", "stackTrace", "stackTrace", TestHelpers.asMap("elementTemplate", TestHelpers.asMap("$resolver", "stackTraceElement", "field", "className")))));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        RuntimeException error = new RuntimeException("foo");
        SimpleMessage message = new SimpleMessage("foo");
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setMessage((Message)message).setThrown((Throwable)error).build();
        String expectedClassName = JsonTemplateLayoutTest.class.getCanonicalName();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            ListAssert cfr_ignored_0 = (ListAssert)Assertions.assertThat((List)accessor.getList("stackTrace", String.class)).contains((Object[])new String[]{expectedClassName});
        });
    }

    @Test
    void test_custom_resolver() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("customField", TestHelpers.asMap("$resolver", "custom")));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        SimpleMessage message = new SimpleMessage("foo");
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setMessage((Message)message).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)accessor.getString("customField")).matches((CharSequence)"CustomValue-[0-9]+");
        });
    }

    @Test
    void test_null_eventDelimiter() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("key", "val"));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).setEventDelimiter("\u0000").build();
        SimpleMessage message = new SimpleMessage("foo");
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setMessage((Message)message).setThrown((Throwable)NonAsciiUtf8MethodNameContainingException.INSTANCE).build();
        String serializedLogEvent = layout.toSerializable((LogEvent)logEvent);
        Assertions.assertThat((String)serializedLogEvent).isEqualTo(eventTemplate + '\u0000');
    }

    @Test
    void test_against_SocketAppender() throws Exception {
        List<LogEvent> logEvents = JsonTemplateLayoutTest.createNastyLogEvents();
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("message", TestHelpers.asMap("$resolver", "message")));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        int port = AvailablePortFinder.getNextAvailable();
        try (JsonAcceptingTcpServer server = new JsonAcceptingTcpServer(port, 1);){
            SocketAppender appender = ((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)SocketAppender.newBuilder().withHost("localhost")).withBufferedIo(false)).withPort(port)).withReconnectDelayMillis(100)).setName("test")).withImmediateFail(false)).setIgnoreExceptions(false)).setLayout((Layout)layout)).build();
            appender.start();
            for (int logEventIndex = 0; logEventIndex < logEvents.size(); ++logEventIndex) {
                LogEvent logEvent = logEvents.get(logEventIndex);
                appender.append(logEvent);
                ((AbstractSocketManager)appender.getManager()).flush();
                JsonNode node = (JsonNode)server.receivedNodes.poll(3L, TimeUnit.SECONDS);
                ((IterableAssert)Assertions.assertThat((Iterable)node).as("logEventIndex=%d", new Object[]{logEventIndex})).isNotNull();
                String expectedMessage = logEvent.getMessage().getFormattedMessage();
                String expectedMessageChars = JsonTemplateLayoutTest.explainChars(expectedMessage);
                String actualMessage = JsonTemplateLayoutTest.point(node, "message").asText();
                String actualMessageChars = JsonTemplateLayoutTest.explainChars(actualMessage);
                ((AbstractStringAssert)Assertions.assertThat((String)actualMessageChars).as("logEventIndex=%d", new Object[]{logEventIndex})).isEqualTo(expectedMessageChars);
            }
            Assertions.assertThat((int)server.droppedNodeCount).isZero();
        }
    }

    private static List<LogEvent> createNastyLogEvents() {
        return JsonTemplateLayoutTest.createNastyMessages().stream().map(message -> Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setMessage((Message)message).build()).collect(Collectors.toList());
    }

    private static List<SimpleMessage> createNastyMessages() {
        int messageCount = 1024;
        boolean minChar = false;
        int maxChar = 55295;
        int totalCharCount = 55296;
        int charOffset = 54;
        ArrayList<SimpleMessage> messages = new ArrayList<SimpleMessage>(1024);
        for (int messageIndex = 0; messageIndex < 1024; ++messageIndex) {
            StringBuilder stringBuilder = new StringBuilder(messageIndex + "@");
            for (int charIndex = 0; charIndex < 54; ++charIndex) {
                char c = (char)(0 + messageIndex * 54 + charIndex);
                stringBuilder.append(c);
            }
            String messageString = stringBuilder.toString();
            SimpleMessage message = new SimpleMessage(messageString);
            messages.add(message);
        }
        return messages;
    }

    private static String explainChars(String input) {
        return IntStream.range(0, input.length()).mapToObj(i -> {
            char c = input.charAt(i);
            return String.format("'%c' (%04X)", Character.valueOf(c), (int)c);
        }).collect(Collectors.joining(", "));
    }

    @Test
    void test_PatternResolver() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("message", TestHelpers.asMap("$resolver", "pattern", "pattern", "%p:%m")));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        SimpleMessage message = new SimpleMessage("foo");
        Level level = Level.FATAL;
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setMessage((Message)message).setLevel(level).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            String expectedMessage = String.format("%s:%s", level, message.getFormattedMessage());
            Assertions.assertThat((String)accessor.getString("message")).isEqualTo(expectedMessage);
        });
    }

    @Test
    void test_MessageParameterResolver_with_ParameterizedMessageFactory() {
        JsonTemplateLayoutTest.testMessageParameterResolver((MessageFactory)ParameterizedMessageFactory.INSTANCE);
    }

    @Test
    void test_MessageParameterResolver_noParameters_with_ParameterizedMessageFactory() {
        JsonTemplateLayoutTest.testMessageParameterResolverNoParameters((MessageFactory)ParameterizedMessageFactory.INSTANCE);
    }

    @Test
    void test_MessageParameterResolver_with_ReusableMessageFactory() {
        JsonTemplateLayoutTest.testMessageParameterResolver((MessageFactory)ReusableMessageFactory.INSTANCE);
    }

    @Test
    void test_MessageParameterResolver_noParameters_with_ReusableMessageFactory() {
        JsonTemplateLayoutTest.testMessageParameterResolverNoParameters((MessageFactory)ReusableMessageFactory.INSTANCE);
    }

    private static void testMessageParameterResolver(MessageFactory messageFactory) {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("po*", TestHelpers.asMap("$resolver", "messageParameter"), "ps*", TestHelpers.asMap("$resolver", "messageParameter", "stringified", true), "po2", TestHelpers.asMap("$resolver", "messageParameter", "index", 2), "ps2", TestHelpers.asMap("$resolver", "messageParameter", "index", 2, "stringified", true), "po3", TestHelpers.asMap("$resolver", "messageParameter", "index", 3)));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        Object[] parameters = new Object[]{0x80000000L, "foo", 56};
        Message message = messageFactory.newMessage("foo", parameters);
        Level level = Level.FATAL;
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setMessage(message).setLevel(level).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            Assertions.assertThat((Object)accessor.getObject("po*")).isEqualTo(Arrays.asList(parameters));
            List stringifiedParameters = Arrays.stream(parameters).map(String::valueOf).collect(Collectors.toList());
            Assertions.assertThat((Object)accessor.getObject("ps*")).isEqualTo(stringifiedParameters);
            Assertions.assertThat((Object)accessor.getObject("po2")).isEqualTo(parameters[2]);
            Assertions.assertThat((String)accessor.getString("ps2")).isEqualTo((String)stringifiedParameters.get(2));
            Assertions.assertThat((String)accessor.getString("ps3")).isNull();
        });
    }

    private static void testMessageParameterResolverNoParameters(MessageFactory messageFactory) {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("po*", TestHelpers.asMap("$resolver", "messageParameter"), "ps*", TestHelpers.asMap("$resolver", "messageParameter", "stringified", true)));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        Message message = messageFactory.newMessage("foo", new Object[0]);
        Level level = Level.FATAL;
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setMessage(message).setLevel(level).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            Assertions.assertThat((Object)accessor.getObject("po*")).isEqualTo(Collections.emptyList());
            Assertions.assertThat((Object)accessor.getObject("ps*")).isEqualTo(Collections.emptyList());
        });
    }

    @Test
    void test_unresolvable_nested_fields_are_skipped() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("exception", TestHelpers.asMap("message", TestHelpers.asMap("$resolver", "exception", "field", "message"), "className", TestHelpers.asMap("$resolver", "exception", "field", "className")), "exceptionRootCause", TestHelpers.asMap("message", TestHelpers.asMap("$resolver", "exceptionRootCause", "field", "message"), "className", TestHelpers.asMap("$resolver", "exceptionRootCause", "field", "className")), "source", TestHelpers.asMap("lineNumber", TestHelpers.asMap("$resolver", "source", "field", "lineNumber"), "fileName", TestHelpers.asMap("$resolver", "source", "field", "fileName")), "emptyMap", Collections.emptyMap(), "emptyList", Collections.emptyList(), "null", null));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).setStackTraceEnabled(false).setLocationInfoEnabled(false).build();
        SimpleMessage message = new SimpleMessage("foo");
        RuntimeException thrown = new RuntimeException("bar");
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setMessage((Message)message).setThrown((Throwable)thrown).build();
        String expectedSerializedLogEventJson = "{}" + JsonTemplateLayoutDefaults.getEventDelimiter();
        String actualSerializedLogEventJson = layout.toSerializable((LogEvent)logEvent);
        Assertions.assertThat((String)actualSerializedLogEventJson).isEqualTo(expectedSerializedLogEventJson);
    }

    @Test
    void test_recursive_collections() {
        Object[] recursiveCollection;
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("message", TestHelpers.asMap("$resolver", "message")));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        recursiveCollection[0] = recursiveCollection = new Object[1];
        ObjectMessage message = new ObjectMessage((Object)recursiveCollection);
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setMessage((Message)message).build();
        Assertions.assertThatThrownBy(() -> JsonTemplateLayoutTest.lambda$test_recursive_collections$29(layout, (LogEvent)logEvent)).isInstanceOf(StackOverflowError.class);
    }

    @Test
    void test_eventTemplateRootObjectKey() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("message", TestHelpers.asMap("$resolver", "message")));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).setEventTemplateRootObjectKey("event").build();
        SimpleMessage message = new SimpleMessage("LOG4J2-2985");
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName(LOGGER_NAME).setMessage((Message)message).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)accessor.getObject(new String[]{"event", "message"})).isEqualTo((Object)"LOG4J2-2985");
        });
    }

    private static /* synthetic */ void lambda$test_recursive_collections$29(JsonTemplateLayout layout, LogEvent logEvent) throws Throwable {
        layout.toSerializable(logEvent);
    }

    private static final class JsonAcceptingTcpServer
    extends Thread
    implements AutoCloseable {
        private final ServerSocket serverSocket;
        private final BlockingQueue<JsonNode> receivedNodes;
        private volatile int droppedNodeCount = 0;
        private volatile boolean closed = false;

        private JsonAcceptingTcpServer(int port, int capacity) throws IOException {
            this.serverSocket = new ServerSocket(port);
            this.receivedNodes = new ArrayBlockingQueue<JsonNode>(capacity);
            this.serverSocket.setReuseAddress(true);
            this.serverSocket.setSoTimeout(5000);
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try (Socket socket2 = this.serverSocket.accept();){
                InputStream inputStream = socket2.getInputStream();
                while (!this.closed) {
                    MappingIterator iterator = JacksonFixture.getObjectMapper().readerFor(JsonNode.class).readValues(inputStream);
                    while (iterator.hasNextValue()) {
                        JsonNode value = (JsonNode)iterator.nextValue();
                        JsonAcceptingTcpServer jsonAcceptingTcpServer = this;
                        synchronized (jsonAcceptingTcpServer) {
                            boolean added = this.receivedNodes.offer(value);
                            if (!added) {
                                ++this.droppedNodeCount;
                            }
                        }
                    }
                    continue;
                    return;
                }
            }
            catch (EOFException socket2) {
                return;
            }
            catch (Exception error) {
                if (this.closed) return;
                throw new RuntimeException(error);
            }
        }

        @Override
        public synchronized void close() {
            if (this.closed) {
                throw new IllegalStateException("shutdown has already been invoked");
            }
            this.closed = true;
            this.interrupt();
            try {
                this.join(3000L);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Plugin(name="CustomResolverFactory", category="JsonTemplateResolverFactory")
    public static final class CustomResolverFactory
    implements EventResolverFactory {
        private static final CustomResolverFactory INSTANCE = new CustomResolverFactory();

        private CustomResolverFactory() {
        }

        @PluginFactory
        public static CustomResolverFactory getInstance() {
            return INSTANCE;
        }

        public String getName() {
            return "custom";
        }

        public TemplateResolver<LogEvent> create(EventResolverContext context, TemplateResolverConfig config) {
            return new CustomResolver();
        }
    }

    private static final class CustomResolver
    implements EventResolver {
        private static final AtomicInteger COUNTER = new AtomicInteger(0);

        private CustomResolver() {
        }

        public void resolve(LogEvent value, JsonWriter jsonWriter) {
            jsonWriter.writeString((CharSequence)("CustomValue-" + COUNTER.getAndIncrement()));
        }
    }

    private static final class NonAsciiUtf8MethodNameContainingException
    extends RuntimeException {
        public static final long serialVersionUID = 0L;
        private static final String NON_ASCII_UTF8_TEXT = "\u0b85\u0b86\u0b87\u0e2c\u0e58";
        private static final NonAsciiUtf8MethodNameContainingException INSTANCE = NonAsciiUtf8MethodNameContainingException.createInstance();

        private static NonAsciiUtf8MethodNameContainingException createInstance() {
            try {
                NonAsciiUtf8MethodNameContainingException.throwException_\u0b85\u0b86\u0b87\u0e2c\u0e58();
                throw new IllegalStateException("should not have reached here");
            }
            catch (NonAsciiUtf8MethodNameContainingException exception) {
                return exception;
            }
        }

        private static void throwException_\u0b85\u0b86\u0b87\u0e2c\u0e58() {
            throw new NonAsciiUtf8MethodNameContainingException("exception with non-ASCII UTF-8 method name");
        }

        private NonAsciiUtf8MethodNameContainingException(String message) {
            super(message);
        }
    }
}

