/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json;

import co.elastic.logging.log4j2.EcsLayout;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpHost;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.SocketAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.GelfLayout;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayout;
import org.apache.logging.log4j.layout.template.json.LogEventFixture;
import org.apache.logging.log4j.layout.template.json.util.RecyclerFactory;
import org.apache.logging.log4j.layout.template.json.util.ThreadLocalRecyclerFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.status.StatusLogger;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
class LogstashIT {
    private static final StatusLogger LOGGER = StatusLogger.getLogger();
    private static final DefaultConfiguration CONFIGURATION = new DefaultConfiguration();
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final String HOST_NAME = NetUtils.getLocalHostname();
    private static final String SERVICE_NAME = "LogstashIT";
    private static final String EVENT_DATASET = "LogstashIT.log";
    private static final GelfLayout GELF_LAYOUT = ((GelfLayout.Builder)((GelfLayout.Builder)GelfLayout.newBuilder().setConfiguration((Configuration)CONFIGURATION)).setCharset(CHARSET)).setCompressionType(GelfLayout.CompressionType.OFF).setIncludeNullDelimiter(true).setHost(HOST_NAME).build();
    private static final JsonTemplateLayout JSON_TEMPLATE_GELF_LAYOUT = JsonTemplateLayout.newBuilder().setConfiguration((Configuration)CONFIGURATION).setCharset(CHARSET).setEventTemplateUri("classpath:GelfLayout.json").setEventDelimiter("\u0000").setEventTemplateAdditionalFields(new JsonTemplateLayout.EventTemplateAdditionalField[]{JsonTemplateLayout.EventTemplateAdditionalField.newBuilder().setKey("host").setValue(HOST_NAME).build()}).build();
    private static final EcsLayout ECS_LAYOUT = EcsLayout.newBuilder().setConfiguration((Configuration)CONFIGURATION).setServiceName("LogstashIT").setEventDataset("LogstashIT.log").build();
    private static final JsonTemplateLayout JSON_TEMPLATE_ECS_LAYOUT = JsonTemplateLayout.newBuilder().setConfiguration((Configuration)CONFIGURATION).setCharset(CHARSET).setEventTemplateUri("classpath:EcsLayout.json").setRecyclerFactory((RecyclerFactory)ThreadLocalRecyclerFactory.getInstance()).setEventTemplateAdditionalFields(new JsonTemplateLayout.EventTemplateAdditionalField[]{JsonTemplateLayout.EventTemplateAdditionalField.newBuilder().setKey("service.name").setValue("LogstashIT").build(), JsonTemplateLayout.EventTemplateAdditionalField.newBuilder().setKey("event.dataset").setValue("LogstashIT.log").build()}).build();
    private static final int LOG_EVENT_COUNT = 100;
    private static final String ES_INDEX_MESSAGE_FIELD_NAME = "message";

    LogstashIT() {
    }

    @Test
    void test_lite_events() throws IOException {
        List<LogEvent> logEvents = LogEventFixture.createLiteLogEvents(100);
        LogstashIT.testEvents(logEvents);
    }

    @Test
    void test_full_events() throws IOException {
        List<LogEvent> logEvents = LogEventFixture.createFullLogEvents(100);
        LogstashIT.testEvents(logEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testEvents(List<LogEvent> logEvents) throws IOException {
        try (RestHighLevelClient client = LogstashIT.createClient();){
            SocketAppender appender = LogstashIT.createStartedAppender(JSON_TEMPLATE_GELF_LAYOUT, 12222);
            try {
                LOGGER.info("appending events");
                logEvents.forEach(arg_0 -> ((Appender)appender).append(arg_0));
                LOGGER.info("completed appending events");
                Awaitility.await().atMost(Duration.ofSeconds(60L)).pollDelay(Duration.ofSeconds(2L)).until(() -> LogstashIT.queryDocumentCount(client) == 100L);
                Set expectedMessages = logEvents.stream().map(LogstashIT::expectedLogstashMessageField).collect(Collectors.toSet());
                Set actualMessages = LogstashIT.queryDocuments(client).stream().map(source -> (String)source.get(ES_INDEX_MESSAGE_FIELD_NAME)).filter(Objects::nonNull).collect(Collectors.toSet());
                Assertions.assertThat(actualMessages).isEqualTo(expectedMessages);
            }
            finally {
                appender.stop();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static String expectedLogstashMessageField(LogEvent logEvent) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void test_newlines() throws IOException {
        Level level = Level.DEBUG;
        String loggerFqcn = "f.q.c.n";
        String loggerName = "A";
        SimpleMessage message1 = new SimpleMessage("line1\nline2\r\nline3");
        long instantMillis1 = Instant.EPOCH.toEpochMilli();
        Log4jLogEvent logEvent1 = Log4jLogEvent.newBuilder().setLoggerName("A").setLoggerFqcn("f.q.c.n").setLevel(level).setMessage((Message)message1).setTimeMillis(instantMillis1).build();
        SimpleMessage message2 = new SimpleMessage("line4\nline5\r\nline6");
        long instantMillis2 = instantMillis1 + Duration.ofDays(1L).toMillis();
        Log4jLogEvent logEvent2 = Log4jLogEvent.newBuilder().setLoggerName("A").setLoggerFqcn("f.q.c.n").setLevel(level).setMessage((Message)message2).setTimeMillis(instantMillis2).build();
        try (RestHighLevelClient client = LogstashIT.createClient();){
            SocketAppender appender = LogstashIT.createStartedAppender(JSON_TEMPLATE_GELF_LAYOUT, 12222);
            try {
                LOGGER.info("appending events");
                appender.append((LogEvent)logEvent1);
                appender.append((LogEvent)logEvent2);
                LOGGER.info("completed appending events");
                Awaitility.await().atMost(Duration.ofSeconds(60L)).pollDelay(Duration.ofSeconds(2L)).until(() -> LogstashIT.queryDocumentCount(client) == 2L);
                Set expectedMessages = Stream.of(logEvent1, logEvent2).map(LogstashIT::expectedLogstashMessageField).collect(Collectors.toSet());
                Set actualMessages = LogstashIT.queryDocuments(client).stream().map(source -> (String)source.get(ES_INDEX_MESSAGE_FIELD_NAME)).filter(Objects::nonNull).collect(Collectors.toSet());
                Assertions.assertThat(actualMessages).isEqualTo(expectedMessages);
            }
            finally {
                appender.stop();
            }
        }
    }

    @Test
    void test_GelfLayout() throws IOException {
        List<LogEvent> logEvents = LogEventFixture.createFullLogEvents(100);
        Function<Map, Integer> keyMapper = source -> {
            String timestamp = (String)source.get("timestamp");
            String shortMessage = (String)source.get("short_message");
            String fullMessage = (String)source.get("full_message");
            return Objects.hash(timestamp, shortMessage, fullMessage);
        };
        Map<Integer, Object> expectedSourceByKey = LogstashIT.appendAndCollect(logEvents, GELF_LAYOUT, 12222, keyMapper, Collections.emptySet());
        Map<Integer, Object> actualSourceByKey = LogstashIT.appendAndCollect(logEvents, JSON_TEMPLATE_GELF_LAYOUT, 12222, keyMapper, Collections.emptySet());
        Assertions.assertThat(actualSourceByKey).isEqualTo(expectedSourceByKey);
    }

    @Test
    void test_EcsLayout() throws IOException {
        List<LogEvent> logEvents = LogEventFixture.createFullLogEvents(100);
        Function<Map, Integer> keyMapper = source -> {
            String timestamp = (String)source.get("@timestamp");
            String message = (String)source.get(ES_INDEX_MESSAGE_FIELD_NAME);
            String errorMessage = (String)source.get("error.message");
            return Objects.hash(timestamp, message, errorMessage);
        };
        Set<String> excludedKeys = Collections.singleton("port");
        Map<Integer, Object> expectedSourceByKey = LogstashIT.appendAndCollect(logEvents, ECS_LAYOUT, 12345, keyMapper, excludedKeys);
        Map<Integer, Object> actualSourceByKey = LogstashIT.appendAndCollect(logEvents, JSON_TEMPLATE_ECS_LAYOUT, 12345, keyMapper, excludedKeys);
        Assertions.assertThat(actualSourceByKey).isEqualTo(expectedSourceByKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K> Map<K, Object> appendAndCollect(List<LogEvent> logEvents, Layout<?> layout, int port, Function<Map<String, Object>, K> keyMapper, Set<String> excludedKeys) throws IOException {
        Throwable throwable = null;
        try (RestHighLevelClient client = LogstashIT.createClient();){
            Map<K, Object> map;
            SocketAppender appender = LogstashIT.createStartedAppender(layout, port);
            try {
                LOGGER.info("appending events");
                logEvents.forEach(arg_0 -> ((Appender)appender).append(arg_0));
                LOGGER.info("completed appending events");
                Awaitility.await().atMost(Duration.ofSeconds(60L)).pollDelay(Duration.ofSeconds(2L)).until(() -> LogstashIT.queryDocumentCount(client) == 100L);
                map = LogstashIT.queryDocuments(client).stream().collect(Collectors.toMap(keyMapper, source -> {
                    excludedKeys.forEach(source::remove);
                    return source;
                }));
            }
            catch (Throwable throwable2) {
                try {
                    appender.stop();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            appender.stop();
            return map;
        }
    }

    private static RestHighLevelClient createClient() throws IOException {
        LOGGER.info("instantiating the ES client");
        HttpHost httpHost = new HttpHost(HOST_NAME, 9200);
        RestClientBuilder clientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{httpHost});
        RestHighLevelClient client = new RestHighLevelClient(clientBuilder);
        LOGGER.info("verifying the ES connection");
        ClusterHealthResponse healthResponse = client.cluster().health(new ClusterHealthRequest(), RequestOptions.DEFAULT);
        Assertions.assertThat((Comparable)healthResponse.getStatus()).isNotEqualTo((Object)ClusterHealthStatus.RED);
        LOGGER.info("deleting the ES index");
        DeleteIndexRequest deleteRequest = new DeleteIndexRequest("log4j");
        try {
            AcknowledgedResponse deleteResponse = client.indices().delete(deleteRequest, RequestOptions.DEFAULT);
            Assertions.assertThat((boolean)deleteResponse.isAcknowledged()).isTrue();
        }
        catch (ElasticsearchStatusException error) {
            Assertions.assertThat((Throwable)error).satisfies(ignored -> {
                AbstractComparableAssert cfr_ignored_0 = (AbstractComparableAssert)Assertions.assertThat((Comparable)error.status()).isEqualTo((Object)RestStatus.NOT_FOUND);
            });
        }
        return client;
    }

    private static SocketAppender createStartedAppender(Layout<?> layout, int port) {
        LOGGER.info("creating the appender");
        SocketAppender appender = ((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)SocketAppender.newBuilder().setConfiguration((Configuration)CONFIGURATION)).withHost(HOST_NAME)).withPort(port)).withReconnectDelayMillis(100)).setName("LogstashItAppender")).withBufferedIo(false)).withImmediateFail(true)).setIgnoreExceptions(false)).setLayout(layout)).build();
        appender.start();
        return appender;
    }

    private static long queryDocumentCount(RestHighLevelClient client) throws IOException {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).fetchSource(false);
        SearchRequest searchRequest = new SearchRequest(new String[]{"log4j"}).source(searchSourceBuilder);
        try {
            SearchResponse searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
            return searchResponse.getHits().getTotalHits().value;
        }
        catch (ElasticsearchStatusException error) {
            if (RestStatus.NOT_FOUND.equals((Object)error.status())) {
                return 0L;
            }
            throw new IOException(error);
        }
    }

    private static List<Map<String, Object>> queryDocuments(RestHighLevelClient client) throws IOException {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(100).fetchSource(true);
        SearchRequest searchRequest = new SearchRequest(new String[]{"log4j"}).source(searchSourceBuilder);
        try {
            SearchResponse searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
            return Arrays.stream(searchResponse.getHits().getHits()).map(SearchHit::getSourceAsMap).collect(Collectors.toList());
        }
        catch (ElasticsearchStatusException error) {
            if (RestStatus.NOT_FOUND.equals((Object)error.status())) {
                return Collections.emptyList();
            }
            throw new IOException(error);
        }
    }

    private static final class MavenHardcodedConstants {
        private static final int LS_GELF_INPUT_PORT = 12222;
        private static final int LS_TCP_INPUT_PORT = 12345;
        private static final int ES_PORT = 9200;
        private static final String ES_INDEX_NAME = "log4j";

        private MavenHardcodedConstants() {
        }
    }
}

