/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayout;
import org.apache.logging.log4j.layout.template.json.TestHelpers;
import org.apache.logging.log4j.layout.template.json.util.JsonReader;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.message.StringMapMessage;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MessageResolverTest {
    MessageResolverTest() {
    }

    @Test
    @LoggerContextSource(value="messageFallbackKeyUsingJsonTemplateLayout.xml")
    void log4j1_logger_calls_should_use_fallbackKey(@Named(value="List") ListAppender appender) {
        String log4j1Message = "Message logged using org.apache.log4j.Category.info(Object)";
        org.apache.log4j.LogManager.getLogger(MessageResolverTest.class).info((Object)"Message logged using org.apache.log4j.Category.info(Object)");
        String log4j2Message = "Message logged using org.apache.logging.log4j.Logger.info(String)";
        LogManager.getLogger(MessageResolverTest.class).info("Message logged using org.apache.logging.log4j.Logger.info(String)");
        List actualLoggedEvents = appender.getData().stream().map(jsonBytes -> {
            String json = new String((byte[])jsonBytes, StandardCharsets.UTF_8);
            return JsonReader.read((String)json);
        }).collect(Collectors.toList());
        List expectedLoggedEvents = Stream.of("Message logged using org.apache.log4j.Category.info(Object)", "Message logged using org.apache.logging.log4j.Logger.info(String)").map(message -> Collections.singletonMap("message", Collections.singletonMap("fallback", message))).collect(Collectors.toList());
        Assertions.assertThat(actualLoggedEvents).isEqualTo(expectedLoggedEvents);
    }

    @Test
    void test_message_fallbackKey() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("message", TestHelpers.asMap("$resolver", "message", "fallbackKey", "formattedMessage")));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        MapMessage mapMessage = new StringMapMessage().with("key1", "val1");
        Log4jLogEvent mapMessageLogEvent = Log4jLogEvent.newBuilder().setMessage((Message)mapMessage).setTimeMillis(System.currentTimeMillis()).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)mapMessageLogEvent, accessor -> Assertions.assertThat((String)accessor.getString(new String[]{"message", "key1"})).isEqualTo("val1"));
        SimpleMessage simpleMessage = new SimpleMessage("simple");
        Log4jLogEvent simpleMessageLogEvent = Log4jLogEvent.newBuilder().setMessage((Message)simpleMessage).setTimeMillis(System.currentTimeMillis()).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)simpleMessageLogEvent, accessor -> Assertions.assertThat((String)accessor.getString(new String[]{"message", "formattedMessage"})).isEqualTo("simple"));
    }

    @Test
    void test_StringMapMessage() {
        StringMapMessage message = new StringMapMessage();
        message.put("message", "Hello, World!");
        message.put("bottle", "Kickapoo Joy Juice");
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setMessage((Message)message).build();
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("message", TestHelpers.asMap("$resolver", "message")));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setStackTraceEnabled(true).setEventTemplate(eventTemplate).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            Assertions.assertThat((String)accessor.getString(new String[]{"message", "message"})).isEqualTo("Hello, World!");
            Assertions.assertThat((String)accessor.getString(new String[]{"message", "bottle"})).isEqualTo("Kickapoo Joy Juice");
        });
    }

    @Test
    void test_ObjectMessage() {
        int id = -559038737;
        String name = "name--559038737";
        LinkedHashMap<String, Object> attachment = new LinkedHashMap<String, Object>(){
            {
                this.put("id", -559038737);
                this.put("name", "name--559038737");
            }
        };
        ObjectMessage message = new ObjectMessage((Object)attachment);
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setMessage((Message)message).build();
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("message", TestHelpers.asMap("$resolver", "message")));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setStackTraceEnabled(true).setEventTemplate(eventTemplate).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            Assertions.assertThat((Integer)accessor.getInteger(new String[]{"message", "id"})).isEqualTo(-559038737);
            Assertions.assertThat((String)accessor.getString(new String[]{"message", "name"})).isEqualTo("name--559038737");
        });
    }

    @Test
    void test_MapMessage_serialization() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("message", TestHelpers.asMap("$resolver", "message")));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        StringMapMessage mapMessage = (StringMapMessage)((StringMapMessage)((StringMapMessage)new StringMapMessage().with("key1", "val1")).with("key2", -559038737)).with("key3", Collections.singletonMap("key3.1", "val3.1"));
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setMessage((Message)mapMessage).setTimeMillis(System.currentTimeMillis()).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            Assertions.assertThat((String)accessor.getString(new String[]{"message", "key1"})).isEqualTo("val1");
            Assertions.assertThat((Integer)accessor.getInteger(new String[]{"message", "key2"})).isEqualTo(-559038737);
            Assertions.assertThat((String)accessor.getString(new String[]{"message", "key3", "key3.1"})).isEqualTo("val3.1");
        });
    }
}

