/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.logging.log4j.layout.template.json.util.JsonReader;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class JsonReaderTest {
    JsonReaderTest() {
    }

    @Test
    void test_null() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read(null)).isInstanceOf(NullPointerException.class)).hasMessage("json");
    }

    @Test
    void test_valid_null() {
        this.test("null", null);
        this.test("[null, null]", Arrays.asList(null, null));
    }

    @Test
    void test_invalid_null() {
        for (String json : new String[]{"nuL", "nulL", "nul1"}) {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)json)).as("json=%s", new Object[]{json})).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("was expecting keyword 'null' at index");
        }
    }

    @Test
    void test_valid_boolean() {
        this.test("true", true);
        this.test("false", false);
        this.test("[true, false]", Arrays.asList(true, false));
    }

    @Test
    void test_invalid_boolean() {
        for (String json : new String[]{"tru", "truE", "fals", "falsE"}) {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)json)).as("json=%s", new Object[]{json})).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("^was expecting keyword '(true|false)' at index [0-9]+: .*$");
        }
    }

    @Test
    void test_valid_string() {
        this.test("\"\"", "");
        this.test("\" \"", " ");
        this.test("\" a\"", " a");
        this.test("\"a \"", "a ");
        this.test("\"abc\"", "abc");
        this.test("\"abc\\\"\"", "abc\"");
        this.test("\"\\b\\f\\n\\r\\t\"", "\b\f\n\r\t");
    }

    @Test
    void test_invalid_string_start() {
        String json = "abc\"";
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)"abc\"")).as("json=%s", new Object[]{"abc\""})).isInstanceOf(IllegalArgumentException.class)).hasMessage("invalid character at index 0: a");
    }

    @Test
    void test_invalid_string_end() {
        for (String json : new String[]{"", " ", "\r", "\t", "\"abc"}) {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)json)).as("json=%s", new Object[]{json})).isInstanceOf(IllegalArgumentException.class)).hasMessage("premature end of input");
        }
    }

    @Test
    void test_invalid_string_escape() {
        for (String json : new String[]{"\"\\k\"", "\"\\d\""}) {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)json)).as("json=%s", new Object[]{json})).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("was expecting an escape character at index 2: ");
        }
    }

    @Test
    void test_invalid_string_concat() {
        String json = "\"foo\"\"bar\"";
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)"\"foo\"\"bar\"")).as("json=%s", new Object[]{"\"foo\"\"bar\""})).isInstanceOf(IllegalArgumentException.class)).hasMessage("was not expecting input at index 5: \"");
    }

    @Test
    void test_valid_unicode_string() {
        String json = "\"a\\u00eF4bc\"";
        ((ObjectAssert)Assertions.assertThat((Object)JsonReader.read((String)"\"a\\u00eF4bc\"")).as("json=%s", new Object[]{"\"a\\u00eF4bc\""})).isEqualTo((Object)"a\u00ef4bc");
    }

    @Test
    void test_invalid_unicode() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)"\"\\u000x\"")).isInstanceOf(IllegalArgumentException.class)).hasMessage("was expecting a unicode character at index 6: x");
    }

    @Test
    void test_valid_integers() {
        for (String integer : new String[]{"0", "1", "92233720368547758079223372036854775807"}) {
            for (String signedInteger : new String[]{integer, '-' + integer}) {
                Number expectedToken = signedInteger.length() < 3 ? Integer.valueOf(Integer.parseInt(signedInteger)) : new BigInteger(signedInteger);
                this.test(signedInteger, expectedToken);
            }
        }
    }

    @Test
    void test_invalid_integers() {
        for (String integer : new String[]{"0-", "1a"}) {
            for (String signedInteger : new String[]{integer, '-' + integer}) {
                ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)signedInteger)).as("signedInteger=%s", new Object[]{signedInteger})).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("was not expecting input at index");
            }
        }
    }

    @Test
    void test_valid_decimals() {
        for (String decimal : new String[]{"0.0", "1.0", "1.2", "1e2", "1e-2", "1.2e3", "1.2e-3"}) {
            for (String signedDecimal : new String[]{decimal, '-' + decimal}) {
                this.test(signedDecimal, new BigDecimal(signedDecimal));
            }
        }
    }

    @Test
    void test_invalid_decimals() {
        for (String decimal : new String[]{"0.", ".1", "1e", "1e-", "1.2e", "1.2e-"}) {
            for (String signedDecimal : new String[]{decimal, '-' + decimal}) {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)signedDecimal)).as("signedDecimal=%s", new Object[]{signedDecimal})).isInstanceOf(IllegalArgumentException.class);
            }
        }
    }

    @Test
    void test_valid_arrays() {
        for (String json : new String[]{"[]", "[ ]"}) {
            this.test(json, Collections.emptyList());
        }
        for (String json : new String[]{"[1]", "[ 1]", "[1 ]", "[ 1 ]"}) {
            this.test(json, Collections.singletonList(1));
        }
        for (String json : new String[]{"[1,2]", "[1, 2]", "[ 1, 2]", "[1 , 2]", "[ 1 , 2 ]"}) {
            this.test(json, Arrays.asList(1, 2));
        }
    }

    @Test
    void test_invalid_array_start() {
        String json = "[";
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)"[")).as("json=%s", new Object[]{"["})).isInstanceOf(IllegalArgumentException.class)).hasMessage("premature end of input");
    }

    @Test
    void test_invalid_array_end_1() {
        String json = "]";
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)"]")).as("json=%s", new Object[]{"]"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("was not expecting ARRAY_END at index 0");
    }

    @Test
    void test_invalid_array_comma() {
        String json = "[,";
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)"[,")).as("json=%s", new Object[]{"[,"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("was expecting an array element at index 1: COMMA");
    }

    @Test
    void test_invalid_array_end_2() {
        String json = "[1,";
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)"[1,")).as("json=%s", new Object[]{"[1,"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("premature end of input");
    }

    @Test
    void test_invalid_array_end_3() {
        String json = "[1,]";
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)"[1,]")).as("json=%s", new Object[]{"[1,]"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("was expecting an array element at index 3: ARRAY_END");
    }

    @Test
    void test_valid_objects() {
        this.test("{}", Collections.emptyMap());
        this.test("{\"foo\":\"bar\"}", Collections.singletonMap("foo", "bar"));
    }

    @Test
    void test_invalid_object_start() {
        String json = "{";
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)"{")).as("json=%s", new Object[]{"{"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("premature end of input");
    }

    @Test
    void test_invalid_object_end() {
        String json = "}";
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)"}")).as("json=%s", new Object[]{"}"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("was not expecting OBJECT_END at index 0");
    }

    @Test
    void test_invalid_object_colon_1() {
        String json = "{\"foo\"\"bar\"}";
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)"{\"foo\"\"bar\"}")).as("json=%s", new Object[]{"{\"foo\"\"bar\"}"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("was expecting COLON at index 6: bar");
    }

    @Test
    void test_invalid_object_colon_2() {
        String json = "{\"foo\":}";
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)"{\"foo\":}")).as("json=%s", new Object[]{"{\"foo\":}"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("premature end of input");
    }

    @Test
    void test_invalid_object_token() {
        String json = "{\"foo\":\"bar}";
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)"{\"foo\":\"bar}")).as("json=%s", new Object[]{"{\"foo\":\"bar}"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("premature end of input");
    }

    @Test
    void test_invalid_object_comma() {
        String json = "{\"foo\":\"bar\",}";
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)"{\"foo\":\"bar\",}")).as("json=%s", new Object[]{"{\"foo\":\"bar\",}"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("was expecting an object key at index 13: OBJECT_END");
    }

    @Test
    void test_invalid_object_key() {
        String json = "{\"foo\":\"bar\",]}";
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonReader.read((String)"{\"foo\":\"bar\",]}")).as("json=%s", new Object[]{"{\"foo\":\"bar\",]}"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("was expecting an object key at index 13: ARRAY_END");
    }

    @Test
    public void test_nesting() {
        this.test("{\"k1\": [true, null, 1e5, {\"k2\": \"v2\", \"k3\": {\"k4\": \"v4\"}}]}", Collections.singletonMap("k1", Arrays.asList(true, null, new BigDecimal("1e5"), new LinkedHashMap<String, Object>(){
            {
                this.put("k2", "v2");
                this.put("k3", Collections.singletonMap("k4", "v4"));
            }
        })));
    }

    private void test(String json, Object expected) {
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)JsonReader.read((String)json)).isEqualTo(expected);
        }).as("json=%s", new Object[]{json})).doesNotThrowAnyException();
    }
}

