/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.util;

import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverter;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverterRegistry;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayout;
import org.apache.logging.log4j.layout.template.json.util.DummyRecyclerFactory;
import org.apache.logging.log4j.layout.template.json.util.QueueingRecycler;
import org.apache.logging.log4j.layout.template.json.util.QueueingRecyclerFactory;
import org.apache.logging.log4j.layout.template.json.util.Recycler;
import org.apache.logging.log4j.layout.template.json.util.RecyclerFactory;
import org.apache.logging.log4j.layout.template.json.util.ThreadLocalRecyclerFactory;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.assertj.core.api.Assertions;
import org.jctools.queues.MpmcArrayQueue;
import org.junit.jupiter.api.Test;

class RecyclerFactoriesTest {
    RecyclerFactoriesTest() {
    }

    @Test
    void test_RecyclerFactoryConverter() throws Exception {
        TypeConverter converter = TypeConverterRegistry.getInstance().findCompatibleConverter(RecyclerFactory.class);
        Assertions.assertThat((Object)converter).isNotNull();
        Object actualDummyRecyclerFactory = converter.convert("dummy");
        Assertions.assertThat((Object)actualDummyRecyclerFactory).isSameAs((Object)DummyRecyclerFactory.getInstance());
        Object actualThreadLocalRecyclerFactory = converter.convert("threadLocal");
        Assertions.assertThat((Object)actualThreadLocalRecyclerFactory).isSameAs((Object)ThreadLocalRecyclerFactory.getInstance());
        Object actualQueueingRecyclerFactory = converter.convert("queue");
        Assertions.assertThat((Object)actualQueueingRecyclerFactory).isInstanceOf(QueueingRecyclerFactory.class);
        Object recyclerFactory = converter.convert("queue:supplier=java.util.ArrayDeque.new");
        Assertions.assertThat((Object)recyclerFactory).isInstanceOf(QueueingRecyclerFactory.class);
        QueueingRecyclerFactory queueingRecyclerFactory = (QueueingRecyclerFactory)recyclerFactory;
        Recycler recycler = queueingRecyclerFactory.create(Object::new);
        Assertions.assertThat((Object)recycler).isInstanceOf(QueueingRecycler.class);
        QueueingRecycler queueingRecycler = (QueueingRecycler)recycler;
        Assertions.assertThat((Iterable)queueingRecycler.getQueue()).isInstanceOf(ArrayDeque.class);
        actualQueueingRecyclerFactory = converter.convert("queue:capacity=100");
        Assertions.assertThat((Object)actualQueueingRecyclerFactory).isInstanceOf(QueueingRecyclerFactory.class);
        recyclerFactory = converter.convert("queue:supplier=java.util.concurrent.ArrayBlockingQueue.new,capacity=100");
        Assertions.assertThat((Object)recyclerFactory).isInstanceOf(QueueingRecyclerFactory.class);
        queueingRecyclerFactory = (QueueingRecyclerFactory)recyclerFactory;
        recycler = queueingRecyclerFactory.create(Object::new);
        Assertions.assertThat((Object)recycler).isInstanceOf(QueueingRecycler.class);
        queueingRecycler = (QueueingRecycler)recycler;
        Assertions.assertThat((Iterable)queueingRecycler.getQueue()).isInstanceOf(ArrayBlockingQueue.class);
        ArrayBlockingQueue queue = (ArrayBlockingQueue)queueingRecycler.getQueue();
        Assertions.assertThat((int)queue.remainingCapacity()).isEqualTo(100);
    }

    @Test
    @LoggerContextSource(value="recyclerFactoryCustomizedJsonTemplateLayoutLogging.xml")
    void test_RecyclerFactoryConverter_using_XML_config(@Named(value="List") ListAppender appender) throws Exception {
        JsonTemplateLayout layout = (JsonTemplateLayout)appender.getLayout();
        Field field = JsonTemplateLayout.class.getDeclaredField("contextRecycler");
        field.setAccessible(true);
        QueueingRecycler contextRecycler = (QueueingRecycler)field.get(layout);
        MpmcArrayQueue queue = (MpmcArrayQueue)contextRecycler.getQueue();
        Assertions.assertThat((int)queue.capacity()).isEqualTo(512);
    }
}

