/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.layout.JsonLayout;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayout;
import org.apache.logging.log4j.layout.template.json.LogEventFixture;
import org.apache.logging.log4j.layout.template.json.TestHelpers;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class JsonLayoutTest {
    private static final Configuration CONFIGURATION = new DefaultConfiguration();
    private static final JsonTemplateLayout JSON_TEMPLATE_LAYOUT = JsonTemplateLayout.newBuilder().setConfiguration(CONFIGURATION).setEventTemplateUri("classpath:JsonLayout.json").build();
    private static final JsonLayout JSON_LAYOUT = ((JsonLayout.Builder)JsonLayout.newBuilder().setConfiguration(CONFIGURATION)).build();

    JsonLayoutTest() {
    }

    @Test
    void test_lite_log_events() {
        List<LogEvent> logEvents = LogEventFixture.createLiteLogEvents(1000);
        JsonLayoutTest.test(logEvents);
    }

    @Test
    void test_full_log_events() {
        List<LogEvent> logEvents = LogEventFixture.createFullLogEvents(1000);
        JsonLayoutTest.test(logEvents);
    }

    private static void test(Collection<LogEvent> logEvents) {
        for (LogEvent logEvent : logEvents) {
            JsonLayoutTest.test(logEvent);
        }
    }

    private static void test(LogEvent logEvent) {
        Map<String, Object> jsonTemplateLayoutMap = JsonLayoutTest.renderUsingJsonTemplateLayout(logEvent);
        Map<String, Object> jsonLayoutMap = JsonLayoutTest.renderUsingJsonLayout(logEvent);
        jsonTemplateLayoutMap.remove("thrown");
        jsonLayoutMap.remove("thrown");
        Assertions.assertThat(jsonTemplateLayoutMap).isEqualTo(jsonLayoutMap);
    }

    private static Map<String, Object> renderUsingJsonTemplateLayout(LogEvent logEvent) {
        return TestHelpers.serializeUsingLayout(logEvent, (Layout<String>)JSON_TEMPLATE_LAYOUT);
    }

    private static Map<String, Object> renderUsingJsonLayout(LogEvent logEvent) {
        return TestHelpers.serializeUsingLayout(logEvent, (Layout<String>)JSON_LAYOUT);
    }
}

