/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayoutDefaults;
import org.apache.logging.log4j.layout.template.json.util.JsonReader;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
class JsonTemplateLayoutAdditionalFieldTest {
    JsonTemplateLayoutAdditionalFieldTest() {
    }

    @Test
    @LoggerContextSource(value="additionalFieldEnrichedJsonTemplateLayoutLogging.json")
    void test_JSON_config_additional_fields(LoggerContext loggerContext, @Named(value="List") ListAppender appender) {
        JsonTemplateLayoutAdditionalFieldTest.assertAdditionalFields(loggerContext, appender);
    }

    @Test
    @LoggerContextSource(value="additionalFieldEnrichedJsonTemplateLayoutLogging.properties")
    void test_Properties_config_additional_fields(LoggerContext loggerContext, @Named(value="List") ListAppender appender) {
        JsonTemplateLayoutAdditionalFieldTest.assertAdditionalFields(loggerContext, appender);
    }

    @Test
    @LoggerContextSource(value="additionalFieldEnrichedJsonTemplateLayoutLogging.xml")
    void test_XML_config_additional_fields(LoggerContext loggerContext, @Named(value="List") ListAppender appender) {
        JsonTemplateLayoutAdditionalFieldTest.assertAdditionalFields(loggerContext, appender);
    }

    @Test
    @LoggerContextSource(value="additionalFieldEnrichedJsonTemplateLayoutLogging.yaml")
    void test_YAML_config_additional_fields(LoggerContext loggerContext, @Named(value="List") ListAppender appender) {
        JsonTemplateLayoutAdditionalFieldTest.assertAdditionalFields(loggerContext, appender);
    }

    private static void assertAdditionalFields(LoggerContext loggerContext, ListAppender appender) {
        ExtendedLogger logger = loggerContext.getLogger(JsonTemplateLayoutAdditionalFieldTest.class);
        logger.info("trigger");
        List serializedEvents = appender.getData();
        Assertions.assertThat((List)serializedEvents).hasSize(1);
        byte[] serializedEvent = (byte[])serializedEvents.get(0);
        String serializedEventJson = new String(serializedEvent, JsonTemplateLayoutDefaults.getCharset());
        Object serializedEventObject = JsonReader.read((String)serializedEventJson);
        Assertions.assertThat((Object)serializedEventObject).isInstanceOf(Map.class);
        Map serializedEventMap = (Map)serializedEventObject;
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)serializedEventMap).containsEntry((Object)"stringField", (Object)"string")).containsEntry((Object)"numberField", (Object)1)).containsEntry((Object)"objectField", Collections.singletonMap("numberField", 1))).containsEntry((Object)"listField", Arrays.asList(1, "two"));
    }
}

