/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.layout.template.json.util.JsonReader;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;
import org.apache.logging.log4j.layout.template.json.util.MapAccessor;
import org.apache.logging.log4j.test.appender.ListAppender;

public final class TestHelpers {
    public static final Configuration CONFIGURATION = new DefaultConfiguration();
    private static final JsonWriter JSON_WRITER = JsonWriter.newBuilder().setMaxStringLength(10000).setTruncatedStringSuffix("\u2026").build();

    private TestHelpers() {
    }

    static Map<String, Object> serializeUsingLayout(LogEvent logEvent, Layout<String> layout) {
        String json = (String)((Object)layout.toSerializable(logEvent));
        return (Map)JsonReader.read((String)json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeJson(Object value) {
        JsonWriter jsonWriter = JSON_WRITER;
        synchronized (jsonWriter) {
            String string;
            StringBuilder stringBuilder = JSON_WRITER.getStringBuilder();
            stringBuilder.setLength(0);
            try {
                JSON_WRITER.writeValue(value);
                string = stringBuilder.toString();
                stringBuilder.setLength(0);
            }
            catch (Throwable throwable) {
                stringBuilder.setLength(0);
                throw throwable;
            }
            return string;
        }
    }

    public static void usingSerializedLogEventAccessor(Layout<String> layout, LogEvent logEvent, Consumer<MapAccessor> accessorConsumer) {
        String serializedLogEventJson = (String)((Object)layout.toSerializable(logEvent));
        Map deserializedLogEvent = (Map)TestHelpers.readJson(serializedLogEventJson);
        MapAccessor serializedLogEventAccessor = new MapAccessor(deserializedLogEvent);
        accessorConsumer.accept(serializedLogEventAccessor);
    }

    public static Object readJson(String json) {
        return JsonReader.read((String)json);
    }

    public static Map<String, Object> asMap(Object ... pairs) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException("odd number of arguments: " + pairs.length);
        }
        for (int i = 0; i < pairs.length; i += 2) {
            String key = (String)pairs[i];
            Object value = pairs[i + 1];
            map.put(key, value);
        }
        return map;
    }

    public static void withContextFromTemplate(String configName, Object eventTemplate, BiConsumer<LoggerContext, ListAppender> consumer) {
        ConfigurationBuilder configBuilder = ConfigurationBuilderFactory.newConfigurationBuilder().setStatusLevel(Level.ERROR).setConfigurationName(configName);
        String eventTemplateJson = TestHelpers.writeJson(eventTemplate);
        String appenderName = "List";
        Configuration config = configBuilder.add(((AppenderComponentBuilder)configBuilder.newAppender("List", "List").addAttribute("raw", true)).add((LayoutComponentBuilder)configBuilder.newLayout("JsonTemplateLayout").addAttribute("eventTemplate", eventTemplateJson))).add((RootLoggerComponentBuilder)configBuilder.newRootLogger(Level.ALL).add(configBuilder.newAppenderRef("List"))).build(false);
        try (LoggerContext loggerContext = Configurator.initialize((Configuration)config);){
            ListAppender appender = (ListAppender)loggerContext.getConfiguration().getAppender("List");
            consumer.accept(loggerContext, appender);
        }
    }

    public static void uncheckedSleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("interrupted");
        }
    }
}

