/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.layout.template.json.TestHelpers;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

class TimestampResolverTest {
    TimestampResolverTest() {
    }

    @Test
    void epoch_nanos_should_not_overlap() {
        Map<String, Object> eventTemplate = TestHelpers.asMap("$resolver", "timestamp", "epoch", TestHelpers.asMap("unit", "nanos"));
        TestHelpers.withContextFromTemplate("TimestampResolverTest", eventTemplate, (loggerContext, appender) -> {
            ExtendedLogger logger = loggerContext.getLogger(TimestampResolverTest.class);
            int logEventCount = 5;
            for (int logEventIndex = 0; logEventIndex < 5; ++logEventIndex) {
                if (logEventIndex > 0) {
                    TestHelpers.uncheckedSleep(1L);
                }
                logger.info("message #{}", (Object)logEventIndex);
            }
            List logEvents = appender.getData().stream().map(jsonBytes -> {
                String json = new String((byte[])jsonBytes, StandardCharsets.UTF_8);
                return (long)((Long)TestHelpers.readJson(json));
            }).collect(Collectors.toList());
            ((ListAssert)Assertions.assertThat(logEvents).hasSize(5)).doesNotHaveDuplicates();
        });
    }
}

