/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.logging.log4j.layout.template.json.util.StringParameterParser;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;

class StringParameterParserTest {
    StringParameterParserTest() {
    }

    @Test
    void test_empty_string() {
        StringParameterParserTest.testSuccess("", Collections.emptyMap());
    }

    @Test
    void test_blank_string() {
        StringParameterParserTest.testSuccess("\t", Collections.emptyMap());
    }

    @Test
    void test_simple_pair() {
        StringParameterParserTest.testSuccess("a=b", Collections.singletonMap("a", StringParameterParser.Values.stringValue((String)"b")));
    }

    @Test
    void test_simple_pair_with_whitespace_1() {
        StringParameterParserTest.testSuccess(" a=b", Collections.singletonMap("a", StringParameterParser.Values.stringValue((String)"b")));
    }

    @Test
    void test_simple_pair_with_whitespace_2() {
        StringParameterParserTest.testSuccess(" a =b", Collections.singletonMap("a", StringParameterParser.Values.stringValue((String)"b")));
    }

    @Test
    void test_simple_pair_with_whitespace_3() {
        StringParameterParserTest.testSuccess(" a = b", Collections.singletonMap("a", StringParameterParser.Values.stringValue((String)"b")));
    }

    @Test
    void test_simple_pair_with_whitespace_4() {
        StringParameterParserTest.testSuccess(" a = b ", Collections.singletonMap("a", StringParameterParser.Values.stringValue((String)"b")));
    }

    @Test
    void test_null_value_1() {
        StringParameterParserTest.testSuccess("a", Collections.singletonMap("a", StringParameterParser.Values.nullValue()));
    }

    @Test
    void test_null_value_2() {
        StringParameterParserTest.testSuccess("a,b=c,d=", (Map<String, StringParameterParser.Value>)new LinkedHashMap<String, StringParameterParser.Value>(){
            {
                this.put("a", StringParameterParser.Values.nullValue());
                this.put("b", StringParameterParser.Values.stringValue((String)"c"));
                this.put("d", StringParameterParser.Values.nullValue());
            }
        });
    }

    @Test
    void test_null_value_3() {
        StringParameterParserTest.testSuccess("a,b=c,d", (Map<String, StringParameterParser.Value>)new LinkedHashMap<String, StringParameterParser.Value>(){
            {
                this.put("a", StringParameterParser.Values.nullValue());
                this.put("b", StringParameterParser.Values.stringValue((String)"c"));
                this.put("d", StringParameterParser.Values.nullValue());
            }
        });
    }

    @Test
    void test_null_value_4() {
        StringParameterParserTest.testSuccess("a,b=\"c,=\\\"\",d=,e=f", (Map<String, StringParameterParser.Value>)new LinkedHashMap<String, StringParameterParser.Value>(){
            {
                this.put("a", StringParameterParser.Values.nullValue());
                this.put("b", StringParameterParser.Values.doubleQuotedStringValue((String)"c,=\""));
                this.put("d", StringParameterParser.Values.nullValue());
                this.put("e", StringParameterParser.Values.stringValue((String)"f"));
            }
        });
    }

    @Test
    void test_two_pairs() {
        StringParameterParserTest.testSuccess("a=b,c=d", (Map<String, StringParameterParser.Value>)new LinkedHashMap<String, StringParameterParser.Value>(){
            {
                this.put("a", StringParameterParser.Values.stringValue((String)"b"));
                this.put("c", StringParameterParser.Values.stringValue((String)"d"));
            }
        });
    }

    @Test
    void test_quoted_string_01() {
        StringParameterParserTest.testSuccess("a=\"b\"", Collections.singletonMap("a", StringParameterParser.Values.doubleQuotedStringValue((String)"b")));
    }

    @Test
    void test_quoted_string_02() {
        StringParameterParserTest.testSuccess("a=\"b\",c=d", (Map<String, StringParameterParser.Value>)new LinkedHashMap<String, StringParameterParser.Value>(){
            {
                this.put("a", StringParameterParser.Values.doubleQuotedStringValue((String)"b"));
                this.put("c", StringParameterParser.Values.stringValue((String)"d"));
            }
        });
    }

    @Test
    void test_quoted_string_03() {
        StringParameterParserTest.testSuccess("a=b,c=\"d\"", (Map<String, StringParameterParser.Value>)new LinkedHashMap<String, StringParameterParser.Value>(){
            {
                this.put("a", StringParameterParser.Values.stringValue((String)"b"));
                this.put("c", StringParameterParser.Values.doubleQuotedStringValue((String)"d"));
            }
        });
    }

    @Test
    void test_quoted_string_04() {
        StringParameterParserTest.testSuccess("a=\"b\",c=\"d\"", (Map<String, StringParameterParser.Value>)new LinkedHashMap<String, StringParameterParser.Value>(){
            {
                this.put("a", StringParameterParser.Values.doubleQuotedStringValue((String)"b"));
                this.put("c", StringParameterParser.Values.doubleQuotedStringValue((String)"d"));
            }
        });
    }

    @Test
    void test_quoted_string_05() {
        StringParameterParserTest.testSuccess("a=\"\\\"b\"", Collections.singletonMap("a", StringParameterParser.Values.doubleQuotedStringValue((String)"\"b")));
    }

    @Test
    void test_quoted_string_06() {
        StringParameterParserTest.testSuccess("a=\"\\\"b\\\"\"", Collections.singletonMap("a", StringParameterParser.Values.doubleQuotedStringValue((String)"\"b\"")));
    }

    @Test
    void test_quoted_string_07() {
        StringParameterParserTest.testSuccess("a=\"\\\"b\",c=d", (Map<String, StringParameterParser.Value>)new LinkedHashMap<String, StringParameterParser.Value>(){
            {
                this.put("a", StringParameterParser.Values.doubleQuotedStringValue((String)"\"b"));
                this.put("c", StringParameterParser.Values.stringValue((String)"d"));
            }
        });
    }

    @Test
    void test_quoted_string_08() {
        StringParameterParserTest.testSuccess("a=\"\\\"b\\\"\",c=d", (Map<String, StringParameterParser.Value>)new LinkedHashMap<String, StringParameterParser.Value>(){
            {
                this.put("a", StringParameterParser.Values.doubleQuotedStringValue((String)"\"b\""));
                this.put("c", StringParameterParser.Values.stringValue((String)"d"));
            }
        });
    }

    @Test
    void test_quoted_string_09() {
        StringParameterParserTest.testSuccess("a=\"\\\"b,\",c=d", (Map<String, StringParameterParser.Value>)new LinkedHashMap<String, StringParameterParser.Value>(){
            {
                this.put("a", StringParameterParser.Values.doubleQuotedStringValue((String)"\"b,"));
                this.put("c", StringParameterParser.Values.stringValue((String)"d"));
            }
        });
    }

    @Test
    void test_quoted_string_10() {
        StringParameterParserTest.testSuccess("a=\"\\\"b\\\",\",c=d", (Map<String, StringParameterParser.Value>)new LinkedHashMap<String, StringParameterParser.Value>(){
            {
                this.put("a", StringParameterParser.Values.doubleQuotedStringValue((String)"\"b\","));
                this.put("c", StringParameterParser.Values.stringValue((String)"d"));
            }
        });
    }

    @Test
    void test_quoted_string_11() {
        StringParameterParserTest.testSuccess("a=\"\\\"b\",c=\"d\"", (Map<String, StringParameterParser.Value>)new LinkedHashMap<String, StringParameterParser.Value>(){
            {
                this.put("a", StringParameterParser.Values.doubleQuotedStringValue((String)"\"b"));
                this.put("c", StringParameterParser.Values.doubleQuotedStringValue((String)"d"));
            }
        });
    }

    @Test
    void test_quoted_string_12() {
        StringParameterParserTest.testSuccess("a=\"\\\"b\\\"\",c=\"d\"", (Map<String, StringParameterParser.Value>)new LinkedHashMap<String, StringParameterParser.Value>(){
            {
                this.put("a", StringParameterParser.Values.doubleQuotedStringValue((String)"\"b\""));
                this.put("c", StringParameterParser.Values.doubleQuotedStringValue((String)"d"));
            }
        });
    }

    @Test
    void test_quoted_string_13() {
        StringParameterParserTest.testSuccess("a=\"\\\"b,\",c=\"\\\"d\"", (Map<String, StringParameterParser.Value>)new LinkedHashMap<String, StringParameterParser.Value>(){
            {
                this.put("a", StringParameterParser.Values.doubleQuotedStringValue((String)"\"b,"));
                this.put("c", StringParameterParser.Values.doubleQuotedStringValue((String)"\"d"));
            }
        });
    }

    @Test
    void test_quoted_string_14() {
        StringParameterParserTest.testSuccess("a=\"\\\"b\\\",\",c=\"\\\"d\\\"\"", (Map<String, StringParameterParser.Value>)new LinkedHashMap<String, StringParameterParser.Value>(){
            {
                this.put("a", StringParameterParser.Values.doubleQuotedStringValue((String)"\"b\","));
                this.put("c", StringParameterParser.Values.doubleQuotedStringValue((String)"\"d\""));
            }
        });
    }

    @Test
    void test_quoted_string_15() {
        StringParameterParserTest.testSuccess("a=\"\\\"b\",c=\",d\"", (Map<String, StringParameterParser.Value>)new LinkedHashMap<String, StringParameterParser.Value>(){
            {
                this.put("a", StringParameterParser.Values.doubleQuotedStringValue((String)"\"b"));
                this.put("c", StringParameterParser.Values.doubleQuotedStringValue((String)",d"));
            }
        });
    }

    @Test
    void test_quoted_string_16() {
        StringParameterParserTest.testSuccess("a=\"\\\"b\\\"\",c=\",d\"", (Map<String, StringParameterParser.Value>)new LinkedHashMap<String, StringParameterParser.Value>(){
            {
                this.put("a", StringParameterParser.Values.doubleQuotedStringValue((String)"\"b\""));
                this.put("c", StringParameterParser.Values.doubleQuotedStringValue((String)",d"));
            }
        });
    }

    @Test
    void test_quoted_string_17() {
        StringParameterParserTest.testSuccess("a=\"\\\"b,\",c=\"\\\"d,\"", (Map<String, StringParameterParser.Value>)new LinkedHashMap<String, StringParameterParser.Value>(){
            {
                this.put("a", StringParameterParser.Values.doubleQuotedStringValue((String)"\"b,"));
                this.put("c", StringParameterParser.Values.doubleQuotedStringValue((String)"\"d,"));
            }
        });
    }

    @Test
    void test_quoted_string_18() {
        StringParameterParserTest.testSuccess("a=\"\\\"b\\\",\",c=\"\\\"d\\\",\"", (Map<String, StringParameterParser.Value>)new LinkedHashMap<String, StringParameterParser.Value>(){
            {
                this.put("a", StringParameterParser.Values.doubleQuotedStringValue((String)"\"b\","));
                this.put("c", StringParameterParser.Values.doubleQuotedStringValue((String)"\"d\","));
            }
        });
    }

    private static void testSuccess(String input, Map<String, StringParameterParser.Value> expectedMap) {
        Map actualMap = StringParameterParser.parse((String)input);
        ((MapAssert)Assertions.assertThat((Map)actualMap).as("input: %s", new Object[]{input})).isEqualTo(expectedMap);
    }

    @Test
    void test_missing_key() {
        Assertions.assertThatThrownBy(() -> {
            String input = ",a=b";
            StringParameterParser.parse((String)",a=b");
        }).hasMessageStartingWith("failed to locate key at index 0");
    }

    @Test
    void test_conflicting_key() {
        Assertions.assertThatThrownBy(() -> {
            String input = "a,a";
            StringParameterParser.parse((String)"a,a");
        }).hasMessageStartingWith("conflicting key at index 2");
    }

    @Test
    void test_prematurely_ending_quoted_string_01() {
        Assertions.assertThatThrownBy(() -> {
            String input = "a,b=\"";
            StringParameterParser.parse((String)"a,b=\"");
        }).hasMessageStartingWith("failed to locate the end of double-quoted content starting at index 4");
    }

    @Test
    void test_prematurely_ending_quoted_string_02() {
        Assertions.assertThatThrownBy(() -> {
            String input = "a,b=\"c";
            StringParameterParser.parse((String)"a,b=\"c");
        }).hasMessageStartingWith("failed to locate the end of double-quoted content starting at index 4");
    }

    @Test
    void test_prematurely_ending_quoted_string_03() {
        Assertions.assertThatThrownBy(() -> {
            String input = "a,b=\",c";
            StringParameterParser.parse((String)"a,b=\",c");
        }).hasMessageStartingWith("failed to locate the end of double-quoted content starting at index 4");
    }

    @Test
    void test_prematurely_ending_quoted_string_04() {
        Assertions.assertThatThrownBy(() -> {
            String input = "a,b=\",c\" x";
            StringParameterParser.parse((String)"a,b=\",c\" x");
        }).hasMessageStartingWith("was expecting comma at index 9");
    }

    @Test
    void test_NullValue_toString() {
        Map map = StringParameterParser.parse((String)"a");
        StringParameterParser.NullValue value = (StringParameterParser.NullValue)map.get("a");
        Assertions.assertThat((String)value.toString()).isEqualTo("null");
    }

    @Test
    void test_StringValue_toString() {
        Map map = StringParameterParser.parse((String)"a=b");
        StringParameterParser.StringValue value = (StringParameterParser.StringValue)map.get("a");
        Assertions.assertThat((String)value.toString()).isEqualTo("b");
    }

    @Test
    void test_DoubleQuotedStringValue_toString() {
        Map map = StringParameterParser.parse((String)"a=\"\\\"b\"");
        StringParameterParser.DoubleQuotedStringValue value = (StringParameterParser.DoubleQuotedStringValue)map.get("a");
        Assertions.assertThat((String)value.toString()).isEqualTo("\"b");
    }

    @Test
    void test_allowedKeys() {
        Assertions.assertThatThrownBy(() -> {
            String input = "a,b";
            LinkedHashSet<String> allowedKeys = new LinkedHashSet<String>(Collections.singletonList("a"));
            StringParameterParser.parse((String)"a,b", allowedKeys);
        }).hasMessageStartingWith("unknown key \"b\" is found in input: a,b");
    }
}

