/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.util;

import org.apache.logging.log4j.layout.template.json.util.TruncatingBufferedWriter;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TruncatingBufferedWriterTest {
    TruncatingBufferedWriterTest() {
    }

    @Test
    void test_ctor_invalid_args() {
        Assertions.assertThatThrownBy(() -> new TruncatingBufferedWriter(-1)).isInstanceOf(NegativeArraySizeException.class);
    }

    @Test
    void test_okay_payloads() {
        int capacity = 1000;
        TruncatingBufferedWriter writer = new TruncatingBufferedWriter(1000);
        writer.write(65535);
        writer.write(new char[]{'\u0000', '\uffff'});
        writer.write("foo");
        writer.write("foobar", 3, 3);
        writer.write(new char[]{'f', 'o', 'o', 'b', 'a', 'r', 'b', 'u', 'z', 'z'}, 6, 4);
        writer.append('!');
        writer.append((CharSequence)"yo");
        writer.append(null);
        writer.append((CharSequence)"yo dog", 3, 6);
        writer.append(null, -1, -1);
        char[] expectedBuffer = new char[1000];
        int expectedPosition = 0;
        expectedBuffer[expectedPosition++] = 65535;
        expectedBuffer[expectedPosition++] = '\u0000';
        expectedBuffer[expectedPosition++] = 65535;
        expectedBuffer[expectedPosition++] = 102;
        expectedBuffer[expectedPosition++] = 111;
        expectedBuffer[expectedPosition++] = 111;
        expectedBuffer[expectedPosition++] = 98;
        expectedBuffer[expectedPosition++] = 97;
        expectedBuffer[expectedPosition++] = 114;
        expectedBuffer[expectedPosition++] = 98;
        expectedBuffer[expectedPosition++] = 117;
        expectedBuffer[expectedPosition++] = 122;
        expectedBuffer[expectedPosition++] = 122;
        expectedBuffer[expectedPosition++] = 33;
        expectedBuffer[expectedPosition++] = 121;
        expectedBuffer[expectedPosition++] = 111;
        expectedBuffer[expectedPosition++] = 110;
        expectedBuffer[expectedPosition++] = 117;
        expectedBuffer[expectedPosition++] = 108;
        expectedBuffer[expectedPosition++] = 108;
        expectedBuffer[expectedPosition++] = 100;
        expectedBuffer[expectedPosition++] = 111;
        expectedBuffer[expectedPosition++] = 103;
        expectedBuffer[expectedPosition++] = 110;
        expectedBuffer[expectedPosition++] = 117;
        expectedBuffer[expectedPosition++] = 108;
        expectedBuffer[expectedPosition++] = 108;
        Assertions.assertThat((char[])writer.buffer()).isEqualTo((Object)expectedBuffer);
        Assertions.assertThat((int)writer.position()).isEqualTo(expectedPosition);
        Assertions.assertThat((int)writer.capacity()).isEqualTo(1000);
        Assertions.assertThat((boolean)writer.truncated()).isFalse();
        this.verifyClose(writer);
    }

    @Test
    void test_write_int_truncation() {
        TruncatingBufferedWriter writer = new TruncatingBufferedWriter(1);
        writer.write(97);
        writer.write(98);
        this.verifyTruncation(writer, 'a');
    }

    @Test
    void test_write_char_array_truncation() {
        TruncatingBufferedWriter writer = new TruncatingBufferedWriter(1);
        writer.write(new char[]{'a', 'b'});
        this.verifyTruncation(writer, 'a');
    }

    @Test
    void test_write_String_truncation() {
        TruncatingBufferedWriter writer = new TruncatingBufferedWriter(1);
        writer.write("ab");
        this.verifyTruncation(writer, 'a');
    }

    @Test
    void test_write_String_slice_invalid_args() {
        TruncatingBufferedWriter writer = new TruncatingBufferedWriter(1);
        String string = "a";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.write("a", -1, 1)).isInstanceOf(IndexOutOfBoundsException.class)).hasMessageStartingWith("invalid offset");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.write("a", 1, 1)).isInstanceOf(IndexOutOfBoundsException.class)).hasMessageStartingWith("invalid offset");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.write("a", 0, -1)).isInstanceOf(IndexOutOfBoundsException.class)).hasMessageStartingWith("invalid length");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.write("a", 0, 2)).isInstanceOf(IndexOutOfBoundsException.class)).hasMessageStartingWith("invalid length");
    }

    @Test
    void test_write_String_slice_truncation() {
        TruncatingBufferedWriter writer = new TruncatingBufferedWriter(1);
        writer.write("ab", 0, 2);
        this.verifyTruncation(writer, 'a');
    }

    @Test
    void test_write_char_array_slice_invalid_args() {
        TruncatingBufferedWriter writer = new TruncatingBufferedWriter(1);
        char[] buffer = new char[]{'a'};
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.write(buffer, -1, 1)).isInstanceOf(IndexOutOfBoundsException.class)).hasMessageStartingWith("invalid offset");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.write(buffer, 1, 1)).isInstanceOf(IndexOutOfBoundsException.class)).hasMessageStartingWith("invalid offset");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.write(buffer, 0, -1)).isInstanceOf(IndexOutOfBoundsException.class)).hasMessageStartingWith("invalid length");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.write(buffer, 0, 2)).isInstanceOf(IndexOutOfBoundsException.class)).hasMessageStartingWith("invalid length");
    }

    @Test
    void test_write_char_array_slice_truncation() {
        TruncatingBufferedWriter writer = new TruncatingBufferedWriter(1);
        writer.write(new char[]{'a', 'b'}, 0, 2);
        this.verifyTruncation(writer, 'a');
    }

    @Test
    void test_append_char_truncation() {
        TruncatingBufferedWriter writer = new TruncatingBufferedWriter(1);
        writer.append('a');
        writer.append('b');
        this.verifyTruncation(writer, 'a');
    }

    @Test
    void test_append_seq_truncation() {
        TruncatingBufferedWriter writer = new TruncatingBufferedWriter(1);
        writer.append((CharSequence)"ab");
        this.verifyTruncation(writer, 'a');
    }

    @Test
    void test_append_seq_null_truncation() {
        TruncatingBufferedWriter writer = new TruncatingBufferedWriter(1);
        writer.append(null);
        this.verifyTruncation(writer, 'n');
    }

    @Test
    void test_append_seq_slice_invalid_args() {
        TruncatingBufferedWriter writer = new TruncatingBufferedWriter(1);
        String seq = "ab";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.append(seq, -1, 2)).isInstanceOf(IndexOutOfBoundsException.class)).hasMessageStartingWith("invalid start");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.append(seq, 2, 2)).isInstanceOf(IndexOutOfBoundsException.class)).hasMessageStartingWith("invalid start");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.append(seq, 0, -1)).isInstanceOf(IndexOutOfBoundsException.class)).hasMessageStartingWith("invalid end");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.append(seq, 1, 0)).isInstanceOf(IndexOutOfBoundsException.class)).hasMessageStartingWith("invalid end");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.append(seq, 0, 3)).isInstanceOf(IndexOutOfBoundsException.class)).hasMessageStartingWith("invalid end");
    }

    @Test
    void test_append_seq_slice_truncation() {
        TruncatingBufferedWriter writer = new TruncatingBufferedWriter(1);
        writer.append((CharSequence)"ab", 0, 1);
        this.verifyTruncation(writer, 'a');
    }

    @Test
    void test_append_seq_slice_null_truncation() {
        TruncatingBufferedWriter writer = new TruncatingBufferedWriter(1);
        writer.append(null, -1, -1);
        this.verifyTruncation(writer, 'n');
    }

    private void verifyTruncation(TruncatingBufferedWriter writer, char c) {
        Assertions.assertThat((char[])writer.buffer()).isEqualTo((Object)new char[]{c});
        Assertions.assertThat((int)writer.position()).isEqualTo(1);
        Assertions.assertThat((int)writer.capacity()).isEqualTo(1);
        Assertions.assertThat((boolean)writer.truncated()).isTrue();
        this.verifyClose(writer);
    }

    private void verifyClose(TruncatingBufferedWriter writer) {
        writer.close();
        Assertions.assertThat((int)writer.position()).isEqualTo(0);
        Assertions.assertThat((boolean)writer.truncated()).isFalse();
    }
}

