/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json;

import co.elastic.logging.log4j2.EcsLayout;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayout;
import org.apache.logging.log4j.layout.template.json.LogEventFixture;
import org.apache.logging.log4j.layout.template.json.TestHelpers;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class EcsLayoutTest {
    private static final Configuration CONFIGURATION = new DefaultConfiguration();
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final String SERVICE_NAME = "test";
    private static final String EVENT_DATASET = "test.log";
    private static final JsonTemplateLayout JSON_TEMPLATE_LAYOUT = JsonTemplateLayout.newBuilder().setConfiguration(CONFIGURATION).setCharset(CHARSET).setEventTemplateUri("classpath:EcsLayout.json").setEventTemplateAdditionalFields(new JsonTemplateLayout.EventTemplateAdditionalField[]{JsonTemplateLayout.EventTemplateAdditionalField.newBuilder().setKey("service.name").setValue("test").build(), JsonTemplateLayout.EventTemplateAdditionalField.newBuilder().setKey("event.dataset").setValue("test.log").build()}).build();
    private static final EcsLayout ECS_LAYOUT = EcsLayout.newBuilder().setConfiguration(CONFIGURATION).setServiceName("test").setEventDataset("test.log").build();

    EcsLayoutTest() {
    }

    @Test
    void test_EcsLayout_charset() {
        Assertions.assertThat((Comparable)ECS_LAYOUT.getCharset()).isEqualTo((Object)CHARSET);
    }

    @Test
    void test_lite_log_events() {
        List<LogEvent> logEvents = LogEventFixture.createLiteLogEvents(1000);
        EcsLayoutTest.test(logEvents);
    }

    @Test
    void test_full_log_events() {
        List<LogEvent> logEvents = LogEventFixture.createFullLogEvents(1000);
        EcsLayoutTest.test(logEvents);
    }

    private static void test(Collection<LogEvent> logEvents) {
        for (LogEvent logEvent : logEvents) {
            EcsLayoutTest.test(logEvent);
        }
    }

    private static void test(LogEvent logEvent) {
        Map<String, Object> jsonTemplateLayoutMap = EcsLayoutTest.renderUsingJsonTemplateLayout(logEvent);
        Map<String, Object> ecsLayoutMap = EcsLayoutTest.renderUsingEcsLayout(logEvent);
        Assertions.assertThat(jsonTemplateLayoutMap).isEqualTo(ecsLayoutMap);
    }

    private static Map<String, Object> renderUsingJsonTemplateLayout(LogEvent logEvent) {
        return TestHelpers.serializeUsingLayout(logEvent, (Layout<String>)JSON_TEMPLATE_LAYOUT);
    }

    private static Map<String, Object> renderUsingEcsLayout(LogEvent logEvent) {
        return TestHelpers.serializeUsingLayout(logEvent, (Layout<String>)ECS_LAYOUT);
    }
}

