/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.layout.GelfLayout;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayout;
import org.apache.logging.log4j.layout.template.json.LogEventFixture;
import org.apache.logging.log4j.layout.template.json.TestHelpers;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class GelfLayoutTest {
    private static final Configuration CONFIGURATION = new DefaultConfiguration();
    private static final String HOST_NAME = "localhost";
    private static final JsonTemplateLayout JSON_TEMPLATE_LAYOUT = JsonTemplateLayout.newBuilder().setConfiguration(CONFIGURATION).setEventTemplateUri("classpath:GelfLayout.json").setEventTemplateAdditionalFields(new JsonTemplateLayout.EventTemplateAdditionalField[]{JsonTemplateLayout.EventTemplateAdditionalField.newBuilder().setKey("host").setValue("localhost").build()}).build();
    private static final GelfLayout GELF_LAYOUT = ((GelfLayout.Builder)GelfLayout.newBuilder().setConfiguration(CONFIGURATION)).setHost("localhost").setCompressionType(GelfLayout.CompressionType.OFF).build();

    GelfLayoutTest() {
    }

    @Test
    void test_lite_log_events() {
        List<LogEvent> logEvents = LogEventFixture.createLiteLogEvents(1000);
        GelfLayoutTest.test(logEvents);
    }

    @Test
    void test_full_log_events() {
        List<LogEvent> logEvents = LogEventFixture.createFullLogEvents(1000);
        GelfLayoutTest.test(logEvents);
    }

    private static void test(Collection<LogEvent> logEvents) {
        for (LogEvent logEvent : logEvents) {
            GelfLayoutTest.test(logEvent);
        }
    }

    private static void test(LogEvent logEvent) {
        Map<String, Object> jsonTemplateLayoutMap = GelfLayoutTest.renderUsingJsonTemplateLayout(logEvent);
        Map<String, Object> gelfLayoutMap = GelfLayoutTest.renderUsingGelfLayout(logEvent);
        GelfLayoutTest.verifyTimestamp(logEvent.getInstant(), jsonTemplateLayoutMap, gelfLayoutMap);
        Assertions.assertThat(jsonTemplateLayoutMap).isEqualTo(gelfLayoutMap);
    }

    private static Map<String, Object> renderUsingJsonTemplateLayout(LogEvent logEvent) {
        return TestHelpers.serializeUsingLayout(logEvent, (Layout<String>)JSON_TEMPLATE_LAYOUT);
    }

    private static Map<String, Object> renderUsingGelfLayout(LogEvent logEvent) {
        return TestHelpers.serializeUsingLayout(logEvent, (Layout<String>)GELF_LAYOUT);
    }

    private static void verifyTimestamp(Instant logEventInstant, Map<String, Object> jsonTemplateLayoutMap, Map<String, Object> gelfLayoutMap) {
        BigDecimal jsonTemplateLayoutTimestamp = (BigDecimal)jsonTemplateLayoutMap.remove("timestamp");
        BigDecimal gelfLayoutTimestamp = (BigDecimal)gelfLayoutMap.remove("timestamp");
        String description = String.format("instantEpochSecs=%d.%d, jsonTemplateLayoutTimestamp=%s, gelfLayoutTimestamp=%s", logEventInstant.getEpochSecond(), logEventInstant.getNanoOfSecond(), jsonTemplateLayoutTimestamp, gelfLayoutTimestamp);
        ((AbstractIntegerAssert)Assertions.assertThat((int)jsonTemplateLayoutTimestamp.compareTo(gelfLayoutTimestamp)).as(description, new Object[0])).isEqualTo(0);
    }
}

