/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.layout.template.json.TestHelpers;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.util.Strings;
import org.assertj.core.api.AbstractCharacterAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Execution(value=ExecutionMode.SAME_THREAD)
class JsonTemplateLayoutConcurrentEncodeTest {
    JsonTemplateLayoutConcurrentEncodeTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"dummy", "threadLocal", "queue:supplier=java.util.concurrent.ArrayBlockingQueue.new", "queue:supplier=org.jctools.queues.MpmcArrayQueue.new"})
    void test_concurrent_encode(String recyclerFactory) throws IOException {
        Path appenderFilepath = JsonTemplateLayoutConcurrentEncodeTest.createAppenderFilepath(recyclerFactory);
        int workerCount = 10;
        int messageLength = 1000;
        int messageCount = 1000;
        try {
            JsonTemplateLayoutConcurrentEncodeTest.withContextFromTemplate(appenderFilepath, recyclerFactory, loggerContext -> {
                ExtendedLogger logger = loggerContext.getLogger(JsonTemplateLayoutConcurrentEncodeTest.class);
                JsonTemplateLayoutConcurrentEncodeTest.runWorkers(10, 1000, 1000, (Logger)logger);
            });
            JsonTemplateLayoutConcurrentEncodeTest.verifyLines(appenderFilepath, 1000, 10000);
        }
        catch (Throwable error) {
            String message = String.format("test failure for appender pointing to file: `%s`", appenderFilepath);
            throw new AssertionError(message, error);
        }
        Files.delete(appenderFilepath);
    }

    private static Path createAppenderFilepath(String recyclerFactory) {
        String appenderFilename = String.format("%s-%s.log", JsonTemplateLayoutConcurrentEncodeTest.class.getSimpleName(), recyclerFactory.replaceAll("[^A-Za-z0-9]+", ""));
        return Paths.get(System.getProperty("java.io.tmpdir"), appenderFilename);
    }

    private static void withContextFromTemplate(Path appenderFilepath, String recyclerFactory, Consumer<LoggerContext> loggerContextConsumer) {
        String configName = String.format("%s-%s", JsonTemplateLayoutConcurrentEncodeTest.class.getSimpleName(), recyclerFactory.replaceAll("[^A-Za-z0-9]+", ""));
        ConfigurationBuilder configBuilder = ConfigurationBuilderFactory.newConfigurationBuilder().setStatusLevel(Level.ERROR).setConfigurationName(configName);
        Map<String, Object> eventTemplate = TestHelpers.asMap("$resolver", "message");
        String eventTemplateJson = TestHelpers.writeJson(eventTemplate);
        String appenderName = "File";
        Configuration config = configBuilder.add(((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)configBuilder.newAppender("File", "File").addAttribute("fileName", appenderFilepath.toAbsolutePath().toString())).addAttribute("append", false)).addAttribute("immediateFlush", false)).addAttribute("ignoreExceptions", false)).add((LayoutComponentBuilder)((LayoutComponentBuilder)configBuilder.newLayout("JsonTemplateLayout").addAttribute("eventTemplate", eventTemplateJson)).addAttribute("recyclerFactory", recyclerFactory))).add((RootLoggerComponentBuilder)configBuilder.newRootLogger(Level.ALL).add(configBuilder.newAppenderRef("File"))).build(false);
        try (LoggerContext loggerContext = Configurator.initialize((Configuration)config);){
            loggerContextConsumer.accept(loggerContext);
        }
    }

    private static void runWorkers(int workerCount, int messageLength, int messageCount, Logger logger) {
        List<Thread> workers = IntStream.range(0, workerCount).mapToObj(threadIndex -> JsonTemplateLayoutConcurrentEncodeTest.createWorker(messageLength, messageCount, logger, threadIndex)).collect(Collectors.toList());
        workers.forEach(Thread::start);
        workers.forEach(worker -> {
            try {
                worker.join();
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
                System.err.format("join to `%s` interrupted%n", worker.getName());
            }
        });
    }

    private static Thread createWorker(int messageLength, int messageCount, Logger logger, int threadIndex) {
        int maxThreadIndex = 25;
        if (threadIndex > 25) {
            String message = String.format("was expecting `threadIndex <= %d`, found: %d", 25, threadIndex);
            throw new IndexOutOfBoundsException(message);
        }
        String messageLetter = String.valueOf((char)(65 + threadIndex));
        String message = Strings.repeat((String)messageLetter, (int)messageLength);
        String threadName = String.format("Worker-%d", threadIndex);
        return new Thread(() -> {
            for (int i = 0; i < messageCount; ++i) {
                logger.info(message);
            }
        }, threadName);
    }

    private static void verifyLines(Path appenderFilepath, int messageLength, int messageCount) {
        try (FileInputStream inputStream = new FileInputStream(appenderFilepath.toFile());
             InputStreamReader reader = new InputStreamReader((InputStream)inputStream, StandardCharsets.US_ASCII);
             BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            int lineCount = 0;
            while ((line = bufferedReader.readLine()) != null) {
                try {
                    JsonTemplateLayoutConcurrentEncodeTest.verifyLine(messageLength, line);
                }
                catch (Throwable error) {
                    String message = String.format("verification failure at line %d: `%s`", lineCount + 1, line);
                    throw new AssertionError(message, error);
                }
                ++lineCount;
            }
            Assertions.assertThat((int)lineCount).isEqualTo(messageCount);
        }
        catch (IOException error) {
            String message = String.format("error verifying file: `%s`", appenderFilepath);
            throw new RuntimeException(message, error);
        }
    }

    private static void verifyLine(int messageLength, String line) {
        Assertions.assertThat((String)line).hasSize(messageLength + 2);
        char c0 = line.charAt(0);
        char cN = line.charAt(messageLength + 1);
        Assertions.assertThat((char)c0).isEqualTo('\"').isEqualTo(cN);
        char c1 = line.charAt(1);
        for (int i = 1; i < messageLength; ++i) {
            char c = line.charAt(1 + i);
            ((AbstractCharacterAssert)Assertions.assertThat((char)c).describedAs("character at index %d", new Object[]{i})).isEqualTo(c1);
        }
    }
}

