/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayout;
import org.apache.logging.log4j.layout.template.json.TestHelpers;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.apache.logging.log4j.util.Strings;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class CaseConverterResolverTest {
    CaseConverterResolverTest() {
    }

    @ParameterizedTest
    @CsvSource(value={"upper,nl,ioz,IOZ", "upper,nl,IOZ,IOZ", "lower,nl,ioz,ioz", "lower,nl,IOZ,ioz", "upper,tr,\u0131i\u011f\u00fc\u015f\u00f6\u00e7,I\u0130\u011e\u00dc\u015e\u00d6\u00c7", "upper,tr,I\u0130\u011e\u00dc\u015e\u00d6\u00c7,I\u0130\u011e\u00dc\u015e\u00d6\u00c7", "lower,tr,\u0131i\u011f\u00fc\u015f\u00f6\u00e7,\u0131i\u011f\u00fc\u015f\u00f6\u00e7", "lower,tr,I\u0130\u011e\u00dc\u015e\u00d6\u00c7,\u0131i\u011f\u00fc\u015f\u00f6\u00e7"})
    void test_upper(String case_, String locale, String input, String output) {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("output", TestHelpers.asMap("$resolver", "caseConverter", "case", case_, "locale", locale, "input", TestHelpers.asMap("$resolver", "mdc", "key", "input"))));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        SortedArrayStringMap contextData = new SortedArrayStringMap();
        contextData.putValue("input", (Object)input);
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setContextData((StringMap)contextData).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> Assertions.assertThat((String)accessor.getString("output")).isEqualTo(output));
    }

    @ParameterizedTest
    @CsvSource(value={",nl,1,pass,null,1", ",nl,[2],pass,null,[2]", "was expecting a string value,nl,1,fail,null,null", ",nl,1,replace,null,null", ",nl,1,replace,2,2", ",nl,1,replace,\"s\",\"s\""})
    void test_errorHandlingStrategy(String failureMessage, String locale, String inputJson, String errorHandlingStrategy, String replacementJson, String outputJson) {
        Object input = TestHelpers.readJson(inputJson);
        Object replacement = TestHelpers.readJson(replacementJson);
        Object output = TestHelpers.readJson(outputJson);
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("output", TestHelpers.asMap("$resolver", "caseConverter", "case", "lower", "locale", locale, "input", input, "errorHandlingStrategy", errorHandlingStrategy, "replacement", replacement)));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().build();
        boolean failureExpected = Strings.isNotBlank((String)failureMessage);
        if (failureExpected) {
            Assertions.assertThatThrownBy(() -> CaseConverterResolverTest.lambda$test_errorHandlingStrategy$1(layout, (LogEvent)logEvent)).hasMessageContaining(failureMessage);
        } else {
            TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
                ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)accessor.getObject("output")).isEqualTo(output);
            });
        }
    }

    private static /* synthetic */ void lambda$test_errorHandlingStrategy$1(JsonTemplateLayout layout, LogEvent logEvent) throws Throwable {
        layout.toSerializable(logEvent);
    }
}

