/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.math.BigInteger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayout;
import org.apache.logging.log4j.layout.template.json.TestHelpers;
import org.apache.logging.log4j.layout.template.json.util.JsonReader;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CounterResolverTest {
    CounterResolverTest() {
    }

    @Test
    void no_arg_setup_should_start_from_zero() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("$resolver", "counter"));
        CounterResolverTest.verify(eventTemplate, 0, 1);
    }

    @Test
    void positive_start_should_work() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("$resolver", "counter", "start", 3));
        CounterResolverTest.verify(eventTemplate, 3, 4);
    }

    @Test
    void positive_start_should_work_when_stringified() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("$resolver", "counter", "start", 3, "stringified", true));
        CounterResolverTest.verify(eventTemplate, "3", "4");
    }

    @Test
    void negative_start_should_work() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("$resolver", "counter", "start", -3));
        CounterResolverTest.verify(eventTemplate, -3, -2);
    }

    @Test
    void negative_start_should_work_when_stringified() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("$resolver", "counter", "start", -3, "stringified", true));
        CounterResolverTest.verify(eventTemplate, "-3", "-2");
    }

    @Test
    void min_long_should_work_when_overflow_enabled() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("$resolver", "counter", "start", Long.MIN_VALUE));
        CounterResolverTest.verify(eventTemplate, Long.MIN_VALUE, -9223372036854775807L);
    }

    @Test
    void min_long_should_work_when_overflow_enabled_and_stringified() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("$resolver", "counter", "start", Long.MIN_VALUE, "stringified", true));
        CounterResolverTest.verify(eventTemplate, "-9223372036854775808", "-9223372036854775807");
    }

    @Test
    void max_long_should_work_when_overflowing() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("$resolver", "counter", "start", Long.MAX_VALUE));
        CounterResolverTest.verify(eventTemplate, Long.MAX_VALUE, Long.MIN_VALUE);
    }

    @Test
    void max_long_should_work_when_overflowing_and_stringified() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("$resolver", "counter", "start", Long.MAX_VALUE, "stringified", true));
        CounterResolverTest.verify(eventTemplate, "9223372036854775807", "-9223372036854775808");
    }

    @Test
    void max_long_should_work_when_not_overflowing() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("$resolver", "counter", "start", Long.MAX_VALUE, "overflowing", false));
        CounterResolverTest.verify(eventTemplate, Long.MAX_VALUE, BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE));
    }

    @Test
    void max_long_should_work_when_not_overflowing_and_stringified() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("$resolver", "counter", "start", Long.MAX_VALUE, "overflowing", false, "stringified", true));
        CounterResolverTest.verify(eventTemplate, "9223372036854775807", "" + BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE));
    }

    private static void verify(String eventTemplate, Object expectedNumber1, Object expectedNumber2) {
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().build();
        String serializedLogEvent1 = layout.toSerializable((LogEvent)logEvent);
        Object deserializedLogEvent1 = JsonReader.read((String)serializedLogEvent1);
        Assertions.assertThat((Object)deserializedLogEvent1).isEqualTo(expectedNumber1);
        String serializedLogEvent2 = layout.toSerializable((LogEvent)logEvent);
        Object deserializedLogEvent2 = JsonReader.read((String)serializedLogEvent2);
        Assertions.assertThat((Object)deserializedLogEvent2).isEqualTo(expectedNumber2);
    }
}

