/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.util.Arrays;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayout;
import org.apache.logging.log4j.layout.template.json.TestHelpers;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.message.StringMapMessage;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ReadOnlyStringMapResolverTest {
    ReadOnlyStringMapResolverTest() {
    }

    @Test
    void key_should_not_be_allowed_with_flatten() {
        ReadOnlyStringMapResolverTest.verifyConfigFailure(TestHelpers.writeJson(TestHelpers.asMap("$resolver", "mdc", "key", "foo", "flatten", true)), IllegalArgumentException.class, "key and flatten options cannot be combined");
    }

    @Test
    void invalid_pattern_should_fail() {
        ReadOnlyStringMapResolverTest.verifyConfigFailure(TestHelpers.writeJson(TestHelpers.asMap("$resolver", "mdc", "pattern", "[1")), PatternSyntaxException.class, "Unclosed character");
    }

    @Test
    void pattern_should_not_be_allowed_with_key() {
        ReadOnlyStringMapResolverTest.verifyConfigFailure(TestHelpers.writeJson(TestHelpers.asMap("$resolver", "mdc", "key", "foo", "pattern", "bar")), IllegalArgumentException.class, "pattern and key options cannot be combined");
    }

    @Test
    void replacement_should_not_be_allowed_without_pattern() {
        ReadOnlyStringMapResolverTest.verifyConfigFailure(TestHelpers.writeJson(TestHelpers.asMap("$resolver", "mdc", "replacement", "$1")), IllegalArgumentException.class, "replacement cannot be provided without a pattern");
    }

    private static void verifyConfigFailure(String eventTemplate, Class<? extends Throwable> failureClass, String failureMessage) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build()).isInstanceOf(failureClass)).hasMessageContaining(failureMessage);
    }

    @Test
    void pattern_replacement_should_work() {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("$resolver", "mdc", "pattern", "user:(role|rank)", "replacement", "$1"));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        SortedArrayStringMap contextData = new SortedArrayStringMap();
        contextData.putValue("user:role", (Object)"engineer");
        contextData.putValue("user:rank", (Object)"senior");
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setContextData((StringMap)contextData).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            Assertions.assertThat((String)accessor.getString("role")).isEqualTo("engineer");
            Assertions.assertThat((String)accessor.getString("rank")).isEqualTo("senior");
        });
    }

    @Test
    void test_mdc_key_access() {
        SimpleMessage message = new SimpleMessage("Hello, World!");
        SortedArrayStringMap contextData = new SortedArrayStringMap();
        String mdcDirectlyAccessedKey = "mdcKey1";
        String mdcDirectlyAccessedValue = "mdcValue1";
        contextData.putValue("mdcKey1", (Object)"mdcValue1");
        String mdcDirectlyAccessedNullPropertyKey = "mdcKey2";
        contextData.putValue("mdcKey2", null);
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setMessage((Message)message).setContextData((StringMap)contextData).build();
        ReadOnlyStringMapResolverTest.testReadOnlyStringMapKeyAccess("mdcKey1", "mdcValue1", "mdcKey2", (LogEvent)logEvent, "mdc");
    }

    @Test
    public void test_map_key_access() {
        String directlyAccessedKey = "mapKey1";
        String directlyAccessedValue = "mapValue1";
        String directlyAccessedNullPropertyKey = "mapKey2";
        MapMessage message = new StringMapMessage().with("mapKey1", "mapValue1");
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setMessage((Message)message).build();
        ReadOnlyStringMapResolverTest.testReadOnlyStringMapKeyAccess("mapKey1", "mapValue1", "mapKey2", (LogEvent)logEvent, "map");
    }

    private static void testReadOnlyStringMapKeyAccess(String directlyAccessedKey, String directlyAccessedValue, String directlyAccessedNullPropertyKey, LogEvent logEvent, String resolverName) {
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap(directlyAccessedKey, TestHelpers.asMap("$resolver", resolverName, "key", directlyAccessedKey), directlyAccessedNullPropertyKey, TestHelpers.asMap("$resolver", resolverName, "key", directlyAccessedNullPropertyKey)));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setStackTraceEnabled(true).setEventTemplate(eventTemplate).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, logEvent, accessor -> {
            Assertions.assertThat((String)accessor.getString(directlyAccessedKey)).isEqualTo(directlyAccessedValue);
            Assertions.assertThat((String)accessor.getString(directlyAccessedNullPropertyKey)).isNull();
        });
    }

    @Test
    void test_mdc_pattern() {
        SimpleMessage message = new SimpleMessage("Hello, World!");
        SortedArrayStringMap contextData = new SortedArrayStringMap();
        String mdcPatternMatchedKey = "mdcKey1";
        String mdcPatternMatchedValue = "mdcValue1";
        contextData.putValue("mdcKey1", (Object)"mdcValue1");
        String mdcPatternMismatchedKey = "mdcKey2";
        String mdcPatternMismatchedValue = "mdcValue2";
        contextData.putValue("mdcKey2", (Object)"mdcValue2");
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setMessage((Message)message).setContextData((StringMap)contextData).build();
        ReadOnlyStringMapResolverTest.testReadOnlyStringMapPattern("mdcKey1", "mdcValue1", "mdcKey2", (LogEvent)logEvent, "mdc");
    }

    @Test
    public void test_map_pattern() {
        String patternMatchedKey = "mapKey1";
        String patternMatchedValue = "mapValue1";
        String patternMismatchedKey = "mapKey2";
        String patternMismatchedValue = "mapValue2";
        MapMessage message = ((StringMapMessage)new StringMapMessage().with("mapKey1", "mapValue1")).with("mapKey2", "mapValue2");
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setMessage((Message)message).build();
        ReadOnlyStringMapResolverTest.testReadOnlyStringMapPattern("mapKey1", "mapValue1", "mapKey2", (LogEvent)logEvent, "map");
    }

    private static void testReadOnlyStringMapPattern(String patternMatchedKey, String patternMatchedValue, String patternMismatchedKey, LogEvent logEvent, String resolverName) {
        String mapFieldName = "map";
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("map", TestHelpers.asMap("$resolver", resolverName, "pattern", patternMatchedKey)));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setStackTraceEnabled(true).setEventTemplate(eventTemplate).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, logEvent, accessor -> {
            Assertions.assertThat((String)accessor.getString(new String[]{"map", patternMatchedKey})).isEqualTo(patternMatchedValue);
            Assertions.assertThat((boolean)accessor.exists(new String[]{"map", patternMismatchedKey})).isFalse();
        });
    }

    @Test
    void test_mdc_flatten() {
        SimpleMessage message = new SimpleMessage("Hello, World!");
        SortedArrayStringMap contextData = new SortedArrayStringMap();
        String mdcPatternMatchedKey = "mdcKey1";
        String mdcPatternMatchedValue = "mdcValue1";
        contextData.putValue("mdcKey1", (Object)"mdcValue1");
        String mdcPatternMismatchedKey = "mdcKey2";
        String mdcPatternMismatchedValue = "mdcValue2";
        contextData.putValue("mdcKey2", (Object)"mdcValue2");
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setMessage((Message)message).setContextData((StringMap)contextData).build();
        ReadOnlyStringMapResolverTest.testReadOnlyStringMapFlatten("mdcKey1", "mdcValue1", "mdcKey2", (LogEvent)logEvent, "mdc");
    }

    @Test
    public void test_map_flatten() {
        String patternMatchedKey = "mapKey1";
        String patternMatchedValue = "mapValue1";
        String patternMismatchedKey = "mapKey2";
        String patternMismatchedValue = "mapValue2";
        MapMessage message = ((StringMapMessage)new StringMapMessage().with("mapKey1", "mapValue1")).with("mapKey2", "mapValue2");
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setMessage((Message)message).build();
        ReadOnlyStringMapResolverTest.testReadOnlyStringMapFlatten("mapKey1", "mapValue1", "mapKey2", (LogEvent)logEvent, "map");
    }

    private static void testReadOnlyStringMapFlatten(String patternMatchedKey, String patternMatchedValue, String patternMismatchedKey, LogEvent logEvent, String resolverName) {
        String prefix = "_map.";
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("ignoredFieldName", TestHelpers.asMap("$resolver", resolverName, "pattern", patternMatchedKey, "flatten", TestHelpers.asMap("prefix", "_map."))));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setStackTraceEnabled(true).setEventTemplate(eventTemplate).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, logEvent, accessor -> {
            Assertions.assertThat((String)accessor.getString("_map." + patternMatchedKey)).isEqualTo(patternMatchedValue);
            Assertions.assertThat((boolean)accessor.exists("_map." + patternMismatchedKey)).isFalse();
        });
    }

    @Test
    void test_MapResolver() {
        StringMapMessage message = (StringMapMessage)new StringMapMessage().with("key1", "val1");
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setMessage((Message)message).build();
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("mapValue1", TestHelpers.asMap("$resolver", "map", "key", "key1"), "mapValue2", TestHelpers.asMap("$resolver", "map", "key", "key?")));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            Assertions.assertThat((String)accessor.getString("mapValue1")).isEqualTo("val1");
            Assertions.assertThat((String)accessor.getString("mapValue2")).isNull();
        });
    }

    @Test
    void test_MapMessage_keyed_access() {
        String key = "list";
        String eventTemplate = TestHelpers.writeJson(TestHelpers.asMap("typedValue", TestHelpers.asMap("$resolver", "map", "key", "list"), "stringifiedValue", TestHelpers.asMap("$resolver", "map", "key", "list", "stringified", true)));
        JsonTemplateLayout layout = JsonTemplateLayout.newBuilder().setConfiguration(TestHelpers.CONFIGURATION).setEventTemplate(eventTemplate).build();
        List<Integer> value = Arrays.asList(1, 2);
        StringMapMessage mapMessage = (StringMapMessage)new StringMapMessage().with("list", value);
        Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setMessage((Message)mapMessage).setTimeMillis(System.currentTimeMillis()).build();
        TestHelpers.usingSerializedLogEventAccessor((Layout<String>)layout, (LogEvent)logEvent, accessor -> {
            Assertions.assertThat((Object)accessor.getObject("typedValue")).isEqualTo((Object)value);
            Assertions.assertThat((String)accessor.getString("stringifiedValue")).isEqualTo(String.valueOf(value));
        });
    }
}

