/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.util;

import java.util.TimeZone;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.apache.logging.log4j.layout.template.json.util.InstantFormatter;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class InstantFormatterTest {
    InstantFormatterTest() {
    }

    @ParameterizedTest
    @CsvSource(value={"yyyy-MM-dd'T'HH:mm:ss.SSS,FixedDateFormat", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z',FastDateFormat", "yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS'Z',DateTimeFormatter"})
    void all_internal_implementations_should_be_used(String pattern, String className) {
        InstantFormatter formatter = InstantFormatter.newBuilder().setPattern(pattern).build();
        ((AbstractStringAssert)Assertions.assertThat((Class)formatter.getInternalImplementationClass()).asString().describedAs("pattern=%s", new Object[]{pattern})).endsWith((CharSequence)("." + className));
    }

    @Test
    void nanoseconds_should_be_formatted() {
        InstantFormatter formatter = InstantFormatter.newBuilder().setPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS'Z'").setTimeZone(TimeZone.getTimeZone("UTC")).build();
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochSecond(0L, 123456789);
        Assertions.assertThat((String)formatter.format((Instant)instant)).isEqualTo("1970-01-01T00:00:00.123456789Z");
    }
}

