/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.util;

import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.core.impl.JdkMapAdapterStringMap;
import org.apache.logging.log4j.layout.template.json.JacksonFixture;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.IndexedReadOnlyStringMap;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.StringMap;
import org.apache.logging.log4j.util.Strings;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.StringAssert;
import org.junit.jupiter.api.Test;

class JsonWriterTest {
    private static final JsonWriter WRITER = JsonWriter.newBuilder().setMaxStringLength(128).setTruncatedStringSuffix("~").build();
    private static final int SURROGATE_CODE_POINT = 65536;
    private static final char[] SURROGATE_PAIR = new char[2];
    private static final char HI_SURROGATE;
    private static final char LO_SURROGATE;

    JsonWriterTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized <V> V withLockedWriterReturning(Function<JsonWriter, V> consumer) {
        JsonWriter jsonWriter = WRITER;
        synchronized (jsonWriter) {
            return consumer.apply(WRITER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void withLockedWriter(Consumer<JsonWriter> consumer) {
        JsonWriter jsonWriter = WRITER;
        synchronized (jsonWriter) {
            consumer.accept(WRITER);
        }
    }

    @Test
    void test_close() {
        JsonWriterTest.withLockedWriter(writer -> {
            writer.writeString((CharSequence)"x");
            writer.close();
            JsonWriterTest.assertStringBuilderReset(writer);
        });
    }

    @Test
    void test_close_after_excessive_write() {
        JsonWriterTest.withLockedWriter(writer -> {
            String text = Strings.repeat((String)"x", (int)writer.getMaxStringLength());
            writer.writeString((CharSequence)text);
            writer.writeString((CharSequence)text);
            writer.close();
            JsonWriterTest.assertStringBuilderReset(writer);
        });
    }

    private static void assertStringBuilderReset(JsonWriter writer) {
        Assertions.assertThat((int)writer.getStringBuilder().capacity()).isEqualTo(writer.getMaxStringLength());
        Assertions.assertThat((int)writer.getStringBuilder().length()).isEqualTo(0);
    }

    @Test
    void test_surrogate_code_point() {
        Assertions.assertThat((char)HI_SURROGATE).matches(Character::isHighSurrogate, "is high surrogate");
        Assertions.assertThat((char)LO_SURROGATE).matches(Character::isLowSurrogate, "is low surrogate");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)Character.isSurrogatePair(HI_SURROGATE, LO_SURROGATE)).as("is surrogate pair", new Object[0])).isTrue();
        Assertions.assertThat((int)65536).matches(Character::isDefined, "is defined");
    }

    @Test
    void test_use_null_Runnable() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonWriterTest.withLockedWriter(writer -> writer.use(null))).isInstanceOf(NullPointerException.class)).hasMessageContaining("runnable");
    }

    @Test
    void test_use_failing_Runnable() {
        RuntimeException exception = new RuntimeException();
        JsonWriterTest.withLockedWriter(writer -> {
            int initialLength = writer.getStringBuilder().length();
            Assertions.assertThatThrownBy(() -> writer.use(() -> {
                writer.writeString((CharSequence)"extending the buffer");
                throw exception;
            })).isSameAs((Object)exception);
            Assertions.assertThat((StringBuilder)writer.getStringBuilder()).hasSize(initialLength);
        });
    }

    @Test
    void test_writeValue_null_Object() {
        this.expectNull(writer -> writer.writeValue(null));
    }

    @Test
    void test_writeValue() {
        Map<String, String> value = Collections.singletonMap("a", "b");
        String expectedJson = "{'a':'b'}".replace('\'', '\"');
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeValue(value)));
        Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
    }

    @Test
    void test_writeObject_null_StringMap() {
        this.expectNull(writer -> writer.writeObject((StringMap)null));
    }

    @Test
    void test_writeObject_StringMap() {
        JdkMapAdapterStringMap map = new JdkMapAdapterStringMap(Collections.singletonMap("a", "b"));
        String expectedJson = "{'a':'b'}".replace('\'', '\"');
        String actualJson = JsonWriterTest.withLockedWriterReturning(arg_0 -> JsonWriterTest.lambda$test_writeObject_StringMap$12((StringMap)map, arg_0));
        Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
    }

    @Test
    void test_writeObject_null_IndexedReadOnlyStringMap() {
        this.expectNull(writer -> writer.writeObject((IndexedReadOnlyStringMap)null));
    }

    @Test
    void test_writeObject_IndexedReadOnlyStringMap() {
        SortedArrayStringMap map = new SortedArrayStringMap((Map)new LinkedHashMap<String, Object>(){
            {
                this.put("buzz", 1.2);
                this.put("foo", "bar");
            }
        });
        String expectedJson = "{'buzz':1.2,'foo':'bar'}".replace('\'', '\"');
        String actualJson = JsonWriterTest.withLockedWriterReturning(arg_0 -> JsonWriterTest.lambda$test_writeObject_IndexedReadOnlyStringMap$15((IndexedReadOnlyStringMap)map, arg_0));
        Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
    }

    @Test
    void test_writeObject_null_Map() {
        this.expectNull(writer -> writer.writeObject((Map)null));
    }

    @Test
    void test_writeObject_Map() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(){
            {
                this.put("key1", "val1");
                this.put("key2", Collections.singletonMap("key2.1", "val2.1"));
                this.put("key3", Arrays.asList(3, (byte)127, 4.5, Float.valueOf(4.6f), Arrays.asList(true, false), new BigDecimal("30.12345678901234567890123456789"), new BigInteger("12345678901234567890123456789"), Collections.singleton(Character.valueOf('a')), Collections.singletonMap("key3.3", "val3.3")));
                this.put("key4", new LinkedHashMap<String, Object>(){
                    {
                        this.put("chars", new char[]{'a', 'b', 'c'});
                        this.put("booleans", new boolean[]{true, false});
                        this.put("bytes", new byte[]{1, 2});
                        this.put("shorts", new short[]{3, 4});
                        this.put("ints", new int[]{256, 257});
                        this.put("longs", new long[]{0x80000000L, 0x80000001L});
                        this.put("floats", new float[]{1.0f, 1.1f});
                        this.put("doubles", new double[]{2.0, 2.1});
                        this.put("objects", new Object[]{"foo", "bar"});
                    }
                });
                this.put("key5\t", new Object(){

                    public String toString() {
                        return "custom-object\r";
                    }
                });
                this.put("key6", Arrays.asList(new SortedArrayStringMap((Map)new LinkedHashMap<String, Object>(){
                    {
                        this.put("buzz", 1.2);
                        this.put("foo", "bar");
                    }
                }), new JdkMapAdapterStringMap(Collections.singletonMap("a", "b"))));
                this.put("key7", buffer -> buffer.append(7.7777777777777));
            }
        };
        String expectedJson = "{'key1':'val1','key2':{'key2.1':'val2.1'},'key3':[3,127,4.5,4.6,[true,false],30.12345678901234567890123456789,12345678901234567890123456789,['a'],{'key3.3':'val3.3'}],'key4':{'chars':['a','b','c'],'booleans':[true,false],'bytes':[1,2],'shorts':[3,4],'ints':[256,257],'longs':[2147483648,2147483649],'floats':[1.0,1.1],'doubles':[2.0,2.1],'objects':['foo','bar']},'key5\\t':'custom-object\\r','key6':[{'buzz':1.2,'foo':'bar'},{'a':'b'}],'key7':'7.7777777777777'}".replace('\'', '\"');
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeObject(map)));
        Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
    }

    @Test
    void test_writeArray_null_List() {
        this.expectNull(writer -> writer.writeArray((List)null));
    }

    @Test
    void test_writeArray_List() {
        List<Object> items = Arrays.asList(1, 2, 3, "yo", Collections.singletonMap("foo", "bar"));
        String expectedJson = "[1,2,3,\"yo\",{\"foo\":\"bar\"}]";
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeArray(items)));
        Assertions.assertThat((String)actualJson).isEqualTo("[1,2,3,\"yo\",{\"foo\":\"bar\"}]");
    }

    @Test
    void test_writeArray_null_Collection() {
        this.expectNull(writer -> writer.writeArray((Collection)null));
    }

    @Test
    void test_writeArray_Collection() {
        List<Object> items = Arrays.asList(1, 2, 3, Collections.singletonMap("foo", "bar"));
        String expectedJson = "[1,2,3,{\"foo\":\"bar\"}]";
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeArray(items)));
        Assertions.assertThat((String)actualJson).isEqualTo("[1,2,3,{\"foo\":\"bar\"}]");
    }

    @Test
    void test_writeArray_null_char() {
        this.expectNull(writer -> writer.writeArray((char[])null));
    }

    @Test
    void test_writeArray_char() {
        char[] items = new char[]{'\u0000', 'a', 'b', 'c', '\u007f'};
        String expectedJson = "[\"\\u0000\",\"a\",\"b\",\"c\",\"\u007f\"]";
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeArray(items)));
        Assertions.assertThat((String)actualJson).isEqualTo("[\"\\u0000\",\"a\",\"b\",\"c\",\"\u007f\"]");
    }

    @Test
    void test_writeArray_null_boolean() {
        this.expectNull(writer -> writer.writeArray((boolean[])null));
    }

    @Test
    void test_writeArray_boolean() {
        boolean[] items = new boolean[]{true, false};
        String expectedJson = "[true,false]";
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeArray(items)));
        Assertions.assertThat((String)actualJson).isEqualTo("[true,false]");
    }

    @Test
    void test_writeArray_null_byte() {
        this.expectNull(writer -> writer.writeArray((byte[])null));
    }

    @Test
    void test_writeArray_byte() {
        byte[] items = new byte[]{-128, -1, 0, 1, 127};
        String expectedJson = Arrays.toString(items).replaceAll(" ", "");
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeArray(items)));
        Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
    }

    @Test
    void test_writeArray_null_short() {
        this.expectNull(writer -> writer.writeArray((short[])null));
    }

    @Test
    void test_writeArray_short() {
        short[] items = new short[]{Short.MIN_VALUE, -1, 0, 1, Short.MAX_VALUE};
        String expectedJson = Arrays.toString(items).replaceAll(" ", "");
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeArray(items)));
        Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
    }

    @Test
    void test_writeArray_null_int() {
        this.expectNull(writer -> writer.writeArray((int[])null));
    }

    @Test
    void test_writeArray_int() {
        int[] items = new int[]{Integer.MIN_VALUE, -1, 0, 1, Integer.MAX_VALUE};
        String expectedJson = Arrays.toString(items).replaceAll(" ", "");
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeArray(items)));
        Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
    }

    @Test
    void test_writeArray_null_long() {
        this.expectNull(writer -> writer.writeArray((long[])null));
    }

    @Test
    void test_writeArray_long() {
        long[] items = new long[]{Long.MIN_VALUE, -1L, 0L, 1L, Long.MAX_VALUE};
        String expectedJson = Arrays.toString(items).replaceAll(" ", "");
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeArray(items)));
        Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
    }

    @Test
    void test_writeArray_null_float() {
        this.expectNull(writer -> writer.writeArray((float[])null));
    }

    @Test
    void test_writeArray_float() {
        float[] items = new float[]{Float.MIN_VALUE, -1.0f, 0.0f, 1.0f, Float.MAX_VALUE};
        String expectedJson = Arrays.toString(items).replaceAll(" ", "");
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeArray(items)));
        Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
    }

    @Test
    void test_writeArray_null_double() {
        this.expectNull(writer -> writer.writeArray((double[])null));
    }

    @Test
    void test_writeArray_double() {
        double[] items = new double[]{Double.MIN_VALUE, -1.0, 0.0, 1.0, Double.MAX_VALUE};
        String expectedJson = Arrays.toString(items).replaceAll(" ", "");
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeArray(items)));
        Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
    }

    @Test
    void test_writeArray_null_Object() {
        this.expectNull(writer -> writer.writeArray((Object[])null));
    }

    @Test
    void test_writeArray_Object() {
        String expectedJson = "[\"foo\",{\"bar\":\"buzz\"},null]";
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeArray(new Object[]{"foo", Collections.singletonMap("bar", "buzz"), null})));
        Assertions.assertThat((String)actualJson).isEqualTo("[\"foo\",{\"bar\":\"buzz\"},null]");
    }

    @Test
    void test_writeString_null_emitter() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonWriterTest.withLockedWriter(writer -> writer.use(() -> writer.writeString(null, (Object)0L)))).isInstanceOf(NullPointerException.class)).hasMessageContaining("emitter");
    }

    @Test
    void test_writeString_emitter() {
        String state = "there-is-no-spoon";
        BiConsumer emitter = StringBuilder::append;
        String expectedJson = "\"there-is-no-spoon\"";
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeString(emitter, (Object)"there-is-no-spoon")));
        Assertions.assertThat((String)actualJson).isEqualTo("\"there-is-no-spoon\"");
    }

    @Test
    void test_writeString_emitter_excessive_string() {
        JsonWriterTest.withLockedWriter(writer -> {
            int maxStringLength = writer.getMaxStringLength();
            String excessiveString = Strings.repeat((String)"x", (int)maxStringLength) + 'y';
            String expectedJson = '\"' + excessiveString.substring(0, maxStringLength) + writer.getTruncatedStringSuffix() + '\"';
            BiConsumer emitter = StringBuilder::append;
            String actualJson = writer.use(() -> writer.writeString(emitter, (Object)excessiveString));
            Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
            JsonWriterTest.assertFormattableBufferReset(writer);
        });
    }

    @Test
    void test_writeString_emitter_excessive_string_ending_with_high_surrogate() {
        JsonWriterTest.withLockedWriter(writer -> {
            int maxStringLength = writer.getMaxStringLength();
            String excessiveString = Strings.repeat((String)"x", (int)(maxStringLength - 1)) + HI_SURROGATE + LO_SURROGATE;
            String expectedJson = "\"" + Strings.repeat((String)"x", (int)(maxStringLength - 1)) + writer.getTruncatedStringSuffix() + '\"';
            BiConsumer emitter = StringBuilder::append;
            String actualJson = writer.use(() -> writer.writeString(emitter, (Object)excessiveString));
            Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
            JsonWriterTest.assertFormattableBufferReset(writer);
        });
    }

    @Test
    void test_writeString_null_formattable() {
        this.expectNull(writer -> writer.writeString((StringBuilderFormattable)null));
    }

    @Test
    void test_writeString_formattable() {
        String expectedJson = "\"foo\\tbar\\tbuzz\"";
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeString(stringBuilder -> stringBuilder.append("foo\tbar\tbuzz"))));
        Assertions.assertThat((String)actualJson).isEqualTo("\"foo\\tbar\\tbuzz\"");
    }

    @Test
    void test_writeString_formattable_excessive_string() {
        JsonWriterTest.withLockedWriter(writer -> {
            int maxStringLength = writer.getMaxStringLength();
            String excessiveString = Strings.repeat((String)"x", (int)maxStringLength) + 'y';
            String expectedJson = '\"' + excessiveString.substring(0, maxStringLength) + writer.getTruncatedStringSuffix() + '\"';
            String actualJson = writer.use(() -> writer.writeString(stringBuilder -> stringBuilder.append(excessiveString)));
            Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
            JsonWriterTest.assertFormattableBufferReset(writer);
        });
    }

    @Test
    void test_writeString_formattable_excessive_string_ending_with_high_surrogate() {
        JsonWriterTest.withLockedWriter(writer -> {
            int maxStringLength = writer.getMaxStringLength();
            String excessiveString = Strings.repeat((String)"x", (int)(maxStringLength - 1)) + HI_SURROGATE + LO_SURROGATE;
            String expectedJson = "\"" + Strings.repeat((String)"x", (int)(maxStringLength - 1)) + writer.getTruncatedStringSuffix() + '\"';
            String actualJson = writer.use(() -> writer.writeString(stringBuilder -> stringBuilder.append(excessiveString)));
            Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
            JsonWriterTest.assertFormattableBufferReset(writer);
        });
    }

    private static void assertFormattableBufferReset(JsonWriter writer) {
        StringBuilder formattableBuffer = JsonWriterTest.getFormattableBuffer(writer);
        Assertions.assertThat((int)formattableBuffer.capacity()).isEqualTo(writer.getMaxStringLength());
        Assertions.assertThat((int)formattableBuffer.length()).isEqualTo(0);
    }

    private static StringBuilder getFormattableBuffer(JsonWriter writer) {
        try {
            Field field = JsonWriter.class.getDeclaredField("formattableBuffer");
            field.setAccessible(true);
            return (StringBuilder)field.get(writer);
        }
        catch (Exception error) {
            throw new RuntimeException(error);
        }
    }

    @Test
    void test_writeString_null_seq_1() {
        this.expectNull(writer -> writer.writeString((CharSequence)null));
    }

    @Test
    void test_writeString_null_seq_2() {
        this.expectNull(writer -> writer.writeString((CharSequence)null, 0, 4));
    }

    @Test
    void test_writeString_seq_negative_offset() {
        JsonWriterTest.withLockedWriter(writer -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.use(() -> writer.writeString((CharSequence)"a", -1, 0))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("offset"));
    }

    @Test
    void test_writeString_seq_negative_length() {
        JsonWriterTest.withLockedWriter(writer -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.use(() -> writer.writeString((CharSequence)"a", 0, -1))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("length"));
    }

    @Test
    void test_writeString_excessive_seq() {
        JsonWriterTest.withLockedWriter(writer -> {
            String seq = Strings.repeat((String)"x", (int)writer.getMaxStringLength()) + 'y';
            String expectedJson = "\"" + Strings.repeat((String)"x", (int)writer.getMaxStringLength()) + writer.getTruncatedStringSuffix() + '\"';
            String actualJson = writer.use(() -> writer.writeString(seq));
            Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
        });
    }

    @Test
    void test_writeString_excessive_seq_ending_with_high_surrogate() {
        JsonWriterTest.withLockedWriter(writer -> {
            int maxStringLength = writer.getMaxStringLength();
            String seq = Strings.repeat((String)"x", (int)(maxStringLength - 1)) + HI_SURROGATE + LO_SURROGATE;
            String expectedJson = "\"" + Strings.repeat((String)"x", (int)(maxStringLength - 1)) + writer.getTruncatedStringSuffix() + '\"';
            String actualJson = writer.use(() -> writer.writeString(seq));
            Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
        });
    }

    @Test
    void test_writeString_seq() throws IOException {
        char[] surrogates = new char[2];
        JsonWriterTest.testQuoting(codePoint -> {
            Character.toChars(codePoint, surrogates, 0);
            String s = new String(surrogates);
            return JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeString((CharSequence)s)));
        });
    }

    @Test
    void test_writeString_null_buffer_1() {
        this.expectNull(writer -> writer.writeString((char[])null));
    }

    @Test
    void test_writeString_null_buffer_2() {
        this.expectNull(writer -> writer.writeString((char[])null, 0, 4));
    }

    @Test
    void test_writeString_buffer_negative_offset() {
        JsonWriterTest.withLockedWriter(writer -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.use(() -> writer.writeString(new char[]{'a'}, -1, 0))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("offset"));
    }

    @Test
    void test_writeString_buffer_negative_length() {
        JsonWriterTest.withLockedWriter(writer -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.use(() -> writer.writeString(new char[]{'a'}, 0, -1))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("length"));
    }

    @Test
    void test_writeString_excessive_buffer() {
        JsonWriterTest.withLockedWriter(writer -> {
            char[] buffer = (Strings.repeat((String)"x", (int)writer.getMaxStringLength()) + 'y').toCharArray();
            String expectedJson = "\"" + Strings.repeat((String)"x", (int)writer.getMaxStringLength()) + writer.getTruncatedStringSuffix() + '\"';
            String actualJson = writer.use(() -> writer.writeString(buffer));
            Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
        });
    }

    @Test
    void test_writerString_excessive_buffer_ending_with_high_surrogate() {
        JsonWriterTest.withLockedWriter(writer -> {
            int maxStringLength = writer.getMaxStringLength();
            char[] buffer = (Strings.repeat((String)"x", (int)(maxStringLength - 1)) + HI_SURROGATE + LO_SURROGATE).toCharArray();
            String expectedJson = "\"" + Strings.repeat((String)"x", (int)(maxStringLength - 1)) + writer.getTruncatedStringSuffix() + '\"';
            String actualJson = writer.use(() -> writer.writeString(buffer));
            Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
        });
    }

    @Test
    void test_writeString_buffer() throws IOException {
        char[] buffer = new char[2];
        JsonWriterTest.testQuoting(codePoint -> {
            Character.toChars(codePoint, buffer, 0);
            return JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeString(buffer)));
        });
    }

    private static void testQuoting(Function<Integer, String> quoter) throws IOException {
        SoftAssertions assertions = new SoftAssertions();
        char[] surrogates = new char[2];
        Random random = new Random(0L);
        for (int codePoint = 0; codePoint <= 0x10FFFF; codePoint += Math.abs(random.nextInt(100))) {
            Character.toChars(codePoint, surrogates, 0);
            String s = new String(surrogates);
            String expectedJson = JacksonFixture.getObjectMapper().writeValueAsString((Object)s);
            String actualJson = quoter.apply(codePoint);
            ((StringAssert)assertions.assertThat(actualJson).as("codePoint='%s' (%d)", new Object[]{s, codePoint})).isEqualTo(expectedJson);
        }
        assertions.assertAll();
    }

    @Test
    void test_writeNumber_null_BigDecimal() {
        this.expectNull(writer -> writer.writeNumber((BigDecimal)null));
    }

    @Test
    void test_writeNumber_BigDecimal() {
        for (BigDecimal number : new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.TEN, new BigDecimal("92233720368547758079223372036854775807.92233720368547758079223372036854775807")}) {
            String expectedJson = String.valueOf(number);
            String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeNumber(number)));
            Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
        }
    }

    @Test
    void test_writeNumber_null_BigInteger() {
        this.expectNull(writer -> writer.writeNumber((BigInteger)null));
    }

    @Test
    void test_writeNumber_BigInteger() {
        for (BigInteger number : new BigInteger[]{BigInteger.ZERO, BigInteger.ONE, BigInteger.TEN, new BigInteger("92233720368547758079223372036854775807")}) {
            String expectedJson = String.valueOf(number);
            String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeNumber(number)));
            Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
        }
    }

    @Test
    void test_writeNumber_float() {
        for (float number : new float[]{Float.MIN_VALUE, -1.0f, 0.0f, 1.0f, Float.MAX_VALUE}) {
            String expectedJson = String.valueOf(number);
            String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeNumber(number)));
            Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
        }
    }

    @Test
    void test_writeNumber_double() {
        for (double number : new double[]{Double.MIN_VALUE, -1.0, 0.0, 1.0, Double.MAX_VALUE}) {
            String expectedJson = String.valueOf(number);
            String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeNumber(number)));
            Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
        }
    }

    @Test
    void test_writeNumber_short() {
        for (short number : new short[]{Short.MIN_VALUE, -1, 0, 1, Short.MAX_VALUE}) {
            String expectedJson = String.valueOf(number);
            String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeNumber(number)));
            Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
        }
    }

    @Test
    void test_writeNumber_int() {
        for (int number : new int[]{Integer.MIN_VALUE, -1, 0, 1, Integer.MAX_VALUE}) {
            String expectedJson = String.valueOf(number);
            String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeNumber(number)));
            Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
        }
    }

    @Test
    void test_writeNumber_long() {
        for (long number : new long[]{Long.MIN_VALUE, -1L, 0L, 1L, Long.MAX_VALUE}) {
            String expectedJson = String.valueOf(number);
            String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeNumber(number)));
            Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
        }
    }

    @Test
    void test_writeNumber_integral_and_negative_fractional() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonWriterTest.withLockedWriter(writer -> writer.use(() -> writer.writeNumber(0L, -1L)))).isInstanceOf(IllegalArgumentException.class)).hasMessage("was expecting a positive fraction: -1");
    }

    @Test
    void test_writeNumber_integral_and_zero_fractional() {
        String expectedJson = "123";
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeNumber(123L, 0L)));
        Assertions.assertThat((String)actualJson).isEqualTo("123");
    }

    @Test
    void test_writeNumber_integral_and_fractional() {
        String expectedJson = "123.456";
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeNumber(123L, 456L)));
        Assertions.assertThat((String)actualJson).isEqualTo("123.456");
    }

    @Test
    void test_writeBoolean_true() {
        String expectedJson = "true";
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeBoolean(true)));
        Assertions.assertThat((String)actualJson).isEqualTo("true");
    }

    @Test
    void test_writeBoolean_false() {
        String expectedJson = "false";
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeBoolean(false)));
        Assertions.assertThat((String)actualJson).isEqualTo("false");
    }

    @Test
    void test_writeNull() {
        this.expectNull(JsonWriter::writeNull);
    }

    private void expectNull(Consumer<JsonWriter> body) {
        String expectedJson = "null";
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> body.accept((JsonWriter)writer)));
        Assertions.assertThat((String)actualJson).isEqualTo("null");
    }

    @Test
    void test_writeRawString_null_seq() {
        JsonWriterTest.withLockedWriter(writer -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.use(() -> writer.writeRawString((CharSequence)null))).isInstanceOf(NullPointerException.class)).hasMessage("seq"));
    }

    @Test
    void test_writeRawString_seq_negative_offset() {
        JsonWriterTest.withLockedWriter(writer -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.use(() -> writer.writeRawString((CharSequence)"a", -1, 0))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("offset"));
    }

    @Test
    void test_writeRawString_seq_negative_length() {
        JsonWriterTest.withLockedWriter(writer -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.use(() -> writer.writeRawString((CharSequence)"a", 0, -1))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("length"));
    }

    @Test
    void test_writeRawString_seq() {
        String expectedJson = "this is not a valid JSON string";
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeRawString((CharSequence)"this is not a valid JSON string")));
        Assertions.assertThat((String)actualJson).isEqualTo("this is not a valid JSON string");
    }

    @Test
    void test_writeRawString_null_buffer() {
        JsonWriterTest.withLockedWriter(writer -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.use(() -> writer.writeRawString((char[])null))).isInstanceOf(NullPointerException.class)).hasMessage("buffer"));
    }

    @Test
    void test_writeRawString_buffer_negative_offset() {
        JsonWriterTest.withLockedWriter(writer -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.use(() -> writer.writeRawString(new char[]{'a'}, -1, 0))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("offset"));
    }

    @Test
    void test_writeRawString_buffer_negative_length() {
        JsonWriterTest.withLockedWriter(writer -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.use(() -> writer.writeRawString(new char[]{'a'}, 0, -1))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("length"));
    }

    @Test
    void test_writeRawString_buffer() {
        String expectedJson = "this is not a valid JSON string";
        String actualJson = JsonWriterTest.withLockedWriterReturning(writer -> writer.use(() -> writer.writeRawString("this is not a valid JSON string".toCharArray())));
        Assertions.assertThat((String)actualJson).isEqualTo("this is not a valid JSON string");
    }

    private static /* synthetic */ String lambda$test_writeObject_IndexedReadOnlyStringMap$15(IndexedReadOnlyStringMap map, JsonWriter writer) {
        return writer.use(() -> writer.writeObject(map));
    }

    private static /* synthetic */ String lambda$test_writeObject_StringMap$12(StringMap map, JsonWriter writer) {
        return writer.use(() -> writer.writeObject(map));
    }

    static {
        Character.toChars(65536, SURROGATE_PAIR, 0);
        HI_SURROGATE = SURROGATE_PAIR[0];
        LO_SURROGATE = SURROGATE_PAIR[1];
    }
}

