/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.layout.template.json.util.Uris;
import org.apache.logging.log4j.status.StatusLogger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class UrisTest {
    private static final Logger LOGGER = StatusLogger.getLogger();

    UrisTest() {
    }

    @Test
    void testClassPathResource() {
        String content = Uris.readUri((String)"classpath:JsonLayout.json", (Charset)StandardCharsets.US_ASCII);
        Assertions.assertThat((String)content).startsWith((CharSequence)"{");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testFilePathResource() throws IOException {
        String nonAsciiUtfText = "\u0b85\u0b86\u0b87\u0e2c\u0e58";
        File file = Files.createTempFile("log4j-UriUtilTest-", ".txt", new FileAttribute[0]).toFile();
        try {
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                ((OutputStream)outputStream).write("\u0b85\u0b86\u0b87\u0e2c\u0e58".getBytes(StandardCharsets.UTF_8));
            }
            URI uri = file.toURI();
            String content = Uris.readUri((URI)uri, (Charset)StandardCharsets.UTF_8);
            Assertions.assertThat((String)content).isEqualTo("\u0b85\u0b86\u0b87\u0e2c\u0e58");
        }
        finally {
            boolean deleted = file.delete();
            if (!deleted) {
                LOGGER.warn("could not delete temporary file: " + file);
            }
        }
    }
}

