/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.osgi.tests;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.osgi.tests.junit.BundleTestInfo;
import org.apache.logging.log4j.osgi.tests.junit.OsgiRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.FrameworkFactory;

public abstract class AbstractLoadBundleTest {
    private BundleContext bundleContext;
    private final BundleTestInfo bundleTestInfo;
    private Path here;
    @Rule
    public OsgiRule osgi = new OsgiRule(this.getFactory());

    public AbstractLoadBundleTest() {
        this.bundleTestInfo = new BundleTestInfo();
    }

    @Before
    public void before() throws BundleException {
        this.bundleContext = this.osgi.getFramework().getBundleContext();
        this.here = Paths.get(".", new String[0]).toAbsolutePath().normalize();
    }

    private Bundle getApiBundle() throws BundleException {
        Path apiPath = this.here.resolveSibling("log4j-api").resolve("target").resolve("log4j-api-" + this.bundleTestInfo.getVersion() + ".jar");
        return this.bundleContext.installBundle(apiPath.toUri().toString());
    }

    private Bundle getCoreBundle() throws BundleException {
        Path corePath = this.here.resolveSibling("log4j-core").resolve("target").resolve("log4j-core-" + this.bundleTestInfo.getVersion() + ".jar");
        return this.bundleContext.installBundle(corePath.toUri().toString());
    }

    private Bundle getDummyBundle() throws BundleException {
        Path dumyPath = this.here.resolveSibling("log4j-samples").resolve("log4j-samples-configuration").resolve("target").resolve("log4j-samples-configuration-" + this.bundleTestInfo.getVersion() + ".jar");
        return this.bundleContext.installBundle(dumyPath.toUri().toString());
    }

    private Bundle get12ApiBundle() throws BundleException {
        Path apiPath = this.here.resolveSibling("log4j-1.2-api").resolve("target").resolve("log4j-1.2-api-" + this.bundleTestInfo.getVersion() + ".jar");
        return this.bundleContext.installBundle(apiPath.toUri().toString());
    }

    protected abstract FrameworkFactory getFactory();

    private void log(Bundle dummy) throws ReflectiveOperationException {
        Class logManagerClass = dummy.loadClass("org.apache.logging.log4j.LogManager");
        Method getLoggerMethod = logManagerClass.getMethod("getLogger", Class.class);
        Class loggerClass = dummy.loadClass("org.apache.logging.log4j.configuration.CustomConfiguration");
        Object logger = getLoggerMethod.invoke(null, loggerClass);
        Method errorMethod = logger.getClass().getMethod("error", Object.class);
        errorMethod.invoke(logger, "Test OK");
    }

    private PrintStream setupStream(Bundle api, PrintStream newStream) throws ReflectiveOperationException {
        Class statusLoggerClass = api.loadClass("org.apache.logging.log4j.status.StatusLogger");
        Field statusLoggerField = statusLoggerClass.getDeclaredField("STATUS_LOGGER");
        statusLoggerField.setAccessible(true);
        Object statusLoggerFieldValue = statusLoggerField.get(null);
        Field loggerField = statusLoggerClass.getDeclaredField("logger");
        loggerField.setAccessible(true);
        Object loggerFieldValue = loggerField.get(statusLoggerFieldValue);
        Class simpleLoggerClass = api.loadClass("org.apache.logging.log4j.simple.SimpleLogger");
        Field streamField = simpleLoggerClass.getDeclaredField("stream");
        streamField.setAccessible(true);
        PrintStream oldStream = (PrintStream)streamField.get(loggerFieldValue);
        streamField.set(loggerFieldValue, newStream);
        return oldStream;
    }

    private void start(Bundle api, Bundle core, Bundle dummy) throws BundleException {
        api.start();
        core.start();
        dummy.start();
    }

    private void stop(Bundle api, Bundle core, Bundle dummy) throws BundleException {
        dummy.stop();
        core.stop();
        api.stop();
    }

    private void uninstall(Bundle api, Bundle core, Bundle dummy) throws BundleException {
        dummy.uninstall();
        core.uninstall();
        api.uninstall();
    }

    @Test
    public void testApiCoreStartStopStartStop() throws BundleException, ReflectiveOperationException {
        Bundle api = this.getApiBundle();
        Bundle core = this.getCoreBundle();
        Assert.assertEquals((String)"api is not in INSTALLED state", (long)2L, (long)api.getState());
        Assert.assertEquals((String)"core is not in INSTALLED state", (long)2L, (long)core.getState());
        api.start();
        core.start();
        Assert.assertEquals((String)"api is not in ACTIVE state", (long)32L, (long)api.getState());
        Assert.assertEquals((String)"core is not in ACTIVE state", (long)32L, (long)core.getState());
        core.stop();
        api.stop();
        Assert.assertEquals((String)"api is not in RESOLVED state", (long)4L, (long)api.getState());
        Assert.assertEquals((String)"core is not in RESOLVED state", (long)4L, (long)core.getState());
        api.start();
        core.start();
        Assert.assertEquals((String)"api is not in ACTIVE state", (long)32L, (long)api.getState());
        Assert.assertEquals((String)"core is not in ACTIVE state", (long)32L, (long)core.getState());
        core.stop();
        api.stop();
        Assert.assertEquals((String)"api is not in RESOLVED state", (long)4L, (long)api.getState());
        Assert.assertEquals((String)"core is not in RESOLVED state", (long)4L, (long)core.getState());
        core.uninstall();
        api.uninstall();
        Assert.assertEquals((String)"api is not in UNINSTALLED state", (long)1L, (long)api.getState());
        Assert.assertEquals((String)"core is not in UNINSTALLED state", (long)1L, (long)core.getState());
    }

    @Test
    public void testClassNotFoundErrorLogger() throws BundleException {
        Bundle core;
        Bundle api;
        block3: {
            api = this.getApiBundle();
            core = this.getCoreBundle();
            api.start();
            try {
                core.start();
            }
            catch (BundleException ex) {
                Throwable t2;
                boolean shouldRethrow = true;
                Throwable t = ex.getCause();
                if (t != null && (t2 = t.getCause()) != null) {
                    String cause = t2.toString();
                    boolean result = cause.equals("java.lang.ClassNotFoundException: org.apache.logging.log4j.Logger") || cause.equals("java.lang.ClassNotFoundException: org.apache.logging.log4j.Logger not found by org.apache.logging.log4j.core [2]");
                    Assert.assertFalse((String)"org.apache.logging.log4j package is not properly imported in org.apache.logging.log4j.core bundle, check that the package is exported from api and is not split between api and core", (boolean)result);
                    boolean bl = shouldRethrow = !result;
                }
                if (!shouldRethrow) break block3;
                throw ex;
            }
        }
        core.stop();
        api.stop();
        core.uninstall();
        api.uninstall();
    }

    @Test
    public void testLoadingOfConfigurableCoreClasses() throws BundleException, ReflectiveOperationException {
        Bundle api = this.getApiBundle();
        Bundle core = this.getCoreBundle();
        Bundle dummy = this.getDummyBundle();
        this.start(api, core, dummy);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream logStream = new PrintStream(baos);
        PrintStream bakStream = this.setupStream(api, logStream);
        this.log(dummy);
        this.setupStream(api, bakStream);
        boolean result = baos.toString().contains("BundleContextSelector cannot be found");
        Assert.assertFalse((String)"Core class BundleContextSelector cannot be loaded in OSGI setup", (boolean)result);
        this.stop(api, core, dummy);
        this.uninstall(api, core, dummy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleLogInAnOsgiContext() throws BundleException, ReflectiveOperationException {
        Bundle api = this.getApiBundle();
        Bundle core = this.getCoreBundle();
        Bundle dummy = this.getDummyBundle();
        this.start(api, core, dummy);
        PrintStream bakStream = System.out;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream logStream = new PrintStream(baos);
            System.setOut(logStream);
            this.log(dummy);
            String result = baos.toString().substring(12).trim();
            Assert.assertEquals((Object)"[main] ERROR org.apache.logging.log4j.configuration.CustomConfiguration - Test OK", (Object)result);
        }
        finally {
            System.setOut(bakStream);
        }
        this.stop(api, core, dummy);
        this.uninstall(api, core, dummy);
    }

    @Test
    public void testLog4J12Fragement() throws BundleException, ReflectiveOperationException {
        Bundle api = this.getApiBundle();
        Bundle core = this.getCoreBundle();
        Bundle compat = this.get12ApiBundle();
        api.start();
        core.start();
        Class coreClassFromCore = core.loadClass("org.apache.logging.log4j.core.Core");
        Class levelClassFrom12API = core.loadClass("org.apache.log4j.Level");
        Class levelClassFromAPI = core.loadClass("org.apache.logging.log4j.Level");
        Assert.assertEquals((String)"expected 1.2 API Level to have the same class loader as Core", (Object)levelClassFrom12API.getClassLoader(), (Object)coreClassFromCore.getClassLoader());
        Assert.assertNotEquals((String)"expected 1.2 API Level NOT to have the same class loader as API Level", (Object)levelClassFrom12API.getClassLoader(), (Object)levelClassFromAPI.getClassLoader());
        core.stop();
        api.stop();
        this.uninstall(api, core, compat);
    }
}

