/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.osgi.tests.junit;

import java.util.HashMap;
import org.junit.rules.ExternalResource;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public class OsgiRule
extends ExternalResource {
    private final FrameworkFactory factory;
    private Framework framework;

    public OsgiRule(FrameworkFactory factory) {
        this.factory = factory;
    }

    protected void after() {
        if (this.framework != null) {
            try {
                this.framework.stop();
            }
            catch (BundleException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.framework = null;
            }
        }
    }

    protected void before() throws Throwable {
        HashMap<String, String> configMap = new HashMap<String, String>(2);
        configMap.put("org.osgi.framework.storage.clean", "onFirstInit");
        configMap.put("felix.log.level", "4");
        configMap.put("eclipse.log.level", "ALL");
        configMap.put("felix.cache.locking", "false");
        this.framework = this.factory.newFramework(configMap);
        this.framework.init();
        this.framework.start();
    }

    public Framework getFramework() {
        return this.framework;
    }

    public String toString() {
        return "OsgiRule [factory=" + this.factory + ", framework=" + this.framework + "]";
    }
}

