/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.CreateIndexTask;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;

public class OpenReaderTask
extends PerfTask {
    public static final String USER_DATA = "userData";
    private boolean readOnly = true;
    private String commitUserData = null;

    public OpenReaderTask(PerfRunData runData) {
        super(runData);
    }

    public int doLogic() throws IOException {
        Directory dir = this.getRunData().getDirectory();
        Config config = this.getRunData().getConfig();
        IndexReader r = null;
        IndexDeletionPolicy deletionPolicy = this.readOnly ? null : CreateIndexTask.getIndexDeletionPolicy(config);
        r = this.commitUserData != null ? IndexReader.open((IndexCommit)OpenReaderTask.findIndexCommit(dir, this.commitUserData), (IndexDeletionPolicy)deletionPolicy, (boolean)this.readOnly) : IndexReader.open((Directory)dir, (IndexDeletionPolicy)deletionPolicy, (boolean)this.readOnly);
        this.getRunData().setIndexReader(r);
        r.decRef();
        return 1;
    }

    public void setParams(String params) {
        super.setParams(params);
        if (params != null) {
            String[] split = params.split(",");
            if (split.length > 0) {
                this.readOnly = Boolean.valueOf(split[0]);
            }
            if (split.length > 1) {
                this.commitUserData = split[1];
            }
        }
    }

    public boolean supportsParams() {
        return true;
    }

    public static IndexCommit findIndexCommit(Directory dir, String userData) throws IOException {
        Collection commits = IndexReader.listCommits((Directory)dir);
        for (IndexCommit ic : commits) {
            Map map = ic.getUserData();
            String ud = null;
            if (map != null) {
                ud = (String)map.get(USER_DATA);
            }
            if (ud == null || !ud.equals(userData)) continue;
            return ic;
        }
        throw new IOException("index does not contain commit with userData: " + userData);
    }
}

