/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.QueryMaker;
import org.apache.lucene.benchmark.byTask.tasks.ReadTask;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public class SearchWithSortTask
extends ReadTask {
    private boolean doScore = true;
    private boolean doMaxScore = true;
    private Sort sort;

    public SearchWithSortTask(PerfRunData runData) {
        super(runData);
    }

    public void setParams(String sortField) {
        super.setParams(sortField);
        String[] fields = sortField.split(",");
        SortField[] sortFields = new SortField[fields.length];
        int upto = 0;
        for (int i = 0; i < fields.length; ++i) {
            SortField sortField0;
            String field = fields[i];
            if (field.equals("doc")) {
                sortField0 = SortField.FIELD_DOC;
            } else if (field.equals("score")) {
                sortField0 = SortField.FIELD_SCORE;
            } else {
                if (field.equals("noscore")) {
                    this.doScore = false;
                    continue;
                }
                if (field.equals("nomaxscore")) {
                    this.doMaxScore = false;
                    continue;
                }
                int index = field.lastIndexOf(":");
                if (index == -1) {
                    throw new RuntimeException("You must specify the sort type ie page:int,subject:string");
                }
                String fieldName = field.substring(0, index);
                String typeString = field.substring(1 + index, field.length());
                int type = this.getType(typeString);
                sortField0 = new SortField(fieldName, type);
            }
            sortFields[upto++] = sortField0;
        }
        if (upto < sortFields.length) {
            SortField[] newSortFields = new SortField[upto];
            System.arraycopy(sortFields, 0, newSortFields, 0, upto);
            sortFields = newSortFields;
        }
        this.sort = new Sort(sortFields);
    }

    private int getType(String typeString) {
        int type;
        if (typeString.equals("float")) {
            type = 5;
        } else if (typeString.equals("double")) {
            type = 7;
        } else if (typeString.equals("byte")) {
            type = 10;
        } else if (typeString.equals("short")) {
            type = 8;
        } else if (typeString.equals("int")) {
            type = 4;
        } else if (typeString.equals("long")) {
            type = 6;
        } else if (typeString.equals("string")) {
            type = 3;
        } else if (typeString.equals("string_val")) {
            type = 11;
        } else {
            throw new RuntimeException("Unrecognized sort field type " + typeString);
        }
        return type;
    }

    public boolean supportsParams() {
        return true;
    }

    public QueryMaker getQueryMaker() {
        return this.getRunData().getQueryMaker(this);
    }

    public boolean withRetrieve() {
        return false;
    }

    public boolean withSearch() {
        return true;
    }

    public boolean withTraverse() {
        return false;
    }

    public boolean withWarm() {
        return false;
    }

    public boolean withScore() {
        return this.doScore;
    }

    public boolean withMaxScore() {
        return this.doMaxScore;
    }

    public Sort getSort() {
        if (this.sort == null) {
            throw new IllegalStateException("No sort field was set");
        }
        return this.sort;
    }
}

