/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.OrdTermState;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.RunAutomaton;
import org.apache.lucene.util.automaton.Transition;

public final class DirectPostingsFormat
extends PostingsFormat {
    private final int minSkipCount;
    private final int lowFreqCutoff;
    private static final int DEFAULT_MIN_SKIP_COUNT = 8;
    private static final int DEFAULT_LOW_FREQ_CUTOFF = 32;

    public DirectPostingsFormat() {
        this(8, 32);
    }

    public DirectPostingsFormat(int minSkipCount, int lowFreqCutoff) {
        super("Direct");
        this.minSkipCount = minSkipCount;
        this.lowFreqCutoff = lowFreqCutoff;
    }

    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return PostingsFormat.forName((String)"Lucene50").fieldsConsumer(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        FieldsProducer postings = PostingsFormat.forName((String)"Lucene50").fieldsProducer(state);
        if (state.context.context != IOContext.Context.MERGE) {
            DirectFields loadedPostings;
            try {
                postings.checkIntegrity();
                loadedPostings = new DirectFields(state, (Fields)postings, this.minSkipCount, this.lowFreqCutoff);
            }
            finally {
                postings.close();
            }
            return loadedPostings;
        }
        return postings;
    }

    private static final class HighFreqPostingsEnum
    extends PostingsEnum {
        private int[] docIDs;
        private int[] freqs;
        private int[][] positions;
        private byte[][][] payloads;
        private final boolean hasOffsets;
        private final int posJump;
        private int upto;
        private int docID = -1;
        private int posUpto;
        private int[] curPositions;
        private final BytesRef payload = new BytesRef();

        public HighFreqPostingsEnum(boolean hasOffsets) {
            this.hasOffsets = hasOffsets;
            this.posJump = hasOffsets ? 3 : 1;
        }

        public int[] getDocIDs() {
            return this.docIDs;
        }

        public int[][] getPositions() {
            return this.positions;
        }

        public int getPosJump() {
            return this.posJump;
        }

        public PostingsEnum reset(int[] docIDs, int[] freqs, int[][] positions, byte[][][] payloads) {
            this.docIDs = docIDs;
            this.freqs = freqs;
            this.positions = positions;
            this.payloads = payloads;
            this.upto = -1;
            return this;
        }

        public int nextDoc() {
            ++this.upto;
            if (this.upto < this.docIDs.length) {
                this.posUpto = -this.posJump;
                this.curPositions = this.positions[this.upto];
                this.docID = this.docIDs[this.upto];
                return this.docID;
            }
            this.docID = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        public int freq() {
            return this.freqs[this.upto];
        }

        public int docID() {
            return this.docID;
        }

        public int nextPosition() {
            this.posUpto += this.posJump;
            assert (this.posUpto < this.curPositions.length);
            return this.curPositions[this.posUpto];
        }

        public int startOffset() {
            if (this.hasOffsets) {
                return this.curPositions[this.posUpto + 1];
            }
            return -1;
        }

        public int endOffset() {
            if (this.hasOffsets) {
                return this.curPositions[this.posUpto + 2];
            }
            return -1;
        }

        public int advance(int target) {
            block8: {
                int mid;
                int high;
                int low;
                ++this.upto;
                if (this.upto == this.docIDs.length) {
                    this.docID = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                int inc = 10;
                int nextUpto = this.upto + 10;
                while (true) {
                    if (nextUpto >= this.docIDs.length) {
                        low = nextUpto - inc;
                        high = this.docIDs.length - 1;
                        break;
                    }
                    if (target <= this.docIDs[nextUpto]) {
                        low = nextUpto - inc;
                        high = nextUpto;
                        break;
                    }
                    nextUpto += (inc *= 2);
                }
                while (true) {
                    if (low > high) {
                        this.upto = low;
                        break block8;
                    }
                    mid = low + high >>> 1;
                    int cmp = this.docIDs[mid] - target;
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp <= 0) break;
                    high = mid - 1;
                }
                this.upto = mid;
            }
            if (this.upto == this.docIDs.length) {
                this.docID = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.posUpto = -this.posJump;
            this.curPositions = this.positions[this.upto];
            this.docID = this.docIDs[this.upto];
            return this.docID;
        }

        public BytesRef getPayload() {
            if (this.payloads == null) {
                return null;
            }
            byte[] payloadBytes = this.payloads[this.upto][this.posUpto / (this.hasOffsets ? 3 : 1)];
            if (payloadBytes == null) {
                return null;
            }
            this.payload.bytes = payloadBytes;
            this.payload.length = payloadBytes.length;
            this.payload.offset = 0;
            return this.payload;
        }

        public long cost() {
            return this.docIDs.length;
        }
    }

    private static final class HighFreqDocsEnum
    extends PostingsEnum {
        private int[] docIDs;
        private int[] freqs;
        private int upto;
        private int docID = -1;

        public int[] getDocIDs() {
            return this.docIDs;
        }

        public int[] getFreqs() {
            return this.freqs;
        }

        public PostingsEnum reset(int[] docIDs, int[] freqs) {
            this.docIDs = docIDs;
            this.freqs = freqs;
            this.upto = -1;
            this.docID = -1;
            return this;
        }

        public int nextDoc() {
            ++this.upto;
            try {
                this.docID = this.docIDs[this.upto];
                return this.docID;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.docID = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
        }

        public int docID() {
            return this.docID;
        }

        public int freq() {
            if (this.freqs == null) {
                return 1;
            }
            return this.freqs[this.upto];
        }

        public int advance(int target) {
            block8: {
                int mid;
                int high;
                int low;
                ++this.upto;
                if (this.upto == this.docIDs.length) {
                    this.docID = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                int inc = 10;
                int nextUpto = this.upto + 10;
                while (true) {
                    if (nextUpto >= this.docIDs.length) {
                        low = nextUpto - inc;
                        high = this.docIDs.length - 1;
                        break;
                    }
                    if (target <= this.docIDs[nextUpto]) {
                        low = nextUpto - inc;
                        high = nextUpto;
                        break;
                    }
                    nextUpto += (inc *= 2);
                }
                while (true) {
                    if (low > high) {
                        this.upto = low;
                        break block8;
                    }
                    mid = low + high >>> 1;
                    int cmp = this.docIDs[mid] - target;
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp <= 0) break;
                    high = mid - 1;
                }
                this.upto = mid;
            }
            if (this.upto == this.docIDs.length) {
                this.docID = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.docID = this.docIDs[this.upto];
            return this.docID;
        }

        public long cost() {
            return this.docIDs.length;
        }

        public int nextPosition() throws IOException {
            return -1;
        }

        public int startOffset() throws IOException {
            return -1;
        }

        public int endOffset() throws IOException {
            return -1;
        }

        public BytesRef getPayload() throws IOException {
            return null;
        }
    }

    private static final class LowFreqPostingsEnum
    extends PostingsEnum {
        private int[] postings;
        private final int posMult;
        private final boolean hasOffsets;
        private final boolean hasPayloads;
        private final BytesRef payload = new BytesRef();
        private int upto;
        private int docID;
        private int freq;
        private int skipPositions;
        private int pos;
        private int startOffset;
        private int endOffset;
        private int lastPayloadOffset;
        private int payloadOffset;
        private int payloadLength;
        private byte[] payloadBytes;

        public LowFreqPostingsEnum(boolean hasOffsets, boolean hasPayloads) {
            this.hasOffsets = hasOffsets;
            this.hasPayloads = hasPayloads;
            this.posMult = hasOffsets ? (hasPayloads ? 4 : 3) : (hasPayloads ? 2 : 1);
        }

        public PostingsEnum reset(int[] postings, byte[] payloadBytes) {
            this.postings = postings;
            this.upto = 0;
            this.skipPositions = 0;
            this.pos = -1;
            this.startOffset = -1;
            this.endOffset = -1;
            this.docID = -1;
            this.payloadLength = 0;
            this.payloadBytes = payloadBytes;
            return this;
        }

        public int nextDoc() {
            this.pos = -1;
            if (this.hasPayloads) {
                for (int i = 0; i < this.skipPositions; ++i) {
                    ++this.upto;
                    if (this.hasOffsets) {
                        this.upto += 2;
                    }
                    this.payloadOffset += this.postings[this.upto++];
                }
            } else {
                this.upto += this.posMult * this.skipPositions;
            }
            if (this.upto < this.postings.length) {
                this.docID = this.postings[this.upto++];
                this.skipPositions = this.freq = this.postings[this.upto++];
                return this.docID;
            }
            this.docID = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        public int docID() {
            return this.docID;
        }

        public int freq() {
            return this.freq;
        }

        public int nextPosition() {
            assert (this.skipPositions > 0);
            --this.skipPositions;
            this.pos = this.postings[this.upto++];
            if (this.hasOffsets) {
                this.startOffset = this.postings[this.upto++];
                this.endOffset = this.postings[this.upto++];
            }
            if (this.hasPayloads) {
                this.payloadLength = this.postings[this.upto++];
                this.lastPayloadOffset = this.payloadOffset;
                this.payloadOffset += this.payloadLength;
            }
            return this.pos;
        }

        public int startOffset() {
            return this.startOffset;
        }

        public int endOffset() {
            return this.endOffset;
        }

        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        public BytesRef getPayload() {
            if (this.payloadLength > 0) {
                this.payload.bytes = this.payloadBytes;
                this.payload.offset = this.lastPayloadOffset;
                this.payload.length = this.payloadLength;
                return this.payload;
            }
            return null;
        }

        public long cost() {
            return this.postings.length / 2;
        }
    }

    private static final class LowFreqDocsEnum
    extends PostingsEnum {
        private int[] postings;
        private final int posMult;
        private int upto;
        private int freq;

        public LowFreqDocsEnum(int posMult) {
            this.posMult = posMult;
        }

        public boolean canReuse(int posMult) {
            return this.posMult == posMult;
        }

        public PostingsEnum reset(int[] postings) {
            this.postings = postings;
            this.upto = -2;
            this.freq = 0;
            return this;
        }

        public int nextDoc() {
            this.upto += 2 + this.freq * this.posMult;
            if (this.upto < this.postings.length) {
                this.freq = this.postings[this.upto + 1];
                assert (this.freq > 0);
                return this.postings[this.upto];
            }
            return Integer.MAX_VALUE;
        }

        public int docID() {
            if (this.upto < 0) {
                return -1;
            }
            if (this.upto < this.postings.length) {
                return this.postings[this.upto];
            }
            return Integer.MAX_VALUE;
        }

        public int freq() {
            return this.freq;
        }

        public int nextPosition() throws IOException {
            return -1;
        }

        public int startOffset() throws IOException {
            return -1;
        }

        public int endOffset() throws IOException {
            return -1;
        }

        public BytesRef getPayload() throws IOException {
            return null;
        }

        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        public long cost() {
            return this.postings.length / 2;
        }
    }

    private static final class LowFreqDocsEnumNoPos
    extends PostingsEnum {
        private int[] postings;
        private int upto;

        public PostingsEnum reset(int[] postings) {
            this.postings = postings;
            this.upto = -2;
            return this;
        }

        public int nextDoc() {
            this.upto += 2;
            if (this.upto < this.postings.length) {
                return this.postings[this.upto];
            }
            return Integer.MAX_VALUE;
        }

        public int docID() {
            if (this.upto < 0) {
                return -1;
            }
            if (this.upto < this.postings.length) {
                return this.postings[this.upto];
            }
            return Integer.MAX_VALUE;
        }

        public int freq() {
            return this.postings[this.upto + 1];
        }

        public int nextPosition() throws IOException {
            return -1;
        }

        public int startOffset() throws IOException {
            return -1;
        }

        public int endOffset() throws IOException {
            return -1;
        }

        public BytesRef getPayload() throws IOException {
            return null;
        }

        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        public long cost() {
            return this.postings.length / 2;
        }
    }

    private static final class LowFreqDocsEnumNoTF
    extends PostingsEnum {
        private int[] postings;
        private int upto;

        private LowFreqDocsEnumNoTF() {
        }

        public PostingsEnum reset(int[] postings) {
            this.postings = postings;
            this.upto = -1;
            return this;
        }

        public int nextDoc() {
            ++this.upto;
            if (this.upto < this.postings.length) {
                return this.postings[this.upto];
            }
            return Integer.MAX_VALUE;
        }

        public int docID() {
            if (this.upto < 0) {
                return -1;
            }
            if (this.upto < this.postings.length) {
                return this.postings[this.upto];
            }
            return Integer.MAX_VALUE;
        }

        public int freq() {
            return 1;
        }

        public int nextPosition() throws IOException {
            return -1;
        }

        public int startOffset() throws IOException {
            return -1;
        }

        public int endOffset() throws IOException {
            return -1;
        }

        public BytesRef getPayload() throws IOException {
            return null;
        }

        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        public long cost() {
            return this.postings.length;
        }
    }

    private static final class DirectField
    extends Terms
    implements Accountable {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DirectField.class);
        private final byte[] termBytes;
        private final int[] termOffsets;
        private final int[] skips;
        private final int[] skipOffsets;
        private final TermAndSkip[] terms;
        private final boolean hasFreq;
        private final boolean hasPos;
        private final boolean hasOffsets;
        private final boolean hasPayloads;
        private final long sumTotalTermFreq;
        private final int docCount;
        private final long sumDocFreq;
        private int skipCount;
        private int count;
        private int[] sameCounts = new int[10];
        private final int minSkipCount;

        public DirectField(SegmentReadState state, String field, Terms termsIn, int minSkipCount, int lowFreqCutoff) throws IOException {
            BytesRef term;
            FieldInfo fieldInfo = state.fieldInfos.fieldInfo(field);
            this.sumTotalTermFreq = termsIn.getSumTotalTermFreq();
            this.sumDocFreq = termsIn.getSumDocFreq();
            this.docCount = termsIn.getDocCount();
            int numTerms = (int)termsIn.size();
            if (numTerms == -1) {
                throw new IllegalArgumentException("codec does not provide Terms.size()");
            }
            this.terms = new TermAndSkip[numTerms];
            this.termOffsets = new int[1 + numTerms];
            byte[] termBytes = new byte[1024];
            this.minSkipCount = minSkipCount;
            this.hasFreq = fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS) > 0;
            this.hasPos = fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) > 0;
            this.hasOffsets = fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) > 0;
            this.hasPayloads = fieldInfo.hasPayloads();
            PostingsEnum postingsEnum = null;
            PostingsEnum docsAndPositionsEnum = null;
            TermsEnum termsEnum = termsIn.iterator();
            int termOffset = 0;
            IntArrayWriter scratch = new IntArrayWriter();
            RAMOutputStream ros = new RAMOutputStream();
            while ((term = termsEnum.next()) != null) {
                TermAndSkip ent;
                int docID;
                int docFreq = termsEnum.docFreq();
                long totalTermFreq = termsEnum.totalTermFreq();
                this.termOffsets[this.count] = termOffset;
                if (termBytes.length < termOffset + term.length) {
                    termBytes = ArrayUtil.grow((byte[])termBytes, (int)(termOffset + term.length));
                }
                System.arraycopy(term.bytes, term.offset, termBytes, termOffset, term.length);
                this.termOffsets[this.count + 1] = termOffset += term.length;
                if (this.hasPos) {
                    docsAndPositionsEnum = termsEnum.postings(docsAndPositionsEnum, 120);
                } else {
                    postingsEnum = termsEnum.postings(postingsEnum);
                }
                PostingsEnum postingsEnum2 = this.hasPos ? docsAndPositionsEnum : postingsEnum;
                if (docFreq <= lowFreqCutoff) {
                    byte[] payloads;
                    ros.reset();
                    while ((docID = postingsEnum2.nextDoc()) != Integer.MAX_VALUE) {
                        scratch.add(docID);
                        if (!this.hasFreq) continue;
                        int freq = postingsEnum2.freq();
                        scratch.add(freq);
                        if (!this.hasPos) continue;
                        for (int pos = 0; pos < freq; ++pos) {
                            scratch.add(docsAndPositionsEnum.nextPosition());
                            if (this.hasOffsets) {
                                scratch.add(docsAndPositionsEnum.startOffset());
                                scratch.add(docsAndPositionsEnum.endOffset());
                            }
                            if (!this.hasPayloads) continue;
                            BytesRef payload = docsAndPositionsEnum.getPayload();
                            if (payload != null) {
                                scratch.add(payload.length);
                                ros.writeBytes(payload.bytes, payload.offset, payload.length);
                                continue;
                            }
                            scratch.add(0);
                        }
                    }
                    if (this.hasPayloads) {
                        payloads = new byte[(int)ros.getFilePointer()];
                        ros.writeTo(payloads, 0);
                    } else {
                        payloads = null;
                    }
                    int[] postings = scratch.get();
                    ent = new LowFreqTerm(postings, payloads, docFreq, (int)totalTermFreq);
                } else {
                    Object payloads;
                    Object positions;
                    int[] freqs;
                    int[] docs = new int[docFreq];
                    if (this.hasFreq) {
                        freqs = new int[docFreq];
                        if (this.hasPos) {
                            positions = new int[docFreq][];
                            payloads = this.hasPayloads ? (Object)new byte[docFreq][][] : (byte[][][])null;
                        } else {
                            positions = null;
                            payloads = null;
                        }
                    } else {
                        freqs = null;
                        positions = null;
                        payloads = null;
                    }
                    int upto = 0;
                    while ((docID = postingsEnum2.nextDoc()) != Integer.MAX_VALUE) {
                        docs[upto] = docID;
                        if (this.hasFreq) {
                            int freq;
                            freqs[upto] = freq = postingsEnum2.freq();
                            if (this.hasPos) {
                                int mult = this.hasOffsets ? 3 : 1;
                                if (this.hasPayloads) {
                                    payloads[upto] = new byte[freq][];
                                }
                                positions[upto] = new int[mult * freq];
                                int posUpto = 0;
                                for (int pos = 0; pos < freq; ++pos) {
                                    BytesRef payload;
                                    positions[upto][posUpto] = docsAndPositionsEnum.nextPosition();
                                    if (this.hasPayloads && (payload = docsAndPositionsEnum.getPayload()) != null) {
                                        byte[] payloadBytes = new byte[payload.length];
                                        System.arraycopy(payload.bytes, payload.offset, payloadBytes, 0, payload.length);
                                        payloads[upto][pos] = payloadBytes;
                                    }
                                    ++posUpto;
                                    if (!this.hasOffsets) continue;
                                    positions[upto][posUpto++] = docsAndPositionsEnum.startOffset();
                                    positions[upto][posUpto++] = docsAndPositionsEnum.endOffset();
                                }
                            }
                        }
                        ++upto;
                    }
                    assert (upto == docFreq);
                    ent = new HighFreqTerm(docs, freqs, (int[][])positions, (byte[][][])payloads, totalTermFreq);
                }
                this.terms[this.count] = ent;
                this.setSkips(this.count, termBytes);
                ++this.count;
            }
            this.termOffsets[this.count] = termOffset;
            this.finishSkips();
            this.termBytes = new byte[termOffset];
            System.arraycopy(termBytes, 0, this.termBytes, 0, termOffset);
            this.skips = new int[this.skipCount];
            this.skipOffsets = new int[1 + numTerms];
            int skipOffset = 0;
            for (int i = 0; i < numTerms; ++i) {
                int[] termSkips = this.terms[i].skips;
                this.skipOffsets[i] = skipOffset;
                if (termSkips == null) continue;
                System.arraycopy(termSkips, 0, this.skips, skipOffset, termSkips.length);
                skipOffset += termSkips.length;
                this.terms[i].skips = null;
            }
            this.skipOffsets[numTerms] = skipOffset;
            assert (skipOffset == this.skipCount);
        }

        public long ramBytesUsed() {
            long sizeInBytes = BASE_RAM_BYTES_USED;
            sizeInBytes += this.termBytes != null ? RamUsageEstimator.sizeOf((byte[])this.termBytes) : 0L;
            sizeInBytes += this.termOffsets != null ? RamUsageEstimator.sizeOf((int[])this.termOffsets) : 0L;
            sizeInBytes += this.skips != null ? RamUsageEstimator.sizeOf((int[])this.skips) : 0L;
            sizeInBytes += this.skipOffsets != null ? RamUsageEstimator.sizeOf((int[])this.skipOffsets) : 0L;
            sizeInBytes += this.sameCounts != null ? RamUsageEstimator.sizeOf((int[])this.sameCounts) : 0L;
            if (this.terms != null) {
                sizeInBytes += RamUsageEstimator.shallowSizeOf((Object[])this.terms);
                for (TermAndSkip termAndSkip : this.terms) {
                    sizeInBytes += termAndSkip != null ? termAndSkip.ramBytesUsed() : 0L;
                }
            }
            return sizeInBytes;
        }

        public String toString() {
            return "DirectTerms(terms=" + this.terms.length + ",postings=" + this.sumDocFreq + ",positions=" + this.sumTotalTermFreq + ",docs=" + this.docCount + ")";
        }

        int compare(int ord, BytesRef other) {
            byte[] otherBytes = other.bytes;
            int upto = this.termOffsets[ord];
            int termLen = this.termOffsets[1 + ord] - upto;
            int otherUpto = other.offset;
            int stop = upto + Math.min(termLen, other.length);
            while (upto < stop) {
                int diff;
                if ((diff = (this.termBytes[upto++] & 0xFF) - (otherBytes[otherUpto++] & 0xFF)) == 0) continue;
                return diff;
            }
            return termLen - other.length;
        }

        private void setSkips(int termOrd, byte[] termBytes) {
            int termLength = this.termOffsets[termOrd + 1] - this.termOffsets[termOrd];
            if (this.sameCounts.length < termLength) {
                this.sameCounts = ArrayUtil.grow((int[])this.sameCounts, (int)termLength);
            }
            if (termOrd > 0) {
                int lastTermLength = this.termOffsets[termOrd] - this.termOffsets[termOrd - 1];
                int limit = Math.min(termLength, lastTermLength);
                int lastTermOffset = this.termOffsets[termOrd - 1];
                int termOffset = this.termOffsets[termOrd];
                int i = 0;
                while (i < limit) {
                    if (termBytes[lastTermOffset++] == termBytes[termOffset++]) {
                        int n = i++;
                        this.sameCounts[n] = this.sameCounts[n] + 1;
                        continue;
                    }
                    while (i < limit) {
                        if (this.sameCounts[i] >= this.minSkipCount) {
                            this.saveSkip(termOrd, this.sameCounts[i]);
                        }
                        this.sameCounts[i] = 1;
                        ++i;
                    }
                    break;
                }
                while (i < lastTermLength) {
                    if (this.sameCounts[i] >= this.minSkipCount) {
                        this.saveSkip(termOrd, this.sameCounts[i]);
                    }
                    this.sameCounts[i] = 0;
                    ++i;
                }
                for (int j = limit; j < termLength; ++j) {
                    this.sameCounts[j] = 1;
                }
            } else {
                int i = 0;
                while (i < termLength) {
                    int n = i++;
                    this.sameCounts[n] = this.sameCounts[n] + 1;
                }
            }
        }

        private void finishSkips() {
            assert (this.count == this.terms.length);
            int lastTermOffset = this.termOffsets[this.count - 1];
            int lastTermLength = this.termOffsets[this.count] - lastTermOffset;
            for (int i = 0; i < lastTermLength; ++i) {
                if (this.sameCounts[i] < this.minSkipCount) continue;
                this.saveSkip(this.count, this.sameCounts[i]);
            }
            for (int termID = 0; termID < this.terms.length; ++termID) {
                TermAndSkip term = this.terms[termID];
                if (term.skips == null || term.skips.length <= 1) continue;
                for (int pos = 0; pos < term.skips.length / 2; ++pos) {
                    int otherPos = term.skips.length - pos - 1;
                    int temp = term.skips[pos];
                    term.skips[pos] = term.skips[otherPos];
                    term.skips[otherPos] = temp;
                }
            }
        }

        private void saveSkip(int ord, int backCount) {
            TermAndSkip term = this.terms[ord - backCount];
            ++this.skipCount;
            if (term.skips == null) {
                term.skips = new int[]{ord};
            } else {
                int[] newSkips = new int[term.skips.length + 1];
                System.arraycopy(term.skips, 0, newSkips, 0, term.skips.length);
                term.skips = newSkips;
                term.skips[term.skips.length - 1] = ord;
            }
        }

        public TermsEnum iterator() {
            return new DirectTermsEnum();
        }

        public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) {
            return new DirectIntersectTermsEnum(compiled, startTerm);
        }

        public long size() {
            return this.terms.length;
        }

        public long getSumTotalTermFreq() {
            return this.sumTotalTermFreq;
        }

        public long getSumDocFreq() {
            return this.sumDocFreq;
        }

        public int getDocCount() {
            return this.docCount;
        }

        public boolean hasFreqs() {
            return this.hasFreq;
        }

        public boolean hasOffsets() {
            return this.hasOffsets;
        }

        public boolean hasPositions() {
            return this.hasPos;
        }

        public boolean hasPayloads() {
            return this.hasPayloads;
        }

        private final class DirectIntersectTermsEnum
        extends TermsEnum {
            private final RunAutomaton runAutomaton;
            private final CompiledAutomaton compiledAutomaton;
            private int termOrd;
            private final BytesRef scratch = new BytesRef();
            private State[] states;
            private int stateUpto;

            public DirectIntersectTermsEnum(CompiledAutomaton compiled, BytesRef startTerm) {
                this.runAutomaton = compiled.runAutomaton;
                this.compiledAutomaton = compiled;
                this.termOrd = -1;
                this.states = new State[1];
                this.states[0] = new State();
                this.states[0].changeOrd = DirectField.this.terms.length;
                this.states[0].state = this.runAutomaton.getInitialState();
                this.states[0].transitionCount = this.compiledAutomaton.automaton.getNumTransitions(this.states[0].state);
                this.compiledAutomaton.automaton.initTransition(this.states[0].state, this.states[0].transition);
                this.states[0].transitionUpto = -1;
                this.states[0].transitionMax = -1;
                if (startTerm != null) {
                    int skipUpto = 0;
                    if (startTerm.length == 0) {
                        if (DirectField.this.terms.length > 0 && DirectField.this.termOffsets[1] == 0) {
                            this.termOrd = 0;
                        }
                    } else {
                        ++this.termOrd;
                        for (int i = 0; i < startTerm.length; ++i) {
                            int nextState;
                            int skipOffset;
                            block23: {
                                int label = startTerm.bytes[startTerm.offset + i] & 0xFF;
                                while (label > this.states[i].transitionMax) {
                                    ++this.states[i].transitionUpto;
                                    assert (this.states[i].transitionUpto < this.states[i].transitionCount);
                                    this.compiledAutomaton.automaton.getNextTransition(this.states[i].transition);
                                    this.states[i].transitionMin = this.states[i].transition.min;
                                    this.states[i].transitionMax = this.states[i].transition.max;
                                    assert (this.states[i].transitionMin >= 0);
                                    assert (this.states[i].transitionMin <= 255);
                                    assert (this.states[i].transitionMax >= 0);
                                    assert (this.states[i].transitionMax <= 255);
                                }
                                while (this.termOrd < DirectField.this.terms.length) {
                                    skipOffset = DirectField.this.skipOffsets[this.termOrd];
                                    int numSkips = DirectField.this.skipOffsets[this.termOrd + 1] - skipOffset;
                                    int termOffset = DirectField.this.termOffsets[this.termOrd];
                                    int termLength = DirectField.this.termOffsets[1 + this.termOrd] - termOffset;
                                    if (this.termOrd == this.states[this.stateUpto].changeOrd) {
                                        --this.stateUpto;
                                        --this.termOrd;
                                        return;
                                    }
                                    if (termLength == i) {
                                        ++this.termOrd;
                                        skipUpto = 0;
                                        continue;
                                    }
                                    if (label < (DirectField.this.termBytes[termOffset + i] & 0xFF)) {
                                        --this.termOrd;
                                        this.stateUpto -= skipUpto;
                                        assert (this.stateUpto >= 0);
                                        return;
                                    }
                                    if (label == (DirectField.this.termBytes[termOffset + i] & 0xFF)) {
                                        if (skipUpto < numSkips) {
                                            this.grow();
                                            nextState = this.runAutomaton.step(this.states[this.stateUpto].state, label);
                                            assert (nextState != -1);
                                            ++this.stateUpto;
                                            break block23;
                                        }
                                        int startTermOrd = this.termOrd;
                                        while (this.termOrd < DirectField.this.terms.length && DirectField.this.compare(this.termOrd, startTerm) <= 0) {
                                            assert (this.termOrd == startTermOrd || DirectField.this.skipOffsets[this.termOrd] == DirectField.this.skipOffsets[this.termOrd + 1]);
                                            ++this.termOrd;
                                        }
                                        assert (this.termOrd - startTermOrd < DirectField.this.minSkipCount);
                                        --this.termOrd;
                                        this.stateUpto -= skipUpto;
                                        return;
                                    }
                                    this.termOrd = skipUpto < numSkips ? DirectField.this.skips[skipOffset + skipUpto] : ++this.termOrd;
                                    skipUpto = 0;
                                }
                                --this.termOrd;
                                return;
                            }
                            this.states[this.stateUpto].changeOrd = DirectField.this.skips[skipOffset + skipUpto++];
                            this.states[this.stateUpto].state = nextState;
                            this.states[this.stateUpto].transitionCount = this.compiledAutomaton.automaton.getNumTransitions(nextState);
                            this.compiledAutomaton.automaton.initTransition(this.states[this.stateUpto].state, this.states[this.stateUpto].transition);
                            this.states[this.stateUpto].transitionUpto = -1;
                            this.states[this.stateUpto].transitionMax = -1;
                        }
                    }
                    int termOffset = DirectField.this.termOffsets[this.termOrd];
                    int termLen = DirectField.this.termOffsets[1 + this.termOrd] - termOffset;
                    if (this.termOrd >= 0 && !startTerm.equals((Object)new BytesRef(DirectField.this.termBytes, termOffset, termLen))) {
                        this.stateUpto -= skipUpto;
                        --this.termOrd;
                    }
                }
            }

            private void grow() {
                if (this.states.length == 1 + this.stateUpto) {
                    State[] newStates = new State[this.states.length + 1];
                    System.arraycopy(this.states, 0, newStates, 0, this.states.length);
                    newStates[this.states.length] = new State();
                    this.states = newStates;
                }
            }

            public BytesRef next() {
                ++this.termOrd;
                int skipUpto = 0;
                if (this.termOrd == 0 && DirectField.this.termOffsets[1] == 0) {
                    assert (this.stateUpto == 0);
                    if (this.runAutomaton.isAccept(this.states[0].state)) {
                        this.scratch.bytes = DirectField.this.termBytes;
                        this.scratch.offset = 0;
                        this.scratch.length = 0;
                        return this.scratch;
                    }
                    ++this.termOrd;
                }
                block0: while (this.termOrd != DirectField.this.terms.length) {
                    State state = this.states[this.stateUpto];
                    if (this.termOrd == state.changeOrd) {
                        --this.stateUpto;
                        continue;
                    }
                    int termOffset = DirectField.this.termOffsets[this.termOrd];
                    int termLength = DirectField.this.termOffsets[this.termOrd + 1] - termOffset;
                    int skipOffset = DirectField.this.skipOffsets[this.termOrd];
                    int numSkips = DirectField.this.skipOffsets[this.termOrd + 1] - skipOffset;
                    assert (this.termOrd < state.changeOrd);
                    assert (this.stateUpto <= termLength) : "term.length=" + termLength + "; stateUpto=" + this.stateUpto;
                    int label = DirectField.this.termBytes[termOffset + this.stateUpto] & 0xFF;
                    while (label > state.transitionMax) {
                        ++state.transitionUpto;
                        if (state.transitionUpto == state.transitionCount) {
                            if (this.stateUpto == 0) {
                                this.termOrd = DirectField.this.terms.length;
                                return null;
                            }
                            assert (state.changeOrd > this.termOrd);
                            this.termOrd = this.states[this.stateUpto].changeOrd;
                            skipUpto = 0;
                            --this.stateUpto;
                            continue block0;
                        }
                        this.compiledAutomaton.automaton.getNextTransition(state.transition);
                        assert (state.transitionUpto < state.transitionCount) : " state.transitionUpto=" + state.transitionUpto + " vs " + state.transitionCount;
                        state.transitionMin = state.transition.min;
                        state.transitionMax = state.transition.max;
                        assert (state.transitionMin >= 0);
                        assert (state.transitionMin <= 255);
                        assert (state.transitionMax >= 0);
                        assert (state.transitionMax <= 255);
                    }
                    int targetLabel = state.transitionMin;
                    if ((DirectField.this.termBytes[termOffset + this.stateUpto] & 0xFF) < targetLabel) {
                        int mid;
                        int low = this.termOrd + 1;
                        int high = state.changeOrd - 1;
                        while (true) {
                            if (low > high) {
                                this.termOrd = low;
                                skipUpto = 0;
                                continue block0;
                            }
                            int cmp = (DirectField.this.termBytes[DirectField.this.termOffsets[mid] + this.stateUpto] & 0xFF) - targetLabel;
                            if (cmp < 0) {
                                low = mid + 1;
                                continue;
                            }
                            if (cmp <= 0) break;
                            high = mid - 1;
                        }
                        for (mid = low + high >>> 1; mid > this.termOrd && (DirectField.this.termBytes[DirectField.this.termOffsets[mid - 1] + this.stateUpto] & 0xFF) == targetLabel; --mid) {
                        }
                        this.termOrd = mid;
                        skipUpto = 0;
                        continue;
                    }
                    int nextState = this.runAutomaton.step(this.states[this.stateUpto].state, label);
                    if (nextState == -1) {
                        this.termOrd = skipUpto < numSkips ? DirectField.this.skips[skipOffset + skipUpto] : ++this.termOrd;
                        skipUpto = 0;
                        continue;
                    }
                    if (skipUpto < numSkips) {
                        this.grow();
                        ++this.stateUpto;
                        this.states[this.stateUpto].state = nextState;
                        this.states[this.stateUpto].changeOrd = DirectField.this.skips[skipOffset + skipUpto++];
                        this.states[this.stateUpto].transitionCount = this.compiledAutomaton.automaton.getNumTransitions(nextState);
                        this.compiledAutomaton.automaton.initTransition(nextState, this.states[this.stateUpto].transition);
                        this.states[this.stateUpto].transitionUpto = -1;
                        this.states[this.stateUpto].transitionMax = -1;
                        if (this.stateUpto != termLength) continue;
                        if (this.runAutomaton.isAccept(nextState)) {
                            this.scratch.bytes = DirectField.this.termBytes;
                            this.scratch.offset = DirectField.this.termOffsets[this.termOrd];
                            this.scratch.length = DirectField.this.termOffsets[1 + this.termOrd] - this.scratch.offset;
                            return this.scratch;
                        }
                        ++this.termOrd;
                        skipUpto = 0;
                        continue;
                    }
                    if (this.compiledAutomaton.commonSuffixRef != null) {
                        assert (this.compiledAutomaton.commonSuffixRef.offset == 0);
                        if (termLength < this.compiledAutomaton.commonSuffixRef.length) {
                            ++this.termOrd;
                            skipUpto = 0;
                            continue;
                        }
                        int offset = termOffset + termLength - this.compiledAutomaton.commonSuffixRef.length;
                        for (int suffix = 0; suffix < this.compiledAutomaton.commonSuffixRef.length; ++suffix) {
                            if (DirectField.this.termBytes[offset + suffix] == this.compiledAutomaton.commonSuffixRef.bytes[suffix]) continue;
                            ++this.termOrd;
                            skipUpto = 0;
                            continue block0;
                        }
                    }
                    for (int upto = this.stateUpto + 1; upto < termLength; ++upto) {
                        if ((nextState = this.runAutomaton.step(nextState, DirectField.this.termBytes[termOffset + upto] & 0xFF)) != -1) continue;
                        ++this.termOrd;
                        skipUpto = 0;
                        continue block0;
                    }
                    if (this.runAutomaton.isAccept(nextState)) {
                        this.scratch.bytes = DirectField.this.termBytes;
                        this.scratch.offset = DirectField.this.termOffsets[this.termOrd];
                        this.scratch.length = DirectField.this.termOffsets[1 + this.termOrd] - this.scratch.offset;
                        return this.scratch;
                    }
                    ++this.termOrd;
                    skipUpto = 0;
                }
                return null;
            }

            public TermState termState() {
                OrdTermState state = new OrdTermState();
                state.ord = this.termOrd;
                return state;
            }

            public BytesRef term() {
                return this.scratch;
            }

            public long ord() {
                return this.termOrd;
            }

            public int docFreq() {
                if (DirectField.this.terms[this.termOrd] instanceof LowFreqTerm) {
                    return ((LowFreqTerm)((DirectField)DirectField.this).terms[this.termOrd]).docFreq;
                }
                return ((HighFreqTerm)((DirectField)DirectField.this).terms[this.termOrd]).docIDs.length;
            }

            public long totalTermFreq() {
                if (DirectField.this.terms[this.termOrd] instanceof LowFreqTerm) {
                    return ((LowFreqTerm)((DirectField)DirectField.this).terms[this.termOrd]).totalTermFreq;
                }
                return ((HighFreqTerm)((DirectField)DirectField.this).terms[this.termOrd]).totalTermFreq;
            }

            public PostingsEnum postings(PostingsEnum reuse, int flags) {
                if (DirectField.this.hasPos && PostingsEnum.featureRequested((int)flags, (short)24)) {
                    if (DirectField.this.terms[this.termOrd] instanceof LowFreqTerm) {
                        LowFreqTerm term = (LowFreqTerm)DirectField.this.terms[this.termOrd];
                        int[] postings = term.postings;
                        byte[] payloads = term.payloads;
                        return new LowFreqPostingsEnum(DirectField.this.hasOffsets, DirectField.this.hasPayloads).reset(postings, payloads);
                    }
                    HighFreqTerm term = (HighFreqTerm)DirectField.this.terms[this.termOrd];
                    return new HighFreqPostingsEnum(DirectField.this.hasOffsets).reset(term.docIDs, term.freqs, term.positions, term.payloads);
                }
                if (DirectField.this.terms[this.termOrd] instanceof LowFreqTerm) {
                    int[] postings = ((LowFreqTerm)((DirectField)DirectField.this).terms[this.termOrd]).postings;
                    if (DirectField.this.hasFreq) {
                        if (DirectField.this.hasPos) {
                            int posLen = DirectField.this.hasOffsets ? 3 : 1;
                            if (DirectField.this.hasPayloads) {
                                ++posLen;
                            }
                            return new LowFreqDocsEnum(posLen).reset(postings);
                        }
                        return new LowFreqDocsEnumNoPos().reset(postings);
                    }
                    return new LowFreqDocsEnumNoTF().reset(postings);
                }
                HighFreqTerm term = (HighFreqTerm)DirectField.this.terms[this.termOrd];
                return new HighFreqDocsEnum().reset(term.docIDs, term.freqs);
            }

            public TermsEnum.SeekStatus seekCeil(BytesRef term) {
                throw new UnsupportedOperationException();
            }

            public void seekExact(long ord) {
                throw new UnsupportedOperationException();
            }

            private final class State {
                int changeOrd;
                int state;
                int transitionUpto;
                int transitionCount;
                int transitionMax;
                int transitionMin;
                final Transition transition = new Transition();

                private State() {
                }
            }
        }

        private final class DirectTermsEnum
        extends TermsEnum {
            private final BytesRef scratch = new BytesRef();
            private int termOrd = -1;

            private DirectTermsEnum() {
            }

            private BytesRef setTerm() {
                this.scratch.bytes = DirectField.this.termBytes;
                this.scratch.offset = DirectField.this.termOffsets[this.termOrd];
                this.scratch.length = DirectField.this.termOffsets[this.termOrd + 1] - DirectField.this.termOffsets[this.termOrd];
                return this.scratch;
            }

            public BytesRef next() {
                ++this.termOrd;
                if (this.termOrd < DirectField.this.terms.length) {
                    return this.setTerm();
                }
                return null;
            }

            public TermState termState() {
                OrdTermState state = new OrdTermState();
                state.ord = this.termOrd;
                return state;
            }

            private int findTerm(BytesRef term) {
                int low = 0;
                int high = DirectField.this.terms.length - 1;
                while (low <= high) {
                    int mid = low + high >>> 1;
                    int cmp = DirectField.this.compare(mid, term);
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    return mid;
                }
                return -(low + 1);
            }

            public TermsEnum.SeekStatus seekCeil(BytesRef term) {
                int ord = this.findTerm(term);
                if (ord >= 0) {
                    this.termOrd = ord;
                    this.setTerm();
                    return TermsEnum.SeekStatus.FOUND;
                }
                if (ord == -DirectField.this.terms.length - 1) {
                    return TermsEnum.SeekStatus.END;
                }
                this.termOrd = -ord - 1;
                this.setTerm();
                return TermsEnum.SeekStatus.NOT_FOUND;
            }

            public boolean seekExact(BytesRef term) {
                int ord = this.findTerm(term);
                if (ord >= 0) {
                    this.termOrd = ord;
                    this.setTerm();
                    return true;
                }
                return false;
            }

            public void seekExact(long ord) {
                this.termOrd = (int)ord;
                this.setTerm();
            }

            public void seekExact(BytesRef term, TermState state) throws IOException {
                this.termOrd = (int)((OrdTermState)state).ord;
                this.setTerm();
                assert (term.equals((Object)this.scratch));
            }

            public BytesRef term() {
                return this.scratch;
            }

            public long ord() {
                return this.termOrd;
            }

            public int docFreq() {
                if (DirectField.this.terms[this.termOrd] instanceof LowFreqTerm) {
                    return ((LowFreqTerm)((DirectField)DirectField.this).terms[this.termOrd]).docFreq;
                }
                return ((HighFreqTerm)((DirectField)DirectField.this).terms[this.termOrd]).docIDs.length;
            }

            public long totalTermFreq() {
                if (DirectField.this.terms[this.termOrd] instanceof LowFreqTerm) {
                    return ((LowFreqTerm)((DirectField)DirectField.this).terms[this.termOrd]).totalTermFreq;
                }
                return ((HighFreqTerm)((DirectField)DirectField.this).terms[this.termOrd]).totalTermFreq;
            }

            public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
                if (PostingsEnum.featureRequested((int)flags, (short)24)) {
                    if (DirectField.this.terms[this.termOrd] instanceof LowFreqTerm) {
                        LowFreqTerm term = (LowFreqTerm)DirectField.this.terms[this.termOrd];
                        int[] postings = term.postings;
                        if (!DirectField.this.hasFreq) {
                            LowFreqDocsEnumNoTF docsEnum = reuse instanceof LowFreqDocsEnumNoTF ? (LowFreqDocsEnumNoTF)reuse : new LowFreqDocsEnumNoTF();
                            return docsEnum.reset(postings);
                        }
                        if (!DirectField.this.hasPos) {
                            LowFreqDocsEnumNoPos docsEnum = reuse instanceof LowFreqDocsEnumNoPos ? (LowFreqDocsEnumNoPos)reuse : new LowFreqDocsEnumNoPos();
                            return docsEnum.reset(postings);
                        }
                        byte[] payloads = term.payloads;
                        return new LowFreqPostingsEnum(DirectField.this.hasOffsets, DirectField.this.hasPayloads).reset(postings, payloads);
                    }
                    HighFreqTerm term = (HighFreqTerm)DirectField.this.terms[this.termOrd];
                    if (!DirectField.this.hasPos) {
                        return new HighFreqDocsEnum().reset(term.docIDs, term.freqs);
                    }
                    return new HighFreqPostingsEnum(DirectField.this.hasOffsets).reset(term.docIDs, term.freqs, term.positions, term.payloads);
                }
                if (DirectField.this.terms[this.termOrd] instanceof LowFreqTerm) {
                    int[] postings = ((LowFreqTerm)((DirectField)DirectField.this).terms[this.termOrd]).postings;
                    if (DirectField.this.hasFreq) {
                        if (DirectField.this.hasPos) {
                            LowFreqDocsEnum docsEnum;
                            int posLen = DirectField.this.hasOffsets ? 3 : 1;
                            if (DirectField.this.hasPayloads) {
                                ++posLen;
                            }
                            if (reuse instanceof LowFreqDocsEnum) {
                                docsEnum = (LowFreqDocsEnum)reuse;
                                if (!docsEnum.canReuse(posLen)) {
                                    docsEnum = new LowFreqDocsEnum(posLen);
                                }
                            } else {
                                docsEnum = new LowFreqDocsEnum(posLen);
                            }
                            return docsEnum.reset(postings);
                        }
                        LowFreqDocsEnumNoPos docsEnum = reuse instanceof LowFreqDocsEnumNoPos ? (LowFreqDocsEnumNoPos)reuse : new LowFreqDocsEnumNoPos();
                        return docsEnum.reset(postings);
                    }
                    LowFreqDocsEnumNoTF docsEnum = reuse instanceof LowFreqDocsEnumNoTF ? (LowFreqDocsEnumNoTF)reuse : new LowFreqDocsEnumNoTF();
                    return docsEnum.reset(postings);
                }
                HighFreqTerm term = (HighFreqTerm)DirectField.this.terms[this.termOrd];
                HighFreqDocsEnum docsEnum = reuse instanceof HighFreqDocsEnum ? (HighFreqDocsEnum)reuse : new HighFreqDocsEnum();
                return docsEnum.reset(term.docIDs, term.freqs);
            }
        }

        private static final class IntArrayWriter {
            private int[] ints = new int[10];
            private int upto;

            private IntArrayWriter() {
            }

            public void add(int value) {
                if (this.ints.length == this.upto) {
                    this.ints = ArrayUtil.grow((int[])this.ints);
                }
                this.ints[this.upto++] = value;
            }

            public int[] get() {
                int[] arr = new int[this.upto];
                System.arraycopy(this.ints, 0, arr, 0, this.upto);
                this.upto = 0;
                return arr;
            }
        }

        private static final class HighFreqTerm
        extends TermAndSkip {
            private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(HighFreqTerm.class);
            public final long totalTermFreq;
            public final int[] docIDs;
            public final int[] freqs;
            public final int[][] positions;
            public final byte[][][] payloads;

            public HighFreqTerm(int[] docIDs, int[] freqs, int[][] positions, byte[][][] payloads, long totalTermFreq) {
                this.docIDs = docIDs;
                this.freqs = freqs;
                this.positions = positions;
                this.payloads = payloads;
                this.totalTermFreq = totalTermFreq;
            }

            public long ramBytesUsed() {
                long sizeInBytes = BASE_RAM_BYTES_USED;
                sizeInBytes += this.docIDs != null ? RamUsageEstimator.sizeOf((int[])this.docIDs) : 0L;
                sizeInBytes += this.freqs != null ? RamUsageEstimator.sizeOf((int[])this.freqs) : 0L;
                if (this.positions != null) {
                    sizeInBytes += RamUsageEstimator.shallowSizeOf((Object[])this.positions);
                    for (int[] position : this.positions) {
                        sizeInBytes += position != null ? RamUsageEstimator.sizeOf((int[])position) : 0L;
                    }
                }
                if (this.payloads != null) {
                    sizeInBytes += RamUsageEstimator.shallowSizeOf((Object[])this.payloads);
                    for (byte[][] payload : this.payloads) {
                        if (payload == null) continue;
                        sizeInBytes += RamUsageEstimator.shallowSizeOf((Object[])payload);
                        for (byte[] pload : payload) {
                            sizeInBytes += pload != null ? RamUsageEstimator.sizeOf((byte[])pload) : 0L;
                        }
                    }
                }
                return sizeInBytes;
            }
        }

        private static final class LowFreqTerm
        extends TermAndSkip {
            private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(HighFreqTerm.class);
            public final int[] postings;
            public final byte[] payloads;
            public final int docFreq;
            public final int totalTermFreq;

            public LowFreqTerm(int[] postings, byte[] payloads, int docFreq, int totalTermFreq) {
                this.postings = postings;
                this.payloads = payloads;
                this.docFreq = docFreq;
                this.totalTermFreq = totalTermFreq;
            }

            public long ramBytesUsed() {
                return BASE_RAM_BYTES_USED + (this.postings != null ? RamUsageEstimator.sizeOf((int[])this.postings) : 0L) + (this.payloads != null ? RamUsageEstimator.sizeOf((byte[])this.payloads) : 0L);
            }
        }

        private static abstract class TermAndSkip
        implements Accountable {
            public int[] skips;

            private TermAndSkip() {
            }
        }
    }

    private static final class DirectFields
    extends FieldsProducer {
        private final Map<String, DirectField> fields = new TreeMap<String, DirectField>();

        public DirectFields(SegmentReadState state, Fields fields, int minSkipCount, int lowFreqCutoff) throws IOException {
            for (String field : fields) {
                this.fields.put(field, new DirectField(state, field, fields.terms(field), minSkipCount, lowFreqCutoff));
            }
        }

        public Iterator<String> iterator() {
            return Collections.unmodifiableSet(this.fields.keySet()).iterator();
        }

        public Terms terms(String field) {
            return this.fields.get(field);
        }

        public int size() {
            return this.fields.size();
        }

        public void close() {
        }

        public long ramBytesUsed() {
            long sizeInBytes = 0L;
            for (Map.Entry<String, DirectField> entry : this.fields.entrySet()) {
                sizeInBytes += (long)(entry.getKey().length() * 2);
                sizeInBytes += entry.getValue().ramBytesUsed();
            }
            return sizeInBytes;
        }

        public Collection<Accountable> getChildResources() {
            return Accountables.namedAccountables((String)"field", this.fields);
        }

        public void checkIntegrity() throws IOException {
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "(fields=" + this.fields.size() + ")";
        }
    }
}

