/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.intervals.CachingMatchesIterator;
import org.apache.lucene.search.intervals.DisiPriorityQueue;
import org.apache.lucene.search.intervals.DisiWrapper;
import org.apache.lucene.search.intervals.DisjunctionDISIApproximation;
import org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.lucene.search.intervals.IntervalMatches;
import org.apache.lucene.search.intervals.IntervalMatchesIterator;
import org.apache.lucene.search.intervals.IntervalQuery;
import org.apache.lucene.search.intervals.IntervalsSource;
import org.apache.lucene.util.PriorityQueue;

class MinimumShouldMatchIntervalsSource
extends IntervalsSource {
    private final IntervalsSource[] sources;
    private final int minShouldMatch;

    MinimumShouldMatchIntervalsSource(IntervalsSource[] sources, int minShouldMatch) {
        this.sources = sources;
        this.minShouldMatch = minShouldMatch;
    }

    @Override
    public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        ArrayList<IntervalIterator> iterators = new ArrayList<IntervalIterator>();
        for (IntervalsSource source : this.sources) {
            IntervalIterator it = source.intervals(field, ctx);
            if (it == null) continue;
            iterators.add(it);
        }
        if (iterators.size() < this.minShouldMatch) {
            return null;
        }
        return new MinimumShouldMatchIntervalIterator(iterators, this.minShouldMatch);
    }

    @Override
    public MatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        IdentityHashMap<IntervalIterator, CachingMatchesIterator> lookup = new IdentityHashMap<IntervalIterator, CachingMatchesIterator>();
        for (IntervalsSource source : this.sources) {
            MatchesIterator mi = source.matches(field, ctx, doc);
            if (mi == null) continue;
            CachingMatchesIterator cmi = new CachingMatchesIterator(mi);
            lookup.put(IntervalMatches.wrapMatches((MatchesIterator)cmi, doc), cmi);
        }
        if (lookup.size() < this.minShouldMatch) {
            return null;
        }
        MinimumShouldMatchIntervalIterator it = new MinimumShouldMatchIntervalIterator(lookup.keySet(), this.minShouldMatch);
        if (it.advance(doc) != doc) {
            return null;
        }
        if (it.nextInterval() == Integer.MAX_VALUE) {
            return null;
        }
        return new MinimumMatchesIterator(it, lookup);
    }

    @Override
    public void visit(String field, QueryVisitor visitor) {
        IntervalQuery parent = new IntervalQuery(field, this);
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.SHOULD, (Query)parent);
        for (IntervalsSource source : this.sources) {
            source.visit(field, v);
        }
    }

    @Override
    public int minExtent() {
        int[] subExtents = new int[this.sources.length];
        for (int i = 0; i < subExtents.length; ++i) {
            subExtents[i] = this.sources[i].minExtent();
        }
        Arrays.sort(subExtents);
        int minExtent = 0;
        for (int i = 0; i < this.minShouldMatch; ++i) {
            minExtent += subExtents[i];
        }
        return minExtent;
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Collections.singleton(this);
    }

    @Override
    public String toString() {
        return "ProxBoost(" + Arrays.stream(this.sources).map(IntervalsSource::toString).collect(Collectors.joining(",")) + "~" + this.minShouldMatch + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinimumShouldMatchIntervalsSource that = (MinimumShouldMatchIntervalsSource)o;
        return this.minShouldMatch == that.minShouldMatch && Arrays.equals(this.sources, that.sources);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.minShouldMatch);
        result = 31 * result + Arrays.hashCode(this.sources);
        return result;
    }

    static class MinimumMatchesIterator
    implements IntervalMatchesIterator {
        boolean cached = true;
        final MinimumShouldMatchIntervalIterator iterator;
        final Map<IntervalIterator, CachingMatchesIterator> lookup;

        MinimumMatchesIterator(MinimumShouldMatchIntervalIterator iterator, Map<IntervalIterator, CachingMatchesIterator> lookup) {
            this.iterator = iterator;
            this.lookup = lookup;
        }

        public boolean next() throws IOException {
            if (this.cached) {
                this.cached = false;
                return true;
            }
            return this.iterator.nextInterval() != Integer.MAX_VALUE;
        }

        public int startPosition() {
            return this.iterator.start();
        }

        public int endPosition() {
            return this.iterator.end();
        }

        public int startOffset() throws IOException {
            int start = Integer.MAX_VALUE;
            int endPos = this.endPosition();
            for (IntervalIterator it : this.iterator.getCurrentIterators()) {
                CachingMatchesIterator cms = this.lookup.get((Object)it);
                start = Math.min(start, cms.startOffset(endPos));
            }
            return start;
        }

        public int endOffset() throws IOException {
            int end = 0;
            int endPos = this.endPosition();
            for (IntervalIterator it : this.iterator.getCurrentIterators()) {
                CachingMatchesIterator cms = this.lookup.get((Object)it);
                end = Math.max(end, cms.endOffset(endPos));
            }
            return end;
        }

        @Override
        public int gaps() {
            return this.iterator.gaps();
        }

        public MatchesIterator getSubMatches() throws IOException {
            ArrayList<MatchesIterator> mis = new ArrayList<MatchesIterator>();
            int endPos = this.endPosition();
            for (IntervalIterator it : this.iterator.getCurrentIterators()) {
                CachingMatchesIterator cms = this.lookup.get((Object)it);
                mis.add(cms.getSubMatches(endPos));
            }
            return MatchesUtils.disjunction(mis);
        }

        public Query getQuery() {
            return null;
        }
    }

    static class MinimumShouldMatchIntervalIterator
    extends IntervalIterator {
        private final DocIdSetIterator approximation;
        private final DisiPriorityQueue disiQueue;
        private final PriorityQueue<IntervalIterator> proximityQueue;
        private final PriorityQueue<IntervalIterator> backgroundQueue;
        private final float matchCost;
        private final int minShouldMatch;
        private final int[] innerPositions;
        private final Collection<IntervalIterator> currentIterators = new ArrayList<IntervalIterator>();
        private int start;
        private int end;
        private int queueEnd;
        private int firstEnd;
        private IntervalIterator lead;

        MinimumShouldMatchIntervalIterator(Collection<IntervalIterator> subs, int minShouldMatch) {
            this.disiQueue = new DisiPriorityQueue(subs.size());
            float mc = 0.0f;
            for (IntervalIterator it : subs) {
                this.disiQueue.add(new DisiWrapper(it));
                mc += it.matchCost();
            }
            this.approximation = new DisjunctionDISIApproximation(this.disiQueue);
            this.matchCost = mc;
            this.minShouldMatch = minShouldMatch;
            this.innerPositions = new int[minShouldMatch * 2];
            this.proximityQueue = new PriorityQueue<IntervalIterator>(minShouldMatch){

                protected boolean lessThan(IntervalIterator a, IntervalIterator b) {
                    return a.start() < b.start() || a.start() == b.start() && a.end() >= b.end();
                }
            };
            this.backgroundQueue = new PriorityQueue<IntervalIterator>(subs.size()){

                protected boolean lessThan(IntervalIterator a, IntervalIterator b) {
                    return a.end() < b.end() || a.end() == b.end() && a.start() >= b.start();
                }
            };
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        @Override
        public int gaps() {
            int i = 0;
            for (IntervalIterator it : this.proximityQueue) {
                if (it.end() > this.end) {
                    this.innerPositions[i * 2] = this.start;
                    this.innerPositions[i * 2 + 1] = this.firstEnd;
                } else {
                    this.innerPositions[i * 2] = it.start();
                    this.innerPositions[i * 2 + 1] = it.end();
                }
                ++i;
            }
            if (this.proximityQueue.size() < this.minShouldMatch) {
                this.innerPositions[i * 2] = this.start;
                this.innerPositions[i * 2 + 1] = this.firstEnd;
            }
            Arrays.sort(this.innerPositions);
            int gaps = 0;
            for (int j = 1; j < this.minShouldMatch; ++j) {
                gaps += this.innerPositions[j * 2] - this.innerPositions[j * 2 - 1] - 1;
            }
            return gaps;
        }

        @Override
        public int nextInterval() throws IOException {
            while (this.proximityQueue.size() == this.minShouldMatch && ((IntervalIterator)((Object)this.proximityQueue.top())).start() == this.start) {
                IntervalIterator it = (IntervalIterator)((Object)this.proximityQueue.pop());
                if (it == null || it.nextInterval() == Integer.MAX_VALUE) continue;
                this.backgroundQueue.add((Object)it);
                IntervalIterator next = (IntervalIterator)((Object)this.backgroundQueue.pop());
                assert (next != null);
                this.proximityQueue.add((Object)next);
                this.updateRightExtreme(next);
            }
            if (this.proximityQueue.size() < this.minShouldMatch) {
                this.end = Integer.MAX_VALUE;
                this.start = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            do {
                IntervalIterator next;
                this.start = ((IntervalIterator)((Object)this.proximityQueue.top())).start();
                this.firstEnd = ((IntervalIterator)((Object)this.proximityQueue.top())).end();
                this.end = this.queueEnd;
                if (((IntervalIterator)((Object)this.proximityQueue.top())).end() == this.end) {
                    return this.start;
                }
                this.lead = (IntervalIterator)((Object)this.proximityQueue.pop());
                if (this.lead == null) continue;
                if (this.lead.nextInterval() != Integer.MAX_VALUE) {
                    this.backgroundQueue.add((Object)this.lead);
                }
                if ((next = (IntervalIterator)((Object)this.backgroundQueue.pop())) == null) continue;
                this.proximityQueue.add((Object)next);
                this.updateRightExtreme(next);
            } while (this.proximityQueue.size() == this.minShouldMatch && this.end == this.queueEnd);
            return this.start;
        }

        Collection<IntervalIterator> getCurrentIterators() {
            this.currentIterators.clear();
            this.currentIterators.add(this.lead);
            for (IntervalIterator it : this.proximityQueue) {
                if (it.end() > this.end) continue;
                this.currentIterators.add(it);
            }
            return this.currentIterators;
        }

        private void reset() throws IOException {
            IntervalIterator it;
            this.proximityQueue.clear();
            this.backgroundQueue.clear();
            DisiWrapper dw = this.disiQueue.topList();
            while (dw != null) {
                if (dw.intervals.nextInterval() != Integer.MAX_VALUE) {
                    this.backgroundQueue.add((Object)dw.intervals);
                }
                dw = dw.next;
            }
            this.queueEnd = -1;
            for (int i = 0; i < this.minShouldMatch && (it = (IntervalIterator)((Object)this.backgroundQueue.pop())) != null; ++i) {
                this.proximityQueue.add((Object)it);
                this.updateRightExtreme(it);
            }
            this.end = -1;
            this.start = -1;
        }

        private void updateRightExtreme(IntervalIterator it) {
            int itEnd = it.end();
            if (itEnd > this.queueEnd) {
                this.queueEnd = itEnd;
            }
        }

        @Override
        public float matchCost() {
            return this.matchCost;
        }

        public int docID() {
            return this.approximation.docID();
        }

        public int nextDoc() throws IOException {
            int doc = this.approximation.nextDoc();
            this.reset();
            return doc;
        }

        public int advance(int target) throws IOException {
            int doc = this.approximation.advance(target);
            this.reset();
            return doc;
        }

        public long cost() {
            return this.approximation.cost();
        }
    }
}

