/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.markdown;

import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.IndentedCodeBlock;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

class FlexmarkDoxiaNodeRenderer
implements NodeRenderer {
    public FlexmarkDoxiaNodeRenderer(DataHolder options) {
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler(IndentedCodeBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<IndentedCodeBlock>(){

            public void render(IndentedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
                FlexmarkDoxiaNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(FencedCodeBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<FencedCodeBlock>(){

            public void render(FencedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
                FlexmarkDoxiaNodeRenderer.this.render(node, context, html);
            }
        })));
    }

    private void render(IndentedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
        html.line();
        ((HtmlWriter)html.attr((CharSequence)"class", (CharSequence)"source")).tag((CharSequence)"div");
        ((HtmlWriter)html.srcPosWithEOL(node.getChars()).withAttr().tag((CharSequence)"pre")).openPre();
        String noLanguageClass = context.getHtmlOptions().noLanguageClass.trim();
        if (!noLanguageClass.isEmpty()) {
            html.attr((CharSequence)"class", (CharSequence)noLanguageClass);
        }
        String s = node.getContentChars().trimTailBlankLines().normalizeEndWithEOL();
        while (!s.isEmpty() && s.charAt(0) == '\n') {
            html.raw((CharSequence)"<br/>");
            s = s.substring(1);
        }
        html.text((CharSequence)s);
        ((HtmlWriter)html.tag((CharSequence)"/pre")).closePre();
        html.tag((CharSequence)"/div");
        html.line();
    }

    private void render(FencedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
        html.line();
        ((HtmlWriter)html.attr((CharSequence)"class", (CharSequence)"source")).tag((CharSequence)"div");
        ((HtmlWriter)html.srcPosWithTrailingEOL(node.getChars()).withAttr().tag((CharSequence)"pre")).openPre();
        String s = node.getContentChars().normalizeEOL();
        while (!s.isEmpty() && s.charAt(0) == '\n') {
            html.raw((CharSequence)"<br/>");
            s = s.substring(1);
        }
        html.text((CharSequence)s);
        ((HtmlWriter)html.tag((CharSequence)"/pre")).closePre();
        html.tag((CharSequence)"/div");
        html.line();
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new FlexmarkDoxiaNodeRenderer(options);
        }
    }
}

