/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.xhtml;

import javax.swing.text.html.HTML;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.module.xhtml.XhtmlMarkup;
import org.apache.maven.doxia.parser.XhtmlBaseParser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class XhtmlParser
extends XhtmlBaseParser
implements XhtmlMarkup {
    private boolean boxed;
    private boolean isEmptyElement;

    protected void handleStartTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        this.isEmptyElement = parser.isEmptyElementTag();
        SinkEventAttributeSet attribs = this.getAttributesFromParser(parser);
        if (this.isVerbatim()) {
            if (parser.getName().equals(HTML.Tag.PRE.toString())) {
                this.verbatim();
            }
            sink.text(parser.getText());
        } else {
            if (parser.getName().equals(HTML.Tag.HTML.toString())) {
                return;
            }
            if (parser.getName().equals(HTML.Tag.HEAD.toString())) {
                sink.head((SinkEventAttributes)attribs);
            } else if (parser.getName().equals(HTML.Tag.TITLE.toString())) {
                sink.title((SinkEventAttributes)attribs);
            } else if (parser.getName().equals(HTML.Tag.META.toString())) {
                String name = parser.getAttributeValue(null, HTML.Attribute.NAME.toString());
                String content = parser.getAttributeValue(null, HTML.Attribute.CONTENT.toString());
                attribs.removeAttribute((Object)HTML.Attribute.NAME.toString());
                attribs.removeAttribute((Object)HTML.Attribute.CONTENT.toString());
                if ("author".equals(name)) {
                    sink.author((SinkEventAttributes)attribs);
                    sink.text(content);
                    sink.author_();
                } else if ("date".equals(name)) {
                    sink.date((SinkEventAttributes)attribs);
                    sink.text(content);
                    sink.date_();
                }
            } else if (parser.getName().equals(HTML.Tag.ADDRESS.toString())) {
                sink.author((SinkEventAttributes)attribs);
            } else if (parser.getName().equals(HTML.Tag.BODY.toString())) {
                sink.body((SinkEventAttributes)attribs);
            } else if (parser.getName().equals(HTML.Tag.DIV.toString())) {
                String divclass = parser.getAttributeValue(null, HTML.Attribute.CLASS.toString());
                if ("source".equals(divclass)) {
                    this.boxed = true;
                }
                super.baseStartTag(parser, sink);
            } else if (parser.getName().equals(HTML.Tag.PRE.toString())) {
                if (this.boxed) {
                    attribs.addAttribute((Object)"decoration", (Object)"boxed");
                }
                this.verbatim();
                sink.verbatim((SinkEventAttributes)attribs);
            } else if (!this.baseStartTag(parser, sink)) {
                if (this.isEmptyElement) {
                    this.handleUnknown(parser, sink, 1);
                } else {
                    this.handleUnknown(parser, sink, 2);
                }
                if (this.getLog().isDebugEnabled()) {
                    String position = "[" + parser.getLineNumber() + ":" + parser.getColumnNumber() + "]";
                    String tag = "<" + parser.getName() + ">";
                    this.getLog().debug((CharSequence)("Unrecognized xhtml tag: " + tag + " at " + position));
                }
            }
        }
    }

    protected void handleEndTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (this.isVerbatim()) {
            if (parser.getName().equals(HTML.Tag.PRE.toString())) {
                this.verbatim_();
                if (this.isVerbatim()) {
                    sink.text(parser.getText());
                } else {
                    sink.verbatim_();
                }
            } else {
                sink.text(parser.getText());
            }
        } else {
            if (parser.getName().equals(HTML.Tag.HTML.toString())) {
                return;
            }
            if (parser.getName().equals(HTML.Tag.HEAD.toString())) {
                sink.head_();
            } else if (parser.getName().equals(HTML.Tag.TITLE.toString())) {
                sink.title_();
            } else if (parser.getName().equals(HTML.Tag.BODY.toString())) {
                this.consecutiveSections(0, sink);
                sink.body_();
            } else if (parser.getName().equals(HTML.Tag.ADDRESS.toString())) {
                sink.author_();
            } else if (parser.getName().equals(HTML.Tag.DIV.toString())) {
                this.boxed = false;
                super.baseEndTag(parser, sink);
            } else if (!this.baseEndTag(parser, sink) && !this.isEmptyElement) {
                this.handleUnknown(parser, sink, 3);
            }
        }
        this.isEmptyElement = false;
    }
}

