/*
 * $Id$
 */

package org.apache.maven.usability.plugin;

/**
 * A plugin parameter expression supported by Maven
 * 
 * @version $Revision$ $Date$
 */
public class Expression implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field syntax
     */
    private String syntax;

    /**
     * Field description
     */
    private String description;

    /**
     * Field configuration
     */
    private String configuration;

    /**
     * Field cliOptions
     */
    private java.util.Properties cliOptions;

    /**
     * Field apiMethods
     */
    private java.util.Properties apiMethods;

    /**
     * Field deprecation
     */
    private String deprecation;

    /**
     * Field ban
     */
    private String ban;

    /**
     * Field editable
     */
    private boolean editable = true;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addApiMethod
     * 
     * @param key
     * @param value
     */
    public void addApiMethod(String key, String value)
    {
        getApiMethods().put( key, value );
    } //-- void addApiMethod(String, String) 

    /**
     * Method addCliOption
     * 
     * @param key
     * @param value
     */
    public void addCliOption(String key, String value)
    {
        getCliOptions().put( key, value );
    } //-- void addCliOption(String, String) 

    /**
     * Method getApiMethods
     */
    public java.util.Properties getApiMethods()
    {
        if ( this.apiMethods == null )
        {
            this.apiMethods = new java.util.Properties();
        }
        
        return this.apiMethods;
    } //-- java.util.Properties getApiMethods() 

    /**
     * Get A preferred alternative to this expression, in the case
     * where it's banned from use.
     */
    public String getBan()
    {
        return this.ban;
    } //-- String getBan() 

    /**
     * Method getCliOptions
     */
    public java.util.Properties getCliOptions()
    {
        if ( this.cliOptions == null )
        {
            this.cliOptions = new java.util.Properties();
        }
        
        return this.cliOptions;
    } //-- java.util.Properties getCliOptions() 

    /**
     * Get The place and syntax used to change the value of this
     * expression.
     */
    public String getConfiguration()
    {
        return this.configuration;
    } //-- String getConfiguration() 

    /**
     * Get A preferred alternative to this expression, in the case
     * where it's deprecated.
     */
    public String getDeprecation()
    {
        return this.deprecation;
    } //-- String getDeprecation() 

    /**
     * Get The description of what this expression references, and
     * what it's generally used for.
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription() 

    /**
     * Get The syntax of the expression
     */
    public String getSyntax()
    {
        return this.syntax;
    } //-- String getSyntax() 

    /**
     * Get Whether the value of this expression can be changed.
     */
    public boolean isEditable()
    {
        return this.editable;
    } //-- boolean isEditable() 

    /**
     * Set The programmatic methods used to change the value of
     * this expression.
     * 
     * @param apiMethods
     */
    public void setApiMethods(java.util.Properties apiMethods)
    {
        this.apiMethods = apiMethods;
    } //-- void setApiMethods(java.util.Properties) 

    /**
     * Set A preferred alternative to this expression, in the case
     * where it's banned from use.
     * 
     * @param ban
     */
    public void setBan(String ban)
    {
        this.ban = ban;
    } //-- void setBan(String) 

    /**
     * Set The command-line switches used to change the value of
     * this expression.
     * 
     * @param cliOptions
     */
    public void setCliOptions(java.util.Properties cliOptions)
    {
        this.cliOptions = cliOptions;
    } //-- void setCliOptions(java.util.Properties) 

    /**
     * Set The place and syntax used to change the value of this
     * expression.
     * 
     * @param configuration
     */
    public void setConfiguration(String configuration)
    {
        this.configuration = configuration;
    } //-- void setConfiguration(String) 

    /**
     * Set A preferred alternative to this expression, in the case
     * where it's deprecated.
     * 
     * @param deprecation
     */
    public void setDeprecation(String deprecation)
    {
        this.deprecation = deprecation;
    } //-- void setDeprecation(String) 

    /**
     * Set The description of what this expression references, and
     * what it's generally used for.
     * 
     * @param description
     */
    public void setDescription(String description)
    {
        this.description = description;
    } //-- void setDescription(String) 

    /**
     * Set Whether the value of this expression can be changed.
     * 
     * @param editable
     */
    public void setEditable(boolean editable)
    {
        this.editable = editable;
    } //-- void setEditable(boolean) 

    /**
     * Set The syntax of the expression
     * 
     * @param syntax
     */
    public void setSyntax(String syntax)
    {
        this.syntax = syntax;
    } //-- void setSyntax(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
