/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.builder.profile;

import java.util.List;
import org.apache.maven.project.builder.ProjectUri;
import org.apache.maven.project.builder.profile.ActiveProfileMatcher;
import org.apache.maven.shared.model.InterpolatorProperty;
import org.apache.maven.shared.model.ModelContainer;
import org.apache.maven.shared.model.ModelProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatingSystemMatcher
implements ActiveProfileMatcher {
    @Override
    public boolean isMatch(ModelContainer modelContainer, List<InterpolatorProperty> properties) {
        if (modelContainer == null) {
            throw new IllegalArgumentException("modelContainer: null");
        }
        if (!OperatingSystemMatcher.doTest(modelContainer)) {
            return false;
        }
        for (InterpolatorProperty property : properties) {
            if (OperatingSystemMatcher.matches(modelContainer, property)) continue;
            return false;
        }
        return true;
    }

    private static boolean doTest(ModelContainer modelContainer) {
        for (ModelProperty mp : modelContainer.getProperties()) {
            if (!mp.getUri().startsWith(ProjectUri.Profiles.Profile.Activation.Os.xUri)) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(ModelContainer modelContainer, InterpolatorProperty interpolatorProperty) {
        String key = interpolatorProperty.getKey();
        for (ModelProperty property : modelContainer.getProperties()) {
            if (!(key.equals("${os.arch}") && property.getUri().equals(ProjectUri.Profiles.Profile.Activation.Os.arch) || key.equals("${os.version}") && property.getUri().equals(ProjectUri.Profiles.Profile.Activation.Os.version) || key.equals("${os.family}") && property.getUri().equals(ProjectUri.Profiles.Profile.Activation.Os.family)) && (!key.equals("${os.name}") || !property.getUri().equals(ProjectUri.Profiles.Profile.Activation.Os.name))) continue;
            return interpolatorProperty.getValue().equals(property.getResolvedValue());
        }
        return true;
    }
}

