/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.plugin.testing;

import java.io.File;
import java.util.Map;
import org.apache.maven.api.plugin.testing.MojoExtension;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import org.eclipse.aether.repository.LocalRepository;

public class ResolverExpressionEvaluatorStub
implements TypeAwareExpressionEvaluator {
    private final Map<String, Object> properties;

    public ResolverExpressionEvaluatorStub(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Object evaluate(String expr) throws ExpressionEvaluationException {
        return this.evaluate(expr, null);
    }

    public Object evaluate(String expr, Class<?> type) throws ExpressionEvaluationException {
        Object value = null;
        if (expr == null) {
            return null;
        }
        String expression = this.stripTokens(expr);
        if (expression.equals(expr)) {
            int lastIndex;
            int index = expr.indexOf("${");
            if (index >= 0 && (lastIndex = expr.indexOf("}", index)) >= 0) {
                Object retVal = expr.substring(0, index);
                retVal = index > 0 && expr.charAt(index - 1) == '$' ? (String)retVal + expr.substring(index + 1, lastIndex + 1) : (String)retVal + String.valueOf(this.evaluate(expr.substring(index, lastIndex + 1)));
                retVal = (String)retVal + String.valueOf(this.evaluate(expr.substring(lastIndex + 1)));
                return retVal;
            }
            return expression.contains("$$") ? expression.replaceAll("\\$\\$", "\\$") : expression;
        }
        if ("basedir".equals(expression) || "project.basedir".equals(expression)) {
            value = MojoExtension.getBasedir();
        } else if (expression.startsWith("basedir") || expression.startsWith("project.basedir")) {
            int pathSeparator = expression.indexOf("/");
            if (pathSeparator > 0) {
                value = MojoExtension.getBasedir() + expression.substring(pathSeparator);
            }
        } else if ("localRepository".equals(expression)) {
            File localRepo = new File(MojoExtension.getBasedir(), "target/local-repo");
            return new LocalRepository("file://" + localRepo.getAbsolutePath());
        }
        if (value == null && this.properties != null && this.properties.containsKey(expression)) {
            value = this.properties.get(expression);
        }
        return value;
    }

    private String stripTokens(String expr) {
        if (expr.startsWith("${") && expr.indexOf("}") == expr.length() - 1) {
            expr = expr.substring(2, expr.length() - 1);
        }
        return expr;
    }

    public File alignToBaseDirectory(File file) {
        if (file.getAbsolutePath().startsWith(MojoExtension.getBasedir())) {
            return file;
        }
        if (file.isAbsolute()) {
            return file;
        }
        return new File(MojoExtension.getBasedir(), file.getPath());
    }
}

