/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.plugin.testing.stubs;

import java.util.Objects;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.ArtifactCoordinates;
import org.apache.maven.api.Version;
import org.apache.maven.api.VersionConstraint;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.model.ModelVersionParser;
import org.apache.maven.impl.DefaultModelVersionParser;
import org.apache.maven.impl.DefaultVersionParser;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.VersionScheme;

public class ArtifactStub
implements Artifact {
    private String groupId;
    private String artifactId;
    private String classifier;
    private String version;
    private String baseVersion;
    private String extension;

    public ArtifactStub() {
        this.groupId = "";
        this.artifactId = "";
        this.version = "";
        this.classifier = "";
        this.extension = "";
    }

    public ArtifactStub(String groupId, String artifactId, String classifier, String version, String extension) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classifier = classifier;
        this.version = version;
        this.extension = extension;
    }

    @Nonnull
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Nonnull
    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Nonnull
    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    @Nonnull
    public Version getVersion() {
        return ArtifactStub.getParser().parseVersion(this.version);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Version getBaseVersion() {
        return ArtifactStub.getParser().parseVersion(this.baseVersion != null ? this.baseVersion : this.version);
    }

    public void setBaseVersion(String baseVersion) {
        this.baseVersion = baseVersion;
    }

    @Nonnull
    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public boolean isSnapshot() {
        return false;
    }

    public ArtifactCoordinates toCoordinates() {
        return new ArtifactCoordinates(){

            public String getGroupId() {
                return ArtifactStub.this.groupId;
            }

            public String getArtifactId() {
                return ArtifactStub.this.artifactId;
            }

            public String getClassifier() {
                return ArtifactStub.this.classifier;
            }

            public VersionConstraint getVersionConstraint() {
                return ArtifactStub.getParser().parseVersionConstraint(ArtifactStub.this.version);
            }

            public String getExtension() {
                return ArtifactStub.this.extension;
            }
        };
    }

    public String toString() {
        return "ArtifactStub[groupId='" + this.groupId + "', artifactId='" + this.artifactId + "', classifier='" + this.classifier + "', version='" + this.version + "', extension='" + this.extension + "']";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArtifactStub)) {
            return false;
        }
        ArtifactStub that = (ArtifactStub)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.classifier, that.classifier) && Objects.equals(this.version, that.version) && Objects.equals(this.extension, that.extension);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.classifier, this.version, this.extension);
    }

    private static DefaultVersionParser getParser() {
        return new DefaultVersionParser((ModelVersionParser)new DefaultModelVersionParser((VersionScheme)new GenericVersionScheme()));
    }
}

