/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.plugin.testing.stubs;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.api.DependencyCoordinates;
import org.apache.maven.api.Language;
import org.apache.maven.api.Packaging;
import org.apache.maven.api.PathType;
import org.apache.maven.api.ProducedArtifact;
import org.apache.maven.api.Project;
import org.apache.maven.api.Type;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.PluginContainer;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.plugin.testing.stubs.ProducedArtifactStub;

public class ProjectStub
implements Project {
    private Model model = Model.newInstance();
    private Path basedir;
    private Path pomPath;
    private boolean topProject;
    private Path rootDirectory;
    private ProducedArtifact mainArtifact;
    private List<Profile> declaredProfiles = List.of();
    private List<Profile> effectiveProfiles = List.of();
    private List<Profile> declaredActiveProfiles = List.of();
    private List<Profile> effectiveActiveProfiles = List.of();

    public void setModel(Model model) {
        this.model = model;
    }

    @Nonnull
    public String getGroupId() {
        return this.model.getGroupId();
    }

    @Nonnull
    public String getArtifactId() {
        return this.model.getArtifactId();
    }

    @Nonnull
    public String getVersion() {
        return this.model.getVersion();
    }

    public String getName() {
        return this.model.getName();
    }

    @Nonnull
    public Packaging getPackaging() {
        return new Packaging(){

            public String id() {
                return ProjectStub.this.model.getPackaging();
            }

            public Type type() {
                return new Type(){

                    public String id() {
                        return ProjectStub.this.model.getPackaging();
                    }

                    public Language getLanguage() {
                        return null;
                    }

                    public String getExtension() {
                        return ProjectStub.this.model.getPackaging();
                    }

                    public String getClassifier() {
                        return "";
                    }

                    public boolean isIncludesDependencies() {
                        return false;
                    }

                    public Set<PathType> getPathTypes() {
                        return Set.of();
                    }
                };
            }

            public Map<String, PluginContainer> plugins() {
                return Map.of();
            }
        };
    }

    public List<ProducedArtifact> getArtifacts() {
        ProducedArtifactStub pomArtifact = new ProducedArtifactStub(this.getGroupId(), this.getArtifactId(), "", this.getVersion(), "pom");
        return this.mainArtifact != null ? Arrays.asList(pomArtifact, this.mainArtifact) : Arrays.asList(pomArtifact);
    }

    @Nonnull
    public Model getModel() {
        return this.model;
    }

    @Nonnull
    public Path getPomPath() {
        return this.pomPath;
    }

    @Nonnull
    public List<DependencyCoordinates> getDependencies() {
        return null;
    }

    @Nonnull
    public List<DependencyCoordinates> getManagedDependencies() {
        return null;
    }

    public Path getBasedir() {
        return this.basedir;
    }

    public Optional<Project> getParent() {
        return Optional.empty();
    }

    public boolean isTopProject() {
        return this.topProject;
    }

    public boolean isRootProject() {
        return this.model.isRoot();
    }

    public Path getRootDirectory() {
        return this.rootDirectory;
    }

    public ProjectStub setBasedir(Path basedir) {
        this.basedir = basedir;
        return this;
    }

    public ProjectStub setGroupId(String groupId) {
        this.model = this.model.withGroupId(groupId);
        return this;
    }

    public ProjectStub setArtifactId(String artifactId) {
        this.model = this.model.withArtifactId(artifactId);
        return this;
    }

    public ProjectStub setVersion(String version) {
        this.model = this.model.withVersion(version);
        return this;
    }

    public ProjectStub setName(String name) {
        this.model = this.model.withName(name);
        return this;
    }

    public ProjectStub setDescription(String desc) {
        this.model = this.model.withDescription(desc);
        return this;
    }

    public ProjectStub setPackaging(String packaging) {
        this.model = this.model.withPackaging(packaging);
        return this;
    }

    public ProjectStub setMainArtifact(ProducedArtifact mainArtifact) {
        this.mainArtifact = mainArtifact;
        return this;
    }

    public ProjectStub setPomPath(Path pomPath) {
        this.pomPath = pomPath;
        return this;
    }

    public ProjectStub setTopProject(boolean topProject) {
        this.topProject = topProject;
        return this;
    }

    public ProjectStub setMavenModel(org.apache.maven.model.Model model) {
        this.model = model.getDelegate();
        return this;
    }

    public ProjectStub setRootDirectory(Path rootDirectory) {
        this.rootDirectory = rootDirectory;
        return this;
    }

    public ProjectStub addProperty(String key, String value) {
        HashMap<String, String> props = new HashMap<String, String>(this.model.getProperties());
        props.put(key, value);
        this.model = this.model.withProperties(props);
        return this;
    }

    public List<Profile> getDeclaredProfiles() {
        return this.declaredProfiles;
    }

    public void setDeclaredProfiles(List<Profile> values) {
        this.declaredProfiles = List.copyOf(values);
    }

    public List<Profile> getEffectiveProfiles() {
        return this.effectiveProfiles;
    }

    public void setEffectiveProfiles(List<Profile> values) {
        this.effectiveProfiles = List.copyOf(values);
    }

    public List<Profile> getDeclaredActiveProfiles() {
        return this.declaredActiveProfiles;
    }

    public void setDeclaredActiveProfiles(List<Profile> values) {
        this.declaredActiveProfiles = List.copyOf(values);
    }

    public List<Profile> getEffectiveActiveProfiles() {
        return this.effectiveActiveProfiles;
    }

    public void setEffectiveActiveProfiles(List<Profile> values) {
        this.effectiveActiveProfiles = List.copyOf(values);
    }
}

