/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.plugin.testing.stubs;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.LocalRepository;
import org.apache.maven.api.ProducedArtifact;
import org.apache.maven.api.Project;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.SessionData;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.plugin.testing.stubs.ArtifactStub;
import org.apache.maven.api.plugin.testing.stubs.LookupStub;
import org.apache.maven.api.plugin.testing.stubs.ProducedArtifactStub;
import org.apache.maven.api.plugin.testing.stubs.ProjectStub;
import org.apache.maven.api.services.ArtifactDeployer;
import org.apache.maven.api.services.ArtifactDeployerRequest;
import org.apache.maven.api.services.ArtifactFactory;
import org.apache.maven.api.services.ArtifactFactoryRequest;
import org.apache.maven.api.services.ArtifactInstaller;
import org.apache.maven.api.services.ArtifactInstallerRequest;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.LocalRepositoryManager;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.services.ProjectBuilder;
import org.apache.maven.api.services.ProjectBuilderRequest;
import org.apache.maven.api.services.ProjectBuilderResult;
import org.apache.maven.api.services.ProjectManager;
import org.apache.maven.api.services.RepositoryFactory;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.services.VersionParser;
import org.apache.maven.api.services.model.ModelVersionParser;
import org.apache.maven.api.services.xml.ModelXmlFactory;
import org.apache.maven.impl.DefaultModelVersionParser;
import org.apache.maven.impl.DefaultModelXmlFactory;
import org.apache.maven.impl.DefaultVersionParser;
import org.apache.maven.impl.InternalSession;
import org.apache.maven.model.v4.MavenStaxReader;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.VersionScheme;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;

public class SessionMock {
    public static InternalSession getMockSession(String localRepo) {
        LocalRepository localRepository = (LocalRepository)Mockito.mock(LocalRepository.class);
        Mockito.when((Object)localRepository.getId()).thenReturn((Object)"local");
        Mockito.when((Object)localRepository.getPath()).thenReturn((Object)Paths.get(localRepo, new String[0]));
        return SessionMock.getMockSession(localRepository);
    }

    public static InternalSession getMockSession(LocalRepository localRepository) {
        InternalSession session = (InternalSession)Mockito.mock(InternalSession.class);
        RepositoryFactory repositoryFactory = (RepositoryFactory)Mockito.mock(RepositoryFactory.class);
        Mockito.when((Object)session.createRemoteRepository(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer(iom -> {
            String id = (String)iom.getArgument(0, String.class);
            String url = (String)iom.getArgument(1, String.class);
            return ((RepositoryFactory)session.getService(RepositoryFactory.class)).createRemote(id, url);
        });
        Mockito.when((Object)session.createRemoteRepository((Repository)ArgumentMatchers.any())).thenAnswer(iom -> repositoryFactory.createRemote((Repository)iom.getArgument(0, Repository.class)));
        Mockito.when((Object)repositoryFactory.createRemote((Repository)ArgumentMatchers.any(Repository.class))).thenAnswer(iom -> {
            Repository repository = (Repository)iom.getArgument(0, Repository.class);
            return repositoryFactory.createRemote(repository.getId(), repository.getUrl());
        });
        Mockito.when((Object)repositoryFactory.createRemote(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer(iom -> {
            String id = (String)iom.getArgument(0, String.class);
            String url = (String)iom.getArgument(1, String.class);
            RemoteRepository remoteRepository = (RemoteRepository)Mockito.mock(RemoteRepository.class, (MockSettings)Mockito.withSettings().lenient());
            Mockito.when((Object)remoteRepository.getId()).thenReturn((Object)id);
            Mockito.when((Object)remoteRepository.getUrl()).thenReturn((Object)url);
            Mockito.when((Object)remoteRepository.getProtocol()).thenReturn((Object)URI.create(url).getScheme());
            return remoteRepository;
        });
        Mockito.when((Object)((RepositoryFactory)session.getService(RepositoryFactory.class))).thenReturn((Object)repositoryFactory);
        DefaultVersionParser versionParser = new DefaultVersionParser((ModelVersionParser)new DefaultModelVersionParser((VersionScheme)new GenericVersionScheme()));
        Mockito.when((Object)session.parseVersion((String)ArgumentMatchers.any())).thenAnswer(arg_0 -> SessionMock.lambda$getMockSession$4((VersionParser)versionParser, arg_0));
        Mockito.when((Object)((VersionParser)session.getService(VersionParser.class))).thenReturn((Object)versionParser);
        LocalRepositoryManager localRepositoryManager = (LocalRepositoryManager)Mockito.mock(LocalRepositoryManager.class);
        Mockito.when((Object)session.getPathForLocalArtifact((Artifact)ArgumentMatchers.any(Artifact.class))).then(iom -> localRepositoryManager.getPathForLocalArtifact((Session)session, session.getLocalRepository(), (Artifact)iom.getArgument(0, Artifact.class)));
        Mockito.when((Object)session.getPathForRemoteArtifact((RemoteRepository)ArgumentMatchers.any(), (Artifact)ArgumentMatchers.any())).thenAnswer(iom -> localRepositoryManager.getPathForRemoteArtifact((Session)session, session.getLocalRepository(), (RemoteRepository)iom.getArgument(0, RemoteRepository.class), (Artifact)iom.getArgument(1, Artifact.class)));
        Mockito.when((Object)localRepositoryManager.getPathForLocalArtifact((Session)ArgumentMatchers.any(), (LocalRepository)ArgumentMatchers.any(), (Artifact)ArgumentMatchers.any())).thenAnswer(iom -> {
            LocalRepository localRepo = (LocalRepository)iom.getArgument(1, LocalRepository.class);
            Artifact artifact = (Artifact)iom.getArgument(2, Artifact.class);
            return localRepo.getPath().resolve(SessionMock.getPathForArtifact(artifact, true));
        });
        Mockito.when((Object)((LocalRepositoryManager)session.getService(LocalRepositoryManager.class))).thenReturn((Object)localRepositoryManager);
        ArtifactInstaller artifactInstaller = (ArtifactInstaller)Mockito.mock(ArtifactInstaller.class);
        ((InternalSession)Mockito.doAnswer(iom -> {
            artifactInstaller.install(ArtifactInstallerRequest.build((Session)session, (Collection)((Collection)iom.getArgument(0, Collection.class))));
            return null;
        }).when((Object)session)).installArtifacts((Collection)ArgumentMatchers.any(Collection.class));
        ((InternalSession)Mockito.doAnswer(iom -> {
            artifactInstaller.install(ArtifactInstallerRequest.build((Session)session, Arrays.asList((ProducedArtifact[])iom.getArgument(0, ProducedArtifact[].class))));
            return null;
        }).when((Object)session)).installArtifacts((ProducedArtifact[])ArgumentMatchers.any(ProducedArtifact[].class));
        ((ArtifactInstaller)Mockito.doAnswer(iom -> {
            artifactInstaller.install(ArtifactInstallerRequest.build((Session)((Session)iom.getArgument(0, Session.class)), (Collection)((Collection)iom.getArgument(1, Collection.class))));
            return null;
        }).when((Object)artifactInstaller)).install((Session)ArgumentMatchers.any(Session.class), (Collection)ArgumentMatchers.any());
        Mockito.when((Object)((ArtifactInstaller)session.getService(ArtifactInstaller.class))).thenReturn((Object)artifactInstaller);
        ArtifactDeployer artifactDeployer = (ArtifactDeployer)Mockito.mock(ArtifactDeployer.class);
        ((InternalSession)Mockito.doAnswer(iom -> {
            artifactDeployer.deploy(ArtifactDeployerRequest.build((Session)((Session)iom.getArgument(0, Session.class)), (RemoteRepository)((RemoteRepository)iom.getArgument(1, RemoteRepository.class)), Arrays.asList((ProducedArtifact[])iom.getArgument(2, ProducedArtifact[].class))));
            return null;
        }).when((Object)session)).deployArtifact((RemoteRepository)ArgumentMatchers.any(), (ProducedArtifact[])ArgumentMatchers.any());
        ((ArtifactDeployer)Mockito.doAnswer(iom -> {
            artifactDeployer.deploy(ArtifactDeployerRequest.build((Session)((Session)iom.getArgument(0, Session.class)), (RemoteRepository)((RemoteRepository)iom.getArgument(1, RemoteRepository.class)), (Collection)((Collection)iom.getArgument(2, Collection.class))));
            return null;
        }).when((Object)artifactDeployer)).deploy((Session)ArgumentMatchers.any(), (RemoteRepository)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any());
        Mockito.when((Object)((ArtifactDeployer)session.getService(ArtifactDeployer.class))).thenReturn((Object)artifactDeployer);
        ArtifactManager artifactManager = (ArtifactManager)Mockito.mock(ArtifactManager.class);
        HashMap paths = new HashMap();
        ((ArtifactManager)Mockito.doAnswer(iom -> {
            paths.put((Artifact)iom.getArgument(0), (Path)iom.getArgument(1));
            return null;
        }).when((Object)artifactManager)).setPath((ProducedArtifact)ArgumentMatchers.any(), (Path)ArgumentMatchers.any());
        ((ArtifactManager)Mockito.doAnswer(iom -> Optional.ofNullable((Path)paths.get(iom.getArgument(0, Artifact.class)))).when((Object)artifactManager)).getPath((Artifact)ArgumentMatchers.any());
        ((InternalSession)Mockito.doAnswer(iom -> artifactManager.getPath((Artifact)iom.getArgument(0, Artifact.class))).when((Object)session)).getArtifactPath((Artifact)ArgumentMatchers.any());
        Mockito.when((Object)((ArtifactManager)session.getService(ArtifactManager.class))).thenReturn((Object)artifactManager);
        ProjectManager projectManager = (ProjectManager)Mockito.mock(ProjectManager.class);
        HashMap attachedArtifacts = new HashMap();
        ((ProjectManager)Mockito.doAnswer(iom -> {
            Project project = (Project)iom.getArgument(1, Project.class);
            String type = (String)iom.getArgument(2, String.class);
            Path path = (Path)iom.getArgument(3, Path.class);
            ProducedArtifact artifact = session.createProducedArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), null, null, type);
            artifactManager.setPath(artifact, path);
            attachedArtifacts.computeIfAbsent(project, p -> new ArrayList()).add(artifact);
            return null;
        }).when((Object)projectManager)).attachArtifact((Session)ArgumentMatchers.same((Object)session), (Project)ArgumentMatchers.any(Project.class), (String)ArgumentMatchers.any(), (Path)ArgumentMatchers.any());
        ((ProjectManager)Mockito.doAnswer(iom -> {
            Project project = (Project)iom.getArgument(0, Project.class);
            ProducedArtifact artifact = (ProducedArtifact)iom.getArgument(1, ProducedArtifact.class);
            Path path = (Path)iom.getArgument(2, Path.class);
            artifactManager.setPath(artifact, path);
            attachedArtifacts.computeIfAbsent(project, p -> new ArrayList()).add(artifact);
            return null;
        }).when((Object)projectManager)).attachArtifact((Project)ArgumentMatchers.any(Project.class), (ProducedArtifact)ArgumentMatchers.any(ProducedArtifact.class), (Path)ArgumentMatchers.any(Path.class));
        Mockito.when((Object)projectManager.getAttachedArtifacts((Project)ArgumentMatchers.any())).then(iom -> attachedArtifacts.computeIfAbsent((Project)iom.getArgument(0, Project.class), p -> new ArrayList()));
        Mockito.when((Object)projectManager.getAllArtifacts((Project)ArgumentMatchers.any())).then(iom -> {
            Project project = (Project)iom.getArgument(0, Project.class);
            ArrayList result = new ArrayList();
            result.addAll(project.getArtifacts());
            result.addAll(attachedArtifacts.computeIfAbsent(project, p -> new ArrayList()));
            return result;
        });
        Mockito.when((Object)((ProjectManager)session.getService(ProjectManager.class))).thenReturn((Object)projectManager);
        ArtifactFactory artifactFactory = (ArtifactFactory)Mockito.mock(ArtifactFactory.class);
        Mockito.when((Object)artifactFactory.create((ArtifactFactoryRequest)ArgumentMatchers.any())).then(iom -> {
            ArtifactFactoryRequest request = (ArtifactFactoryRequest)iom.getArgument(0, ArtifactFactoryRequest.class);
            String classifier = request.getClassifier();
            String extension = request.getExtension();
            String type = request.getType();
            if (classifier == null) {
                classifier = "";
            }
            if (extension == null) {
                extension = type != null ? type : "";
            }
            return new ArtifactStub(request.getGroupId(), request.getArtifactId(), classifier, request.getVersion(), extension);
        });
        Mockito.when((Object)artifactFactory.createProduced((ArtifactFactoryRequest)ArgumentMatchers.any())).then(iom -> {
            ArtifactFactoryRequest request = (ArtifactFactoryRequest)iom.getArgument(0, ArtifactFactoryRequest.class);
            String classifier = request.getClassifier();
            String extension = request.getExtension();
            String type = request.getType();
            if (classifier == null) {
                classifier = "";
            }
            if (extension == null) {
                extension = type != null ? type : "";
            }
            return new ProducedArtifactStub(request.getGroupId(), request.getArtifactId(), classifier, request.getVersion(), extension);
        });
        Mockito.when((Object)session.createArtifact((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenAnswer(iom -> {
            String groupId = (String)iom.getArgument(0, String.class);
            String artifactId = (String)iom.getArgument(1, String.class);
            String version = (String)iom.getArgument(2, String.class);
            String classifier = (String)iom.getArgument(3, String.class);
            String extension = (String)iom.getArgument(4, String.class);
            String type = (String)iom.getArgument(5, String.class);
            return ((ArtifactFactory)session.getService(ArtifactFactory.class)).create(ArtifactFactoryRequest.builder().session((Session)session).groupId(groupId).artifactId(artifactId).version(version).classifier(classifier).extension(extension).type(type).build());
        });
        Mockito.when((Object)session.createArtifact((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenAnswer(iom -> {
            String groupId = (String)iom.getArgument(0, String.class);
            String artifactId = (String)iom.getArgument(1, String.class);
            String version = (String)iom.getArgument(2, String.class);
            String extension = (String)iom.getArgument(3, String.class);
            return ((ArtifactFactory)session.getService(ArtifactFactory.class)).create(ArtifactFactoryRequest.builder().session((Session)session).groupId(groupId).artifactId(artifactId).version(version).extension(extension).build());
        });
        Mockito.when((Object)session.createProducedArtifact((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenAnswer(iom -> {
            String groupId = (String)iom.getArgument(0, String.class);
            String artifactId = (String)iom.getArgument(1, String.class);
            String version = (String)iom.getArgument(2, String.class);
            String classifier = (String)iom.getArgument(3, String.class);
            String extension = (String)iom.getArgument(4, String.class);
            String type = (String)iom.getArgument(5, String.class);
            return ((ArtifactFactory)session.getService(ArtifactFactory.class)).createProduced(ArtifactFactoryRequest.builder().session((Session)session).groupId(groupId).artifactId(artifactId).version(version).classifier(classifier).extension(extension).type(type).build());
        });
        Mockito.when((Object)session.createProducedArtifact((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenAnswer(iom -> {
            String groupId = (String)iom.getArgument(0, String.class);
            String artifactId = (String)iom.getArgument(1, String.class);
            String version = (String)iom.getArgument(2, String.class);
            String extension = (String)iom.getArgument(3, String.class);
            return ((ArtifactFactory)session.getService(ArtifactFactory.class)).createProduced(ArtifactFactoryRequest.builder().session((Session)session).groupId(groupId).artifactId(artifactId).version(version).extension(extension).build());
        });
        Mockito.when((Object)((ArtifactFactory)session.getService(ArtifactFactory.class))).thenReturn((Object)artifactFactory);
        ProjectBuilder projectBuilder = (ProjectBuilder)Mockito.mock(ProjectBuilder.class);
        Mockito.when((Object)projectBuilder.build((ProjectBuilderRequest)ArgumentMatchers.any(ProjectBuilderRequest.class))).then(iom -> {
            ProjectBuilderRequest request = (ProjectBuilderRequest)iom.getArgument(0, ProjectBuilderRequest.class);
            ProjectBuilderResult result = (ProjectBuilderResult)Mockito.mock(ProjectBuilderResult.class);
            Model model = new MavenStaxReader().read(((Source)request.getSource().get()).openStream());
            ProjectStub projectStub = new ProjectStub();
            projectStub.setModel(model);
            ProducedArtifactStub artifactStub = new ProducedArtifactStub(model.getGroupId(), model.getArtifactId(), "", model.getVersion(), model.getPackaging());
            if (!"pom".equals(model.getPackaging())) {
                projectStub.setMainArtifact(artifactStub);
            }
            Mockito.when((Object)result.getProject()).thenReturn(Optional.of(projectStub));
            return result;
        });
        Mockito.when((Object)((ProjectBuilder)session.getService(ProjectBuilder.class))).thenReturn((Object)projectBuilder);
        Mockito.when((Object)((ModelXmlFactory)session.getService(ModelXmlFactory.class))).thenReturn((Object)new DefaultModelXmlFactory());
        Mockito.when((Object)((Lookup)session.getService(Lookup.class))).thenReturn((Object)LookupStub.EMPTY);
        Properties sysProps = new Properties();
        Properties usrProps = new Properties();
        ((InternalSession)Mockito.doReturn((Object)sysProps).when((Object)session)).getSystemProperties();
        ((InternalSession)Mockito.doReturn((Object)usrProps).when((Object)session)).getUserProperties();
        Mockito.when((Object)session.getLocalRepository()).thenReturn((Object)localRepository);
        Mockito.when((Object)session.getData()).thenReturn((Object)new TestSessionData());
        Mockito.when((Object)session.withLocalRepository((LocalRepository)ArgumentMatchers.any())).thenAnswer(iom -> SessionMock.getMockSession((LocalRepository)iom.getArgument(0, LocalRepository.class)));
        return session;
    }

    static String getPathForArtifact(Artifact artifact, boolean local) {
        StringBuilder path = new StringBuilder(128);
        path.append(artifact.getGroupId().replace('.', '/')).append('/');
        path.append(artifact.getArtifactId()).append('/');
        path.append(artifact.getVersion()).append('/');
        path.append(artifact.getArtifactId()).append('-');
        path.append(artifact.getVersion());
        if (artifact.getClassifier().length() > 0) {
            path.append('-').append(artifact.getClassifier());
        }
        if (artifact.getExtension().length() > 0) {
            path.append('.').append(artifact.getExtension());
        }
        return path.toString();
    }

    private static /* synthetic */ Object lambda$getMockSession$4(VersionParser versionParser, InvocationOnMock iom) throws Throwable {
        return versionParser.parseVersion((String)iom.getArgument(0, String.class));
    }

    static class TestSessionData
    implements SessionData {
        private final Map<SessionData.Key<?>, Object> map = new ConcurrentHashMap();

        TestSessionData() {
        }

        public <T> void set(SessionData.Key<T> key, T value) {
            this.map.put(key, value);
        }

        public <T> boolean replace(SessionData.Key<T> key, T oldValue, T newValue) {
            return this.map.replace(key, oldValue, newValue);
        }

        public <T> T get(SessionData.Key<T> key) {
            return (T)this.map.get(key);
        }

        public <T> T computeIfAbsent(SessionData.Key<T> key, Supplier<T> supplier) {
            return (T)this.map.computeIfAbsent(key, (? super K k) -> supplier.get());
        }
    }
}

